/*************************************************************************
 *
 *  $RCSfile: sdrmasterpagedescriptor.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2004/10/12 10:09:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SDR_MASTERPAGEDESCRIPTOR_HXX
#include <sdrmasterpagedescriptor.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWCONTACTOFMASTERPAGEDESCRIPTOR_HXX
#include <svx/sdr/contact/viewcontactofmasterpagedescriptor.hxx>
#endif

#ifndef _SVDPAGE_HXX
#include <svdpage.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	// ViewContact part
	sdr::contact::ViewContact* MasterPageDescriptor::CreateObjectSpecificViewContact()
	{
		return new sdr::contact::ViewContactOfMasterPageDescriptor(*this);
	}

	MasterPageDescriptor::MasterPageDescriptor(SdrPage& aOwnerPage, SdrPage& aUsedPage)
	:	maOwnerPage(aOwnerPage),
		maUsedPage(aUsedPage),
		mpViewContact(0L)
	{
		// all layers visible
		maVisibleLayers.SetAll();

		// register at used page
		maUsedPage.AddPageUser(*this);
	}
	
	MasterPageDescriptor::~MasterPageDescriptor()
	{
		// de-register at used page
		maUsedPage.RemovePageUser(*this);

		if(mpViewContact)
		{
			mpViewContact->PrepareDelete();
			delete mpViewContact;
			mpViewContact = 0L;
		}
	}

	// ViewContact part
	sdr::contact::ViewContact& MasterPageDescriptor::GetViewContact() const
	{
		if(!mpViewContact)
		{
			((MasterPageDescriptor*)this)->mpViewContact = ((MasterPageDescriptor*)this)->CreateObjectSpecificViewContact();
		}

		return *mpViewContact;
	}

	// this method is called form the destructor of the referenced page.
	// do all necessary action to forget the page. It is not necessary to call
	// RemovePageUser(), that is done form the destructor.
	void MasterPageDescriptor::PageInDestruction(const SdrPage& rPage)
	{
		maOwnerPage.TRG_ClearMasterPage();
	}

	void MasterPageDescriptor::SetVisibleLayers(const SetOfByte& rNew)
	{
		if(rNew != maVisibleLayers)
		{
			maVisibleLayers = rNew;
			GetViewContact().ActionChanged();
		}
	}

	// operators
	sal_Bool MasterPageDescriptor::operator==(const MasterPageDescriptor& rCandidate) const
	{
		return (&maOwnerPage == &rCandidate.maOwnerPage 
			&& &maUsedPage == &rCandidate.maUsedPage
			&& maVisibleLayers == rCandidate.maVisibleLayers);
	}

	sal_Bool MasterPageDescriptor::operator!=(const MasterPageDescriptor& rCandidate) const
	{
		return (&maOwnerPage != &rCandidate.maOwnerPage 
			|| &maUsedPage != &rCandidate.maUsedPage
			|| maVisibleLayers != rCandidate.maVisibleLayers);
	}
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
