/*************************************************************************
 *
 *  $RCSfile: xdash.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/21 15:58:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVX_XDASH_HXX
#define _SVX_XDASH_HXX

//-------------
// class XDash
//-------------

#ifndef _XENUM_HXX //autogen
#include <xenum.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

class SVX_DLLPUBLIC XDash
{
protected:
	XDashStyle  eDash;
	USHORT      nDots;
	ULONG       nDotLen;
	USHORT      nDashes;
	ULONG       nDashLen;
	ULONG       nDistance;

public:
		  XDash(XDashStyle eDash = XDASH_RECT,
				USHORT nDots = 1, ULONG nDotLen = 20,
				USHORT nDashes = 1, ULONG nDashLen = 20, ULONG nDistance = 20);

	int operator==(const XDash& rDash) const;

	void SetDashStyle(XDashStyle eNewStyle) { eDash = eNewStyle; }
	void SetDots(USHORT nNewDots)           { nDots = nNewDots; }
	void SetDotLen(ULONG nNewDotLen)        { nDotLen = nNewDotLen; }
	void SetDashes(USHORT nNewDashes)       { nDashes = nNewDashes; }
	void SetDashLen(ULONG nNewDashLen)      { nDashLen = nNewDashLen; }
	void SetDistance(ULONG nNewDistance)    { nDistance = nNewDistance; }

	XDashStyle  GetDashStyle() const        { return eDash; }
	USHORT      GetDots() const             { return nDots; }
	ULONG       GetDotLen() const           { return nDotLen; }
	USHORT      GetDashes() const           { return nDashes; }
	ULONG       GetDashLen() const          { return nDashLen; }
	ULONG       GetDistance() const         { return nDistance; }

};

#endif
