/*************************************************************************
 *
 *  $RCSfile: vocbitmapbuffer.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2004/11/17 09:45:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SDR_CONTACT_VOCBITMAPBUFFER_HXX
#define _SDR_CONTACT_VOCBITMAPBUFFER_HXX

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACT_HXX
#include <svx/sdr/contact/viewobjectcontact.hxx>
#endif

#ifndef _SV_BITMAPEX_HXX
#include <vcl/bitmapex.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////
// predeclarations
class VirtualDevice;

//////////////////////////////////////////////////////////////////////////////
// class BufferHelper

namespace sdr
{
	namespace contact
	{
		class BufferHelper
		{
		protected:
			// The ViewObjectContact this buffer belongs to
			ViewObjectContact&							mrViewObjectContact;

			// The remembered MapMode of the buffered part
			MapMode										maBufferedMapMode;

			// Flagarray
			// Flag to remember state of Buffering. Default is sal_False.
			unsigned									mbBufferValid : 1;

			// helper methods
			Rectangle ImpCalculateClippedPixelRectangle(DisplayInfo& rDisplayInfo) const;
			virtual Size ImpGetBufferedSizePixel() const = 0;
			void ImpCheckForChanges(DisplayInfo& rDisplayInfo);
			bool ImpBufferingAllowed(DisplayInfo& rDisplayInfo) const;
			virtual void ImpPaintUsingBuffer(DisplayInfo& rDisplayInfo) const = 0;
			void ImpTryToCreateBuffer(DisplayInfo& rDisplayInfo);
			virtual VirtualDevice* ImpPrepareVirtualDevice(DisplayInfo& rDisplayInfo) const = 0;
			virtual void ImpCreateBufferFromVDev(VirtualDevice& rVirtualDevice) = 0;

		public:
			BufferHelper(ViewObjectContact& rViewObjectContact);
			virtual ~BufferHelper();

			// Get bool flag about buffer status
			bool BufferIsValid() const { return mbBufferValid; }

			// Try to paint from buffer
			bool TryToPaintObjectWithBuffer(DisplayInfo& rDisplayInfo);

			// dispose buffer
			virtual void DisposeBuffer() = 0;

			// access to MapMode
			const MapMode& GetBufferedMapMode() const { return maBufferedMapMode; }
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// class BufferHelperBitmap

namespace sdr
{
	namespace contact
	{
		class BufferHelperBitmap : public BufferHelper
		{
		protected:
			// The buffered bitmap
			Bitmap										maBuffer;

			// helper methods
			virtual Size ImpGetBufferedSizePixel() const;
			virtual void ImpPaintUsingBuffer(DisplayInfo& rDisplayInfo) const;
			virtual VirtualDevice* ImpPrepareVirtualDevice(DisplayInfo& rDisplayInfo) const;
			virtual void ImpCreateBufferFromVDev(VirtualDevice& rVirtualDevice);

		public:
			BufferHelperBitmap(ViewObjectContact& rViewObjectContact);
			virtual ~BufferHelperBitmap();

			// dispose buffer
			virtual void DisposeBuffer();

			// access to bitmap
			const Bitmap& GetBufferedBitmap() const { return maBuffer; }

			// access if buffered data needs to be injected
			void SetBufferedData(const MapMode& rMapMode, const Bitmap& rBitmap);
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// class BufferHelperBitmapEx

namespace sdr
{
	namespace contact
	{
		class BufferHelperBitmapEx : public BufferHelper
		{
		protected:
			// The buffered bitmap
			BitmapEx									maBuffer;

			// helper methods
			virtual Size ImpGetBufferedSizePixel() const;
			virtual void ImpPaintUsingBuffer(DisplayInfo& rDisplayInfo) const;
			virtual VirtualDevice* ImpPrepareVirtualDevice(DisplayInfo& rDisplayInfo) const;
			virtual void ImpCreateBufferFromVDev(VirtualDevice& rVirtualDevice);

		public:
			BufferHelperBitmapEx(ViewObjectContact& rViewObjectContact);
			virtual ~BufferHelperBitmapEx();

			// dispose buffer
			virtual void DisposeBuffer();

			// access to bitmapEx
			const BitmapEx& GetBufferedBitmapEx() const { return maBuffer; }

			// access if buffered data needs to be injected
			void SetBufferedData(const MapMode& rMapMode, const BitmapEx& rBitmapEx);
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// class VOCBitmapBuffer

namespace sdr
{
	namespace contact
	{
		class VOCBitmapBuffer : public ViewObjectContact
		{
		protected:
			// The Buffer itself
			BufferHelperBitmap							maBuffer;

		public:
			// basic constructor.
			VOCBitmapBuffer(ObjectContact& rObjectContact, ViewContact& rViewContact);

			// The destructor.
			virtual ~VOCBitmapBuffer();

			// Prepare deletion of this object.
			virtual void PrepareDelete();

			// Paint this object. This is before evtl. SubObjects get painted. This method
			// needs to set the flag mbIsPainted and mbIsInvalidated and to set the
			// maPaintedRectangle member. This information is later used for invalidates
			// and repaints.
			virtual void PaintObject(DisplayInfo& rDisplayInfo);

			// React on changes of the object of this ViewContact
			virtual void ActionChanged();

			// Take some action when new objects are inserted
			virtual void ActionChildInserted(const Rectangle& rInitialRectangle);
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// class VOCBitmapExBuffer

namespace sdr
{
	namespace contact
	{
		class VOCBitmapExBuffer : public ViewObjectContact
		{
		protected:
			// The Buffer itself
			BufferHelperBitmapEx						maBuffer;

		public:
			// basic constructor.
			VOCBitmapExBuffer(ObjectContact& rObjectContact, ViewContact& rViewContact);

			// The destructor.
			virtual ~VOCBitmapExBuffer();

			// Prepare deletion of this object.
			virtual void PrepareDelete();

			// Paint this object. This is before evtl. SubObjects get painted. This method
			// needs to set the flag mbIsPainted and mbIsInvalidated and to set the
			// maPaintedRectangle member. This information is later used for invalidates
			// and repaints.
			virtual void PaintObject(DisplayInfo& rDisplayInfo);

			// React on changes of the object of this ViewContact
			virtual void ActionChanged();

			// Take some action when new objects are inserted
			virtual void ActionChildInserted(const Rectangle& rInitialRectangle);
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

//namespace sdr
//{
//	namespace contact
//	{
//		class VOCBitmapBuffer_old : public ViewObjectContact
//		{
//			// The Bitmap to remember the rendered, buffered content
//			BitmapEx									maBitmapEx;
//
//			// #i36136# The remembered MapMode of the cached part
//			MapMode										maCachedMapMode;
//
//			// Flagarray
//			// Flag to remember state ob BitmapCaching Bitmap. Default is sal_False.
//			unsigned									mbCachedBitmapValid : 1;
//
//			// #i36136# Flag to know if Alpha-Channel shall be used. Dfault is true. If
//			// true, a Alpha-VDev is used for creation of buffered context.
//			unsigned									mbUseAlphaChannel : 1;
//
//			// Calculate the clipped PixelSize (visible area) and the offset from the
//			// top left of the original object position
//			Rectangle CalculateClippedPixelRectangle(DisplayInfo& rDisplayInfo);
//
//			// Buffer Bitmap creation/deletion
//			void TryToCreateBuffer(const Rectangle& rNewSizePixel, DisplayInfo& rDisplayInfo);
//			void DisposeBuffer();
//
//			// Get bool flag about buffer status
//			sal_Bool CachedBitmapIsValid() const { return mbCachedBitmapValid; }
//
//			// Get bool flag about alpha channel
//			sal_Bool DoUseAlphaChannel() const { return mbUseAlphaChannel; }
//
//		public:
//			// basic constructor.
//			VOCBitmapBuffer_old(
//				ObjectContact& rObjectContact, ViewContact& rViewContact,
//				bool bUseAlphaChannel = true);
//
//			// The destructor.
//			virtual ~VOCBitmapBuffer_old();
//
//			// Prepare deletion of this object.
//			virtual void PrepareDelete();
//
//			// Paint this object. This is before evtl. SubObjects get painted. This method
//			// needs to set the flag mbIsPainted and mbIsInvalidated and to set the
//			// maPaintedRectangle member. This information is later used for invalidates
//			// and repaints.
//			virtual void PaintObject(DisplayInfo& rDisplayInfo);
//
//			// React on changes of the object of this ViewContact
//			virtual void ActionChanged();
//
//			// Take some action when new objects are inserted
//			virtual void ActionChildInserted(const Rectangle& rInitialRectangle);
//		};
//	} // end of namespace contact
//} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_CONTACT_VOCBITMAPBUFFER_HXX

// eof
