/*************************************************************************
 *
 *  $RCSfile: animationinfo.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2003/11/24 16:24:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SDR_ANIMATION_ANIMATIONINFO_HXX
#define _SDR_ANIMATION_ANIMATIONINFO_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _SV_GEN_HXX
#include <tools/gen.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////
// predeclarations

namespace sdr
{
	namespace mixer
	{
		class BasicMixer;
	} // end of namespace mixer
	namespace contact
	{
		class ViewObjectContact;
		class DisplayInfo;
	} // end of namespace contact
	namespace animation
	{
		class AnimationState;
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		class AnimationInfo
		{
		protected:
			// This needs to be called whenever a defining parameter changes.
			// Default does nothing.
			virtual void ParameterChange();

		public:
			// basic constructor.
			AnimationInfo();

			// destructor
			virtual ~AnimationInfo();

			// This method has to create a fitting AnimationState for the
			// AnimationInfo. It gets the ViewObjectContact it is intended for. This
			// method has to return an Incarnation in every case.
			// Default incarnates standard AnimationState.
			virtual AnimationState* CreateAnimationState(sdr::contact::ViewObjectContact& rVOContact);

			// test if to register at ObjectAnimator again after given time.
			// Fill in the new time value and return accordingly.
			virtual sal_Bool DoRegisterAgain(sal_uInt32 nTime, sal_uInt32& rNewTime, const AnimationState& rAssociatedAS) const = 0;

			// paint method. These needs to paint the object in state of given time point. For
			// this, normally object parameters are changed, then paint from the associated
			// ViewContact is called, then object parameters restored. Default just calls the
			// paint at ViewContact.
			virtual sal_Bool PaintObjectAtTime(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo, 
				Rectangle& rPaintRectangle, const sdr::contact::ViewObjectContact& rAssociatedVOC);

			// Get animation start time, the time it needs to be triggered the
			// first time. Default returns 0L which means to start at once.
			virtual sal_uInt32 GetStartTime() const;

			// React on changes of the object of this AnimationInfo. Default
			// does nothing.
			virtual void ActionChanged();

			// Decide if animation is allowed for the given VOC. Default always returns
			// sal_True. Maybe necessary to switch off for accessibility (e.g.)
			virtual sal_Bool IsAnimationAllowed(const sdr::contact::ViewObjectContact& rVOContact) const;

			// Return smallest/biggest time unit in ms which is handled
			static sal_uInt32 GetSmallestStepTime();
			static sal_uInt32 GetBiggestStepTime();
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		class AInfoDummy : public AnimationInfo
		{
		public:
			// basic constructor.
			AInfoDummy();

			// destructor
			virtual ~AInfoDummy();

			// test if to register at ObjectAnimator again after given time.
			// Fill in the new time value and return accordingly.
			virtual sal_Bool DoRegisterAgain(sal_uInt32 nTime, sal_uInt32& rNewTime, const AnimationState& rAssociatedAS) const;
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		class AInfoMixer : public AnimationInfo
		{
		private:
			// This is the object mixer member to create the in-between states for the
			// Loops between 0.0 and 1.0
			sdr::mixer::BasicMixer*					mpMixer;

			// Create the BasicMixer, called from GetBasicMixer on demand
			virtual sdr::mixer::BasicMixer* CreateBasicMixer() = 0;

		protected:
			// Access the BasicMixer, plus creation on demand. Will use CreateBasicMixer() then.
			sdr::mixer::BasicMixer& GetBasicMixer() const;

			// calculate the MixerState value for given time
			virtual double GetMixerState(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo) const = 0;

		public:
			// basic constructor.
			AInfoMixer();

			// destructor
			virtual ~AInfoMixer();

			// paint method. This implementation uses the mixer to paint the object
			// in the current state.
			virtual sal_Bool PaintObjectAtTime(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo, 
				Rectangle& rPaintRectangle, const sdr::contact::ViewObjectContact& rAssociatedVOC);
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_ANIMATION_ANIMATIONINFO_HXX

// eof
