/*************************************************************************
 *
 *  $RCSfile: svdmark.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/21 15:25:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVDMARK_HXX
#define _SVDMARK_HXX

#ifndef _CONTNR_HXX //autogen
#include <tools/contnr.hxx>
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

class Rectangle;
class SdrPage;
class SdrObjList;
class SdrObject;
class SdrPageView;

// Ein Container fuer USHORTs (im Prinzip ein dynamisches Array)
class SdrUShortCont 
{
	Container											maArray;
	sal_Bool											mbSorted;

private:
	void CheckSort(sal_uInt32 nPos);

public:
	SdrUShortCont(sal_uInt16 nBlock, sal_uInt16 nInit, sal_uInt16 nResize)
	:	maArray(nBlock, nInit, nResize), 
	mbSorted(sal_True) 
	{}

	SdrUShortCont(const SdrUShortCont& rCont)
	:	maArray(rCont.maArray), 
		mbSorted(rCont.mbSorted) 
	{}

	SdrUShortCont& operator=(const SdrUShortCont& rCont)
	{ 
		maArray = rCont.maArray; 
		mbSorted = rCont.mbSorted; 
		return *this; 
	}

	sal_Bool operator==(const SdrUShortCont& rCont) const 
	{ 
		return maArray == rCont.maArray; 
	}

	sal_Bool operator!=(const SdrUShortCont& rCont) const 
	{ 
		return maArray != rCont.maArray; 
	}

	void Clear()
	{ 
		maArray.Clear(); 
		mbSorted = sal_True; 
	}

	void Sort() const;

	void ForceSort() const
	{ 
		if(!mbSorted) 
		{
			Sort(); 
		}
	}

	void Insert(sal_uInt16 nElem, sal_uInt32 nPos = CONTAINER_APPEND) 
	{ 
		maArray.Insert((void*)sal_uInt32(nElem),nPos); 
		
		if(mbSorted) 
		{
			CheckSort(nPos); 
		}
	}

	void Remove(sal_uInt32 nPos) 
	{ 
		maArray.Remove(nPos); 
	}

	void Replace(sal_uInt16 nElem, sal_uInt32 nPos)
	{ 
		maArray.Replace((void*)sal_uInt32(nElem), nPos); 
		
		if(mbSorted)
		{
			CheckSort(nPos); 
		}
	}

	sal_uInt16 GetObject(sal_uInt32 nPos) const 
	{ 
		return sal_uInt16(sal_uInt32(maArray.GetObject(nPos))); 
	}

	sal_uInt32 GetPos(sal_uInt16 nElem) const
	{ 
		return maArray.GetPos((void*)(sal_uInt32)nElem); 
	}

	sal_uInt32 GetCount() const
	{ 
		return maArray.Count(); 
	}

	sal_Bool Exist(sal_uInt16 nElem) const
	{ 
		return (CONTAINER_ENTRY_NOTFOUND != maArray.GetPos((void*)(sal_uInt32)nElem)); 
	}
};

// Alles was eine View ueber ein markiertes Objekt wissen muss
class SdrMark 
{ 
protected:
	SdrObject*											mpObj;
	SdrPageView*										mpPageView;
	SdrUShortCont*										mpPoints;     // Markierte Punkte
	SdrUShortCont*										mpLines;      // Markierte Linienabschnitte
	SdrUShortCont*										mpGluePoints; // Markierte Klebepunkte (deren Id's)
	sal_Bool											mbCon1;       // fuer Connectoren
	sal_Bool											mbCon2;       // fuer Connectoren
	sal_uInt16											mnUser;       // z.B. fuer CopyObjects, mitkopieren von Edges

public:
	SdrMark(SdrObject* pNewObj = 0L, SdrPageView* pNewPageView = 0L)
	:	mpObj(pNewObj), 
		mpPageView(pNewPageView), 
		mpPoints(0L), 
		mpLines(0L), 
		mpGluePoints(0L), 
		mbCon1(sal_False), 
		mbCon2(sal_False), 
		mnUser(0) 
	{}
	
	SdrMark(const SdrMark& rMark)
	:	mpObj(0L), 
		mpPageView(0L), 
		mpPoints(0L), 
		mpLines(0L), 
		mpGluePoints(0L), 
		mbCon1(sal_False), 
		mbCon2(sal_False), 
		mnUser(0) 
	{ 
		*this = rMark; 
	}

	~SdrMark()
	{ 
		if(mpPoints) 
			delete mpPoints; 
		
		if(mpLines) 
			delete mpLines; 
		
		if(mpGluePoints) 
			delete mpGluePoints; 
	}

	SdrMark& operator=(const SdrMark& rMark);
	sal_Bool operator==(const SdrMark& rMark) const;
	sal_Bool operator!=(const SdrMark& rMark) const 
	{ 
		return !(operator==(rMark)); 
	}

	SdrObject* GetObj() const
	{ 
		return mpObj; 
	}

	SdrPage* GetPage() const;
	SdrObjList* GetObjList() const;
	SdrPageView* GetPageView() const
	{ 
		return mpPageView; 
	}

	void SetObj(SdrObject* pNewObj)
	{ 
		mpObj = pNewObj; 
	}

	void SetPageView(SdrPageView* pNewPageView) 
	{ 
		mpPageView = pNewPageView; 
	}

	void SetCon1(sal_Bool bOn) 
	{ 
		mbCon1 = bOn; 
	}

	sal_Bool IsCon1() const
	{ 
		return mbCon1; 
	}

	void SetCon2(sal_Bool bOn)
	{ 
		mbCon2 = bOn; 
	}

	sal_Bool IsCon2() const
	{ 
		return mbCon2; 
	}
	
	void SetUser(sal_uInt16 nVal)
	{ 
		mnUser = nVal; 
	}

	sal_uInt16 GetUser() const
	{ 
		return mnUser; 
	}
	
	const SdrUShortCont* GetMarkedPoints() const
	{ 
		return mpPoints;     
	}

	const SdrUShortCont* GetMarkedLines() const
	{ 
		return mpLines;      
	}
	
	const SdrUShortCont* GetMarkedGluePoints() const    
	{ 
		return mpGluePoints; 
	}

	SdrUShortCont* GetMarkedPoints()
	{ 
		return mpPoints;     
	}
	
	SdrUShortCont* GetMarkedLines()
	{ 
		return mpLines;      
	}
	
	SdrUShortCont* GetMarkedGluePoints()
	{ 
		return mpGluePoints; 
	}

	SdrUShortCont* ForceMarkedPoints()
	{ 
		if(!mpPoints) 
			mpPoints = new SdrUShortCont(1024, 32, 32); 
		
		return mpPoints; 
	}

	SdrUShortCont* ForceMarkedLines()             
	{ 
		if(!mpLines) 
			mpLines = new SdrUShortCont(1024, 32, 32); 
		
		return mpLines; 
	}
	
	SdrUShortCont* ForceMarkedGluePoints()        
	{ 
		if(!mpGluePoints) 
			mpGluePoints = new SdrUShortCont(1024, 32, 32); 
		
		return mpGluePoints; 
	}
};

class SVX_DLLPUBLIC SdrMarkList 
{
protected:
	Container											maList;

	String												maMarkName;
	String												maPointName;
	String												maGluePointName;

	sal_Bool											mbPointNameOk;
	sal_Bool											mbGluePointNameOk;
	sal_Bool											mbNameOk;
	sal_Bool											mbSorted;

private:
	SVX_DLLPRIVATE sal_Bool operator==(const SdrMarkList& rCmpMarkList) const;
	SVX_DLLPRIVATE void ImpForceSort();

private:
	SVX_DLLPRIVATE const XubString& GetPointMarkDescription(sal_Bool bGlue) const;

public:
	SdrMarkList() 
	:	maList(1024, 64, 64),
		mbPointNameOk(sal_False),
		mbGluePointNameOk(sal_False),
		mbNameOk(sal_False),
		mbSorted(sal_True) 
	{
	}

	SdrMarkList(const SdrMarkList& rLst) 
	:	maList(1024, 64, 64)        
	{ 
		*this = rLst; 
	}

	~SdrMarkList() 
	{ 
		Clear(); 
	}

	void Clear();
	void ForceSort() const;
	void SetUnsorted()
	{ 
		mbSorted = sal_False; 
	}

	sal_uInt32 GetMarkCount() const 
	{ 
		return maList.Count(); 
	}

	SdrMark* GetMark(sal_uInt32 nNum) const 
	{ 
		return (SdrMark*)(maList.GetObject(nNum)); 
	}
	
	sal_uInt32 FindObject(const SdrObject* pObj) const;
	void InsertEntry(const SdrMark& rMark, sal_Bool bChkSort = sal_True);
	void DeleteMark(sal_uInt32 nNum);
	void ReplaceMark(const SdrMark& rNewMark, sal_uInt32 nNum);
	void Merge(const SdrMarkList& rSrcList, sal_Bool bReverse = sal_False);
	sal_Bool DeletePageView(const SdrPageView& rPV);
	sal_Bool InsertPageView(const SdrPageView& rPV);

	void SetNameDirty() 
	{ 
		mbNameOk = sal_False; 
		mbPointNameOk = sal_False; 
		mbGluePointNameOk = sal_False; 
	}

	// Eine verbale Beschreibung der markierten Objekte z.B.:
	// "27 Linien", "12 Objekte", "Polygon" oder auch "Kein Objekt"
	const String& GetMarkDescription() const;
	const String& GetPointMarkDescription() const 
	{ 
		return GetPointMarkDescription(sal_False); 
	}

	const String& GetGluePointMarkDescription() const 
	{ 
		return GetPointMarkDescription(sal_True); 
	}

	// pPage=0L: Die Markierungen aller! Seiten beruecksichtigen
	sal_Bool TakeBoundRect(SdrPageView* pPageView, Rectangle& rRect) const;
	sal_Bool TakeSnapRect(SdrPageView* pPageView, Rectangle& rRect) const;

	// Es werden saemtliche Entries kopiert!
	void operator=(const SdrMarkList& rLst);
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// migrate selections

namespace sdr
{
	class SVX_DLLPUBLIC ViewSelection
	{
		SdrMarkList					maMarkedObjectList;
		SdrMarkList					maEdgesOfMarkedNodes;
		SdrMarkList					maMarkedEdgesOfMarkedNodes;
		List						maAllMarkedObjects;

		// bitfield
		unsigned					mbEdgesOfMarkedNodesDirty : 1;

		SVX_DLLPRIVATE void ImpForceEdgesOfMarkedNodes();
		SVX_DLLPRIVATE void ImplCollectCompleteSelection(SdrObject* pObj);

	public:
		ViewSelection();

		void SetEdgesOfMarkedNodesDirty();

		const SdrMarkList& GetMarkedObjectList() const 
		{ 
			return maMarkedObjectList; 
		}

		const SdrMarkList& GetEdgesOfMarkedNodes() const;
		const SdrMarkList& GetMarkedEdgesOfMarkedNodes() const;
		const List& GetAllMarkedObjects() const;

		SdrMarkList& GetMarkedObjectListWriteAccess() 
		{ 
			return maMarkedObjectList; 
		}
	};
} // end of namespace sdr

////////////////////////////////////////////////////////////////////////////////////////////////////

#endif //_SVDMARK_HXX
// eof
