/*************************************************************************
 *
 *  $RCSfile: svddrgmt.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/21 15:21:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVDDRGMT_HXX
#define _SVDDRGMT_HXX

#ifndef _SVDDRGV_HXX
#include "svddrgv.hxx"
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  @@@@@  @@@@@   @@@@   @@@@   @@   @@ @@@@@ @@@@@@ @@  @@  @@@@  @@@@@   @@@@
//  @@  @@ @@  @@ @@  @@ @@  @@  @@@ @@@ @@      @@   @@  @@ @@  @@ @@  @@ @@  @@
//  @@  @@ @@  @@ @@  @@ @@      @@@@@@@ @@      @@   @@  @@ @@  @@ @@  @@ @@
//  @@  @@ @@@@@  @@@@@@ @@ @@@  @@@@@@@ @@@@    @@   @@@@@@ @@  @@ @@  @@  @@@@
//  @@  @@ @@  @@ @@  @@ @@  @@  @@ @ @@ @@      @@   @@  @@ @@  @@ @@  @@     @@
//  @@  @@ @@  @@ @@  @@ @@  @@  @@   @@ @@      @@   @@  @@ @@  @@ @@  @@ @@  @@
//  @@@@@  @@  @@ @@  @@  @@@@@  @@   @@ @@@@@   @@   @@  @@  @@@@  @@@@@   @@@@
//
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

class SdrDragView;
class SdrDragStat;

class SVX_DLLPUBLIC SdrDragMethod {
protected:
	SdrDragView& rView;
	FASTBOOL     bMoveOnly;
protected:
#if _SOLAR__PRIVATE
	void               ImpTakeDescriptionStr(USHORT nStrCacheID, String& rStr, USHORT nVal=0) const;
#endif // __PRIVATE
	SdrHdl*            GetDragHdl() const              { return rView.pDragHdl; }
	SdrHdlKind         GetDragHdlKind() const          { return rView.eDragHdl; }
	SdrDragStat&       DragStat()                      { return rView.aDragStat; }
	const SdrDragStat& DragStat() const                { return rView.aDragStat; }
	Point&             Ref1() const                    { return rView.aRef1; }
	Point&             Ref2() const                    { return rView.aRef2; }
	const SdrHdlList&  GetHdlList() const              { return rView.aHdl; }
	void               AddUndo(SdrUndoAction* pUndo)   { rView.AddUndo(pUndo); }
	void               SetStripes(FASTBOOL bOn)        { rView.aAni.SetStripes(bOn); }
	void               SetDragPolys()                  { rView.SetDragPolys(FALSE); }
	void               SetDragPolysSeparated()         { rView.SetDragPolys(FALSE,TRUE); }
	FASTBOOL           IsDragLimit()                   { return rView.bDragLimit; }
	const Rectangle&   GetDragLimitRect()              { return rView.aDragLimit; }
	const SdrMarkList& GetMarkedObjectList()                   { return rView.GetMarkedObjectList(); }
	Point              GetSnapPos(const Point& rPt) const { return rView.GetSnapPos(rPt,rView.pMarkedPV); }
	USHORT             SnapPos(Point& rPt) const       { return rView.SnapPos(rPt,rView.pMarkedPV); }
	inline const Rectangle& GetMarkedRect() const;
	SdrPageView*       GetDragPV() const;
	SdrObject*         GetDragObj() const;
	OutputDevice*      GetDragWin() const              { return rView.pDragWin; }
	FASTBOOL           IsDraggingPoints() const        { return rView.IsDraggingPoints(); }
	FASTBOOL           IsDraggingGluePoints() const    { return rView.IsDraggingGluePoints(); }
public:
	TYPEINFO();
	SdrDragMethod(SdrDragView& rNewView): rView(rNewView),bMoveOnly(FALSE) {}
	virtual void Draw() const;
	virtual void Show();
	virtual void Hide();
	virtual void TakeComment(String& rStr) const=0;
	virtual FASTBOOL Beg()=0;
	virtual void MovAllPoints();
	virtual void MovPoint(Point& rPnt, const Point& rPvOfs);
	virtual void Mov(const Point& rPnt)=0;
	virtual FASTBOOL End(FASTBOOL bCopy)=0;
	virtual void Brk();
	virtual Pointer GetPointer() const=0;
	virtual FASTBOOL IsMoveOnly() const; // TRUE, wenn nur verschoben wird
	virtual void DrawXor(XOutputDevice& rXOut, FASTBOOL bFull) const;
};

inline const Rectangle& SdrDragMethod::GetMarkedRect() const
{
	return rView.eDragHdl==HDL_POLY ? rView.GetMarkedPointsRect() :
		   rView.eDragHdl==HDL_GLUE ? rView.GetMarkedGluePointsRect() :
		   rView.GetMarkedObjRect();
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#endif //_SVDDRGMT_HXX

