/*************************************************************************
 *
 *  $RCSfile: fmview.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/21 14:34:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVX_FMVIEW_HXX
#define _SVX_FMVIEW_HXX

// HACK to avoid too deep includes and to have some
// levels free in svdmark itself (MS compiler include depth limit)
#ifndef _SVDHDL_HXX
#include "svdhdl.hxx"
#endif

#ifndef _E3D_VIEW3D_HXX
#include <view3d.hxx>
#endif
#ifndef _COMPHELPER_UNO3_HXX_
#include <comphelper/uno3.hxx>
#endif
#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

FORWARD_DECLARE_INTERFACE(util,XNumberFormats)
FORWARD_DECLARE_INTERFACE(beans,XPropertySet)

class OutputDevice;
class XOutputDevice;
class FmFormModel;
class FmPageViewWinRec;
class FmFormPage;

namespace svx {
	class ODataAccessDescriptor;
}

class SVX_DLLPUBLIC FmFormView : public E3dView
{
	friend class FmXFormController;
	friend class FmFormShell;
	friend class FmXFormShell;
	friend class FmXFormView;
	friend class FmExplorer;
	friend class FmFormObj;

	FmXFormView*	pImpl;
	FmFormShell*	pFormShell;

	void Init();
	void SetFormShell( FmFormShell* pShell ) { pFormShell = pShell; }
	FmFormShell* GetFormShell() const { return pFormShell; }

public:
	TYPEINFO();

	FmFormView(FmFormModel* pModel, OutputDevice* pOut);
	FmFormView(FmFormModel* pModel, XOutputDevice* pOut);
	FmFormView(FmFormModel* pModel);
	virtual ~FmFormView();

	/** create a control pair (label/bound control) for the database field description given.
		@param rFieldDesc
			description of the field. see clipboard format SBA-FIELDFORMAT
		@deprecated
			This method is deprecated. Use the version with a ODataAccessDescriptor instead.
	*/
	SdrObject*	 CreateFieldControl(const UniString& rFieldDesc) const;

	/** create a control pair (label/bound control) for the database field description given.
	*/
	SdrObject*	 CreateFieldControl( const ::svx::ODataAccessDescriptor& _rColumnDescriptor );

	/** create a control pair (label/bound control) for the xforms description given.
	*/
	SdrObject*	 CreateXFormsControl( /* we need a descriptor */ );

	virtual void MarkListHasChanged();
	virtual void AddWin(OutputDevice* pWin1);
	virtual void DelWin(OutputDevice* pWin1);

	virtual SdrPageView* ShowPage(SdrPage* pPage, const Point& rOffs);
	virtual void HidePage(SdrPageView* pPV);

	// for copying complete form structures, not only control models
	virtual SdrModel* GetMarkedObjModel() const;
	virtual sal_Bool Paste(const SdrModel& rMod, const Point& rPos, SdrObjList* pLst=NULL, sal_uInt32 nOptions=0);

	virtual BOOL MouseButtonDown( const MouseEvent& _rMEvt, Window* _pWin );

    /** grab the focus to the first form control on the view
		@param _bForceSync
			<TRUE/> if the handling should be done synchronously.
	*/
	void	GrabFirstControlFocus( sal_Bool _bForceSync = sal_False );

	// SdrView
	BOOL KeyInput(const KeyEvent& rKEvt, Window* pWin);

protected:
	void ActivateControls(SdrPageView*);
	void DeactivateControls(SdrPageView*);

	// Hinweis an die UI, da ein Control erzeugt worden ist
	void ObjectCreated(FmFormObj* pObj);
	void ChangeDesignMode(sal_Bool bDesign);

public:
	FmXFormView* GetImpl() const {return pImpl;}

	virtual void InsertControlContainer(const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer >& xCC);
	virtual void RemoveControlContainer(const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlContainer >& xCC);
private:
	SVX_DLLPRIVATE const OutputDevice* GetActualOutDev() const {return pActualOutDev;}
	SVX_DLLPRIVATE void AdjustMarks(const SdrMarkList& rMarkList);
	SVX_DLLPRIVATE sal_Bool checkUnMarkAll(const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& _xSource);
	SVX_DLLPRIVATE FmFormObj* getMarkedGrid() const;
};




#endif          // _FML_FMVIEW_HXX

