/*************************************************************************
 *
 *  $RCSfile: registerlight.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2004/11/26 20:40:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#include <cppuhelper/factory.hxx>

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#include <passwordcontainer.hxx>
#include <fsfactory.hxx>

#include <pathoptions.hxx>
#include <toolkit/helper/macros.hxx>

using namespace ::com::sun::star;

#define IMPL_CREATEINSTANCE( ImplName ) \
	uno::Reference< uno::XInterface > SAL_CALL ImplName##_CreateInstance( const uno::Reference< lang::XMultiServiceFactory >& ) \
	{ return uno::Reference < uno::XInterface >( ( ::cppu::OWeakObject* ) new ImplName ); }

// for CreateInstance functions implemented elsewhere
#define DECLARE_CREATEINSTANCE( ImplName ) \
	uno::Reference< uno::XInterface > SAL_CALL ImplName##_CreateInstance( const uno::Reference< lang::XMultiServiceFactory >& );

// for CreateInstance functions implemented elsewhere, while the function is within a namespace
#define DECLARE_CREATEINSTANCE_NAMESPACE( nmspe, ImplName ) \
	namespace nmspe {	\
		uno::Reference< uno::XInterface > SAL_CALL ImplName##_CreateInstance( const uno::Reference< lang::XMultiServiceFactory >& );	\
	}

// -------------------------------------------------------------------------------------
IMPL_CREATEINSTANCE( PathService )

extern "C"
{

void SAL_CALL component_getImplementationEnvironment( const sal_Char** ppEnvTypeName, uno_Environment** ppEnv )
{
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

sal_Bool SAL_CALL component_writeInfo( void* _pServiceManager, void* _pRegistryKey )
{
	if (_pRegistryKey)
	{
		try
		{
			registry::XRegistryKey * pRegistryKey = reinterpret_cast< registry::XRegistryKey* >( _pRegistryKey );
			uno::Reference< registry::XRegistryKey > xNewKey;
        	xNewKey = pRegistryKey->createKey(
							::rtl::OUString::createFromAscii( "/com.sun.star.comp.svtools.PathService/UNO/SERVICES" ) );
        	xNewKey->createKey( ::rtl::OUString::createFromAscii( "com.sun.star.config.SpecialConfigManager" ) );
        	xNewKey = pRegistryKey->createKey(
							::rtl::OUString::createFromAscii( "/stardiv.svtools.PasswordContainer/UNO/SERVICES" ));
        	xNewKey->createKey( ::rtl::OUString::createFromAscii("com.sun.star.task.PasswordContainer") );

			// register file system storage
			xNewKey = pRegistryKey->createKey( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("/") ) + 
										FSStorageFactory::impl_staticGetImplementationName() +
										::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( "/UNO/SERVICES") )  );

			const uno::Sequence< ::rtl::OUString > aServices = FSStorageFactory::impl_staticGetSupportedServiceNames();
			for( sal_Int32 ind = 0; ind < aServices.getLength(); ind++ )
				xNewKey->createKey( aServices.getConstArray()[ind] );

			return sal_True;
		}
		catch (registry::InvalidRegistryException &)
		{
			OSL_ENSURE( sal_False, "### InvalidRegistryException!" );
		}

	}
	return sal_True;
}

void* SAL_CALL component_getFactory( const sal_Char* sImplementationName, void* _pServiceManager, void* _pRegistryKey )
{
	void* pRet = NULL;

	if ( _pServiceManager )
	{
		lang::XMultiServiceFactory* pServiceManager = reinterpret_cast< lang::XMultiServiceFactory* >( _pServiceManager );
		uno::Reference< lang::XSingleServiceFactory > xFactory;
		::rtl::OUString aImplName( ::rtl::OUString::createFromAscii( sImplementationName ) );

        if ( aImplName.equals( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.svtools.PathService" ) ) ) )
		{
			uno::Sequence< ::rtl::OUString > aServiceNames(1);
            aServiceNames.getArray()[0] = ::rtl::OUString::createFromAscii( "com.sun.star.config.SpecialConfigManager" );
            xFactory = ::cppu::createSingleFactory( pServiceManager, aImplName, PathService_CreateInstance, aServiceNames );
		}
        else if ( aImplName.equals( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "stardiv.svtools.PasswordContainer" ) ) ) )
		{
		     xFactory = PasswordContainer::impl_createFactory( pServiceManager );
		}
		else if ( aImplName.equals( FSStorageFactory::impl_staticGetImplementationName() ) )
		{
			xFactory= ::cppu::createOneInstanceFactory( pServiceManager,
											FSStorageFactory::impl_staticGetImplementationName(),
											FSStorageFactory::impl_staticCreateSelfInstance,
											FSStorageFactory::impl_staticGetSupportedServiceNames() );
		}

		if ( xFactory.is() )
		{
			xFactory->acquire();
			pRet = xFactory.get();
		}
	}
	return pRet;
}

}	// "C"

