/*************************************************************************
 *
 *  $RCSfile: svlbitm.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2004/07/23 11:56:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SVLBOXITM_HXX
#define _SVLBOXITM_HXX

#ifndef LINK_HXX
#include <tools/link.hxx>
#endif

#ifndef _IMAGE_HXX
#include <vcl/image.hxx>
#endif

#ifndef _SVLBOX_HXX //autogen
#include <svlbox.hxx>
#endif
class SvLBoxEntry;

#define SV_ITEM_ID_LBOXSTRING		1
#define SV_ITEM_ID_LBOXBMP			2
#define SV_ITEM_ID_LBOXBUTTON		3
#define SV_ITEM_ID_LBOXCONTEXTBMP	4

enum SvButtonState { SV_BUTTON_UNCHECKED, SV_BUTTON_CHECKED, SV_BUTTON_TRISTATE };

#define SV_BMP_UNCHECKED		0
#define SV_BMP_CHECKED   		1
#define SV_BMP_TRISTATE  		2
#define SV_BMP_HIUNCHECKED 		3
#define SV_BMP_HICHECKED   		4
#define SV_BMP_HITRISTATE  		5

struct SvLBoxButtonData_Impl;

class SvLBoxButtonData
{
private:
	Link 					aLink;
	long 					nWidth;
	long					nHeight;
	SvLBoxButtonData_Impl*	pImpl;
	BOOL					bDataOk;
	SvButtonState			eState;

	void 					SetWidthAndHeight();
	void					InitData( BOOL bImagesFromDefault,
									  bool _bRadioBtn, const Control* pControlForSettings = NULL );
public:
							// include creating default images (CheckBox or RadioButton)
							SvLBoxButtonData( const Control* pControlForSettings );
							SvLBoxButtonData( const Control* pControlForSettings, bool _bRadioBtn );

							SvLBoxButtonData();
							~SvLBoxButtonData();

	USHORT 					GetIndex( USHORT nItemState );
	inline long				Width();
	inline long				Height();
	void					SetLink( const Link& rLink) { aLink=rLink; }
	const Link&				GetLink() const { return aLink; }
	// weil Buttons nicht von LinkHdl abgeleitet sind
	void					CallLink();

	void					StoreButtonState( SvLBoxEntry* pEntry, USHORT nItemFlags );
	SvButtonState 			ConvertToButtonState( USHORT nItemFlags ) const;

	inline SvButtonState	GetActButtonState() const;
	SvLBoxEntry*			GetActEntry() const;

	Image aBmps[24];  // Indizes siehe Konstanten BMP_ ....

	void					SetDefaultImages( const Control* pControlForSettings = NULL );
								// set images acording to the color scheeme of the Control
								// pControlForSettings == NULL: settings are taken from Application
	BOOL					HasDefaultImages( void ) const;
};

inline long SvLBoxButtonData::Width()
{
	if ( !bDataOk )
		SetWidthAndHeight();
	return nWidth;
}

inline long SvLBoxButtonData::Height()
{
	if ( !bDataOk )
		SetWidthAndHeight();
	return nHeight;
}

inline SvButtonState SvLBoxButtonData::GetActButtonState() const
{
	return eState;
}

// **********************************************************************

class SvLBoxString : public SvLBoxItem
{
	XubString aStr;
public:
					SvLBoxString( SvLBoxEntry*,USHORT nFlags,const XubString& rStr);
					SvLBoxString();
	virtual			~SvLBoxString();
	virtual USHORT	IsA();
	void			InitViewData( SvLBox*,SvLBoxEntry*,SvViewDataItem* );
	XubString		GetText() const { return aStr; }
	void 			SetText( SvLBoxEntry*, const XubString& rStr );
	void			Paint( const Point&, SvLBox& rDev, USHORT nFlags,SvLBoxEntry* );
	SvLBoxItem* 	Create() const;
	void 			Clone( SvLBoxItem* pSource );
};

class SvLBoxBmp : public SvLBoxItem
{
	Image aBmp;
public:
					SvLBoxBmp( SvLBoxEntry*, USHORT nFlags, Image );
					SvLBoxBmp();
	virtual			~SvLBoxBmp();
	virtual USHORT	IsA();
	void			InitViewData( SvLBox*,SvLBoxEntry*,SvViewDataItem* );
	void			SetBitmap( SvLBoxEntry*, Image );
	void			Paint( const Point&, SvLBox& rView, USHORT nFlags,SvLBoxEntry* );
	SvLBoxItem*	 	Create() const;
	void 			Clone( SvLBoxItem* pSource );
};


#define SV_ITEMSTATE_UNCHECKED			0x0001
#define SV_ITEMSTATE_CHECKED			0x0002
#define SV_ITEMSTATE_TRISTATE			0x0004
#define SV_ITEMSTATE_HILIGHTED			0x0008
#define SV_STATE_MASK 0xFFF8  // zum Loeschen von UNCHECKED,CHECKED,TRISTATE

class SvLBoxButton : public SvLBoxItem
{
	SvLBoxButtonData*	pData;
	USHORT nItemFlags;
	USHORT nImgArrOffs;
	USHORT nBaseOffs;
public:
					SvLBoxButton( SvLBoxEntry*,USHORT nFlags, SvLBoxButtonData* );
					SvLBoxButton();
	virtual			~SvLBoxButton();
	void			InitViewData( SvLBox*,SvLBoxEntry*,SvViewDataItem* );
	virtual USHORT	IsA();
	void 			Check( SvLBox* pView, SvLBoxEntry*, BOOL bCheck );
	virtual BOOL 	ClickHdl(SvLBox* pView, SvLBoxEntry* );
	void			Paint( const Point&, SvLBox& rView, USHORT nFlags,SvLBoxEntry* );
	SvLBoxItem*	 	Create() const;
	void 			Clone( SvLBoxItem* pSource );
	USHORT			GetButtonFlags() const { return nItemFlags; }
	BOOL			IsStateChecked() const { return (BOOL)(nItemFlags & SV_ITEMSTATE_CHECKED)!=0; }
	BOOL			IsStateUnchecked() const { return (BOOL)(nItemFlags & SV_ITEMSTATE_UNCHECKED)!=0; }
	BOOL			IsStateTristate() const { return (BOOL)(nItemFlags & SV_ITEMSTATE_TRISTATE)!=0; }
	BOOL			IsStateHilighted() const { return (BOOL)(nItemFlags & SV_ITEMSTATE_HILIGHTED)!=0; }
	void			SetStateChecked();
	void			SetStateUnchecked();
	void			SetStateTristate();
	void			SetStateHilighted( BOOL bHilight );

	void			SetBaseOffs( USHORT nOffs ) { nBaseOffs = nOffs; }
	USHORT			GetBaseOffs() const { return nBaseOffs; }
};

inline void	SvLBoxButton::SetStateChecked()
{
	nItemFlags &= SV_STATE_MASK;
	nItemFlags |= SV_ITEMSTATE_CHECKED;
}
inline void	SvLBoxButton::SetStateUnchecked()
{
	nItemFlags &= SV_STATE_MASK;
	nItemFlags |= SV_ITEMSTATE_UNCHECKED;
}
inline void	SvLBoxButton::SetStateTristate()
{
	nItemFlags &= SV_STATE_MASK;
	nItemFlags |= SV_ITEMSTATE_TRISTATE;
}
inline void SvLBoxButton::SetStateHilighted( BOOL bHilight )
{
	if ( bHilight )
		nItemFlags |= SV_ITEMSTATE_HILIGHTED;
	else
		nItemFlags &= ~SV_ITEMSTATE_HILIGHTED;
}


struct SvLBoxContextBmp_Impl;
class SvLBoxContextBmp : public SvLBoxItem
{
	SvLBoxContextBmp_Impl*	m_pImpl;
public:
					SvLBoxContextBmp( SvLBoxEntry*,USHORT nFlags,Image,Image,
									USHORT nEntryFlagsBmp1);
					SvLBoxContextBmp();
	virtual			~SvLBoxContextBmp();
	virtual USHORT	IsA();
	void			InitViewData( SvLBox*,SvLBoxEntry*,SvViewDataItem* );
	void			Paint( const Point&, SvLBox& rView, USHORT nFlags,SvLBoxEntry* );
	SvLBoxItem*	 	Create() const;
	void 			Clone( SvLBoxItem* pSource );


	BOOL			SetModeImages( const Image& _rBitmap1, const Image& _rBitmap2, BmpColorMode _eMode = BMP_COLOR_NORMAL );
	void			GetModeImages(		 Image& _rBitmap1,		 Image& _rBitmap2, BmpColorMode _eMode = BMP_COLOR_NORMAL ) const;

	inline void			SetBitmap1( SvLBoxEntry* _pEntry, const Image& _rImage, BmpColorMode _eMode = BMP_COLOR_NORMAL );
	inline void			SetBitmap2( SvLBoxEntry* _pEntry, const Image& _rImage, BmpColorMode _eMode = BMP_COLOR_NORMAL );
	inline const Image&	GetBitmap1( BmpColorMode _eMode = BMP_COLOR_NORMAL ) const;
	inline const Image&	GetBitmap2( BmpColorMode _eMode = BMP_COLOR_NORMAL ) const;

private:
	Image& implGetImageStore( sal_Bool _bFirst, BmpColorMode _eMode );
};

inline void SvLBoxContextBmp::SetBitmap1( SvLBoxEntry* _pEntry, const Image& _rImage, BmpColorMode _eMode  )
{
	implGetImageStore( sal_True, _eMode ) = _rImage;
}

inline void	SvLBoxContextBmp::SetBitmap2( SvLBoxEntry* _pEntry, const Image& _rImage, BmpColorMode _eMode  )
{
	implGetImageStore( sal_False, _eMode ) = _rImage;
}

inline const Image&	SvLBoxContextBmp::GetBitmap1( BmpColorMode _eMode ) const
{
	Image& rImage = const_cast< SvLBoxContextBmp* >( this )->implGetImageStore( sal_True, _eMode );
	if ( !rImage )
		// fallback to the "normal" image
		rImage = const_cast< SvLBoxContextBmp* >( this )->implGetImageStore( sal_True, BMP_COLOR_NORMAL );
	return rImage;
}

inline const Image&	SvLBoxContextBmp::GetBitmap2( BmpColorMode _eMode ) const
{
	Image& rImage = const_cast< SvLBoxContextBmp* >( this )->implGetImageStore( sal_False, _eMode );
	if ( !rImage )
		// fallback to the "normal" image
		rImage = const_cast< SvLBoxContextBmp* >( this )->implGetImageStore( sal_True, BMP_COLOR_NORMAL );
	return rImage;
}

#endif
