/*************************************************************************
 *
 *  $RCSfile: moduleoptions.hxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: obo $ $Date: 2004/11/15 17:19:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#define INCLUDED_SVTOOLS_MODULEOPTIONS_HXX

//_________________________________________________________________________________________________________________
//	includes
//_________________________________________________________________________________________________________________

#include <salhelper/singletonref.hxx>

#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_H_
#include <com/sun/star/uno/Sequence.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#include <com/sun/star/uno/Sequence.hxx>

//_________________________________________________________________________________________________________________
//	const
//_________________________________________________________________________________________________________________

#define FEATUREFLAG_BASICIDE                0x00000020
#define FEATUREFLAG_MATH           			0x00000100
#define FEATUREFLAG_CHART          			0x00000200
#define FEATUREFLAG_CALC           			0x00000800
#define FEATUREFLAG_DRAW           			0x00001000
#define FEATUREFLAG_WRITER     				0x00002000
#define FEATUREFLAG_IMPRESS     			0x00008000
#define FEATUREFLAG_INSIGHT     			0x00010000

//_________________________________________________________________________________________________________________
//	forward declarations
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
	@short			forward declaration to our private date container implementation
	@descr			We use these class as internal member to support small memory requirements.
					You can create the container if it is neccessary. The class which use these mechanism
					is faster and smaller then a complete implementation!
*//*-*************************************************************************************************************/
class SvtModuleOptions_Impl;

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
	@short			collect informations about installation state of modules
    @descr          Use these class to get installation state of different office modules like writer, calc etc
                    Further you can ask for additional informations; e.g. name of standard template file, which
                    should be used by corresponding module; or short/long name of these module factory.

	@implements		-
	@base			-

	@devstatus		ready to use
    @threadsafe     yes
*//*-*************************************************************************************************************/
class SvtModuleOptions
{
	//-------------------------------------------------------------------------------------------------------------
    //  public const declarations!
	//-------------------------------------------------------------------------------------------------------------
    public:

        enum EModule
        {
            E_SWRITER       = 0,
            E_SCALC         = 1,
            E_SDRAW         = 2,
            E_SIMPRESS      = 3,
            E_SMATH         = 4,
            E_SCHART        = 5,
            E_SSTARTMODULE  = 6,
            E_SBASIC        = 7, 
			E_SDATABASE		= 8
        };

        /*ATTENTION:
            If you change these enum ... don't forget to change reading/writing and order of configuration values too!
            See "SvtModuleOptions_Impl::impl_GetSetNames()" and his ctor for further informations.
         */
        enum EFactory
        {
            E_UNKNOWN_FACTORY = -1,
            E_WRITER        =  0,
            E_WRITERWEB     =  1,
            E_WRITERGLOBAL  =  2,
            E_CALC          =  3,
            E_DRAW          =  4,
            E_IMPRESS       =  5,
            E_MATH          =  6,
            E_CHART         =  7,
            E_STARTMODULE   =  8,
			E_DATABASE		=  9,
            E_BASIC         = 10
			
        };

	//-------------------------------------------------------------------------------------------------------------
	//	public methods
	//-------------------------------------------------------------------------------------------------------------
	public:

		//---------------------------------------------------------------------------------------------------------
		//	constructor / destructor
		//---------------------------------------------------------------------------------------------------------
         SvtModuleOptions();
        ~SvtModuleOptions();

		//---------------------------------------------------------------------------------------------------------
		//	interface
		//---------------------------------------------------------------------------------------------------------
        sal_Bool        IsModuleInstalled         (       EModule          eModule    ) const;
        ::rtl::OUString GetModuleName             (       EModule          eModule    ) const;
        ::rtl::OUString GetModuleName             (       EFactory         eFactory   ) const;
        ::rtl::OUString GetFactoryName            (       EFactory         eFactory   ) const;
        ::rtl::OUString GetFactoryShortName       (       EFactory         eFactory   ) const;
        ::rtl::OUString GetFactoryStandardTemplate(       EFactory         eFactory   ) const;
        ::rtl::OUString GetFactoryWindowAttributes(       EFactory         eFactory   ) const;
        ::rtl::OUString GetFactoryEmptyDocumentURL(       EFactory         eFactory   ) const;
        ::rtl::OUString GetFactoryDefaultFilter   (       EFactory         eFactory   ) const;
        sal_Bool        IsDefaultFilterReadonly   (       EFactory         eFactory   ) const;
        sal_Int32       GetFactoryIcon            (       EFactory         eFactory   ) const;
        static sal_Bool ClassifyFactoryByName     ( const ::rtl::OUString& sName      ,
                                                          EFactory&        eFactory   );
        void            SetFactoryStandardTemplate(       EFactory         eFactory   ,
                                                    const ::rtl::OUString& sTemplate  );
        void            SetFactoryWindowAttributes(       EFactory         eFactory   ,
                                                    const ::rtl::OUString& sAttributes);
        void            SetFactoryDefaultFilter   (       EFactory         eFactory   ,
                                                    const ::rtl::OUString& sFilter    );

        //_______________________________________

        /** @short  return the corresponding application ID for the given
                    document service name.
         */
        static EFactory ClassifyFactoryByServiceName(const ::rtl::OUString& sName);

        //_______________________________________

        /** @short  return the corresponding application ID for the given
                    short name.
         */
        static EFactory ClassifyFactoryByShortName(const ::rtl::OUString& sName);

        //_______________________________________

        /** @short  return the corresponding application ID for the given properties.

            @descr  Because this search base on filters currently (till we have a better solution)
                    a result is not guaranteed everytimes. May a filter does not exists for the specified
                    content (but a FrameLoader which is not bound to any application!) ... or
                    the given properties describe a stream (and we make no deep detection inside here!).

            @attention  The module BASIC cant be detected here. Because it does not
                        has an own URL schema.

            @param  sURL
                    the complete URL!

            @param  lMediaDescriptor
                    additional informations

            @return A suitable enum value. See EFactory above.
         */
        static EFactory ClassifyFactoryByURL(const ::rtl::OUString&                                                           sURL            ,
                                             const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& lMediaDescriptor);

        //_______________________________________

        /** @short  return the corresponding application ID for the given properties.

            @descr  Here we try to use the list of supported service names of the given model
                    to find out the right application module.

            @attention  The module BASIC cant be detected here. Because it does not
                        support any model/ctrl/view paradigm.

            @param  xModel
                    the document model

            @return A suitable enum value. See EFactory above.
         */
        static EFactory ClassifyFactoryByModel(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >& xModel);

		::rtl::OUString GetDefaultModuleName();

		//---------------------------------------------------------------------------------------------------------
        //  old interface ...
		//---------------------------------------------------------------------------------------------------------
        sal_Bool   IsMath     ( sal_Bool bClient = sal_False ) const;
        sal_Bool   IsChart    ( sal_Bool bClient = sal_False ) const;
        sal_Bool   IsCalc     ( sal_Bool bClient = sal_False ) const;
        sal_Bool   IsDraw     ( sal_Bool bClient = sal_False ) const;
        sal_Bool   IsWriter   ( sal_Bool bClient = sal_False ) const;
        sal_Bool   IsImpress  ( sal_Bool bClient = sal_False ) const;
        sal_Bool   IsBasicIDE ( sal_Bool bClient = sal_False ) const;
		sal_Bool   IsDataBase ( sal_Bool bClient = sal_False ) const;
		sal_uInt32 GetFeatures( sal_Bool bClient = sal_False ) const;

	    ::com::sun::star::uno::Sequence < ::rtl::OUString > GetAllServiceNames();
        
	//-------------------------------------------------------------------------------------------------------------
	//	private methods
	//-------------------------------------------------------------------------------------------------------------
    private:
        static ::osl::Mutex& impl_GetOwnStaticMutex();

	//-------------------------------------------------------------------------------------------------------------
	//	private member
	//-------------------------------------------------------------------------------------------------------------
	private:

		/*Attention

			Don't initialize these static member in these header!
            a) Double defined symbols will be detected ...
			b) and unresolved externals exist at linking time.
			Do it in your source only.
		 */

    	static SvtModuleOptions_Impl*	m_pDataContainer	;	/// impl. data container as dynamic pointer for smaller memory requirements!
		static sal_Int32				m_nRefCount			;	/// internal ref count mechanism

};		// class SvtModuleOptions

#endif	// #ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
