/*************************************************************************
 *
 *  $RCSfile: viewshape.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 19:24:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SLIDESHOW_VIEWSHAPE_HXX
#define _SLIDESHOW_VIEWSHAPE_HXX

#ifndef _CPPCANVAS_RENDERER_HXX
#include <cppcanvas/renderer.hxx>
#endif
#ifndef _CPPCANVAS_BITMAP_HXX
#include <cppcanvas/bitmap.hxx>
#endif

#ifndef _BGFX_RANGE_B2DRECTANGLE_HXX
#include <basegfx/range/b2drectangle.hxx>
#endif
#ifndef _BGFX_POLYGON_B2DPOLYGON_HXX
#include <basegfx/polygon/b2dpolygon.hxx>
#endif


#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#include <gdimtftools.hxx>
#include <shapeattributelayer.hxx>
#include <animatedsprite.hxx>
#include <viewlayer.hxx>
#include <doctreenode.hxx>

namespace presentation
{
    namespace internal
    {
        /** This class is the viewable representation of a draw
            document's XShape, associated to a specific View

            The class is able to render the associated XShape on
            View implementations.
         */
        class ViewShape
        {
        public:
            /** Create a ViewShape for the given View

            	@param rView
                The associated View object.
             */
            explicit ViewShape( const ViewLayerSharedPtr& rViewLayer );

            ~ViewShape();

			/** Query the associated view layer of this shape
             */
            ViewLayerSharedPtr getViewLayer() const;

            /** Query true bound rect of this viewshape.

            	This method returns the true bound rect of this
            	viewshape, relative to a one-by-one rectangle. That
            	is, if this viewshape actually only covers the bottom
            	half of the virtual one-by-one rectangle, this method
            	returns a rectangle [0.0,0.5,1.0,1.0]. Use this to
            	correct shape bounding boxes e.g. for subsetted
            	shapes.

                @param rMtf
                The shape metafile

                @param rSubsets
                Vector of subsets of the shape to get the bounds for

                @param pAttr
                Shape attributes (which, of course, might also
                influence actual bounds, e.g. when fonts are scaled)
             */
            ::basegfx::B2DRectangle getActualBounds( const GDIMetaFileSharedPtr&		 		rMtf,
                                                     const ShapeAttributeLayerSharedPtr& 		pAttr,
                                                     const DocTreeNode::VectorOfDocTreeNodes&	rSubsets ) const;

            /** Query dimension of a safety border around the shape for AA

            	If the view performs antialiasing, this method
            	calculates a safety border around the shape, in the
            	shape coordinate system, which is guaranteed to
            	include every pixel touched when rendering the shape.
             */
            ::basegfx::B2DSize getAntialiasingBorder() const;


            // animation methods
            //------------------------------------------------------------------

            /** Notify the ViewShape that an animation starts now

				This method enters animation mode on the associate
				target view. The shape can be animated in parallel on
				different views.

	            @return whether the mode change finished successfully.
             */
            bool enterAnimationMode();

            /** Notify the ViewShape that it is no longer animated

				This methods ends animation mode on the associate
				target view
             */
            void leaveAnimationMode();

            /** Query whether the ViewShape is currently animated

				This method checks whether the ViewShape is currently in
				animation mode.
             */
            bool isBackgroundDetached() const;

            // render methods
            //------------------------------------------------------------------

            enum UpdateFlags
            {
                NONE=			0,
                TRANSFORMATION=	1,
                CLIP=			2,
                ALPHA=			4,
                POSITION=		8,
                CONTENT=	    16,
                FORCE=			32
            };

            struct RenderArgs
            {
                /** Create render argument struct

                    @param rOrigBounds
                    The initial shape bounds

                    @param rBounds
                    The current shape bounds

                    @param rAttr
                    The current shape attribute set. Can be NULL, for
                    default attributes.

                    @param rSubsets
                    Vector of subset rendering ranges
                */
                RenderArgs( const ::basegfx::B2DRectangle&				rOrigBounds,
                            const ::basegfx::B2DRectangle&				rBounds,
                            const ShapeAttributeLayerSharedPtr&			rAttr,
                            const DocTreeNode::VectorOfDocTreeNodes&	rSubsets ) :
                    mrOrigBounds( rOrigBounds ),
                    mrBounds( rBounds ),
                    mrAttr( rAttr ),
                    mrSubsets( rSubsets )
                {
                }

                const ::basegfx::B2DRectangle&				mrOrigBounds;
                const ::basegfx::B2DRectangle&				mrBounds;
                const ShapeAttributeLayerSharedPtr&			mrAttr;
                const DocTreeNode::VectorOfDocTreeNodes&	mrSubsets;
            };

            /** Update the ViewShape

				This method updates the ViewShape on the associated
				view. If the shape is currently animated, the render
				target is the sprite, otherwise the view's
				canvas. This method does not render anything, if the
				update flags are 0. 

                @param rMtf
                The metafile representation of the shape

                @param rArgs
                Parameter structure, containing all necessary arguments

                @param nUpdateFlags
                Bitmask of things to update. Use FORCE to force a repaint.

                @param bIsVisible
                When false, the shape is fully invisible (and possibly
                don't need to be painted)

	            @return whether the rendering finished successfully.
            */
            bool update( const GDIMetaFileSharedPtr&	rMtf,
                         const RenderArgs&				rArgs,
                         int							nUpdateFlags,
                         bool							bIsVisible ) const;

        private:
            // default: disabled copy/assignment
            ViewShape(const ViewShape&);
            ViewShape& operator=( const ViewShape& );

            /** Prefetch Renderer for given canvas
             */
            bool prefetch( const ::cppcanvas::CanvasSharedPtr&	rDestinationCanvas,
                           const GDIMetaFileSharedPtr&			rMtf,
                           const ShapeAttributeLayerSharedPtr&	rAttr ) const;
            
            /** Draw with prefetched Renderer to stored canvas

            	This method draws prefetched Renderer to its
            	associated canvas (which happens to be mpLastCanvas).
             */
            bool draw( const ::cppcanvas::CanvasSharedPtr&		rDestinationCanvas,
                       const GDIMetaFileSharedPtr&				rMtf,
                       const ShapeAttributeLayerSharedPtr&		rAttr,
                       const ::basegfx::B2DHomMatrix&			rTransform,
                       const ::basegfx::B2DPolyPolygon&			rClip,
                       const DocTreeNode::VectorOfDocTreeNodes&	rSubsets ) const;

            /** Render shape to an active sprite
             */
            bool renderSprite( const GDIMetaFileSharedPtr&				rMtf,
                               const ::basegfx::B2DRectangle&			rOrigBounds,
                               const ::basegfx::B2DRectangle&			rBounds,
                               int										nUpdateFlags,
                               const ShapeAttributeLayerSharedPtr&		pAttr,
                               const DocTreeNode::VectorOfDocTreeNodes&	rSubsets,
                               bool 									bIsVisible ) const;

            /** Render shape to given canvas
             */
            bool render( const ::cppcanvas::CanvasSharedPtr&		rDestinationCanvas,
                         const GDIMetaFileSharedPtr&				rMtf,
                         const ::basegfx::B2DRectangle&				rOrigBounds,
                         const ::basegfx::B2DRectangle&				rBounds,
                         int										nUpdateFlags,
                         const ShapeAttributeLayerSharedPtr&		pAttr,
                         const DocTreeNode::VectorOfDocTreeNodes&	rSubsets,
                         bool 										bIsVisible ) const;

            /** The view layer this object is part of. 

                Needed for sprite creation
            */
            ViewLayerSharedPtr							mpViewLayer;

            /// The last render object
            mutable ::cppcanvas::RendererSharedPtr		mpRenderer;

            /// The last metafile a render object was generated for
            mutable GDIMetaFileSharedPtr				mpLastMtf;

            /// The canvas, mpRenderer is associated with
            mutable ::cppcanvas::CanvasSharedPtr		mpLastCanvas;

            /// A bitmap for transparent painting
            mutable ::cppcanvas::BitmapSharedPtr		mpLastBitmap;

            /// The canvas for mpLastBitmap
            mutable ::cppcanvas::BitmapCanvasSharedPtr	mpLastBitmapCanvas;

            /// The sprite object
            mutable AnimatedSpriteSharedPtr				mpSprite;

            /// If true, render() calls go to the sprite
            mutable bool								mbAnimationMode;

            /// If true, shape needs full repaint (and the sprite a setup, if any)
            mutable bool								mbForceUpdate;
        };

        typedef ::boost::shared_ptr< ViewShape > ViewShapeSharedPtr;

    }
}

#endif /* _SLIDESHOW_VIEWSHAPE_HXX */
