/*************************************************************************
 *
 *  $RCSfile: viewmediashape.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 19:24:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SLIDESHOW_VIEWMEDIASHAPE_HXX
#define _SLIDESHOW_VIEWMEDIASHAPE_HXX

#ifndef _BGFX_RANGE_B2DRECTANGLE_HXX
#include <basegfx/range/b2drectangle.hxx>
#endif
#ifndef _COM_SUN_STAR_AWT_POINT_HPP_
#include <com/sun/star/awt/Point.hpp>
#endif
#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#include <viewlayer.hxx>

class JavaChildWindow;

namespace com 
{ 
	namespace sun 
	{ 
		namespace star 
		{ 
			namespace drawing
			{
				class XShape;
			}
			
			namespace media 
			{ 
				class XPlayer;
				class XPlayerWindow;
			}
		
			namespace beans
			{ 
				class XPropertySet;
			}
		}
	} 
}

namespace presentation
{
    namespace internal
    {
		class MediaShape;
	
        /** This class is the viewable representation of a draw
            document's media object, associated to a specific View

            The class is able to render the associated media shape on
            View implementations.
         */
        class ViewMediaShape
        {
        public:
            /** Create a ViewMediaShape for the given View

            	@param rView
                The associated View object.
             */
            explicit ViewMediaShape( MediaShape& rMediaShape,
									 const ViewLayerSharedPtr& rViewLayer, 
									 const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >& rxShape );

            /** destroy the object
             */
            virtual ~ViewMediaShape();
			
            /** Query the associated view layer of this shape
             */
            ViewLayerSharedPtr getViewLayer() const;

            // animation methods
            //------------------------------------------------------------------

            /** Notify the ViewShape that an animation starts now

				This method enters animation mode on the associate
				target view. The shape can be animated in parallel on
				different views.

	            @return whether the mode change finished successfully.
             */
            bool enterAnimationMode();

            /** Notify the ViewShape that it is no longer animated

				This methods ends animation mode on the associate
				target view
             */
            void leaveAnimationMode();

            /** Query whether the ViewShape is currently animated

				This method checks whether the ViewShape is currently in
				animation mode.
             */
            bool isBackgroundDetached() const;

            // render methods
            //------------------------------------------------------------------

            /** Update the ViewShape

				This method updates the ViewMediaShape on the associated view. 

                @param rBounds
                The current media shape bounds

	            @return whether the rendering finished successfully.
            */
            bool update( const ::basegfx::B2DRectangle&	rBounds ) const;

        private:
            
			// default: disabled copy/assignment
            ViewMediaShape( const ViewMediaShape& );
            ViewMediaShape& operator=( const ViewMediaShape& );
			
			bool implInitialize( const ::basegfx::B2DRectangle& rBounds );
			void implSetMediaProperties( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& rxProps );
			bool implInitializeMediaPlayer( const ::rtl::OUString& rMediaURL );
			bool implInitializeVCLBasedPlayerWindow( const ::basegfx::B2DRectangle& rBounds,
													 const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& rVCLDeviceParams );
			bool implInitializeDXBasedPlayerWindow( const ::basegfx::B2DRectangle& rBounds,
													const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& rDXDeviceParams );
    		::basegfx::B2DRectangle& implGetAdjustedBoundRect( ::basegfx::B2DRectangle& rBounds ) const;
			
			ViewLayerSharedPtr					mpViewLayer;
			::std::auto_ptr< JavaChildWindow >	mpMediaWindow;
			::com::sun::star::awt::Point        maWindowOffset;
			MediaShape&							mrMediaShape;
        
			::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >		mxShape;
			::com::sun::star::uno::Reference< ::com::sun::star::media::XPlayer >		mxPlayer;
			::com::sun::star::uno::Reference< ::com::sun::star::media::XPlayerWindow >	mxPlayerWindow;
		};

        typedef ::boost::shared_ptr< ViewMediaShape > ViewMediaShapeSharedPtr;

    }
}

#endif /* _SLIDESHOW_VIEWMEDIASHAPE_HXX */
