/*************************************************************************
 *
 *  $RCSfile: presentation.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 19:19:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SLIDESHOW_PRESENTATION_HXX
#define _SLIDESHOW_PRESENTATION_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HXX_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#include <memory>


namespace com { namespace sun { namespace star { 
    namespace drawing 
    {
        class XDrawPage;
        class XShape;
    }
    namespace presentation
    {
        class XSlideShow;
        class XSlideShowView;
        class XSlideShowListener;
        class XShapeEventListener;
    }
    namespace animations
    {
        class XAnimationNode;
    }
    namespace beans
    {
        struct PropertyValue;
} } } }


/* Definition of Presentation class */

namespace presentation
{
    namespace internal
    {
        class Presentation_Impl;
    }

    /** This class encapsulates the slideshow presentation viewer.

    	With an instance of this class, it is possible to statically
    	and dynamically show a presentation, as defined by the
    	constructor-provided draw model (represented by a sequence
    	of ::com::sun::star::drawing::XDrawPage objects).

        It is possible to show the presentation on multiple views
        simultaneously (e.g. for a multi-monitor setup). Since this
        class also relies on user interaction, the corresponding
        XSlideShowView interface provides means to register some UI
        event listeners (mostly borrowed from awt::XWindow interface).

        Since currently (mid 2004), OOo isn't very well suited to
        multi-threaded rendering, this class relies on <em>very
        frequent</em> external update() calls, which will render the
        next frame of animations. This works as follows: after the
        displaySlide() or one of the slide changing methods
        (nextSlide(), previousSlide() etc.) have been successfully
        called (which setup and starts an actual slide show), the
        update() method must be called until it returns
        false. Effectively, this puts the burden of providing
        concurrency to the clients of this class, which, as noted
        above, is currently unavoidable with the current state of
        affairs (I've actually tried threading here, but failed
        miserably when using the VCL canvas as the render backend -
        deadlocked).
     */
    class Presentation
    {
    public:
        Presentation( const ::com::sun::star::uno::Reference< 
                      		::com::sun::star::uno::XComponentContext >& xContext );
        ~Presentation();

		void dispose();

		/** Prefetch show content

        	@param aPages
            Pages to display

            @param aRootNodes
            Animation node for every page in aPages

            @param bAutomatic
            Whether effect and slide advancement should happen
            automatically.
         */
        bool prefetch( const ::com::sun::star::uno::Sequence< 
                      			::com::sun::star::uno::Reference< 
                      				::com::sun::star::drawing::XDrawPage > >& 			aPages,
                       const ::com::sun::star::uno::Sequence< 
                      			::com::sun::star::uno::Reference< 
                      				::com::sun::star::animations::XAnimationNode > >& 	aRootNodes,
                       const ::com::sun::star::uno::Sequence< 
                       			::com::sun::star::beans::PropertyValue >& 				aShowProperties );

        // mirrors XSlideShow interface here. See docs there.
        // -------------------------------------------------

        bool nextEffect();

		bool startShapeActivity( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >& xShape );

		bool stopShapeActivity( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >& xShape );

		bool previousSlide();

        bool nextSlide();

        bool displaySlide( sal_Int32 nSlideIndex );

        bool pause( bool bPauseShow );

		sal_Int32 getCurrentSlideIndex();

        bool setProperty( const ::com::sun::star::beans::PropertyValue& aShowProperty );

        bool addView( const ::com::sun::star::uno::Reference< ::com::sun::star::presentation::XSlideShowView >& xView );

        bool removeView( const ::com::sun::star::uno::Reference< ::com::sun::star::presentation::XSlideShowView >& xView );

        void addSlideShowListener( const ::com::sun::star::uno::Reference< ::com::sun::star::presentation::XSlideShowListener >& xListener );

        void removeSlideShowListener( const ::com::sun::star::uno::Reference< ::com::sun::star::presentation::XSlideShowListener >& xListener );

        void addShapeEventListener( const ::com::sun::star::uno::Reference< ::com::sun::star::presentation::XShapeEventListener >& 	xListener, 
                                    const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >& 					xShape );

        void removeShapeEventListener( const ::com::sun::star::uno::Reference< ::com::sun::star::presentation::XShapeEventListener >& 	xListener, 
                                       const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >& 					xShape );

        void setShapeCursor( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >& xShape, sal_Int16 nPointerShape );

        /** Render the next frame of animations.

        	This method renders the next frame of animations, once a
        	slide show is started via the displaySlide() method. As
        	long as update() does not return false, update() must be
        	called again within the given timeout value. When update()
        	returns false, the slideshow has ended (either by error,
        	user interruption or successful playback).

            @param pTimeoutForNextCall
            If non-NULL, this method will return a timeout value in
            seconds herein, within which update() must be called again
            to ensure smooth animation playback.
         */
        bool update( double* pNextTimeout );

    private:
        // default: disabled copy/assignment
        Presentation(const Presentation&);
        Presentation& operator=( const Presentation& );

        const ::std::auto_ptr< internal::Presentation_Impl > mpImpl;
    };
}

#endif // _SLIDESHOW_PRESENTATION_HXX
