/*************************************************************************
 *
 *  $RCSfile: shapeeventbroadcaster.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 18:56:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <canvas/debug.hxx>
#include <shapeeventbroadcaster.hxx>

#ifndef _COM_SUN_STAR_AWT_MOUSEBUTTON_HPP_
#include <com/sun/star/awt/MouseButton.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_SYSTEMPOINTER_HPP_ 
#include <com/sun/star/awt/SystemPointer.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_XSHAPEEVENTLISTENER_HPP_ 
#include <com/sun/star/presentation/XShapeEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_XSLIDESHOWLISTENER_HPP_ 
#include <com/sun/star/presentation/XSlideShowListener.hpp>
#endif
 
#ifndef COMPHELPER_INC_COMPHELPER_LISTENERNOTIFICATION_HXX
#include <comphelper/listenernotification.hxx>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif

#ifndef BOOST_BIND_HPP_INCLUDED
#include <boost/bind.hpp>
#endif

#include <mouseeventhandler.hxx>

#include <map>


using namespace ::com::sun::star;
using namespace ::drafts::com::sun::star;

namespace presentation
{
    namespace internal
    {
		class ShapeClickHandler : public MouseEventHandler
		{
		public:
            ShapeClickHandler() :
                maMutex(),
                maBroadcasters(),
                mnSlideIndex(-1)
            {
            }

            // MouseEventHandler interface
            virtual void dispose()
            {
                ::osl::MutexGuard aGuard( maMutex );
                
                maBroadcasters.clear();
            }

            virtual bool handleMousePressed( const awt::MouseEvent& )
            {            
                // not used here
                return false; // did not handle the event
            }

            virtual bool handleMouseReleased( const awt::MouseEvent& e )
            {
                ::osl::ClearableMutexGuard aGuard( maMutex );

                // find hit shape in map
                const ::basegfx::B2DPoint aPosition( e.X, e.Y );

                // TODO(F2): Ensure checking in paint order. The current
                // solution is a hack at best.

                // find matching shape (scan reversely, to coarsely match
                // paint order)
                ShapeBroadcasterMap::reverse_iterator aCurrBroadcaster( maBroadcasters.rbegin() );
                ShapeBroadcasterMap::reverse_iterator aEndBroadcasters( maBroadcasters.rend() );
                while( aCurrBroadcaster != aEndBroadcasters )
                {
                    // TODO(F2): Get proper geometry polygon from the
                    // shape, to avoid having areas outside the shape
                    // react on the mouse
                    if( aCurrBroadcaster->first->getPosSize().isInside( aPosition ) &&
                        aCurrBroadcaster->first->isVisible() )
                    {
                        // shape hit, and shape is visible. Raise
                        // event.

                        ShapeEvent aEvent;
                        // TODO(F1): Missing event source (should be
                        // the XSlideShow instance here)
                        aEvent.Source = NULL;
                        aEvent.mxShape = aCurrBroadcaster->first->getXShape();
                        aEvent.mnSlideIndex = mnSlideIndex;
                        aEvent.maOriginalEvent = e;

                        // release object mutex, we're calling out!
                        ShapeBroadcasterPtr pBroadcaster( aCurrBroadcaster->second );
                        aGuard.clear();

                        // DON'T do anything with /this/ after this point!
                        pBroadcaster->notify( aEvent );

                        return true; // handled this event
                    }

                    ++aCurrBroadcaster;
                }

                return false; // did not handle this event
            }

            virtual bool handleMouseEntered( const awt::MouseEvent& )
            {
                // not used here
                return false; // did not handle the event
            }

            virtual bool handleMouseExited( const awt::MouseEvent& )
            {
                // not used here
                return false; // did not handle the event
            }

            virtual bool handleMouseDragged( const awt::MouseEvent& )
            {
                // not used here
                return false; // did not handle the event
            }

            virtual bool handleMouseMoved( const awt::MouseEvent& )
            {
                // not used here
                return false; // did not handle the event
            }

            void addShapeEventListener( const uno::Reference< 
                                        		::com::sun::star::presentation::XShapeEventListener >& 	xListener, 
                                        const uno::Reference< 
                                        			drawing::XShape >& 									xShape,
                                        const ShapeSharedPtr&											rShape )
            {
                ENSURE_AND_THROW( rShape.get(),
                                  "ShapeClickHandler::addShapeEventListener(): Invalid shape" );

                ::osl::MutexGuard aGuard( maMutex );

                ShapeBroadcasterMap::iterator aIter;
                if( (aIter=maBroadcasters.find( rShape )) == maBroadcasters.end() )
                {
                    // no entry for this shape -> create a ShapeListener
                    aIter = maBroadcasters.insert( 
                        ShapeBroadcasterMap::value_type(rShape, 
                                                        ShapeBroadcasterPtr( 
                                                            new ShapeBroadcaster( maMutex ) ) ) ).first;

                    // aIter now contains the newly added entry
                }
            
                // add new listener to broadcaster
                if( aIter->second.get() )
                    aIter->second->addListener( xListener );
            }

            void removeShapeEventListener( const uno::Reference< 
                                           			::com::sun::star::presentation::XShapeEventListener >& 	xListener, 
                                           const uno::Reference< 
                                           			drawing::XShape >& 										xShape,
                                           const ShapeSharedPtr&											rShape )
            {
                ENSURE_AND_THROW( xShape.is(),
                                  "ShapeClickHandler::removeShapeEventListener(): Invalid shape" );

                ::osl::MutexGuard aGuard( maMutex );

                ShapeBroadcasterMap::iterator aIter;
                if( (aIter=maBroadcasters.find( rShape )) != maBroadcasters.end() )
                {
                    // entry for this shape found -> remove listener from
                    // helper object
                    ENSURE_AND_THROW( aIter->second.get(),
                                      "ShapeClickHandler::removeShapeEventListener(): listener map contains NULL broadcast helper" );

                    aIter->second->removeListener( xListener );

                    if( aIter->second->empty() )
                    {
                        // vector of broadcasters is empty. Can delete the
                        // map entry for this shape
                        maBroadcasters.erase( aIter );
                    }
                }
            }

            void setSlideIndex( sal_Int32 nNewIndex )
            {
                ::osl::MutexGuard aGuard( maMutex );

                mnSlideIndex = nNewIndex;
            }

	        bool isEmpty() const
            {
                ::osl::MutexGuard aGuard( maMutex );

                return maBroadcasters.empty();
            }

            struct ShapeEvent : public lang::EventObject
            {
                uno::Reference< drawing::XShape >	mxShape;
                sal_Int32							mnSlideIndex;
                awt::MouseEvent						maOriginalEvent;
            };

		private:
            typedef ::comphelper::OListenerContainerBase< ::com::sun::star::presentation::XShapeEventListener,
				                                      	  ShapeEvent >   ShapeBroadcaster_Base;

            class ShapeBroadcaster : public ShapeBroadcaster_Base
            {
            public:
                ShapeBroadcaster::ShapeBroadcaster( ::osl::Mutex& rMutex ) :
                    ShapeBroadcaster_Base( rMutex )
                {
                }

            protected:
                virtual bool implNotify( const uno::Reference< ::com::sun::star::presentation::XShapeEventListener >& rListener,
                                         const ShapeEvent& 														   	  rEvent ) throw( uno::Exception )
                {
                    rListener->click( rEvent.mxShape,
                                      rEvent.mnSlideIndex,
                                      rEvent.maOriginalEvent );
                    
                    return true; // continue calling listeners
                }
            };
            typedef ::boost::shared_ptr< ShapeBroadcaster > 			ShapeBroadcasterPtr;
            typedef ::std::map< ShapeSharedPtr, ShapeBroadcasterPtr > 	ShapeBroadcasterMap;

            mutable ::osl::Mutex	maMutex;
            ShapeBroadcasterMap		maBroadcasters;
            sal_Int32				mnSlideIndex;
		};

		class MoveHandler : public MouseEventHandler
		{
		public:
			MoveHandler( EventMultiplexer& rMultiplexer ) :
                maMutex(),
                maShapeCursors(),
                mrMultiplexer( rMultiplexer )
            {
            }

            void setShapeCursor( const ShapeSharedPtr&	rShape, 
                                 sal_Int16 				nPointerShape )
            {
                ::osl::MutexGuard aGuard( maMutex );

                ENSURE_AND_THROW( rShape.get(),
                                  "MoveHandler::setShapeCursor(): Invalid shape" );

                ShapeCursorMap::iterator aIter;
                if( (aIter=maShapeCursors.find( rShape )) == maShapeCursors.end() )
                {
                    // no entry for this shape -> add a new one
                    // ========================================

                    if( nPointerShape != awt::SystemPointer::ARROW )
                    {
                        // add new entry, unless shape shall display
                        // normal pointer arrow -> no need to handle that
                        // case

                        // no entry -> create one
                        maShapeCursors.insert( 
                            ShapeCursorMap::value_type(rShape, 
                                                       nPointerShape ) );
                    }
                }
                else if( nPointerShape == awt::SystemPointer::ARROW )
                {
                    // shape shall display normal cursor -> can disable
                    // the cursor and clear the entry
                    maShapeCursors.erase( rShape );
                }
                else
                {
                    // existing entry found, update with new cursor ID
                    aIter->second = nPointerShape;
                }
            }

            // MouseEventHandler interface
            virtual void dispose()
            {
                ::osl::MutexGuard aGuard( maMutex );

                maShapeCursors.clear();
            }

            virtual bool handleMousePressed( const awt::MouseEvent& )
            {
                // not used here
                return false; // did not handle the event
            }

            virtual bool handleMouseReleased( const awt::MouseEvent& )
            {
                // not used here
                return false; // did not handle the event
            }

            virtual bool handleMouseEntered( const awt::MouseEvent& )
            {
                // not used here
                return false; // did not handle the event
            }

            virtual bool handleMouseExited( const awt::MouseEvent& )
            {
                // not used here
                return false; // did not handle the event
            }

            virtual bool handleMouseDragged( const awt::MouseEvent& )
            {
                // not used here
                return false; // did not handle the event
            }

            virtual bool handleMouseMoved( const awt::MouseEvent& e )
            {
                ::osl::MutexGuard aGuard( maMutex );

                // find hit shape in map
                const ::basegfx::B2DPoint aPosition( e.X, e.Y );
                
                // TODO(F2): Ensure checking in paint order. The current
                // solution is a hack at best.

                // find matching shape (scan reversely, to coarsely match
                // paint order)
                ShapeCursorMap::reverse_iterator aCurrCursor( maShapeCursors.rbegin() );
                ShapeCursorMap::reverse_iterator aEndCursors( maShapeCursors.rend() );
                while( aCurrCursor != aEndCursors )
                {
                    // TODO(F2): Get proper geometry polygon from the
                    // shape, to avoid having areas outside the shape
                    // react on the mouse
                    if( aCurrCursor->first->getPosSize().isInside( aPosition ) &&
                        aCurrCursor->first->isVisible() )
                    {
                        // shape found, and it's visible. set
                        // requested cursor to shape's
                        mrMultiplexer.setVolatileMouseCursor( aCurrCursor->second );
                        break;
                    }

                    ++aCurrCursor;
                }

                return false; // we don't /eat/ this event. Lower prio
                              // handler should see it, too.
            }
	        
	        bool isEmpty() const
            {
                ::osl::MutexGuard aGuard( maMutex );

                return maShapeCursors.empty();
            }

		private:
            typedef ::std::map< ShapeSharedPtr, sal_Int16 > ShapeCursorMap;

            mutable ::osl::Mutex	maMutex;
            ShapeCursorMap			maShapeCursors;
            EventMultiplexer&		mrMultiplexer;
		};

        ShapeEventBroadcaster::ShapeEventBroadcaster( EventMultiplexer& rMultiplexer ) :
            mpShapeClickHandler(),
            mpMoveHandler(),
            mrMultiplexer( rMultiplexer ),
            mnSlideIndex( -1 )
        {
        }

        ShapeEventBroadcaster::~ShapeEventBroadcaster()
        {
        }

        void ShapeEventBroadcaster::addShapeEventListener( const uno::Reference< 
                                                           			::com::sun::star::presentation::XShapeEventListener >& 	xListener, 
                                                           const uno::Reference< drawing::XShape >& 						xShape,
                                                           const ShapeSharedPtr&											rShape )
        {
            ENSURE_AND_THROW( rShape.get(),
                              "ShapeEventBroadcaster::addShapeEventListener(): Invalid shape" );

            if( !mpShapeClickHandler.get() )
            {
                // create handler 
                mpShapeClickHandler.reset( new ShapeClickHandler() );

                // set initial slide index
                mpShapeClickHandler->setSlideIndex( mnSlideIndex );

                // register handler on EventMultiplexer
                mrMultiplexer.addClickHandler( mpShapeClickHandler, 
                                               2.0 ); // raised prio
                                                      // (overrides
                                                      // engine
                                                      // handlers)
            }

            mpShapeClickHandler->addShapeEventListener( xListener,
                                                        xShape,
                                                        rShape );
        }

        void ShapeEventBroadcaster::removeShapeEventListener( const uno::Reference< 
                                                              			::com::sun::star::presentation::XShapeEventListener >& 	xListener, 
                                                              const uno::Reference< drawing::XShape >& 							xShape,
                                                              const ShapeSharedPtr&												rShape )
        {
            ENSURE_AND_THROW( rShape.get(),
                              "ShapeEventBroadcaster::removeShapeEventListener(): Invalid shape" );
            ENSURE_AND_THROW( mpShapeClickHandler.get(),
                              "ShapeEventBroadcaster::removeShapeEventListener(): No click handler!" );

            mpShapeClickHandler->removeShapeEventListener( xListener,
                                                           xShape,
                                                           rShape );

            // queue now empty?
            if( mpShapeClickHandler->isEmpty() )
            {
                // register unhandler on EventMultiplexer
                mrMultiplexer.removeClickHandler( mpShapeClickHandler );

                // delete handler 
                mpShapeClickHandler.reset();
            }
        }

        void ShapeEventBroadcaster::setShapeCursor( const ShapeSharedPtr&	rShape, 
                                                    sal_Int16 				nPointerShape )
        {
            ENSURE_AND_THROW( rShape.get(),
                              "ShapeEventBroadcaster::setShapeCursor(): Invalid shape" );

            if( !mpMoveHandler.get() )
            {
                // create handler 
                mpMoveHandler.reset( new MoveHandler( mrMultiplexer ) );

                // register handler on EventMultiplexer
                mrMultiplexer.addMouseMoveHandler( mpMoveHandler,
                                                   2.0 ); // raised
                                                          // prio
                                                          // (overrides
                                                          // engine
                                                          // handlers)

                // add cursor
                mpMoveHandler->setShapeCursor( rShape,
                                               nPointerShape );
            }
            else
            {
                // add cursor
                mpMoveHandler->setShapeCursor( rShape,
                                               nPointerShape );

                if( nPointerShape == awt::SystemPointer::ARROW )
                {
                    // possibly, cleared last cursor. If yes,
                    // unregister move handler
                    if( mpMoveHandler->isEmpty() )
                    {
                        mrMultiplexer.removeMouseMoveHandler( mpMoveHandler );
                        mpMoveHandler.reset();
                    }
                }
            }
        }

        void ShapeEventBroadcaster::setSlideIndex( sal_Int32 nNewIndex )
        {
            mnSlideIndex = nNewIndex;
            if( mpShapeClickHandler.get() )
                mpShapeClickHandler->setSlideIndex( nNewIndex );
        }

    }
}
