/*************************************************************************
 *
 *  $RCSfile: layer.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 18:54:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// must be first
#include <canvas/debug.hxx>
#include <layer.hxx>

#ifndef _BGFX_RANGE_B2DMULTIRANGE_HXX
#include <basegfx/range/b2dmultirange.hxx>
#endif

#ifndef BOOST_BIND_HPP_INCLUDED
#include <boost/bind.hpp>
#endif
#ifndef BOOST_MEM_FN_HPP_INCLUDED
#include <boost/mem_fn.hpp>
#endif


using namespace ::com::sun::star;

namespace presentation
{
    namespace internal
    {
        Layer::Layer() :
            maShapeSet(),
            maViewLayers()
        { 
        }

        void Layer::addViewLayer( const ViewLayerSharedPtr& rNewLayer )
        {
            const ViewLayerVector::iterator aEnd( maViewLayers.end() );

            // already added?
            if( ::std::find( maViewLayers.begin(), 
                             aEnd, 
                             rNewLayer ) != aEnd )
            {
                return; // yes, nothing to do
            }

            // add to local list
            maViewLayers.push_back( rNewLayer );

            // forward to all shape's addViewLayer method (which we request to
            // renders the Shape on the new ViewLayer. Since we add the shapes 
            // in the maShapeSet order (which is also the render order), this 
            // is equivalent to a subsequent render() call)
            ::std::for_each( maShapeSet.begin(),
                             maShapeSet.end(),
                             ::boost::bind( &Shape::addViewLayer,
                                            _1,
                                            ::boost::cref(rNewLayer),
                                            true ) );
        }

        bool Layer::removeViewLayer( const ViewLayerSharedPtr& rLayer )
        {
            const ViewLayerVector::iterator aEnd( maViewLayers.end() );

            OSL_ENSURE( ::std::count( maViewLayers.begin(),
                                      aEnd,
                                      rLayer ) < 2,
                        "Layer::removeViewLayer(): Duplicate ViewLayer entries!" );

            ViewLayerVector::iterator aIter;

            // remove from local list
            if( (aIter=::std::remove( maViewLayers.begin(),
                                      aEnd,
                                      rLayer )) == aEnd )
            {
                // ViewLayer was not added in the first place
                return false;
            }

            // actually perform the removal
            maViewLayers.erase( aIter, aEnd );

            // forward to all shape's removeViewLayer method
            if( ::std::count_if( maShapeSet.begin(),
                                 maShapeSet.end(),
                                 ::boost::bind<bool>( ::boost::mem_fn( &Shape::removeViewLayer ),
                                                      _1,
                                                      ::boost::cref(rLayer) ) ) 
                != static_cast<ShapeSet::difference_type>(maShapeSet.size()) )
            {
                // at least one of the Shape::removeViewLayer() calls did return 
                // false - removal failed on at least one Shape
                return false;
            }

            return true;
        }

        void Layer::addShape( const ShapeSharedPtr& rShape )
        {
            maShapeSet.insert( rShape );

            // add all view layers to the shape (and don't render.
            // Would most probably be out of order, anyway, and
            // overwrite underlying page content)
            ::std::for_each( maViewLayers.begin(),
                             maViewLayers.end(),
                             ::boost::bind( &Shape::addViewLayer,
                                            ::boost::ref(rShape),
                                            _1,
                                            false ) );
        }
            
        bool Layer::removeShape( const ShapeSharedPtr& rShape )
        {
            // removal was successful if we removed one or more elements
            const bool bWasRemoved( maShapeSet.erase( rShape ) > 0 );

            // remove all our view layers from the shape
            ::std::for_each( maViewLayers.begin(),
                             maViewLayers.end(),
                             ::boost::bind( &Shape::removeViewLayer,
                                            ::boost::ref(rShape),
                                            _1 ) );

            return bWasRemoved;
        }

        void Layer::enterAnimationMode( const AnimatableShapeSharedPtr& rShape )
        {
            rShape->enterAnimationMode();
        }

        void Layer::leaveAnimationMode( const AnimatableShapeSharedPtr& rShape )
        {
            rShape->leaveAnimationMode();
        }

        bool Layer::update( const ::basegfx::B2DMultiRange& rArea ) const
        {
            bool bRet( true );

            const ShapeSet::iterator 	aEnd( maShapeSet.end() );
            ShapeSet::iterator 			aCurr( maShapeSet.begin() );
            while( aCurr != aEnd )
            {
                if( !(*aCurr)->isBackgroundDetached() )
                {
                    // animated shapes -> sprites. Don't have to paint them 
                    // explicitely, the canvas handles compositing on screen

                    // now, check against intersection with update area
                    if( rArea.overlaps( (*aCurr)->getUpdateArea() ) )
                    {
                        if( !(*aCurr)->render() )
                        {
                            // render ultimately failed if one render failed.
                            // but don't bail out immediately, page might still
                            // come out sufficiently correct.
                            bRet = false;
                        }
                    }
                }

                ++aCurr;
            }

            return bRet;
        }

        bool Layer::render() const
        {
            bool bRet( true );

            // forward to each Shape's render() method
            const ShapeSet::iterator 	aEnd( maShapeSet.end() );
            ShapeSet::iterator 			aCurr( maShapeSet.begin() );
            while( aCurr != aEnd )
            {
                try
                {
                    if( !(*aCurr)->isBackgroundDetached() )
                    {
                        // animated shapes -> sprites. Don't have to paint them 
                        // explicitely, the canvas handles compositing on screen
                        if( !(*aCurr)->render() )
                        {
                            // render ultimately failed if one render failed.
                            // but don't bail out immediately, page might still
                            // come out sufficiently correct.
                            bRet = false;
                        }
                    }
                }
                catch( uno::Exception& )
                {
                    // shape could not be rendered - catch and
                    // delay error, we want all other shapes
                    // still to be rendered.
                    bRet = false;
                }

                ++aCurr;
            }

            return bRet;
        }

    }
}
