/*************************************************************************
 *
 *  $RCSfile: doctreenode.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 18:50:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// must be first
#include <canvas/debug.hxx>

#include <doctreenode.hxx>


namespace presentation
{
    namespace internal
    {
        bool DocTreeNode::isEmpty() const
        {
            return mnStartIndex == mnEndIndex;
        }

        sal_Int32 DocTreeNode::getNumberOfChildren() const
        {
            return maChildren.size();
        }

        DocTreeNode::NodeType DocTreeNode::getType() const
        {
            return meType;
        }

        const DocTreeNode& DocTreeNode::getChild( sal_Int32 nIndex ) const
        {
            ENSURE_AND_THROW( nIndex >= 0 && nIndex < static_cast<sal_Int32>(maChildren.size()), 
                              "DocTreeNode::getChild(): Invalid index");

            return maChildren[nIndex];
        }

        void DocTreeNode::setChild( const DocTreeNode& rChild, sal_Int32 nIndex )
        {
            ENSURE_AND_THROW( nIndex >= 0 && nIndex < static_cast<sal_Int32>(maChildren.size()), 
                              "DocTreeNode::setChild(): Invalid index");

            maChildren[nIndex] = rChild;
        }

        void DocTreeNode::appendChild( const DocTreeNode& rChild )
        {
            maChildren.push_back( rChild );
        }

        // -------------------------------------------------------------------

        namespace
        {
            bool recursiveDocTreeTraversal( DocTreeNode& 			o_rTreeNode, 
                                            sal_Int16&				io_nNode,
                                            const DocTreeNode&		rCurrNode,
                                            DocTreeNode::NodeType	eWantedType )
            {
                if( rCurrNode.getType() == eWantedType )
                {
                    if( io_nNode == 0 )
                    {
                        // type matches, and correct index - take and leave
                        o_rTreeNode = rCurrNode;
                        return true;
                    }

                    // type matches, but still before the requested index
                    // still, do _not_ recurse further, since we assume that
                    // similar types are all on the same level 
                    --io_nNode;
                    return false;
                }

                const sal_Int32 nNumNodes( rCurrNode.getNumberOfChildren() );
                sal_Int32 nCurrNode;
                for( nCurrNode=0; nCurrNode<nNumNodes; ++nCurrNode )
                {
                    if( recursiveDocTreeTraversal( o_rTreeNode,
                                                   io_nNode,
                                                   rCurrNode.getChild( nCurrNode ),
                                                   eWantedType ) )
                    {
                        // found, done
                        return true;
                    }
                }

                // not found
                return false;
            }
        }

        DocTreeNode DocTreeNode::createFromShape( const AttributableShapeSharedPtr& rShape,
                                                  sal_Int16							nNodeIndex,
                                                  DocTreeNode::NodeType				eNodeType )
        {
            DocTreeNode aRes;

            const sal_Int32 nNumNodes( rShape->getNumberOfTreeNodes() );
            for( sal_Int32 nCurrNode=0; nCurrNode<nNumNodes; ++nCurrNode )
            {
                if( recursiveDocTreeTraversal( aRes,
                                               nNodeIndex,
                                               DocTreeNode::isLogicalNodeType( eNodeType ) ?
                                               rShape->getLogicalDocTreeNode( nCurrNode ) :
                                               rShape->getFormattingDocTreeNode( nCurrNode ),
                                               eNodeType ) )
                {
                    // found, done
                    return aRes;
                }
            }

            // failed, return empty DocTreeNode
            return DocTreeNode();
        }

    }
}
