/*************************************************************************
 *
 *  $RCSfile: regsvrex.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2004/04/07 10:58:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <windows.h>

typedef HRESULT (__stdcall *lpfnDllRegisterServer)();
typedef HRESULT (__stdcall *lpfnDllUnregisterServer)();

/**
*/
bool IsUnregisterParameter(const char* Param)
{
	return ((0 == _stricmp(Param, "/u")) || 
			(0 == _stricmp(Param, "-u")));
}

/**	
*/
int main(int argc, char* argv[])
{
	HMODULE hmod;
	HRESULT hr = E_FAIL;
	lpfnDllRegisterServer   lpfn_register;
	lpfnDllUnregisterServer lpfn_unregister;

	if (2 == argc)
	{
		hmod = LoadLibraryA(argv[1]);
		
		if (hmod)
		{
			lpfn_register = (lpfnDllRegisterServer)GetProcAddress(
				hmod, "DllRegisterServer");

			if (lpfn_register)
				hr = lpfn_register();

			FreeLibrary(hmod);
		}
	}
	else if (3 == argc && IsUnregisterParameter(argv[1]))
	{
		hmod = LoadLibraryA(argv[2]);

		if (hmod)
		{
			lpfn_unregister = (lpfnDllUnregisterServer)GetProcAddress(
				hmod, "DllUnregisterServer");

			if (lpfn_unregister)
				hr = lpfn_unregister();

			FreeLibrary(hmod);
		}
	}

	return 0;
}
