/*************************************************************************
 *
 *  $RCSfile: ipfrm.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: kz $ $Date: 2004/10/04 21:03:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "ipfrm.hxx"

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif

#ifndef _IPWIN_HXX //autogen
#include <so3/ipwin.hxx>
#endif

#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif
#ifndef _TOOLKIT_UNOHLP_HXX
#include <toolkit/helper/vclunohelper.hxx>
#endif

#include "ipenv.hxx"
#include "interno.hxx"

#include "sfxtypes.hxx"
#include "minarray.hxx"
#include "objsh.hxx"
#include "docfac.hxx"
#include "viewfac.hxx"
#include "viewsh.hxx"
#include "bindings.hxx"
#include "dispatch.hxx"
#include "request.hxx"
#include "sfxresid.hxx"
#include "sfxbasecontroller.hxx"

#include "sfx.hrc"

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;

// STATIC DATA -----------------------------------------------------------

DECL_PTRARRAY( SfxInPlaceFrameArray_Impl, SfxInPlaceFrame *, 2, 1);

#define SfxInPlaceFrame
#include "sfxslots.hxx"

DBG_NAME(SfxInPlaceFrame);

//--------------------------------------------------------------------

class SfxIPFrame_Impl : public SfxFrame
{
friend class SfxInPlaceFrame;

private:
	Window*				pWindow;

public:
						SfxIPFrame_Impl( SfxInPlaceFrame *p );

	virtual Window&		GetWindow() const;
	virtual BOOL		Close();
	virtual	BOOL		InsertDocument( SfxObjectShell *pDoc );
};

SfxIPFrame_Impl::SfxIPFrame_Impl( SfxInPlaceFrame *p )
    : SfxFrame( NULL )
    , pWindow( NULL )
{
    Reference < XFrame > xFrame ( ::comphelper::getProcessServiceFactory()->createInstance( DEFINE_CONST_UNICODE("com.sun.star.frame.Frame") ), UNO_QUERY );
    SetFrameInterface_Impl( xFrame );
/*
    pParentViewFrame = SfxViewFrame::Current();
    xLayoutManager = xParentFrame->getPropertyValue( "Layoutmanager" );
    XDockingAreaAcceptor = xLayoutManager->getDockingAreaAcceptor();
    xLayoutManager->setVisible( sal_False );
    xMyLayoutManager->setDockingAreaAcceptor( XDockingAreaAcceptor );
*/
	SetCurrentViewFrame_Impl( p );
}

Window& SfxIPFrame_Impl::GetWindow() const
{
	return *pWindow;
}

BOOL SfxIPFrame_Impl::Close()
{
	delete this;
	return TRUE;
}

BOOL SfxIPFrame_Impl::InsertDocument( SfxObjectShell *pDoc )
{
	return FALSE;
}

TYPEINIT1(SfxInPlaceFrame,SfxViewFrame);

SFX_IMPL_INTERFACE(SfxInPlaceFrame,SfxViewFrame,SfxResId(0))
{
}

//--------------------------------------------------------------------

void SfxInPlaceFrame::Exec(SfxRequest &rReq)
{
	DBG_CHKTHIS(SfxInPlaceFrame, 0);
}

//--------------------------------------------------------------------

void SfxInPlaceFrame::GetState(SfxItemSet &rSet)
{
	DBG_CHKTHIS(SfxInPlaceFrame, 0);
	rSet.DisableItem( SID_WIN_FULLSCREEN );
}

//--------------------------------------------------------------------

void SfxInPlaceFrame::SetZoomFactor( const Fraction &rZoomX,
									 const Fraction &rZoomY )
{
	pViewShell->SetZoomFactor( rZoomX, rZoomY );
}

//--------------------------------------------------------------------

void SfxInPlaceFrame::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
						  const SfxHint& rHint, const TypeId& rHintType )
{
	{DBG_CHKTHIS(SfxInPlaceFrame, 0);}

	// we know only SimpleHints
	BOOL bHandled = FALSE;
	if ( rHint.IsA(TYPE(SfxSimpleHint)) )
	{
		switch( ( (SfxSimpleHint&) rHint ).GetId() )
		{
			case SFX_HINT_TITLECHANGED:
			{
				// View-Name h"angt am Title des Object
				String aSbxName( GetObjectShell()->SfxShell::GetName() );
				aSbxName += String::CreateFromAscii( ":0" );
				SetName( aSbxName );
				bHandled = TRUE;
				break;
			}
		}
	}

	if ( !bHandled )
		SfxViewFrame::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
}

//--------------------------------------------------------------------

void SfxInPlaceFrame::Optimize()
{
	DBG_CHKTHIS(SfxInPlaceFrame, 0);
}

//--------------------------------------------------------------------

BOOL SfxInPlaceFrame::Close()
{
	{DBG_CHKTHIS(SfxInPlaceFrame, 0);}

	SfxViewFrame::Close();
	delete this;
	return TRUE;
}

//--------------------------------------------------------------------

void SfxInPlaceFrame::Activate( BOOL bMDI )
{
	DBG_CHKTHIS(SfxInPlaceFrame, 0);
	DBG_ASSERT(pViewShell, "Keine Shell");
    if ( bMDI )
    {
        Reference < XFramesSupplier > xContainer( GetParentViewFrame_Impl()->GetFrame()->GetFrameInterface(), ::com::sun::star::uno::UNO_QUERY );
        xContainer->setActiveFrame( GetFrame()->GetFrameInterface() );
    }
}

//--------------------------------------------------------------------

void SfxInPlaceFrame::Deactivate( BOOL bMDI )
{
	DBG_CHKTHIS(SfxInPlaceFrame, 0);
	DBG_ASSERT(pViewShell, "Keine Shell");
    if ( bMDI )
    {
        Reference < XFramesSupplier > xContainer( GetParentViewFrame_Impl()->GetFrame()->GetFrameInterface(), ::com::sun::star::uno::UNO_QUERY );
        if ( xContainer.is() )
            xContainer->setActiveFrame( NULL );
    }
}

// CTOR / DTOR -----------------------------------------------------------

SfxInPlaceFrame::SfxInPlaceFrame( SfxObjectShell &rObjShell, SfxFrame *pFrame ) :

	SfxViewFrame( (SfxObjectShell&)rObjShell, *(new SfxBindings),
				  new SfxIPFrame_Impl( this ), SFXFRAME_SERVER ),

	pViewShell( NULL )

{
	DBG_CTOR(SfxInPlaceFrame, 0);

    pEnv = new SfxInPlaceEnv_Impl( rObjShell.GetInPlaceObject(), this );
    pFrame = GetFrame();
    pFrame->SetOwnsBindings_Impl(TRUE);
    ((SfxIPFrame_Impl*)pFrame)->pWindow = pEnv->GetBorderWin();
    Reference < XFrame > xFrame = pFrame->GetFrameInterface();
    xFrame->initialize( VCLUnoHelper::GetInterface(pEnv->GetBorderWin() ) );

    Reference < XFramesSupplier > xContainer( SfxViewFrame::Current()->GetFrame()->GetFrameInterface(), ::com::sun::star::uno::UNO_QUERY );
    xContainer->getFrames()->append( GetFrame()->GetFrameInterface() );
    GetFrame()->GetFrameInterface()->setCreator( xContainer );

	// Eigentliches Fenster erzeugen
	LockAdjustPosSizePixel();
	pViewShell = GetObjectShell()->GetFactory().
					GetViewFactory().CreateInstance(this, 0);
	SfxObjectShell* pObjSh = GetObjectShell();
	SfxInPlaceObject* pIO = pObjSh->GetInPlaceObject();
	pEnv->SetEditWin( pViewShell->GetWindow() );
	UnlockAdjustPosSizePixel();

	SetViewShell_Impl(pViewShell);

    {
        Reference < ::com::sun::star::awt::XWindow > xWindow(
			GetFrame()->GetWindow().GetComponentInterface(), UNO_QUERY );
        Reference < XFrame > xFrame( GetFrame()->GetFrameInterface() );
        if ( !pViewShell->GetController().is() )
            pViewShell->SetController( new SfxBaseController( pViewShell ) );
        Reference < XController > xController( pViewShell->GetController() );
        xFrame->setComponent( xWindow, xController );
        xController->attachFrame( xFrame );
        Reference < XModel > xModel( pObjSh->GetModel() );
        if ( xModel.is() )
        {
            xController->attachModel( xModel );
            xModel->connectController( xController );
            xModel->setCurrentController( xController );
        }
    }

	GetDispatcher()->Push( *pViewShell );
	if ( pViewShell->GetSubShell() )
		GetDispatcher()->Push( *pViewShell->GetSubShell() );
	pViewShell->PushSubShells_Impl();
	if ( pViewShell->IsShowView_Impl() )
		pViewShell->GetWindow()->Show();

	// Name setzen
	String aSbxName( GetObjectShell()->SfxShell::GetName() );
	aSbxName += String::CreateFromAscii( ":0" );
	SetName( aSbxName );
}

//-------------------------------------------------------------------------

SfxInPlaceFrame::~SfxInPlaceFrame()
{
	DBG_DTOR(SfxInPlaceFrame, 0);

	// Zuerst das EditWindow wieder vom Environment abziehen, da es von diesem
	// un der ViewShell geshared wird
	pEnv->GetClipWin()->Hide();
	pEnv->SetEditWin(0);

	// Dann das Dokument loslassen, da das EditWindow ein ChildWindow vom
	// InPlaceWindow ist
	ReleaseObjectShell_Impl();

	// Jetzt kann das InPlaceEnvironment und damit das InPlaceWindow freigegeben
	// werden
	delete pEnv;

	// Der Dispatcher mu\s vor den Bindings, also nicht erst im dtor der
	// Basisklasse freigegeben werden
	KillDispatcher_Impl();
//    delete &GetBindings();

	GetFrame()->SetCurrentViewFrame_Impl( NULL );
	GetFrame()->DoClose();
}

//------------------------------------------------------------------------

void SfxInPlaceFrame::InvalidateBorderImpl( const SfxViewShell* pViewSh )

{
	//! if( pBorderWin && pViewSh->GetWindow() )
	{
		Size aSize( pViewSh->GetWindow()->GetSizePixel() );

		Size aBorderSz( pEnv->GetBorderWin()->GetHatchBorderPixel() );
		Point aOfs( aBorderSz.Width(), aBorderSz.Height() );

		DoAdjustPosSizePixel( (SfxViewShell *)pViewSh, aOfs, aSize );
	}
}

//------------------------------------------------------------------------

BOOL SfxInPlaceFrame::SetBorderPixelImpl( const SfxViewShell *pSh, const SvBorder &rBorder )
{
	SfxViewFrame::SetBorderPixelImpl( pSh, rBorder );

	pEnv->GetClipWin()->SetBorderPixel( rBorder );
	Rectangle aRect( pEnv->GetBorderWin()->GetInnerRectPixel() );
#ifdef DBG_UTIL
	Point aTmpPoint;
	Rectangle aSfxRect( aTmpPoint, pEnv->GetBorderWin()->GetOutputSizePixel() );
	aSfxRect -= pEnv->GetBorderWin()->GetAllBorderPixel();
	DBG_ASSERT( aRect == aSfxRect, "so oder sfx - einer rechnet falsch" );
#endif
	pSh->GetWindow()->SetPosSizePixel( aRect.TopLeft(), aRect.GetSize() );
	return TRUE;
}

//------------------------------------------------------------------------

const SvBorder& SfxInPlaceFrame::GetBorderPixelImpl( const SfxViewShell *pSh ) const
{
	return SfxViewFrame::GetBorderPixelImpl( pSh );
}

//------------------------------------------------------------------------

void SfxInPlaceFrame::SetChildWindow(const ResId& rResId)
{
}

//------------------------------------------------------------------------

void SfxInPlaceFrame::ShowStatusText( const String& rText )
{
	pEnv->GetContainerEnv()->SetStatusText(rText);
}

//------------------------------------------------------------------------

void SfxInPlaceFrame::HideStatusText()
{
	pEnv->GetContainerEnv()->SetStatusText( String() );
}

