/*************************************************************************
 *
 *  $RCSfile: exptypes.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: svesik $ $Date: 2004/04/21 13:17:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _BIGINT_HXX //autogen
#include <tools/bigint.hxx>
#endif
#if SUPD<613//MUSTINI
#ifndef _SFXINIMGR_HXX //autogen
#include <svtools/iniman.hxx>
#endif
#endif
#ifndef INCLUDED_RTL_MATH_HXX
#include <rtl/math.hxx>
#endif
#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_SYSLOCALE_HXX
#include <svtools/syslocale.hxx>
#endif

#ifndef GCC
#pragma hdrstop
#endif

#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif

#include "sfx.hrc"
#include "exptypes.hxx"
#include "sfxresid.hxx"
#include "app.hxx"

// Hilfsfunktionen -------------------------------------------------------

String CreateSizeText( ULONG nSize, BOOL bExtraBytes, BOOL bSmartExtraBytes )

/*	[Beschreibung]

	siehe exptypes.hxx
*/

{
	String aUnitStr = ' ';
	aUnitStr += String( SfxResId(STR_BYTES) );
	ULONG nSize1 = nSize;
	ULONG nSize2 = nSize1;
	ULONG nMega = 1024 * 1024;
	ULONG nGiga = nMega * 1024;
	double fSize = nSize;
	int nDec = 0;
	BOOL bGB = FALSE;

	if ( nSize1 >= 10000 && nSize1 < nMega )
	{
		nSize1 /= 1024;
		aUnitStr = ' ';
		aUnitStr += String( SfxResId(STR_KB) );
		fSize /= 1024;
		nDec = 0;
	}
	else if ( nSize1 >= nMega && nSize1 < nGiga )
	{
		nSize1 /= nMega;
		aUnitStr = ' ';
		aUnitStr += String( SfxResId(STR_MB) );
		fSize /= nMega;
		nDec = 2;
	}
	else if ( nSize1 >= nGiga )
	{
		nSize1 /= nGiga;
		aUnitStr = ' ';
		aUnitStr += String( SfxResId(STR_GB) );
		bGB = TRUE;
		fSize /= nGiga;
		nDec = 3;
	}
	const LocaleDataWrapper& rLocaleWrapper = SvtSysLocale().GetLocaleData();
	String aSizeStr( rLocaleWrapper.getNum( nSize1, 0 ) );
	aSizeStr += aUnitStr;
	if ( bExtraBytes && ( nSize1 < nSize2 ) )
	{
        aSizeStr = ::rtl::math::doubleToUString( fSize,
                rtl_math_StringFormat_F, nDec,
                rLocaleWrapper.getNumDecimalSep().GetChar(0) );
		aSizeStr += aUnitStr;

		aSizeStr += DEFINE_CONST_UNICODE(" (");
		aSizeStr += rLocaleWrapper.getNum( nSize2, 0 );
		aSizeStr += ' ';
		aSizeStr += String( SfxResId(STR_BYTES) );
		aSizeStr += ')';
	}
	else if ( bGB && bSmartExtraBytes )
	{
		nSize1 = nSize / nMega;
		aSizeStr = DEFINE_CONST_UNICODE(" (");
		aSizeStr += rLocaleWrapper.getNum( nSize1, 0 );
		aSizeStr += aUnitStr;
		aSizeStr += ')';
	}
	return aSizeStr;
}

// -----------------------------------------------------------------------

String ExtendedCreateSizeText( const BigInt& nSize, BOOL bExtraBytes, BOOL bSmartExtraBytes )

/*	[Beschreibung]

	siehe exptypes.hxx
*/

{
	String aUnitStr( ' ' );
	BigInt nSize1 = nSize;
	BigInt nSize2 = nSize1;
	String aSecondUnitStr( ' ' );
	BOOL bGB = FALSE;
	ULONG nMega = 1024 * 1024;
	ULONG nGiga = nMega * 1024;

	static const BigInt nTenKB( 10000 );
	static const BigInt nOneMB( nMega );
	static const BigInt nOneGB( nGiga );

	if ( nSize1 >= nTenKB && nSize1 < nOneMB )
	{
		nSize1 /= 1024;
		aUnitStr += String( SfxResId( STR_KB ) );
	}
	else if ( nSize1 >= nOneMB && nSize1 < nOneGB )
	{
		nSize1 /= nMega;
		aUnitStr += String( SfxResId( STR_MB ) );
		nSize2 /= 1024;
		aSecondUnitStr += String( SfxResId( STR_KB ) );
	}
	else if ( nSize1 >= nOneGB )
	{
		nSize1 /= nGiga;
		aUnitStr += String( SfxResId( STR_GB ) );
		nSize2 /= nMega;
		aSecondUnitStr += String( SfxResId( STR_KB ) );
		bGB = TRUE;
	}

	if ( 1 == aUnitStr.Len() )
		aUnitStr += String( SfxResId( STR_BYTES ) );
	if ( 1 == aSecondUnitStr.Len() )
		aSecondUnitStr += String( SfxResId( STR_BYTES ) );
	aSecondUnitStr += ')';
	const LocaleDataWrapper& rLocaleWrapper = SvtSysLocale().GetLocaleData();
	String aSizeStr( rLocaleWrapper.getNum( nSize1, 0 ) );
	aSizeStr += aUnitStr;
	if( bExtraBytes )
	{
		aSizeStr += DEFINE_CONST_UNICODE(" (");
		( aSizeStr += rLocaleWrapper.getNum( nSize2, 0 ) ) += aSecondUnitStr;
	}
	else if( bGB && bSmartExtraBytes )
	{
		nSize1 = nSize;
		nSize1 /= nMega;
		aSizeStr += DEFINE_CONST_UNICODE(" (");
		aSizeStr += rLocaleWrapper.getNum( nSize1, 0 );
		aSizeStr += String( SfxResId( STR_MB ));
		aSizeStr += ')';
	}
	return aSizeStr;
}

// -----------------------------------------------------------------------

String CreateKBText( ULONG nSize )

/*	[Beschreibung]

	siehe exptypes.hxx
*/

{
	ULONG nKBSize = nSize;
	nKBSize /= 1024;
	if ( !nKBSize&& nSize )
		nKBSize = 1;
	String aSize =  String::CreateFromInt32( nKBSize );
	const LocaleDataWrapper& rLocaleWrapper = SvtSysLocale().GetLocaleData();
	if ( aSize.Len() > 3 )
		aSize.Insert( rLocaleWrapper.getNumThousandSep(), aSize.Len() - 3 );
	if ( aSize.Len() > 7 )
		aSize.Insert( rLocaleWrapper.getNumThousandSep(), aSize.Len() - 7 );

	aSize += ' ';
	aSize += String( SfxResId( STR_KB ) );
	return aSize;
}

// -----------------------------------------------------------------------

String ConvertWithTilde( const String& rTxt )

/*	[Beschreibung]

	siehe exptypes.hxx
*/

{
	USHORT i = 0;
	String aTmp;

	while ( i < rTxt.Len() )
	{
		if ( rTxt.GetChar(i) == '~' )
			aTmp += '~';
		aTmp += rTxt.GetChar(i++);
	}
	return aTmp;
}

// -----------------------------------------------------------------------

void CreateDateTimeText( const DateTime& rDT, String& rText )

/*	[Beschreibung]

	siehe exptypes.hxx
*/

{
	const LocaleDataWrapper& rLocaleWrapper = SvtSysLocale().GetLocaleData();
	rText = rLocaleWrapper.getDate( rDT );
	( rText += DEFINE_CONST_UNICODE(", ") ) += rLocaleWrapper.getTime( rDT );
}

// -----------------------------------------------------------------------
#if SUPD<613//MUSTINI

String GetAddressToken( USHORT nToken, SfxIniManager* pMgr )

/*	[Beschreibung]

	siehe exptypes.hxx
*/

{
	if ( !pMgr )
		pMgr = SFX_INIMANAGER();
	String aAddress = pMgr->Get( SFX_KEY_USER_ADDRESS );
	String aToken;
	USHORT i = 0, nTxt = 0;

	while ( i < aAddress.Len() )
	{
		while ( i < aAddress.Len() && aAddress.GetChar(i) != '#' )
		{
			if ( aAddress.GetChar(i) == '\\' )
				i++;
			aToken += aAddress.GetChar(i++);
		}

		// aAddress[i] == '#' oder am Ende, also eine Position weiter gehen
		i++;

		if ( nToken == nTxt )
			break;
		else if ( i >= aAddress.Len() )
		{
			aToken.Erase();
			break;
		}
		else
		{
			aToken.Erase();
			nTxt++;
		}
	}
	return aToken;
}
#endif//MUSTINI
// -----------------------------------------------------------------------

BOOL Trim_And_Test_Text( Window& rWnd )
/*
  [Beschreibung]
  Die Methode entfernt die ueberfluessigen Zeichen des Textes des Fensters
  und prueft, ob er mehr als 0 Zeichen hat.

  [Rueckgabewert]
  FALSE  - 0 Zeichen lang
  ...
  */
{
	String aTxt( rWnd.GetText() );
	aTxt.EraseTrailingChars();
	aTxt.EraseLeadingChars();
	return aTxt.Len() > 0;
}

// -----------------------------------------------------------------------

String CreateExactSizeText( ULONG nSize )
{
	String aUnitStr = ' ';
	aUnitStr += String( SfxResId(STR_BYTES) );
	double fSize = nSize;
	int nDec = 0;
	ULONG nMega = 1024 * 1024;
	ULONG nGiga = nMega * 1024;

	if ( nSize >= 10000 && nSize < nMega )
	{
		fSize /= 1024;
		aUnitStr = ' ';
		aUnitStr += String( SfxResId(STR_KB) );
		nDec = 0;
	}
	else if ( nSize >= nMega && nSize < nGiga )
	{
		fSize /= nMega;
		aUnitStr = ' ';
		aUnitStr += String( SfxResId(STR_MB) );
		nDec = 2;
	}
	else if ( nSize >= nGiga )
	{
		fSize /= nGiga;
		aUnitStr = ' ';
		aUnitStr += String( SfxResId(STR_GB) );
		nDec = 3;
	}
    String aSizeStr( ::rtl::math::doubleToUString( fSize,
                rtl_math_StringFormat_F, nDec,
                SvtSysLocale().GetLocaleData().getNumDecimalSep().GetChar(0) ));
	aSizeStr += aUnitStr;
	return aSizeStr;
}

// -----------------------------------------------------------------------

String CreateExactSizeText( const BigInt& rSize )
{
	String aUnitStr = ' ';
	aUnitStr += String( SfxResId(STR_BYTES) );
	int nDec = 0;
	BigInt nSize = rSize;
	double fSize = nSize;

	ULONG nMega = 1024 * 1024;
	ULONG nGiga = nMega * 1024;
	static const BigInt nTenKB( 10000 );
	static const BigInt nOneMB( nMega );
	static const BigInt nOneGB( nGiga );

	if ( nSize >= nTenKB && nSize < nOneMB )
	{
		fSize /= 1024;
		aUnitStr = ' ';
		aUnitStr += String( SfxResId(STR_KB) );
		nDec = 0;
	}
	else if ( nSize >= nOneMB && nSize < nOneGB )
	{
		fSize /= nMega;
		aUnitStr = ' ';
		aUnitStr += String( SfxResId(STR_MB) );
		nDec = 2;
	}
	else if ( nSize >= nOneGB )
	{
		fSize /= nGiga;
		aUnitStr = ' ';
		aUnitStr += String( SfxResId(STR_GB) );
		nDec = 3;
	}
    String aSizeStr( ::rtl::math::doubleToUString( fSize,
                rtl_math_StringFormat_F, nDec,
                SvtSysLocale().GetLocaleData().getNumDecimalSep().GetChar(0) ));
	aSizeStr += aUnitStr;
	return aSizeStr;
}

