/*************************************************************************
 *
 *  $RCSfile: interno.cxx,v $
 *
 *  $Revision: 1.25 $
 *
 *  last change: $Author: kz $ $Date: 2004/10/04 20:55:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SVSTOR_HXX
#include <so3/svstor.hxx>
#endif

#include <svtools/eitem.hxx>

#ifndef GCC
#pragma hdrstop
#endif

#define _SFX_INTERNO_CXX

#include "sfxtypes.hxx"
#include "tbxmgr.hxx"
#include "app.hxx"
#include "dispatch.hxx"
#include "request.hxx"
#include "docfac.hxx"
#include "docfilt.hxx"
#include "viewfrm.hxx"
#include "viewsh.hxx"
#include "virtmenu.hxx"
#include "mnumgr.hxx"
#include "interno.hxx"
#include "ipfrm.hxx"
#include "ipenv.hxx"
#include "imgmgr.hxx"
#include "childwin.hxx"
#include "arrdecl.hxx"
#include "cfgmgr.hxx"
#include "tbxconf.hxx"
#include "fltfnc.hxx"
#include "accmgr.hxx"
#include "sfxresid.hxx"
#include "topfrm.hxx"
#include "doc.hrc"

#include <com/sun/star/uno/Reference.hxx>
#include <com/sun/star/frame/XFrame.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <drafts/com/sun/star/frame/XLayoutManager.hpp>

using namespace com::sun::star;

//-------------------------------------------------------------------------

#define SVIPWINDOW(p) ((SvInPlaceWindow&)p->GetWindow())


//-------------------------------------------------------------------------
SV_IMPL_FACTORY(SfxInPlaceObjectFactory){}};
TYPEINIT1(SfxInPlaceObjectFactory,SvFactory);
SO2_IMPL_CLASS1(SfxInPlaceObject,SfxInPlaceObjectFactory,SvInPlaceObject,
        SvGlobalName(0x3C8A87D0L,0x9B53,0x11d3,0x9E,0xCE,0x00,0x50,0x04,0xD7,0x6C,0x4D))
void SfxInPlaceObject::TestMemberObjRef(BOOL){}
void SfxInPlaceObject::TestMemberInvariant(BOOL){}
IUnknown* SfxInPlaceObject::GetMemberInterface( const SvGlobalName & ){ return 0L; }

SfxInPlaceObject::SfxInPlaceObject()
:	pObjShell(0),
	pFrame(0)
{
	bTriggerLinkTimer = TRUE;
	bDisableViewScaling = FALSE;
	pNote = 0;

	// Verben der Superklasse bekanntgeben, um GetVerbList nicht
	// ueberlagern zu muessen
    SvVerbList* pVerbs = new SvVerbList;
    pVerbs->Append( SvVerb( 0, String( SfxResId( STR_EDITOBJECT ) ) ) );
//    pVerbs->Append( SvVerb( 1, String( SfxResId( STR_OPENOBJECT ) ) ) );
//    pVerbs->Append( SvVerb( 2, DEFINE_CONST_UNICODE(STARAPP_VERB), sal_True, sal_False ) );
    pVerbs->Append( SvVerb( 3, String( SfxResId( STR_SAVECOPYDOC ) ) ) );
    SetVerbList( pVerbs, TRUE );
}

void SfxInPlaceObject::SetShell( SfxObjectShell *pObjSh )
{
    pObjShell = pObjSh;
}

//--------------------------------------------------------------------

SfxInPlaceObject::~SfxInPlaceObject()
{
}

//--------------------------------------------------------------------

void SfxInPlaceObject::FillClass( SvGlobalName * pClassName,
								  ULONG * pClipFormat,
								  String * pAppName,
								  String * pLongUserName,
								  String * pUserName,
								  long nVersion
) const
{
	SvPersist::FillClass( pClassName, pClipFormat, pAppName, pLongUserName, pUserName, nVersion );
/*
	SfxObjectFactory &rFact = pObjShell->GetFactory();
	for( USHORT n = 0; n < rFact.GetFilterCount(); n++ )
	{
		const SfxFilter * pFilter = rFact.GetFilter( n );
		if ( pFilter->IsOwnFormat() && pFilter->GetVersion() == (ULONG)nVersion )
		{
			*pClassName     = *GetSvFactory();
			*pClipFormat    = pFilter->GetFormat();
            *pLongUserName  = pFilter->GetFilterName();
            *pUserName      = pFilter->GetFilterName();
			break;
		}
	}
*/
	*pAppName = String( SfxResId(STR_HUMAN_APPNAME ) );
}

//--------------------------------------------------------------------

void SfxInPlaceObject::SetModified( BOOL bSet )
{
	if ( !bSet || !pObjShell->IsReadOnlyMedium() )
	{
		SvInPlaceObject::SetModified( bSet );
        if( bSet && bTriggerLinkTimer && IsEnableSetModified() )
		{
			ViewChanged( ASPECT_CONTENT );
		}
	}
}

//--------------------------------------------------------------------

void SfxInPlaceObject::UpdateLinks()
{
	SendViewChanged();
}

//--------------------------------------------------------------------

BOOL SfxInPlaceObject::InitNew( SvStorage * pStor)
{
	if( SvInPlaceObject::InitNew( pStor ) )
	{
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------

BOOL SfxInPlaceObject::Load( SvStorage * pStor )
{
	if( SvInPlaceObject::Load( pStor ) )
	{
		// Spaeter mal Childs on demand
//        if( LoadChilds() )
			return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------

BOOL SfxInPlaceObject::Save()
{
	if( !SaveChilds() )
		return FALSE;
	if( SvInPlaceObject::Save() )
        return pObjShell->SfxObjectShell::Save();
	return FALSE;
}

//--------------------------------------------------------------------

BOOL SfxInPlaceObject::SaveAs( SvStorage * pNewStor )
{
	if( !SaveAsChilds( pNewStor ) )
		return FALSE;
    if( SvInPlaceObject::SaveAs( pNewStor ) )
        return pObjShell->SfxObjectShell::SaveAs(pNewStor);
	return FALSE;
}

//--------------------------------------------------------------------

void SfxInPlaceObject::HandsOff()
{
	SvInPlaceObject::HandsOff();
}

//--------------------------------------------------------------------

BOOL SfxInPlaceObject::SaveCompleted( SvStorage * pStor )
{
	if( !SaveCompletedChilds( pStor ) )
		return FALSE;
	if( SvInPlaceObject::SaveCompleted( pStor ) )
	{
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------

void SfxInPlaceObject::SetVisArea( const Rectangle & rRect )
{
	if( GetVisArea() != rRect )
	{
		Size aSize (GetVisArea().GetSize());
		// Groesse des Objects setzen
		SvInPlaceObject::SetVisArea( rRect );

		SetModified( TRUE );

        if ( GetIPEnv() && GetIPEnv()->GetEditWin() )
            ViewChanged( ASPECT_CONTENT );

		SfxInPlaceFrame *pIPF = PTR_CAST(SfxInPlaceFrame,pFrame);

		// OutPlace die Gr"o\se des MDI-Fensters anpassen
		// Unbedingt den Gr"o\senvergleich machen, spart nicht nur Zeit, sondern
		// vermeidet auch Rundungsfehler !
		if ( GetObjectShell()->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
		{
			// in case of ole outplace editing the frame should be found
			SfxViewFrame* pFrameToResize = pFrame ? pFrame : SfxViewFrame::GetFirst( GetObjectShell() );

			if ( pFrameToResize && !pIPF && rRect.GetSize() != aSize &&
				!pFrameToResize->IsAdjustPosSizePixelLocked_Impl() )

			{
				// Zuerst die logischen Koordinaten von IP-Objekt und EditWindow
				// ber"ucksichtigen
				SfxViewShell *pShell = pFrameToResize->GetViewShell();
				Window *pWindow = pShell->GetWindow();

				// Da in den Applikationen bei der R"ucktransformation immer die
				// Eckpunkte tranformiert werden und nicht die Size (um die Ecken
				// alignen zu k"onnen), transformieren wir hier auch die Punkte, um
				// m"oglichst wenig Rundungsfehler zu erhalten.
				Rectangle aRect = pWindow->LogicToPixel( rRect );
				Size aSize = aRect.GetSize();
				pShell->GetWindow()->SetSizePixel( aSize );
				pFrameToResize->DoAdjustPosSizePixel( pShell, Point(), aSize );
			}
		}

		// bei InPlace die View skalieren
        if ( GetIPEnv() && GetIPEnv()->GetEditWin() && !bDisableViewScaling && pIPF )
			pIPF->GetEnv_Impl()->MakeScale( rRect.GetSize(), GetMapUnit(),
						pIPF->GetViewShell()->GetWindow()->GetOutputSizePixel() );
	}
}

//--------------------------------------------------------------------

ErrCode SfxInPlaceObject::Verb( long nVerb, SvEmbeddedClient *pCaller,
								Window *pWindow, const Rectangle* pRect)
{
	if ( pCaller && pCaller == GetClient() )
	{
		if ( nVerb == 1 )
			return DoEmbed(TRUE);
        else if ( nVerb == 3 )
        {
            SfxObjectShell* pDoc = GetObjectShell();
            SfxRequest aReq( SID_SAVEASDOC, SFX_CALLMODE_SYNCHRON, pDoc->GetPool() );
            aReq.AppendItem( SfxBoolItem( SID_SAVETO, TRUE ) );
            pDoc->ExecuteSlot( aReq );
            return ERRCODE_NONE;
        }
		return SvInPlaceObject::Verb(nVerb, pCaller, pWindow, pRect);
	}
	else
	{
        DBG_ERROR("This behaviour is undefined!");
        return FALSE;
/*
		SfxApplication *pSfxApp = SFX_APP();
		pFrame = pObjShell->GetFrame();
		if ( !pFrame )
		{
//(mba)/task: no correct outplace editing
            pFrame = SfxTopFrame::Create( pObjShell )->GetCurrentViewFrame();
		}
		else
		{
			pFrame->GetFrame()->Appear();
		}

		String aFN = GetFileName();
		if( aFN.Len() )
		{
			// Dokumentnamen setzen
            INetURLObject aDE( GetFileName(), INET_PROT_FILE );
			SetDocumentName( aDE.GetName() );
			pFrame->GetWindow().SetText( aDE.GetName() );
		}

        pFrame->GetWindow().ToTop();
		return ERRCODE_NONE;
 */
	}
}

//--------------------------------------------------------------------

BOOL SfxInPlaceObject::Verb( long nVerb, const Rectangle* pRect )
{
	return (BOOL)DoEmbed( TRUE );
}

//--------------------------------------------------------------------

void SfxInPlaceObject::Open( BOOL bOpen )
{
	SvInPlaceObject::Open( bOpen );
}

//-------------------------------------------------------------------------

void SfxInPlaceObject::InPlaceActivate( BOOL bActivate )
{
	if( bActivate )
	{
		DBG_ASSERT( pObjShell,
					"SfxInPlaceObject::InPlaceActivate(): you must call SetShell() bevor" )
		DBG_ASSERT (!pFrame, "Objekt ist noch aktiv!");

		// IPFenster erzeugen
        SfxInPlaceFrame *pIPFrame = new SfxInPlaceFrame( *pObjShell );
		pFrame = pIPFrame;

        SfxWorkWindow* pWorkWin = pIPFrame->GetFrame()->GetWorkWindow_Impl();
        pWorkWin->Lock_Impl(TRUE);
        pWorkWin->SetObjectBarVisibility_Impl( SFX_VISIBILITY_UNVISIBLE );

        uno::Reference < beans::XPropertySet > xFrame( pIPFrame->GetFrame()->GetFrameInterface(), uno::UNO_QUERY );
        uno::Reference< ::drafts::com::sun::star::frame::XLayoutManager > xMyMan;
        uno::Any aAny = xFrame->getPropertyValue( ::rtl::OUString::createFromAscii("LayoutManager") );
        aAny >>= xMyMan;

        xFrame = uno::Reference < beans::XPropertySet >( SfxViewFrame::Current()->GetFrame()->GetFrameInterface(), uno::UNO_QUERY );
        uno::Reference< ::drafts::com::sun::star::frame::XLayoutManager > xMan;
        aAny = xFrame->getPropertyValue( ::rtl::OUString::createFromAscii("LayoutManager") );
        aAny >>= xMan;

        xMyMan->setDockingAreaAcceptor( xMan->getDockingAreaAcceptor() );
        xMyMan->setVisible( sal_False );
        xMyMan->lock();

		SetIPEnv( pIPFrame->GetEnv_Impl() );

		if ( GetIPClient()->Owner() )
		{
            pFrame->SetParentViewFrame_Impl( SfxViewFrame::Current() );
		}

		pIPFrame->GetDispatcher()->Flush();
		pIPFrame->DoActivate( FALSE );
	}

	SvInPlaceObject::InPlaceActivate( bActivate );

	if ( !bActivate )
	{
		// Im UIActivate wurde SetViewFrame(0) gemacht, aber neuerdings
		// gibt es dann kein Deactivate(TRUE), weil alter und neuer
		// ViewFrame der Applikation verschiedene Bindings haben.
		// Frame samt Fenstern jetzt im Deactivate wegwerfen
		// DoDeactivate erfolgt im UIDeactivate

		SfxObjectShell *pSh = pFrame->GetObjectShell();
		SfxViewFrame *pParent = pFrame->GetParentViewFrame_Impl();
		if ( pParent && pSh == SfxObjectShell::GetWorkingDocument() )
			SfxObjectShell::SetWorkingDocument( pParent->GetObjectShell() );

		pFrame->GetFrame()->DoClose();
		pFrame = NULL;
	}
}

//--------------------------------------------------------------------

void SfxInPlaceObject::Embed( BOOL bEmbed )
{
/*
	SvInPlaceObject::Embed( bEmbed );

	if( bEmbed )
	{
        DBG_ASSERT( pObjShell, "SfxInPlaceObject::Embed(): you must call SetShell() bevor" )
		if (pFrame)
		{
			SetIPEnv( 0 );
			pFrame->GetFrame()->DoClose();
			pFrame = NULL;
		}

        pFrame = SfxTopFrame::Create( pObjShell,0 )->GetCurrentViewFrame();
        pFrame->GetFrame()->Appear();

		// Beim Writer stehen sonst die Scrollbars mittendrin
		pFrame->InvalidateBorderImpl( pFrame->GetViewShell() );
	}
	else
	{
		// Unter WIN 3.1 mu\s das MDI-Window schon hier deleted werden,
		// da sonst zun"achst die Verbindung zum Client geclosed wird, dieser
		// dabei den Focus von Windows erh"alt, der ihm aber anschlie\send
		// gleich wieder durch den Window-ctor des MDI-Windows entzogen wird.
		pFrame->GetFrame()->DoClose();
		pFrame = NULL;
	}
*/
}

//--------------------------------------------------------------------

void SfxInPlaceObject::UIActivate( BOOL bActivate )
{
	SfxApplication *pApp = SFX_APP();
	SfxViewFrame *pParent = pFrame->GetParentViewFrame_Impl();
	if ( bActivate )
	{
		if ( pParent )
			pParent->SetIPFrame_Impl( GetIPFrame_Impl() );

		// DoActivate erfolgte schon im InPlaceActivate
		pApp->SetViewFrame( pFrame );
		pFrame->DoActivate( TRUE );
        pFrame->GetDispatcher()->Update_Impl( TRUE );
	}
	else
	{
		if ( pParent )
			// Bei internem InPlace das Container-Dokument aktivieren
			pParent->SetIPFrame_Impl( NULL );

		if ( pApp->GetViewFrame() == pFrame )
			// Das muss nicht sein, es k"onnte auch die Task gewechselt worden sein
			pApp->SetViewFrame( pParent );

		pFrame->DoDeactivate( TRUE );
	}

	SvInPlaceObject::UIActivate( bActivate );
	GetIPFrame_Impl()->GetEnv_Impl()->UIActivate(bActivate);

	if ( !bActivate && pApp->GetViewFrame() == pFrame )
	{
		// Wenn jetzt noch der InPlaceFrame aktiv ist ( externes InPlace ),
		// deaktivieren
		pApp->SetViewFrame(0);
	}
}

//--------------------------------------------------------------------

void SfxInPlaceObject::TopWinActivate( BOOL bActivate )
{
#ifdef DBG_UTIL
	ByteString aTest( "TopWinActivate( " );
	aTest += bActivate ? "TRUE" : "FALSE";
	aTest += " )";
	DBG_TRACE( aTest.GetBuffer() );
#endif

	if ( bActivate )
	{
		if ( GetProtocol().IsDocWinActive() && GetProtocol().IsUIActive() )
		{
			GetIPFrame_Impl()->GetEnv_Impl()->TopWinActivate(bActivate);

			// Hier muss der ViewFrame gesetzt werden, da beim Umschalten von
			// StarApplikation-MDI auf Applikation mit StarApplikation-IP diese
			// nur ein TopWinActivate, aber kein DocWinActivate bekommt !

			if ( SFX_APP()->GetViewFrame() != pFrame )
				SFX_APP()->SetViewFrame( pFrame );
			else
				pFrame->DoActivate( FALSE );
		}
	}

	SvInPlaceObject::TopWinActivate( bActivate );

	if ( !bActivate )
	{
		if ( GetProtocol().IsDocWinActive() && GetProtocol().IsUIActive() )
		{
			GetIPFrame_Impl()->GetEnv_Impl()->TopWinActivate( bActivate );
			pFrame->DoDeactivate( FALSE );
		}
	}
}

//--------------------------------------------------------------------

void SfxInPlaceObject::DocWinActivate( BOOL bActivate )
{
#ifdef DBG_UTIL
	ByteString aTest( "DocWinActivate( " );
	aTest += bActivate ? "TRUE" : "FALSE";
	aTest += " )";
	DBG_TRACE( aTest.GetBuffer() );
#endif

	if ( bActivate )
	{
		if ( GetProtocol().IsUIActive() )
		{
			GetIPFrame_Impl()->GetEnv_Impl()->DocWinActivate( bActivate );
			if ( SFX_APP()->GetViewFrame() != pFrame )
				SFX_APP()->SetViewFrame(pFrame);
			else
				pFrame->DoActivate(FALSE);
		}
	}

	SvInPlaceObject::DocWinActivate( bActivate );

	if ( !bActivate )
	{
		if ( GetProtocol().IsUIActive() )
		{
			GetIPFrame_Impl()->GetEnv_Impl()->DocWinActivate( bActivate );
			pFrame->DoDeactivate( FALSE );
		}
	}
}

//--------------------------------------------------------------------

void SfxInPlaceObject::DocumentNameChanged( const String & rDocName )
{
	if ( !pFrame->IsA( TYPE(SfxInPlaceFrame) ) )
	{
		// Name f"ur Window zusammenbauen
		String aName = GetShortTypeName();
		aName += DEFINE_CONST_UNICODE( " in " );         //! muss noch internationalisiert werden
		aName += rDocName;

		// DocName in Titelzeile von MDI-Window und als SbxObject-Name setzen
		pFrame->GetTopFrame()->GetWindow().SetText( aName );
		pFrame->SetName( aName );

		// Slots invalidieren, damit Menue-Eintr"age aktualisiert werden
		pFrame->GetBindings().Invalidate(SID_CLOSEDOC);
		pFrame->GetBindings().Invalidate(SID_SAVEDOC);
		pFrame->GetBindings().Invalidate(SID_SAVEASDOC);
		pFrame->GetBindings().Invalidate(SID_QUITAPP);
	}
}

//--------------------------------------------------------------------

SfxForceLinkTimer_Impl::SfxForceLinkTimer_Impl( SfxObjectShell *pObj )
{
	pInObj = pObj->GetInPlaceObject();
	if( pInObj )
	{
		pInObj->SetTriggerLinkTimer( FALSE );
		pInObj->UpdateLinks();
	}
}

