/*************************************************************************
 *
 *  $RCSfile: fupoor.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: obo $ $Date: 2004/11/17 09:20:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SD_FU_POOR_HXX
#define SD_FU_POOR_HXX

#ifndef _RTTI_HXX //autogen
#include <tools/rtti.hxx>
#endif
#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif
#ifndef _GEN_HXX //autogen
#include <tools/gen.hxx>
#endif
#ifndef _SV_EVENT_HXX //autogen
#include <vcl/event.hxx>
#endif

class SdDrawDocument;
class SfxRequest;
class Dialog;
class SdrObject;

namespace sd {

class DrawDocShell;
class View;
class ViewShell;
class Window;



/*************************************************************************
|*
|* Basisklasse fuer alle Funktionen
|*
\************************************************************************/

class FuPoor
{
public:
    static const int HITPIX	= 2; 				   // Hit-Toleranz in Pixel
    static const int DRGPIX	= 2; 				   // Drag MinMove in Pixel

	TYPEINFO();

    /**
        @param pViewSh
            May be NULL.
    */
	FuPoor (ViewShell* pViewSh, 
        ::sd::Window* pWin, 
        ::sd::View* pView,
        SdDrawDocument* pDoc, 
        SfxRequest& rReq);
	virtual ~FuPoor (void);

	// #95491# see member
	void SetMouseButtonCode(sal_uInt16 nNew) { if(nNew != mnCode) mnCode = nNew; }
	const sal_uInt16 GetMouseButtonCode() const { return mnCode; }

	DrawDocShell* GetDocSh() { return pDocSh; }
	SdDrawDocument* GetDoc() { return pDoc; }

	virtual void DoCut();
	virtual void DoCopy();
	virtual void DoPaste();

	// Mouse- & Key-Events; Returnwert=TRUE: Event wurde bearbeitet
	virtual BOOL KeyInput(const KeyEvent& rKEvt);
	virtual BOOL MouseMove(const MouseEvent& rMEvt) { return FALSE; }
	virtual BOOL MouseButtonUp(const MouseEvent& rMEvt);

	// #95491# moved from inline to *.cxx
	virtual BOOL MouseButtonDown(const MouseEvent& rMEvt);
	
	virtual BOOL Command(const CommandEvent& rCEvt);
	virtual BOOL RequestHelp(const HelpEvent& rHEvt);
	virtual void Paint(const Rectangle& rRect, ::sd::Window* pWin) {}
	virtual void ReceiveRequest(SfxRequest& rReq);

	virtual void Activate();		// Function aktivieren
	virtual void Deactivate();		// Function deaktivieren

	virtual void ScrollStart() {}	// diese Funktionen werden von
	virtual void ScrollEnd() {} 	// ForceScroll aufgerufen

	void SetWindow(::sd::Window* pWin) { pWindow = pWin; }
	void WriteStatus(const String& aStr);  // Statuszeile schreiben

	// #97016# II
	virtual void SelectionHasChanged();

	USHORT	GetSlotID() const { return( nSlotId ); }
	USHORT	GetSlotValue() const { return( nSlotValue ); }

	void	SetNoScrollUntilInside(BOOL bNoScroll = TRUE)
			{ bNoScrollUntilInside = bNoScroll; }

	void StartDelayToScrollTimer ();

	// #97016#
	virtual SdrObject* CreateDefaultObject(const sal_uInt16 nID, const Rectangle& rRectangle);

	/** is called when the currenct function should be aborted. <p>
		This is used when a function gets a KEY_ESCAPE but can also
		be called directly.

		@returns true if a active function was aborted
	*/
	virtual bool cancel();

	// #i33136#
	/** Decide if the object to be created should be created
		orthogonal. Default implementation uses nSlotID
		to decide. May be overloaded to use other criterias
		for this decision

		@returns true if the to be created object should be orthogonal.
	*/
	virtual bool doConstructOrthogonal() const;

protected:
	DECL_LINK( DelayHdl, Timer * );
	long diffPoint (long pos1, long pos2);

	void ImpForceQuadratic(Rectangle& rRect);

    /** Switch to another layer.  The layer to switch to is specified by an
        offset relative to the active layer.  With respect to the layer bar
        control at the lower left of the document window positive values
        move to the right and negative values move to the left.
    
        <p>Switching the layer is independant of the view's layer mode.  The
        layers are switched even when the layer mode is turned off and the
        layer control is not visible.</p>
        @param nOffset
           If the offset is positive skip that many layers in selecting the
           next layer.  If it is negative then select a previous one.  An
           offset or zero does not change the current layer.  If the
           resulting index lies outside the valid range of indices then it
           is set to either the minimal or maximal valid index, whitchever
           is nearer.
    */
    void SwitchLayer (sal_Int32 nOffset);

	::sd::View* pView;
	ViewShell* pViewShell;
	::sd::Window* pWindow;
	DrawDocShell* pDocSh;
	SdDrawDocument* pDoc;

	USHORT			nSlotId;
	USHORT			nSlotValue;

	Dialog* 		pDialog;

	Timer			aScrollTimer;			// fuer Autoscrolling
	DECL_LINK( ScrollHdl, Timer * );
	void ForceScroll(const Point& aPixPos);

	Timer			aDragTimer; 			// fuer Drag&Drop
	DECL_LINK( DragHdl, Timer * );
	BOOL			bIsInDragMode;
	Point			aMDPos; 				// Position von MouseButtonDown

	// Flag, um AutoScrolling zu verhindern, bis von ausserhalb in das
	// Fenster hinein gedragt wurde
	BOOL			bNoScrollUntilInside;

	// Timer um das scrolling zu verzoegern, wenn aus dem fenster
	// herausgedraggt wird (ca. 1 sec.)
	Timer			aDelayToScrollTimer;	// fuer Verzoegerung bis scroll
	BOOL			bScrollable;
	BOOL			bDelayActive;
	BOOL			bFirstMouseMove;

	// #95491# member to hold state of the mouse buttons for creation
	// of own MouseEvents (like in ScrollHdl)

private:
	sal_uInt16		mnCode;

};

} // end of namespace sd

#endif		// _SD_FUPOOR_HXX

