/*************************************************************************
 *
 *  $RCSfile: ViewShellCache.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2005/01/28 16:23:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SD_VIEW_SHELL_CACHE_HXX
#define SD_VIEW_SHELL_CACHE_HXX

#include "ShellFactory.hxx"
#include <memory>

namespace sd
{

class ViewShellManager;

/** The task of the view shell cache is to provide view shells that are
    displayed in one of the panes.  Its goal is to reduce the number of
    times view shells are created.  For this it uses the fact that view
    shells in the side panes are generally not replaced by another view
    shell but made temporarily hidden.  In the center pane there are a
    limited number of view shells of which a few can be stored and be made
    visible if requested.

    The cache knows about view shells and parent windows, not about panes.
    It therefore does not know whether a view shell belongs to one of the
    side panes.
*/
class ViewShellCache
{
public:
    ViewShellCache (ViewShellManager& rManager);
    ~ViewShellCache (void);

    /** Get a view shell of the specified type that will be displayed in the
        specified window.  It lies in the responsibility of the cache
        whether it creates a new shell or uses one in the cache.
    */
    ViewShell* GetViewShell (
        ShellId nId,
        ::Window* pParentWindow,
        FrameView* pFrameView);

    /** The given view shell is not displayed any longer.  It lies in the
        responsibility of the cache whether it destroys the shell or stores
        it for later use.
    */
    void ReleaseViewShell (ViewShell* pViewShell);

    /** Clear the view shell cache.  Following calls are ignored.
    */
    void Shutdown (void);

private:
    class Implementation;
    ::std::auto_ptr<Implementation> mpImpl;
};

} // end of namespace sd

#endif
