/*************************************************************************
 *
 *  $RCSfile: AccessibleSlideView.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: obo $ $Date: 2004/01/20 10:34:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <rtl/uuid.h>
#include <unotools/accessiblestatesethelper.hxx>
#ifndef SD_SLIDE_VIEW_SHELL_HXX
#include "SlideViewShell.hxx"
#endif
#ifndef SD_WINDOW_HXX
#include "Window.hxx"
#endif
#include "sdpage.hxx"
#include "drawdoc.hxx"
#ifndef SD_ACCESSIBILITY_ACCESSIBLE_SLIDE_VIEW_HXX
#include "AccessibleSlideView.hxx"
#endif

#include "accessibility.hrc"
#include "sdresid.hxx"

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEROLE_HPP_
#include <com/sun/star/accessibility/AccessibleRole.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif
#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

#ifndef COMPHELPER_ACCESSIBLE_EVENT_NOTIFIER
#include <comphelper/accessibleeventnotifier.hxx>
#endif

using namespace ::rtl;
using namespace ::com::sun::star;

// -----------------------------
// - AccessibleSlideViewObject -
// -----------------------------

AccessibleSlideViewObject::AccessibleSlideViewObject( const uno::Reference< accessibility::XAccessible >& rxParent, sal_uInt16 nPage, sal_Bool bVisible ) :
    mxParent( rxParent ),
	mnPage( nPage ),
	mbVisible( bVisible ),
    mnClientId( 0 )
{
}

// -----------------------------------------------------------------------------

AccessibleSlideViewObject::~AccessibleSlideViewObject()
{
    if (mxParent.is())
        Destroyed ();
}

// -----------------------------------------------------------------------

void AccessibleSlideViewObject::FireAccessibleEvent( short nEventId, const uno::Any& rOldValue, const uno::Any& rNewValue )
{
    accessibility::AccessibleEventObject aEvtObject;

    aEvtObject.EventId = nEventId;
    aEvtObject.NewValue = rNewValue;
	aEvtObject.OldValue = rOldValue;

	if (mnClientId)
		comphelper::AccessibleEventNotifier::addEvent( mnClientId, aEvtObject );
}

// -----------------------------------------------------------------------------

void AccessibleSlideViewObject::Destroyed (void)
{
    const vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    mxParent = uno::Reference< accessibility::XAccessible >();

    // Send a disposing to all listeners.
	if ( mnClientId )
	{
        comphelper::AccessibleEventNotifier::revokeClientNotifyDisposing( mnClientId, *this );
		mnClientId =  0;
	}
}

// -----------------------------------------------------------------------------

void AccessibleSlideViewObject::SetVisible( sal_Bool bVisible )
{
    if( IsVisible() != bVisible )
		mbVisible = bVisible;
}

// -----------------------------------------------------------------------------

sal_Bool AccessibleSlideViewObject::IsVisible() const
{
	return( mbVisible );
}

// -----------------------------------------------------------------------------

const uno::Sequence< sal_Int8 >& AccessibleSlideViewObject::getUnoTunnelId()
{
    static uno::Sequence< sal_Int8 > aSeq;

	if( !aSeq.getLength() )
	{
		static osl::Mutex   aCreateMutex;
    	osl::MutexGuard     aGuard( aCreateMutex );

		aSeq.realloc( 16 );
    	rtl_createUuid( reinterpret_cast< sal_uInt8* >( aSeq.getArray() ), 0, sal_True );
	}
	
    return aSeq;
}

// -----------------------------------------------------------------------------

AccessibleSlideViewObject* AccessibleSlideViewObject::getImplementation( const uno::Reference< uno::XInterface >& rxData ) 
    throw()
{
    try
    {
	    uno::Reference< lang::XUnoTunnel > xUnoTunnel( rxData, uno::UNO_QUERY );
        return( xUnoTunnel.is() ? ( (AccessibleSlideViewObject*)(void*) xUnoTunnel->getSomething( AccessibleSlideViewObject::getUnoTunnelId() ) ) : NULL );
    }
    catch( const ::com::sun::star::uno::Exception& )
	{
        return NULL;
	}
}

// -----------------------------------------------------------------------------

sal_Int64 SAL_CALL AccessibleSlideViewObject::getSomething( const uno::Sequence< sal_Int8 >& rId ) throw( uno::RuntimeException )
{
    sal_Int64 nRet;

    if( ( rId.getLength() == 16 ) && ( 0 == rtl_compareMemory( AccessibleSlideViewObject::getUnoTunnelId().getConstArray(), rId.getConstArray(), 16 ) ) )
        nRet = reinterpret_cast< sal_Int64 >( this );
    else
        nRet = 0;

	return nRet;
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessibleContext > SAL_CALL AccessibleSlideViewObject::getAccessibleContext()
    throw (uno::RuntimeException)
{
    return this;
}

// -----------------------------------------------------------------------------

sal_Int32 SAL_CALL AccessibleSlideViewObject::getAccessibleChildCount() 
    throw (uno::RuntimeException)
{
    return 0;
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessible > SAL_CALL AccessibleSlideViewObject::getAccessibleChild( sal_Int32 i ) 
    throw (lang::IndexOutOfBoundsException, uno::RuntimeException)
{
    throw lang::IndexOutOfBoundsException();
    return uno::Reference< accessibility::XAccessible >();
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessible > SAL_CALL AccessibleSlideViewObject::getAccessibleParent() 
    throw (uno::RuntimeException)
{
    return mxParent;
}

// -----------------------------------------------------------------------------

sal_Int32 SAL_CALL AccessibleSlideViewObject::getAccessibleIndexInParent() 
    throw (uno::RuntimeException)
{
    const vos::OGuard   aSolarGuard( Application::GetSolarMutex() );
    sal_Int32           nRet = -1;

    if( mxParent.is() )
    {
        uno::Reference< accessibility::XAccessibleContext > xParentContext( mxParent, uno::UNO_QUERY );

        if( xParentContext.is() )
            for( sal_Int32 nChild = 0, nChildCount = xParentContext->getAccessibleChildCount(); ( nChild < nChildCount) && ( -1 == nRet ); ++nChild )
                if( xParentContext->getAccessibleChild( nChild ).get() == static_cast< accessibility::XAccessible* >( this ) )
                    nRet = nChild;
   }
   
   return nRet;
}

// -----------------------------------------------------------------------------

sal_Int16 SAL_CALL AccessibleSlideViewObject::getAccessibleRole() 
    throw (uno::RuntimeException)
{
    return accessibility::AccessibleRole::SHAPE;
}

// -----------------------------------------------------------------------------

::rtl::OUString SAL_CALL AccessibleSlideViewObject::getAccessibleDescription() 
    throw (uno::RuntimeException)
{
    return( ::rtl::OUString::createFromAscii( "Slide" ) );
}

// -----------------------------------------------------------------------------

::rtl::OUString SAL_CALL AccessibleSlideViewObject::getAccessibleName() 
    throw (uno::RuntimeException)
{
    const vos::OGuard   aSolarGuard( Application::GetSolarMutex() );
    ::rtl::OUString     aRet;

    if( mxParent.is() )
    {
        AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( mxParent );
        SdDrawDocument*      pDrawDoc = pAccView->GetDrawDocument();

        if( pDrawDoc )
        {
    	    SdPage* pPage = pDrawDoc->GetSdPage( mnPage, PK_STANDARD );

            if( pPage )
                aRet = pPage->GetName();
        }
    }

    return( aRet );
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessibleRelationSet > SAL_CALL AccessibleSlideViewObject::getAccessibleRelationSet() 
    throw (uno::RuntimeException)
{
    // !!!
    return uno::Reference< accessibility::XAccessibleRelationSet >();
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessibleStateSet > SAL_CALL AccessibleSlideViewObject::getAccessibleStateSet() 
    throw (uno::RuntimeException)
{
    const vos::OGuard                   aSolarGuard( Application::GetSolarMutex() );
    ::utl::AccessibleStateSetHelper*    pStateSet = new ::utl::AccessibleStateSetHelper;

    if( mxParent.is() )
    {
        AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( mxParent );
        ::sd::SlideView* pSlideView = pAccView->GetSlideView();
        SdDrawDocument*      pDrawDoc = pAccView->GetDrawDocument();

	    // SELECTABLE
	    pStateSet->AddState( accessibility::AccessibleStateType::SELECTABLE );

	    // SELECTED
        if( pDrawDoc )
        {
    	    SdPage* pPage = pDrawDoc->GetSdPage( mnPage, PK_STANDARD );

            if( pPage && pPage->IsSelected() )
        	    pStateSet->AddState( accessibility::AccessibleStateType::SELECTED );
        }

	    // FOCUSABLE
	    pStateSet->AddState( accessibility::AccessibleStateType::FOCUSABLE );

	    // FOCUSED      
        if( pSlideView )
        {
            const USHORT nFocusPage = pSlideView->GetFocusPage();

            if( ( SDRPAGE_NOTFOUND != nFocusPage ) && ( nFocusPage == mnPage ) )
        	    pStateSet->AddState( accessibility::AccessibleStateType::FOCUSED );
        }
    }

    return pStateSet;
}

// -----------------------------------------------------------------------------

lang::Locale SAL_CALL AccessibleSlideViewObject::getLocale() 
    throw (accessibility::IllegalAccessibleComponentStateException, uno::RuntimeException)
{
    // Delegate request to parent.
	if (mxParent.is())
    {
    	uno::Reference<accessibility::XAccessibleContext> xParentContext (
        	mxParent->getAccessibleContext());
        if (xParentContext.is())
	    	return xParentContext->getLocale ();
    }

    //	No locale and no parent.  Therefore throw exception to indicate this
    //	cluelessness.
    throw accessibility::IllegalAccessibleComponentStateException ();
}

// -----------------------------------------------------------------------------

void SAL_CALL AccessibleSlideViewObject::addEventListener( const uno::Reference< accessibility::XAccessibleEventListener >& rxListener ) 
    throw (uno::RuntimeException)
{
	if (rxListener.is())
    {
        const osl::MutexGuard aGuard( maMutex );
		if (!mnClientId)
            mnClientId = comphelper::AccessibleEventNotifier::registerClient( );
		comphelper::AccessibleEventNotifier::addEventListener( mnClientId, rxListener );
    }
}

// -----------------------------------------------------------------------------

void SAL_CALL AccessibleSlideViewObject::removeEventListener( const uno::Reference< accessibility::XAccessibleEventListener >& rxListener ) 
    throw (uno::RuntimeException)
{
	if (rxListener.is())
	{
        const osl::MutexGuard aGuard( maMutex );

        sal_Int32 nListenerCount = comphelper::AccessibleEventNotifier::removeEventListener( mnClientId, rxListener );
		if ( !nListenerCount )
		{
			// no listeners anymore
			// -> revoke ourself. This may lead to the notifier thread dying (if we were the last client),
			// and at least to us not firing any events anymore, in case somebody calls
			// NotifyAccessibleEvent, again
			comphelper::AccessibleEventNotifier::revokeClient( mnClientId );
			mnClientId = 0;
		}
	}
}

// -----------------------------------------------------------------------------

sal_Bool SAL_CALL AccessibleSlideViewObject::containsPoint( const awt::Point& aPoint ) 
    throw (uno::RuntimeException)
{
    const awt::Rectangle    aRect( getBounds() );
    const Point             aSize( aRect.Width, aRect.Height );
    const Point             aNullPoint, aTestPoint( aPoint.X, aPoint.Y );
        
    return Rectangle( aNullPoint, aSize ).IsInside( aTestPoint );
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessible > SAL_CALL AccessibleSlideViewObject::getAccessibleAtPoint( const awt::Point& aPoint ) 
    throw (uno::RuntimeException)
{
    return NULL;
}

// -----------------------------------------------------------------------------

awt::Rectangle SAL_CALL AccessibleSlideViewObject::getBounds() 
    throw (uno::RuntimeException)
{
    const vos::OGuard   aSolarGuard( Application::GetSolarMutex() );
    awt::Rectangle      aRet;

    if( mxParent.is() )
    {
        AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( mxParent );
        ::sd::Window* pParentWindow = pAccView->GetParentWindow();

        if( pParentWindow )
        {
            Rectangle   aItemRect( pParentWindow->LogicToPixel( pAccView->GetSlideView()->GetPageArea( mnPage ) ) );
            Point       aOrigin;
            Rectangle   aParentRect( aOrigin, pParentWindow->GetOutputSizePixel() );

            aItemRect.Intersection( aParentRect );

            aRet.X = aItemRect.Left();
            aRet.Y = aItemRect.Top();
            aRet.Width = aItemRect.GetWidth();
            aRet.Height = aItemRect.GetHeight();
        }
    }

    return aRet;
}

// -----------------------------------------------------------------------------

awt::Point SAL_CALL AccessibleSlideViewObject::getLocation() 
    throw (uno::RuntimeException)
{
    const awt::Rectangle    aRect( getBounds() );
    awt::Point              aRet;

    aRet.X = aRect.X;
    aRet.Y = aRect.Y;

    return aRet;
}

// -----------------------------------------------------------------------------

awt::Point SAL_CALL AccessibleSlideViewObject::getLocationOnScreen() 
    throw (uno::RuntimeException)
{
    const vos::OGuard   aSolarGuard( Application::GetSolarMutex() );
    awt::Point          aRet;

    if( mxParent.is() )
    {
        AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( mxParent );
        ::sd::Window* pParentWindow = pAccView->GetParentWindow();

        if( pParentWindow )
        {
            const awt::Point    aPos( getLocation() );
            Point               aVCLPos( aPos.X, aPos.Y );

            aVCLPos = pParentWindow->OutputToAbsoluteScreenPixel( aVCLPos );
            aRet.X = aVCLPos.X();
            aRet.Y = aVCLPos.Y();
        }
    }

    return aRet;
}

// -----------------------------------------------------------------------------

awt::Size SAL_CALL AccessibleSlideViewObject::getSize() 
    throw (uno::RuntimeException)
{
    const awt::Rectangle    aRect( getBounds() );
    awt::Size               aRet;

    aRet.Width = aRect.Width;
    aRet.Height = aRect.Height;

    return aRet;
}

// -----------------------------------------------------------------------------

void SAL_CALL AccessibleSlideViewObject::grabFocus() 
    throw (uno::RuntimeException)
{
    // nothing to do
}

// -----------------------------------------------------------------------------


sal_Int32 SAL_CALL AccessibleSlideViewObject::getForeground (void)
    throw (::com::sun::star::uno::RuntimeException)
{
	svtools::ColorConfig aColorConfig;
    UINT32 nColor = aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor;
    return static_cast<sal_Int32>(nColor);
}




sal_Int32 SAL_CALL AccessibleSlideViewObject::getBackground (void) 
    throw (::com::sun::star::uno::RuntimeException)
{
    UINT32 nColor = Application::GetSettings().GetStyleSettings().GetWindowColor().GetColor();
    return static_cast<sal_Int32>(nColor);
}







//=====  XServiceInfo  ========================================================

::rtl::OUString SAL_CALL
   	AccessibleSlideViewObject::getImplementationName (void)
    throw (::com::sun::star::uno::RuntimeException)
{
	return OUString(RTL_CONSTASCII_USTRINGPARAM("AccessibleSlideViewObject"));
}




sal_Bool SAL_CALL
 	AccessibleSlideViewObject::supportsService (const OUString& sServiceName)
    throw (::com::sun::star::uno::RuntimeException)
{
    //  Iterate over all supported service names and return true if on of them
    //  matches the given name.
    uno::Sequence< ::rtl::OUString> aSupportedServices (
        getSupportedServiceNames ());
    for (int i=0; i<aSupportedServices.getLength(); i++)
        if (sServiceName == aSupportedServices[i])
            return sal_True;
    return sal_False;
}




uno::Sequence< ::rtl::OUString> SAL_CALL
   	AccessibleSlideViewObject::getSupportedServiceNames (void)
    throw (::com::sun::star::uno::RuntimeException)
{
	static const OUString sServiceNames[3] = {
        OUString(RTL_CONSTASCII_USTRINGPARAM(
            "com.sun.star.accessibility.Accessible")),
        OUString(RTL_CONSTASCII_USTRINGPARAM(
            "com.sun.star.accessibility.AccessibleContext")),
        OUString(RTL_CONSTASCII_USTRINGPARAM(
            "com.sun.star.drawing.AccessibleSlideViewObject"))
    };
	return uno::Sequence<OUString> (sServiceNames, 3);
}




// -----------------------
// - AccessibleSlideView -
// -----------------------

AccessibleSlideView::AccessibleSlideView(
    SdDrawDocument& rDoc, 
    ::sd::SlideView& rView, 
    ::sd::Window& rParentWindow ) :
		mpDoc( &rDoc ),
        mpView( &rView ),
        mpParentWindow( &rParentWindow ),
        mnClientId( 0 )
{
    Reset();
}

// -----------------------------------------------------------------------------

AccessibleSlideView::~AccessibleSlideView()
{
    if (mpView != NULL)
        Destroyed ();
}

// -----------------------------------------------------------------------

void AccessibleSlideView::FireAccessibleEvent( short nEventId, const uno::Any& rOldValue, const uno::Any& rNewValue )
{
    if( mpDoc && nEventId && mnClientId)
    {
        accessibility::AccessibleEventObject aEvtObject;

        aEvtObject.EventId = nEventId;
        aEvtObject.NewValue = rNewValue;
	    aEvtObject.OldValue = rOldValue;

		comphelper::AccessibleEventNotifier::addEvent( mnClientId, aEvtObject );
    }
}

// -----------------------------------------------------------------------------

void AccessibleSlideView::Destroyed (void)
{
    const vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    mpDoc = NULL;
    mpView = NULL;
    mpParentWindow = NULL;

    // Send a disposing to all listeners.
	if ( mnClientId )
	{
        comphelper::AccessibleEventNotifier::revokeClientNotifyDisposing( mnClientId, *this );
		mnClientId =  0;
	}
}

// -----------------------------------------------------------------------------

sal_Int32 AccessibleSlideView::ImplGetVisibleChildCount() const
{
    const vos::OGuard   aSolarGuard( Application::GetSolarMutex() );
    sal_Int32           nVisibleCount = 0;

    if( mpDoc )
    {
        for( sal_Int32 i = 0; i < (sal_Int32) maSlidePageObjects.size(); ++i )
            if( AccessibleSlideViewObject::getImplementation( maSlidePageObjects[ i ] )->IsVisible() )
                ++nVisibleCount;
    }

    return( nVisibleCount );
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessible > AccessibleSlideView::ImplGetVisibleChild( sal_Int32 nVisibleChild ) const
{
    const vos::OGuard                               aSolarGuard( Application::GetSolarMutex() );
    uno::Reference< accessibility::XAccessible >    xRet;
    sal_Int32                                       nVisibleCount = 0;

    if( mpDoc )
    {
        for( sal_uInt32 i = 0; ( i < maSlidePageObjects.size() ) && !xRet.is(); ++i )
        {
            if( AccessibleSlideViewObject::getImplementation( maSlidePageObjects[ i ] )->IsVisible() && 
                ( nVisibleCount++ == nVisibleChild ) )
            {
                xRet = maSlidePageObjects[ i ];
            }
        }
    }

    return( xRet );
}

// -----------------------------------------------------------------------------

void AccessibleSlideView::SetPageVisible( sal_uInt16 nPage, sal_Bool bVisible )
{
    if( mpDoc )
    {
        DBG_ASSERT( nPage < maSlidePageObjects.size(), "nPage out of range" );

        if( nPage < maSlidePageObjects.size() )
        {
            AccessibleSlideViewObject*  pSlideViewObject = AccessibleSlideViewObject::getImplementation( maSlidePageObjects[ nPage ] );
            uno::Any                    aOldAny, aNewAny;
            const sal_Bool              bWasVisible = pSlideViewObject->IsVisible();

            pSlideViewObject->SetVisible( bVisible );

            if( bVisible && !bWasVisible )
            {                    
                aNewAny <<= maSlidePageObjects[ nPage ];
                FireAccessibleEvent( accessibility::AccessibleEventId::CHILD, aOldAny, aNewAny );
            }
            else if( !bVisible && bWasVisible )
            {
                aOldAny <<= maSlidePageObjects[ nPage ];
                FireAccessibleEvent( accessibility::AccessibleEventId::CHILD, aOldAny, aNewAny );
            }
        }
    }
}

// -----------------------------------------------------------------------------

void AccessibleSlideView::Reset()
{
    if( mpDoc && mpView && mpParentWindow )
    {
        sal_uInt16 nPageCount = mpDoc->GetSdPageCount( PK_STANDARD );

        for( sal_uInt32 n = 0; n < maSlidePageObjects.size(); ++n )
        {
            AccessibleSlideViewObject* pSlidePageObject = AccessibleSlideViewObject::getImplementation( maSlidePageObjects[ n ] );

            pSlidePageObject->Destroyed();

            if( pSlidePageObject->IsVisible() )
            {
                uno::Any aOldAny, aNewAny;
            
                aOldAny <<= maSlidePageObjects[ n ];
                FireAccessibleEvent( accessibility::AccessibleEventId::CHILD, aOldAny, aNewAny );
            }
        }

        maSlidePageObjects.clear();

        for( sal_uInt16 i = 0; i < nPageCount; ++i )
        {
	        const Rectangle                                     aOutputRect( mpParentWindow->PixelToLogic( Point() ), mpParentWindow->GetOutputSize() );
            const Rectangle                                     aPageArea( mpView->GetPageArea( i ) );
            const uno::Reference< accessibility::XAccessible >  xRef( new AccessibleSlideViewObject( this, i, aOutputRect.IsOver( aPageArea ) ) );
            
            maSlidePageObjects.push_back( xRef );
        }
    }
}

// -----------------------------------------------------------------------

void AccessibleSlideView::FocusHasChanged( USHORT nOldFocusPage, USHORT nNewFocusPage )
{
    if( mpDoc && mpView && mpParentWindow )
    {
        if( SDRPAGE_NOTFOUND != nOldFocusPage )
        {
            AccessibleSlideViewObject* pSlidePageObject = AccessibleSlideViewObject::getImplementation( maSlidePageObjects[ nOldFocusPage ] );

            if( pSlidePageObject )
            {
                uno::Any aOldAny, aNewAny;
                aOldAny <<= accessibility::AccessibleStateType::FOCUSED;
                pSlidePageObject->FireAccessibleEvent( accessibility::AccessibleEventId::STATE_CHANGED, aOldAny, aNewAny );
            }
        }

        if( SDRPAGE_NOTFOUND != nNewFocusPage )
        {
            AccessibleSlideViewObject* pSlidePageObject = AccessibleSlideViewObject::getImplementation( maSlidePageObjects[ nNewFocusPage ] );

            if( pSlidePageObject )
            {
                uno::Any aOldAny, aNewAny;
                aNewAny <<= accessibility::AccessibleStateType::FOCUSED;
                pSlidePageObject->FireAccessibleEvent( accessibility::AccessibleEventId::STATE_CHANGED, aOldAny, aNewAny );
            }
        }
    }
}

// -----------------------------------------------------------------------------

const uno::Sequence< sal_Int8 >& AccessibleSlideView::getUnoTunnelId()
{
    static uno::Sequence< sal_Int8 > aSeq;

	if( !aSeq.getLength() )
	{
		static osl::Mutex   aCreateMutex;
    	osl::MutexGuard     aGuard( aCreateMutex );

		aSeq.realloc( 16 );
    	rtl_createUuid( reinterpret_cast< sal_uInt8* >( aSeq.getArray() ), 0, sal_True );
	}
	
    return aSeq;
}

// -----------------------------------------------------------------------------

AccessibleSlideView* AccessibleSlideView::getImplementation( const uno::Reference< uno::XInterface >& rxData ) 
    throw()
{
    try
    {
	    uno::Reference< lang::XUnoTunnel > xUnoTunnel( rxData, uno::UNO_QUERY );
        return( xUnoTunnel.is() ? ( (AccessibleSlideView*)(void*) xUnoTunnel->getSomething( AccessibleSlideView::getUnoTunnelId() ) ) : NULL );
    }
    catch( const ::com::sun::star::uno::Exception& )
	{
        return NULL;
	}
}

// -----------------------------------------------------------------------------

sal_Int64 SAL_CALL AccessibleSlideView::getSomething( const uno::Sequence< sal_Int8 >& rId ) throw( uno::RuntimeException )
{
    sal_Int64 nRet;

    if( ( rId.getLength() == 16 ) && ( 0 == rtl_compareMemory( AccessibleSlideView::getUnoTunnelId().getConstArray(), rId.getConstArray(), 16 ) ) )
        nRet = reinterpret_cast< sal_Int64 >( this );
    else
        nRet = 0;

	return nRet;
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessibleContext > SAL_CALL AccessibleSlideView::getAccessibleContext()
    throw (uno::RuntimeException)
{
    return this;
}

// -----------------------------------------------------------------------------

sal_Int32 SAL_CALL AccessibleSlideView::getAccessibleChildCount() 
    throw (uno::RuntimeException)
{
    const vos::OGuard   aSolarGuard( Application::GetSolarMutex() );
    sal_Int32           nVisibleCount = 0;

    if( mpDoc )
    {
        for( sal_uInt32 i = 0; i < maSlidePageObjects.size(); ++i )
            if( AccessibleSlideViewObject::getImplementation( maSlidePageObjects[ i ] )->IsVisible() )
                ++nVisibleCount;
    }

    return( nVisibleCount );
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessible > SAL_CALL AccessibleSlideView::getAccessibleChild( sal_Int32 i ) 
    throw (lang::IndexOutOfBoundsException, uno::RuntimeException)
{
    const vos::OGuard                               aSolarGuard( Application::GetSolarMutex() );
    uno::Reference< accessibility::XAccessible >    xRet;

    if( mpDoc )
    {
        if( i < static_cast< sal_Int32 >( maSlidePageObjects.size() ) )
            xRet = ImplGetVisibleChild( i );

        if( !xRet.is() )
            throw lang::IndexOutOfBoundsException();
    }

    return( xRet );
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessible > SAL_CALL AccessibleSlideView::getAccessibleParent() 
    throw (uno::RuntimeException)
{
    const vos::OGuard                               aSolarGuard( Application::GetSolarMutex() );
    uno::Reference< accessibility::XAccessible >    xRet;

    if( mpDoc && mpView && mpParentWindow )
    {
        Window* pParent = mpParentWindow->GetAccessibleParentWindow();

        if( pParent )
            xRet = pParent->GetAccessible();
    }

    return xRet;
}

// -----------------------------------------------------------------------------

sal_Int32 SAL_CALL AccessibleSlideView::getAccessibleIndexInParent() 
    throw (uno::RuntimeException)
{
    const vos::OGuard   aSolarGuard( Application::GetSolarMutex() );
    sal_Int32           nRet = -1;

    uno::Reference<accessibility::XAccessible> xParentAcc (getAccessibleParent());
    if (xParentAcc.is())
    {
        uno::Reference<accessibility::XAccessibleContext> xParentContext (
            xParentAcc->getAccessibleContext(), uno::UNO_QUERY);

        if (xParentContext.is())
        {
            sal_Int32 nChildCount = xParentContext->getAccessibleChildCount();
            for (sal_Int32 nChild = 0; ( nChild < nChildCount) && ( -1 == nRet ); ++nChild)
                if (xParentContext->getAccessibleChild( nChild ).get() 
                    == static_cast< accessibility::XAccessible* >( this ))
                    nRet = nChild;
        }
    }
   
    return nRet;
}

// -----------------------------------------------------------------------------

sal_Int16 SAL_CALL AccessibleSlideView::getAccessibleRole() 
    throw (uno::RuntimeException)
{
    return accessibility::AccessibleRole::DOCUMENT;
}

// -----------------------------------------------------------------------------

::rtl::OUString SAL_CALL AccessibleSlideView::getAccessibleDescription() 
    throw (uno::RuntimeException)
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );

    return ::rtl::OUString( SdResId(SID_SD_A11Y_I_SLIDEVIEW_D) );
}

// -----------------------------------------------------------------------------

::rtl::OUString SAL_CALL AccessibleSlideView::getAccessibleName() 
    throw (uno::RuntimeException)
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );

    return ::rtl::OUString( SdResId(SID_SD_A11Y_I_SLIDEVIEW_N) );
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessibleRelationSet > SAL_CALL AccessibleSlideView::getAccessibleRelationSet() 
    throw (uno::RuntimeException)
{
    return uno::Reference< accessibility::XAccessibleRelationSet >();
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessibleStateSet > SAL_CALL AccessibleSlideView::getAccessibleStateSet() 
    throw (uno::RuntimeException)
{
    return( new ::utl::AccessibleStateSetHelper );
}

// -----------------------------------------------------------------------------

lang::Locale SAL_CALL AccessibleSlideView::getLocale() 
    throw (accessibility::IllegalAccessibleComponentStateException, uno::RuntimeException)
{
    uno::Reference<accessibility::XAccessibleContext> xParentContext;
    uno::Reference<accessibility::XAccessible> xParent (getAccessibleParent());
    if (xParent.is())
        xParentContext = uno::Reference<accessibility::XAccessibleContext> (
            xParent->getAccessibleContext(), uno::UNO_QUERY);

    if (xParentContext.is())
        return xParentContext->getLocale();
    else
        // Strange, no parent!  Anyway, return the default locale.
        return Application::GetSettings().GetLocale();
}

// -----------------------------------------------------------------------------

void SAL_CALL AccessibleSlideView::addEventListener( const uno::Reference< accessibility::XAccessibleEventListener >& rxListener ) 
    throw (uno::RuntimeException)
{
	if (rxListener.is())
    {
        const osl::MutexGuard aGuard( maMutex );

        if (!mnClientId)
            mnClientId = comphelper::AccessibleEventNotifier::registerClient( );
		comphelper::AccessibleEventNotifier::addEventListener( mnClientId, rxListener );
    }
}

// -----------------------------------------------------------------------------

void SAL_CALL AccessibleSlideView::removeEventListener( const uno::Reference< accessibility::XAccessibleEventListener >& rxListener ) 
    throw (uno::RuntimeException)
{
	if (rxListener.is())
	{
        const osl::MutexGuard aGuard( maMutex );

        sal_Int32 nListenerCount = comphelper::AccessibleEventNotifier::removeEventListener( mnClientId, rxListener );
		if ( !nListenerCount )
		{
			// no listeners anymore
			// -> revoke ourself. This may lead to the notifier thread dying (if we were the last client),
			// and at least to us not firing any events anymore, in case somebody calls
			// NotifyAccessibleEvent, again
			comphelper::AccessibleEventNotifier::revokeClient( mnClientId );
			mnClientId = 0;
		}
	}
}

// -----------------------------------------------------------------------------

sal_Bool SAL_CALL AccessibleSlideView::containsPoint( const awt::Point& aPoint ) 
    throw (uno::RuntimeException)
{
    const awt::Rectangle aBBox (getBounds());
    return (aPoint.X >= 0)
        && (aPoint.X < aBBox.Width)
        && (aPoint.Y >= 0)
        && (aPoint.Y < aBBox.Height);
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessible > SAL_CALL AccessibleSlideView::getAccessibleAtPoint( const awt::Point& aPoint ) 
    throw (uno::RuntimeException)
{
    const vos::OGuard aSolarGuard( Application::GetSolarMutex() );

    uno::Reference< accessibility::XAccessible > xRet;

    if( mpDoc && mpView && mpParentWindow )
    {
        const Point aTestPoint( aPoint.X, aPoint.Y );  
        SdPage*     pHitPage = mpView->GetHitPage( mpParentWindow->PixelToLogic( aTestPoint ) );

        if( pHitPage )
        {
            const USHORT nSdPageNum = ( pHitPage->GetPageNum() - 1 ) / 2;

            if( nSdPageNum < maSlidePageObjects.size() )
                xRet = maSlidePageObjects[ nSdPageNum ];
        }
    }
    
    return xRet;
}

// -----------------------------------------------------------------------------

awt::Rectangle SAL_CALL AccessibleSlideView::getBounds() 
    throw (uno::RuntimeException)
{
    const vos::OGuard   aSolarGuard( Application::GetSolarMutex() );
    awt::Rectangle      aRet;

    if( mpDoc && mpView && mpParentWindow )
    {
        const Point     aOutPos( mpParentWindow->GetPosPixel() );
        const Size      aOutSize( mpParentWindow->GetOutputSizePixel() );
        
        aRet.X = aOutPos.X();
        aRet.Y = aOutPos.Y();
        aRet.Width = aOutSize.Width();
        aRet.Height = aOutSize.Height();
    }
        
    return aRet;
}

// -----------------------------------------------------------------------------

awt::Point SAL_CALL AccessibleSlideView::getLocation() 
    throw (uno::RuntimeException)
{
    const awt::Rectangle    aRect( getBounds() );
    awt::Point              aRet;

    aRet.X = aRect.X;
    aRet.Y = aRect.Y;

    return aRet;
}

// -----------------------------------------------------------------------------

/** Calculate the location on screen from the parent's location on screen
    and our own relative location.
*/
awt::Point SAL_CALL AccessibleSlideView::getLocationOnScreen() 
    throw (uno::RuntimeException)
{
    const vos::OGuard   aSolarGuard( Application::GetSolarMutex() );
    awt::Point aParentLocationOnScreen;

    uno::Reference<accessibility::XAccessible> xParent (getAccessibleParent());
    if (xParent.is())
    {
        uno::Reference<accessibility::XAccessibleComponent> xParentComponent (
            xParent->getAccessibleContext(), uno::UNO_QUERY);
        if (xParentComponent.is())
            aParentLocationOnScreen = xParentComponent->getLocationOnScreen();
    }
    
    awt::Point aLocationOnScreen (getLocation());
    aLocationOnScreen.X += aParentLocationOnScreen.X;
    aLocationOnScreen.Y += aParentLocationOnScreen.Y;

    return aLocationOnScreen;
}

// -----------------------------------------------------------------------------

awt::Size SAL_CALL AccessibleSlideView::getSize() 
    throw (uno::RuntimeException)
{
    const awt::Rectangle    aRect( getBounds() );
    awt::Size               aRet;

    aRet.Width = aRect.Width;
    aRet.Height = aRect.Height;

    return aRet;
}

// -----------------------------------------------------------------------------

void SAL_CALL AccessibleSlideView::grabFocus() 
    throw (uno::RuntimeException)
{
    const vos::OGuard aSolarGuard( Application::GetSolarMutex() );

    if( mpDoc && mpView && mpParentWindow )
        mpParentWindow->GrabFocus();
}

// -----------------------------------------------------------------------------


sal_Int32 SAL_CALL AccessibleSlideView::getForeground (void)
    throw (::com::sun::star::uno::RuntimeException)
{
	svtools::ColorConfig aColorConfig;
    UINT32 nColor = aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor;
    return static_cast<sal_Int32>(nColor);
}




sal_Int32 SAL_CALL AccessibleSlideView::getBackground (void) 
    throw (::com::sun::star::uno::RuntimeException)
{
    UINT32 nColor = Application::GetSettings().GetStyleSettings().GetWindowColor().GetColor();
    return static_cast<sal_Int32>(nColor);
}




// -----------------------------------------------------------------------------

void SAL_CALL AccessibleSlideView::selectAccessibleChild( sal_Int32 nChildIndex ) 
    throw (lang::IndexOutOfBoundsException, uno::RuntimeException)
{
    const vos::OGuard                               aSolarGuard( Application::GetSolarMutex() );
    uno::Reference< accessibility::XAccessible >    aChild( ImplGetVisibleChild( nChildIndex ) );

    if( mpDoc && mpView && mpParentWindow )
    {
        if( aChild.is() )
        {
            if( mpView )
                mpView->Select( AccessibleSlideViewObject::getImplementation( aChild )->GetPageNum(), sal_True );
        }
        else
            throw lang::IndexOutOfBoundsException();
    }
}

// -----------------------------------------------------------------------------

sal_Bool SAL_CALL AccessibleSlideView::isAccessibleChildSelected( sal_Int32 nChildIndex ) 
    throw (lang::IndexOutOfBoundsException, uno::RuntimeException)
{
    const vos::OGuard                               aSolarGuard( Application::GetSolarMutex() );
    uno::Reference< accessibility::XAccessible >    aChild( ImplGetVisibleChild( nChildIndex ) );
    sal_Bool                                        bRet = sal_False;

    if( mpDoc )
    {
        if( aChild.is() )
        {
            if( mpDoc )
            {
                SdPage* pPage = mpDoc->GetSdPage( AccessibleSlideViewObject::getImplementation( aChild )->GetPageNum(), PK_STANDARD );

                if( pPage && pPage->IsSelected() )
                    bRet = sal_True;
            }
        }
        else
            throw lang::IndexOutOfBoundsException();
    }

    return bRet;
}

// -----------------------------------------------------------------------------

void SAL_CALL AccessibleSlideView::clearAccessibleSelection() 
    throw (uno::RuntimeException)
{
    const vos::OGuard aSolarGuard( Application::GetSolarMutex() );

    if( mpDoc && mpView )
        mpView->SelectAll( sal_False );
}

// -----------------------------------------------------------------------------

void SAL_CALL AccessibleSlideView::selectAllAccessibleChildren() 
    throw (uno::RuntimeException)
{
    const vos::OGuard aSolarGuard( Application::GetSolarMutex() );

    if( mpDoc && mpView )
        mpView->SelectAll( sal_True );
}

// -----------------------------------------------------------------------------

sal_Int32 SAL_CALL AccessibleSlideView::getSelectedAccessibleChildCount() 
    throw (uno::RuntimeException)
{
    const vos::OGuard       aSolarGuard( Application::GetSolarMutex() );
    sal_Int32               nRet = 0;

    if( mpDoc )
    {
        for( sal_Int32 i = 0, nChildCount = ImplGetVisibleChildCount(); i < nChildCount; ++i )
        {
            uno::Reference< accessibility::XAccessible > aChild( ImplGetVisibleChild( i ) );

            if( aChild.is() )
            {
                SdPage* pPage = mpDoc->GetSdPage( AccessibleSlideViewObject::getImplementation( aChild )->GetPageNum(), PK_STANDARD );

                if( pPage && pPage->IsSelected() )
                    ++nRet;
            }
        }
    }

    return nRet;
}

// -----------------------------------------------------------------------------

uno::Reference< accessibility::XAccessible > SAL_CALL AccessibleSlideView::getSelectedAccessibleChild( sal_Int32 nSelectedChildIndex ) 
    throw (lang::IndexOutOfBoundsException, uno::RuntimeException)
{
    const vos::OGuard                               aSolarGuard( Application::GetSolarMutex() );
    uno::Reference< accessibility::XAccessible >    xRet;

    if( mpDoc )
    {
        for( sal_Int32 i = 0, nFound = 0, nChildCount = ImplGetVisibleChildCount() ; ( i < nChildCount ) && !xRet.is(); ++i )
        {
            uno::Reference< accessibility::XAccessible > aChild( ImplGetVisibleChild( i ) );

            if( aChild.is() )
            {
                SdPage* pPage = mpDoc->GetSdPage( AccessibleSlideViewObject::getImplementation( aChild )->GetPageNum(), PK_STANDARD );

                if( pPage && pPage->IsSelected() && ( nSelectedChildIndex == nFound++ ) )
                    xRet = aChild;
            }
        }

        if( !xRet.is() )
            throw lang::IndexOutOfBoundsException();
    }

    return( xRet );
}

// -----------------------------------------------------------------------------

void SAL_CALL AccessibleSlideView::deselectAccessibleChild( sal_Int32 nSelectedChildIndex ) 
    throw (lang::IndexOutOfBoundsException, uno::RuntimeException)
{
    const vos::OGuard                               aSolarGuard( Application::GetSolarMutex() );

    if( mpDoc )
    {
        uno::Reference< accessibility::XAccessible > aChild( 
            ImplGetVisibleChild(nSelectedChildIndex) );

        if( aChild.is() )
        {
            SdPage* pPage = mpDoc->GetSdPage( 
                AccessibleSlideViewObject::getImplementation( aChild )->GetPageNum(), 
                PK_STANDARD );

            if( pPage && pPage->IsSelected())
            {
                if( mpView )
                    mpView->Select( 
                        AccessibleSlideViewObject::getImplementation( aChild )->GetPageNum(), sal_False );
            }
        }
        else
            throw lang::IndexOutOfBoundsException();
    }
}




//=====  XServiceInfo  ========================================================

::rtl::OUString SAL_CALL
   	AccessibleSlideView::getImplementationName (void)
    throw (::com::sun::star::uno::RuntimeException)
{
	return OUString(RTL_CONSTASCII_USTRINGPARAM("AccessibleSlideView"));
}




sal_Bool SAL_CALL
 	AccessibleSlideView::supportsService (const OUString& sServiceName)
    throw (::com::sun::star::uno::RuntimeException)
{
    //  Iterate over all supported service names and return true if on of them
    //  matches the given name.
    uno::Sequence< ::rtl::OUString> aSupportedServices (
        getSupportedServiceNames ());
    for (int i=0; i<aSupportedServices.getLength(); i++)
        if (sServiceName == aSupportedServices[i])
            return sal_True;
    return sal_False;
}




uno::Sequence< ::rtl::OUString> SAL_CALL
   	AccessibleSlideView::getSupportedServiceNames (void)
    throw (::com::sun::star::uno::RuntimeException)
{
	static const OUString sServiceNames[3] = {
        OUString(RTL_CONSTASCII_USTRINGPARAM(
            "com.sun.star.accessibility.Accessible")),
        OUString(RTL_CONSTASCII_USTRINGPARAM(
            "com.sun.star.accessibility.AccessibleContext")),
        OUString(RTL_CONSTASCII_USTRINGPARAM(
            "com.sun.star.drawing.AccessibleSlideView"))
    };
	return uno::Sequence<OUString> (sServiceNames, 3);
}
