/*************************************************************************
 *
 *  $RCSfile: memchrt.cxx,v $
 *
 *  $Revision: 1.28 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/21 13:22:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _STREAM_HXX
// enable stream operators >>/<< for UniString (8 Bit !)
#ifndef ENABLE_STRING_STREAM_OPERATORS
#define ENABLE_STRING_STREAM_OPERATORS
#endif
#include <tools/stream.hxx>
#endif

#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif
#ifndef _UNOTOOLS_CHARCLASS_HXX
#include <unotools/charclass.hxx>
#endif

#ifndef _TOOLS_TENCCVT_HXX
#include <tools/tenccvt.hxx>
#endif

#include <float.h>
#include <math.h>
#include "schiocmp.hxx"
#include "memchrt.hxx"

#include "schresid.hxx"
#include "glob.hrc"

#include <functional>
#include <algorithm>

// ========================================
// Helper objects
// ========================================

/** unary function that escapes backslashes and single quotes in a sal_Unicode
    array (which you can get from an OUString with getStr()) and puts the result
    into the OUStringBuffer given in the CTOR
 */
class lcl_Escape : public ::std::unary_function< sal_Unicode, void >
{
public:
    lcl_Escape( ::rtl::OUStringBuffer & aResultBuffer ) : m_aResultBuffer( aResultBuffer ) {}
    void operator() ( sal_Unicode aChar )
    {
        static const sal_Unicode m_aQuote( '\'' );
        static const sal_Unicode m_aBackslash( '\\' );

        if( aChar == m_aQuote ||
            aChar == m_aBackslash )
            m_aResultBuffer.append( m_aBackslash );
        m_aResultBuffer.append( aChar );
    }

private:
    ::rtl::OUStringBuffer & m_aResultBuffer;
};

/** unary function that removes backslash escapes in a sal_Unicode array (which
    you can get from an OUString with getStr()) and puts the result into the
    OUStringBuffer given in the CTOR
 */
class lcl_UnEscape : public ::std::unary_function< sal_Unicode, void >
{
public:
    lcl_UnEscape( ::rtl::OUStringBuffer & aResultBuffer ) : m_aResultBuffer( aResultBuffer ) {}
    void operator() ( sal_Unicode aChar )
    {
        static const sal_Unicode m_aBackslash( '\\' );

        if( aChar != m_aBackslash )
            m_aResultBuffer.append( aChar );
    }

private:
    ::rtl::OUStringBuffer & m_aResultBuffer;
};



#define MIN(a,b) ( ((a)<(b))? (a) : (b) )
/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchMemChart::SchMemChart() :
	nTranslated(TRANS_NONE),
	nRefCount (0),
	mpColNameBuffer(NULL),
	mpRowNameBuffer(NULL),
	nRowCnt (0),
	nColCnt (0),
	eDataType(NUMBERFORMAT_NUMBER),
	pData (0),
	pColText (0),
	pRowText (0),
	myID (CHDATAID_MEMCHART_PLUS),
	mpNumFormatter(NULL),
	pRowNumFmtId(NULL),
	pColNumFmtId(NULL),
	pRowTable(NULL),
	pColTable(NULL),
	bReadOnly(FALSE),
	nLastSelInfoReturn(0)
{
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchMemChart::SchMemChart(ChartDataId nMyID) :
	nTranslated(TRANS_NONE),
	nRefCount (0),
	mpColNameBuffer(NULL),
	mpRowNameBuffer(NULL),
	nRowCnt (0),
	nColCnt (0),
	eDataType(NUMBERFORMAT_NUMBER),
	pData (0),
	pColText (0),
	pRowText (0),
	myID (nMyID),
	mpNumFormatter(NULL),
	pRowNumFmtId(NULL),
	pColNumFmtId(NULL),
	pRowTable(NULL),
	pColTable(NULL),
	bReadOnly(FALSE),
	nLastSelInfoReturn(0)
{
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchMemChart::SchMemChart(short nCols, short nRows) :
	nTranslated(TRANS_NONE),
	nRefCount (0),
	mpColNameBuffer(NULL),
	mpRowNameBuffer(NULL),
	eDataType(NUMBERFORMAT_NUMBER),
	pData (0),
	pColText (0),
	pRowText (0),
	myID (CHDATAID_MEMCHART_PLUS),
	mpNumFormatter(NULL),
	pRowNumFmtId(NULL),
	pColNumFmtId(NULL),
	pRowTable(NULL),
	pColTable(NULL),
	bReadOnly(FALSE),
	nLastSelInfoReturn(0)
{
	nRowCnt = nRows;
	nColCnt = nCols;
	pData   = new double[nColCnt * nRowCnt];

	pRowNumFmtId= new long [nRowCnt];
	pColNumFmtId= new long [nColCnt];
	InitNumFmt();

	pRowTable	= new long [nRowCnt];
	pColTable	= new long [nColCnt];
	ResetTranslation(pRowTable,nRowCnt);
	ResetTranslation(pColTable,nColCnt);

	if (pData)
	{
		double *pFill = pData;

		for (short i = 0; i < nColCnt; i++)
			for (short j = 0; j < nRowCnt; j++)
				*(pFill ++) = 0.0;
	}

	pColText = new String[nColCnt];
	pRowText = new String[nRowCnt];
}
/*************************************************************************
|*
|* Kopiere alles ausser den numerischen Daten (d.h. Texte!)
|*
\************************************************************************/
void SchMemChart::SetNonNumericData(const SchMemChart &rMemChart)
{
	aMainTitle  = rMemChart.aMainTitle;
	aSubTitle   = rMemChart.aSubTitle;
	aXAxisTitle = rMemChart.aXAxisTitle;
	aYAxisTitle = rMemChart.aYAxisTitle;
	aZAxisTitle = rMemChart.aZAxisTitle;
	eDataType   = rMemChart.eDataType;
	aSomeData1  = ((SchMemChart&) rMemChart).SomeData1 ();
	aSomeData2  = ((SchMemChart&) rMemChart).SomeData2 ();
	aSomeData3  = ((SchMemChart&) rMemChart).SomeData3 ();
	aSomeData4  = ((SchMemChart&) rMemChart).SomeData4 ();

	long nCols=MIN(nColCnt,rMemChart.nColCnt);
	long nRows=MIN(nRowCnt,rMemChart.nRowCnt);

	short i;
	for (i = 0; i < nCols; i++)
		pColText[i] = rMemChart.pColText[i];
	for (i = 0; i < nRows; i++)
		pRowText[i] = rMemChart.pRowText[i];

    // copy chart range
    SetChartRange( rMemChart.GetChartRange());
}
/*************************************************************************
|*
|* Kopier-Konstruktor
|*
\************************************************************************/

SchMemChart::SchMemChart(const SchMemChart& rMemChart) :
	nTranslated(TRANS_NONE),
	nRefCount (0),
	mpColNameBuffer(NULL),
	mpRowNameBuffer(NULL),
	myID (CHDATAID_MEMCHART_PLUS),
	mpNumFormatter(NULL),
	pRowNumFmtId(NULL),
	pColNumFmtId(NULL),
	pRowTable(NULL),
	pColTable(NULL)
{
	nColCnt     = rMemChart.nColCnt;
	nRowCnt     = rMemChart.nRowCnt;
	aMainTitle  = rMemChart.aMainTitle;
	aSubTitle   = rMemChart.aSubTitle;
	aXAxisTitle = rMemChart.aXAxisTitle;
	aYAxisTitle = rMemChart.aYAxisTitle;
	aZAxisTitle = rMemChart.aZAxisTitle;
	eDataType   = rMemChart.eDataType;
	aSomeData1  = ((SchMemChart&) rMemChart).SomeData1 ();
	aSomeData2  = ((SchMemChart&) rMemChart).SomeData2 ();
	aSomeData3  = ((SchMemChart&) rMemChart).SomeData3 ();
	aSomeData4  = ((SchMemChart&) rMemChart).SomeData4 ();
	pData       = new double[nColCnt * nRowCnt];

	pRowNumFmtId= new long [nRowCnt];
	pColNumFmtId= new long [nColCnt];
	pRowTable	= new long [nRowCnt];
	pColTable	= new long [nColCnt];

    aAppLink = rMemChart.aAppLink;
	nLastSelInfoReturn = rMemChart.nLastSelInfoReturn;

	nTranslated = rMemChart.nTranslated;
	long i;
	for(i=0;i<nColCnt;i++)
	{
		pColTable[i]	= rMemChart.pColTable[i];
		pColNumFmtId[i]	= rMemChart.pColNumFmtId[i];
	}
	for(i=0;i<nRowCnt;i++)
	{
		pRowTable[i]	= rMemChart.pRowTable[i];
		pRowNumFmtId[i]	= rMemChart.pRowNumFmtId[i];
	}
	mpNumFormatter=rMemChart.mpNumFormatter;

	if (pData)
	{
		double *pDest   = pData;
		double *pSource = rMemChart.pData;

		for (short i = 0; i < nColCnt; i++)
			for (short j = 0; j < nRowCnt; j++)
				*(pDest ++) = *(pSource ++);
	}

	pColText = new String[nColCnt];

	for (i = 0; i < nColCnt; i++)
		pColText[i] = rMemChart.pColText[i];

	pRowText = new String[nRowCnt];

	for (i = 0; i < nRowCnt; i++)
		pRowText[i] = rMemChart.pRowText[i];

	bReadOnly = rMemChart.bReadOnly;			// bm #69410#

	// copy address members
	maCategoriesRangeAddress = rMemChart.maCategoriesRangeAddress;
	maSeriesAddresses = rMemChart.maSeriesAddresses;

    // copy chart range
    SetChartRange( rMemChart.GetChartRange());
}

long SchMemChart::GetTableIndexRow(long nRow) const
{
	long nTmp=-1;
	if(nRow<nRowCnt && nRow>=0)
		for(long i=0;i<nRowCnt;i++)
			if(pRowTable[i]==nRow)
				nTmp=i;
	if(nTmp!=-1)
		nRow=nTmp;

	return nRow;
}
long SchMemChart::GetTableIndexCol(long nCol) const
{
	long nTmp=-1;
	if(nCol<nColCnt && nCol>=0)
		for(long i=0;i<nColCnt;i++)
			if(pColTable[i]==nCol)
				nTmp=i;
	if(nTmp!=-1)
		nCol=nTmp;

	return nCol;
}
long SchMemChart::SubmitSelection(const ChartSelectionInfo& aInfo)
{
	ChartSelectionInfo aNewInfo=aInfo;

	//aNewInfo der Translationstabelle anpassen
	if(nTranslated == TRANS_ROW)
		aNewInfo.nRow=GetTableIndexRow(aInfo.nRow);
	else if(nTranslated == TRANS_COL)
		aNewInfo.nCol=GetTableIndexCol(aInfo.nCol);

	if(aNewInfo == aSelectionInfo || aNewInfo.nSelection==0)
		return nLastSelInfoReturn; //reduzieren doppelter Selektionen bzw. speziell der Deselektion!
	aSelectionInfo = aNewInfo;
	if(aAppLink.IsSet())
	{
		return nLastSelInfoReturn=aAppLink.Call(&aSelectionInfo);
	}
	else
	{
		return nLastSelInfoReturn=0;
	}
}
BOOL SchMemChart::TransCol(long nCol,BOOL bUp)
{
	if(nTranslated==TRANS_ROW)
		return FALSE;

	if(bUp)
	{
		if(nCol+1 >= nColCnt)
			return FALSE;

		long tmp=pColTable[nCol];
		pColTable[nCol]=pColTable[nCol+1];
		pColTable[nCol+1]=tmp;
	}
	else
	{
		if(nCol-1 <= 0)
			return FALSE;

		long tmp=pColTable[nCol];
		pColTable[nCol]=pColTable[nCol-1];
		pColTable[nCol-1]=tmp;
	}
	nTranslated=TRANS_COL;
	return TRUE;
}
BOOL SchMemChart::TransRow(long nRow,BOOL bUp)
{
	if(nTranslated==TRANS_COL)
		return FALSE;

	if(bUp)
	{
		if(nRow+1 >= nRowCnt)
			return FALSE;

		long tmp=pRowTable[nRow];
		pRowTable[nRow]=pRowTable[nRow+1];
		pRowTable[nRow+1]=tmp;
	}
	else
	{
		if(nRow-1 <= 0)
			return FALSE;

		long tmp=pRowTable[nRow];
		pRowTable[nRow]=pRowTable[nRow-1];
		pRowTable[nRow-1]=tmp;
	}
	nTranslated=TRANS_ROW;
	return TRUE;
}

//berprft, ob die Umordnung/Translation OK ist, Fehlerfall, wenn :
// a) Spaltenumordnung aber Reihen vertauscht (FALSE,TRANS_ERROR)
// b) Reihenumordnung aber Spalten vertauscht (FALSE,TRANS_ERROR)
// c) keine Umordnung, Reihen oder Spalten vertauscht (FALSE,TRANS_ERROR)
// d) Umordnungsflag gesetzt (auf TRANS_ROW,TRANS_COL oder TRANS_ERROR) aber
//		keine Umordnung (mehr) vorhanden (FALSE,TRANS_NONE)
// sonst wird TRUE zurckgegeben

BOOL SchMemChart::VerifyTranslation()
{
	//Fehler ?
	if(nTranslated!=TRANS_COL)
	{
		for(long nCol=0;nCol<nColCnt;nCol++)
		{
			if(pColTable[nCol]!=nCol)
			{
				//nTranslated=TRANS_ERROR;
				if(nTranslated==TRANS_NONE)
				{
					DBG_ERROR("SchMemChart::Correcting Translationmode");
					nTranslated=TRANS_COL;
				}
				else
				{
					DBG_ERROR("fatal error in SchMemChart-translation");
					return FALSE;
				}
			}
		}
	}
	if(nTranslated!=TRANS_ROW)
	{
		for(long nRow=0;nRow<nRowCnt;nRow++)
		{
			if(pRowTable[nRow]!=nRow)
			{
				//nTranslated=TRANS_ERROR;
				if(nTranslated==TRANS_NONE)
				{
					DBG_ERROR("SchMemChart::Correcting Translationmode");
					nTranslated=TRANS_ROW;
				}
				else
				{
					DBG_ERROR("fatal error in SchMemChart-translation");
					return FALSE;
				}
			}
		}
	}

	// Sortierung besteht noch ?
	if(nTranslated==TRANS_ROW)
	{
		for(long nRow=0;nRow<nRowCnt;nRow++)
		{
			if(pRowTable[nRow]!=nRow)
				return TRUE;
		}
	}
	if(nTranslated==TRANS_COL)
	{
		for(long nCol=0;nCol<nColCnt;nCol++)
		{
			if(pColTable[nCol]!=nCol)
				return TRUE;
		}
	}

	if(nTranslated!=TRANS_NONE)
	{
		nTranslated=TRANS_NONE;
		return FALSE;
	}
	return TRUE;

}

double SchMemChart::GetTransData(long nCol,long nRow)
{
	DBG_ASSERT(VerifyTranslation(), "Translation table corrupted in MemChart");
	return GetData( (short)pColTable[nCol], (short)pRowTable[nRow]);
}
double SchMemChart::GetTransDataInPercent(long nCol, long nRow, BOOL bRowData) const
{
	DBG_ASSERT(((SchMemChart*)this)->VerifyTranslation(), "Translation table corrupted in MemChart");
	return GetDataInPercent( (short)pColTable[nCol], (short)pRowTable[nRow], bRowData);
}
const String& SchMemChart::GetTransColText(long nCol) const
{
	DBG_ASSERT(((SchMemChart*)this)->VerifyTranslation(), "Translation table corrupted in MemChart");
	return GetColText( (short)pColTable[nCol] );
}
const String& SchMemChart::GetTransRowText(long nRow) const
{
	DBG_ASSERT(((SchMemChart*)this)->VerifyTranslation(), "Translation table corrupted in MemChart");
	return GetRowText( (short)pRowTable[nRow] );
}
long SchMemChart::GetTransNumFormatIdRow(const long nRow) const
{
	DBG_ASSERT(((SchMemChart*)this)->VerifyTranslation(), "Translation table corrupted in MemChart");
	return ( nTranslated == TRANS_ROW )? pRowNumFmtId[ pRowTable[ nRow ]]: pRowNumFmtId[ nRow ];
}
long SchMemChart::GetTransNumFormatIdCol(const long nCol) const
{
	DBG_ASSERT(((SchMemChart*)this)->VerifyTranslation(), "Translation table corrupted in MemChart");
	return ( nTranslated == TRANS_COL ) ? pColNumFmtId[ pColTable[ nCol ]]: pColNumFmtId[ nCol ];
}


BOOL SchMemChart::SwapRowTranslation(long n1,long n2)
{
	if(nTranslated==TRANS_COL)
	{
		DBG_ERROR("Chart: Invalid Reorganisation of Chart attempted");
		return FALSE;
	}
	if(!(n1>=0 && n2>=0 && n1<nRowCnt && n2<nRowCnt))
	{
		DBG_ERROR("Chart: Invalid Reorganisation of Chart attempted, index error");
		return FALSE;
	}

	long nTmp=pRowTable[n1];
	pRowTable[n1]=pRowTable[n2];
	pRowTable[n2]=nTmp;

	nTranslated=TRANS_ROW;

	VerifyTranslation(); //evtl. wurde mit dieser Aktion die Umordnung aufgehoben!
	return TRUE;
}
BOOL SchMemChart::SwapColTranslation(long n1,long n2)
{
	if(!(n1>=0 && n2>=0 && n1<nColCnt && n2<nColCnt))
	{
		DBG_ERROR("Chart: Invalid Reorganisation of Chart attempted, index error");
		return FALSE;
	}

	if(nTranslated==TRANS_ROW)
	{
		DBG_ERROR("Chart: Invalid Reorganisation of Chart attempted");
		return FALSE;
	}

	long nTmp=pColTable[n1];
	pColTable[n1]=pColTable[n2];
	pColTable[n2]=nTmp;

    //	The last swap might have returned the permutation back to identity.
    //	Test this and set the flag nTranslated accordingly.
	nTranslated=TRANS_NONE;
	for (long nCol=0; nCol<nColCnt; nCol++)
		if (pColTable[nCol] != nCol)
        {
        	//	There is at least one moved column.
			nTranslated=TRANS_COL;
			break;
		}

	DBG_ASSERT(((SchMemChart*)this)->VerifyTranslation(),"Translation table corrupted in MemChart");
	return TRUE;
}
/*************************************************************************
|*
|* Wie GetData, aber in Prozentwerten
|* Optimierungsvorschlag: fTotal fuer jede Zeile und Spalte buffern,
|*                        dazu muessen alle Schnittstellen bekannt sein,
|*                        die Daten am MemChart veraendern koennen.
|*
\************************************************************************/
double SchMemChart::GetDataInPercent(const short nCol , const short nRow, const BOOL bRowData) const
{
   double fTotal=0.0,fTemp,fData;
   short i;

   fData = GetData(nCol,nRow);

   if(bRowData)
   {
	   for(i=0;i<nRowCnt;i++)
	   {
		   fTemp=GetData(nCol,i);

		   if(fTemp != DBL_MIN)   fTotal += fabs(fTemp);
	   }
   }
   else
   {
	   for(i=0;i<nColCnt;i++)
	   {
		   fTemp=GetData(i,nRow);

		   if(fTemp != DBL_MIN)   fTotal += fabs(fTemp);
	   }

   }
   return fTotal ? ( (fabs(fData) / fTotal) * 100.0 ) : DBL_MIN;
}

/*************************************************************************
|*
|* Inserter fuer SvStream zum Speichern
|*
\************************************************************************/

SvStream& operator << (SvStream& rOut, const SchMemChart& rMemChart)
{
	CharSet aSysCharSet = static_cast< CharSet >( ::GetSOStoreTextEncoding( gsl_getSystemTextEncoding(),
                                                                            (USHORT)rOut.GetVersion()) );
	rOut.SetStreamCharSet( aSysCharSet );

	//Version 1: Abspeichern der pRow,pColTable (long-array)
	SchIOCompat aIO(rOut, STREAM_WRITE, 2);

	rOut << (INT16)rMemChart.nColCnt;
	rOut << (INT16)rMemChart.nRowCnt;

	double *pOut = rMemChart.pData;

	short i;
	for (i = 0; i < rMemChart.nColCnt; i++)
		for (short j = 0; j < rMemChart.nRowCnt; j++)
			rOut << *(pOut ++);

	rOut << (INT16)aSysCharSet;
	rOut << rMemChart.aMainTitle;
	rOut << rMemChart.aSubTitle;
	rOut << rMemChart.aXAxisTitle;
	rOut << rMemChart.aYAxisTitle;
	rOut << rMemChart.aZAxisTitle;

	for (i = 0; i < rMemChart.nColCnt; i++)
		rOut << rMemChart.pColText[ i ];

	for (i = 0; i < rMemChart.nRowCnt; i++)
		rOut << rMemChart.pRowText[ i ];

	rOut << (INT16)rMemChart.eDataType;

	//IOVersion = 1
	long nIndex;
	for (nIndex = 0; nIndex < rMemChart.nColCnt; nIndex++)
		rOut << rMemChart.pColTable[nIndex];

	for (nIndex = 0; nIndex < rMemChart.nRowCnt; nIndex++)
		rOut << rMemChart.pRowTable[nIndex];

	//IOVersion = 2
	rOut << rMemChart.nTranslated;


	return rOut;
}

/*************************************************************************
|*
|* Extractor fuer SvStream zum Laden
|*
\************************************************************************/

SvStream& operator >> (SvStream& rIn, SchMemChart& rMemChart)
{
	INT16 nInt16;

	SchIOCompat aIO(rIn, STREAM_READ);

	rIn >> nInt16; rMemChart.nColCnt = (short)nInt16;
	rIn >> nInt16; rMemChart.nRowCnt = (short)nInt16;

	rMemChart.pData = new double[rMemChart.nColCnt * rMemChart.nRowCnt];

	double *pIn = rMemChart.pData;

	short i;
	for (i = 0; i < rMemChart.nColCnt; i++)
		for (short j = 0; j < rMemChart.nRowCnt; j++)
			rIn >> *(pIn ++);

	INT16 nCharSet;
	rIn >> nCharSet;

	rtl_TextEncoding aCharSet = ::GetSOLoadTextEncoding( static_cast< rtl_TextEncoding >( nCharSet ),
                                                         (USHORT)rIn.GetVersion());
    rIn.SetStreamCharSet( aCharSet );

	rIn >> rMemChart.aMainTitle;
	rIn >> rMemChart.aSubTitle;
	rIn >> rMemChart.aXAxisTitle;
	rIn >> rMemChart.aYAxisTitle;
	rIn >> rMemChart.aZAxisTitle;

	rMemChart.pColText = new String[rMemChart.nColCnt];

	for (i = 0; i < rMemChart.nColCnt; i++)
	{
		rIn >> rMemChart.pColText[ i ];
	}

	rMemChart.pRowText = new String[rMemChart.nRowCnt];

	for (i = 0; i < rMemChart.nRowCnt; i++)
	{
		rIn >> rMemChart.pRowText[ i ];
	}

	rIn >> nInt16; rMemChart.eDataType = (short)nInt16;

	rMemChart.pRowNumFmtId	= new long [rMemChart.nRowCnt];
	rMemChart.pColNumFmtId	= new long [rMemChart.nColCnt];
	rMemChart.pRowTable		= new long [rMemChart.nRowCnt];
	rMemChart.pColTable		= new long [rMemChart.nColCnt];

	if(aIO.GetVersion()>=1)
	{
		long i;
		for (i = 0; i < rMemChart.nColCnt; i++)
			rIn >> rMemChart.pColTable[i];

		for (i = 0; i < rMemChart.nRowCnt; i++)
			rIn >> rMemChart.pRowTable[i];

		if(aIO.GetVersion()>=2)
			rIn >> rMemChart.nTranslated;

	}
	else
	{
		rMemChart.ResetTranslation(rMemChart.pRowTable,rMemChart.nRowCnt);
		rMemChart.ResetTranslation(rMemChart.pColTable,rMemChart.nColCnt);
	}

	rMemChart.InitNumFmt(); //ab IOVersion 2 (ToDo:)

	return rIn;
}

/*************************************************************************
|*
|* QuickSort ueber Spalten
|*
\************************************************************************/

void SchMemChart::QuickSortTableCols (long l,long r,long nRow)
{
	if (r > l)
	{
		double v = *(pData + r * nRowCnt + nRow);
		long   i = l - 1;
		long   j = r;

		while (TRUE)
		{
			while (*(pData + (++ i) * nRowCnt + nRow) < v)
				;
			while (*(pData + (-- j) * nRowCnt + nRow) > v)
				;

			if (i >= j) break;
			else SwapCols (i, j);
		}

		if (i != r) SwapCols (i, r);
		QuickSortTableCols (l, i - 1, nRow);
		QuickSortTableCols (i + 1, r, nRow);
	}
}

/*************************************************************************
|*
|* QuickSort ueber Zeilen
|*
\************************************************************************/

void SchMemChart::QuickSortTableRows (long l,long r,long nCol)
{
	if (r > l)
	{
		double v = *(pData + r + nCol * nRowCnt);
		long   i = l - 1;
		long   j = r;

		while (TRUE)
		{
			while (*(pData + (++ i) + nCol * nRowCnt) < v)
				;
			while (*(pData + (-- j) + nCol * nRowCnt) > v)
				;

			if (i >= j) break;
			else SwapRows (i, j);
		}

		if (i != r) SwapRows (i, r);
		QuickSortTableRows (l, i - 1, nCol);
		QuickSortTableRows (i + 1, r, nCol);
	}
}

void SchMemChart::InitNumFmt()
{
	long i;
	for(i=0;i<nColCnt;i++)
		pColNumFmtId[i]=-1; //uninitialised!

	for(i=0;i<nRowCnt;i++)
		pRowNumFmtId[i]=-1;
}

/*************************************************************************
|*
|* QuickSort ueber Spalten
|*
\************************************************************************/

void SchMemChart::QuickSortCols(long l,long r,long nRow)
{
	if (r > l)
	{
		double v = *(pData + r * nRowCnt + nRow);
		long   i = l - 1;
		long   j = r;

		while (TRUE)
		{
			while (*(pData + (++ i) * nRowCnt + nRow) < v)
				;
			while (*(pData + (-- j) * nRowCnt + nRow) > v)
				;

			if (i >= j) break;
			else
			{
				double temp = *(pData + i * nRowCnt + nRow);
				*(pData + i * nRowCnt + nRow) = *(pData + j * nRowCnt + nRow);
				*(pData + j * nRowCnt + nRow) = temp;
			}
		}

		if (i != r)
		{
			double temp = *(pData + r * nRowCnt + nRow);
			*(pData + r * nRowCnt + nRow) = *(pData + i * nRowCnt + nRow);
			*(pData + i * nRowCnt + nRow) = temp;
		}

		QuickSortCols (l, i - 1, nRow);
		QuickSortCols (i + 1, r, nRow);
	}
}

/*************************************************************************
|*
|* QuickSort ueber Zeilen
|*
\************************************************************************/

void SchMemChart::QuickSortRows (long l,
								 long r,
								 long nCol)
{
	if (r > l)
	{
		double v = *(pData + r + nCol * nRowCnt);
		long   i = l - 1;
		long   j = r;

		while (TRUE)
		{
			while (*(pData + (++ i) + nCol * nRowCnt) < v)
				;
			while (*(pData + (-- j) + nCol * nRowCnt) > v)
				;

			if (i >= j) break;
			else
			{
				double temp = *(pData + i + nCol * nRowCnt);
				*(pData + i + nCol * nRowCnt) = *(pData + j + nCol * nRowCnt);
				*(pData + j + nCol * nRowCnt) = temp;
			}
		}

		if (i != r)
		{
			double temp = *(pData + r + nCol * nRowCnt);
			*(pData + r + nCol * nRowCnt) = *(pData + i + nCol * nRowCnt);
			*(pData + i + nCol * nRowCnt) = temp;
		}

		QuickSortRows (l, i - 1, nCol);
		QuickSortRows (i + 1, r, nCol);
	}
}

String SchMemChart::GetDefaultColumnText( sal_Int32 nCol ) const
{
	if( !mpColNameBuffer )
	{
		// initialize resource string
		mpColNameBuffer = new String[ 2 ];
		DBG_ASSERT( mpColNameBuffer, "couldn't create two strings!" );
		String aResStr( SchResId( STR_COLUMN ));
		xub_StrLen nPos = aResStr.SearchAscii( "$(N)" );
		if( nPos != STRING_NOTFOUND )
		{
			mpColNameBuffer[ 0 ] = String( aResStr, 0, nPos );
			mpColNameBuffer[ 1 ] = String( aResStr, nPos + sizeof( "$(N)" ) - 1, STRING_LEN );
		}
		else
			mpColNameBuffer[ 0 ] = aResStr;
	}

	if( mpColNameBuffer )
	{
		String aResult( mpColNameBuffer[ 0 ] );
		aResult.Append( String::CreateFromInt32( nCol + 1 ));
		aResult.Append( mpColNameBuffer[ 1 ] );
		return aResult;
	}
	else
		return String();
}

String SchMemChart::GetDefaultRowText( sal_Int32 nRow ) const
{
	if( !mpRowNameBuffer )
	{
		// initialize resource string
		mpRowNameBuffer = new String[ 2 ];
		DBG_ASSERT( mpRowNameBuffer, "couldn't create two strings!" );
		String aResStr( SchResId( STR_ROW ));
		xub_StrLen nPos = aResStr.SearchAscii( "$(N)" );
		if( nPos != STRING_NOTFOUND )
		{
			mpRowNameBuffer[ 0 ] = String( aResStr, 0, nPos );
			mpRowNameBuffer[ 1 ] = String( aResStr, nPos + sizeof( "$(N)" ) - 1, STRING_LEN );
		}
		else
			mpRowNameBuffer[ 0 ] = aResStr;
	}

	if( mpRowNameBuffer )
	{
		String aResult( mpRowNameBuffer[ 0 ] );
		aResult.Append( String::CreateFromInt32( nRow + 1 ));
		aResult.Append( mpRowNameBuffer[ 1 ] );
		return aResult;
	}
	else
		return String();
}

using namespace com::sun::star;

// ========================================

::rtl::OUStringBuffer SchMemChart::getXMLStringForCellAddress( const SchCellAddress& rCell )
{
    ::rtl::OUStringBuffer aBuffer;
    ::std::vector< SchSingleCell >::const_iterator aIter;
    const ::std::vector< SchSingleCell >::const_iterator aEndIter = rCell.maCells.end();

    for( aIter = rCell.maCells.begin(); aIter != aEndIter; aIter++ )
    {
        sal_Int32 nCol = aIter->mnColumn;
        aBuffer.append( (sal_Unicode)'.' );
        if( ! aIter->mbRelativeColumn )
            aBuffer.append( (sal_Unicode)'$' );

        // get A, B, C, ..., AA, AB, ... representation of column number
        if( nCol < 26 )
            aBuffer.append( (sal_Unicode)('A' + nCol) );
        else if( nCol < 702 )
        {
            aBuffer.append( (sal_Unicode)('A' + nCol / 26 - 1 ));
            aBuffer.append( (sal_Unicode)('A' + nCol % 26) );
        }
        else    // works for nCol <= 18,278
        {
            aBuffer.append( (sal_Unicode)('A' + nCol / 702 - 1 ));
            aBuffer.append( (sal_Unicode)('A' + (nCol % 702) / 26 ));
            aBuffer.append( (sal_Unicode)('A' + nCol % 26) );
        }

        // write row number as number
        if( ! aIter->mbRelativeRow )
            aBuffer.append( (sal_Unicode)'$' );
        aBuffer.append( aIter->mnRow + (sal_Int32)1 );
    }

    return aBuffer;
}

void SchMemChart::getSingleCellAddressFromXMLString(
    const ::rtl::OUString& rXMLString,
    sal_Int32 nStartPos, sal_Int32 nEndPos,
    SchSingleCell& rSingleCell )
{
    // expect "\$?[a-zA-Z]+\$?[1-9][0-9]*"
    static const sal_Unicode aDollar( '$' );
    static const sal_Unicode aLetterA( 'A' );

    ::rtl::OUString aCellStr = rXMLString.copy( nStartPos, nEndPos - nStartPos + 1 ).toAsciiUpperCase();
    const sal_Unicode* pStrArray = aCellStr.getStr();
    sal_Int32 nLength = aCellStr.getLength();
    sal_Int32 i = nLength - 1, nColumn = 0;

    // parse number for row
    while( CharClass::isAsciiDigit( pStrArray[ i ] ) && i >= 0 )
        i--;
    rSingleCell.mnRow = (aCellStr.copy( i + 1 )).toInt32() - 1;
    // a dollar in XML means absolute (whereas in UI it means relative)
    if( pStrArray[ i ] == aDollar )
    {
        i--;
        rSingleCell.mbRelativeRow = sal_False;
    }
    else
        rSingleCell.mbRelativeRow = sal_True;

    // parse rest for column
    sal_Int32 nPower = 1;
    while( CharClass::isAsciiAlpha( pStrArray[ i ] ))
    {
        nColumn += (pStrArray[ i ] - aLetterA + 1) * nPower;
        i--;
        nPower *= 26;
    }
    rSingleCell.mnColumn = nColumn - 1;

    rSingleCell.mbRelativeColumn = sal_True;
    if( i >= 0 &&
        pStrArray[ i ] == aDollar )
        rSingleCell.mbRelativeColumn = sal_False;
}

bool SchMemChart::getCellAddressFromXMLString(
    const ::rtl::OUString& rXMLString,
    sal_Int32 nStartPos, sal_Int32 nEndPos,
    SchCellAddress& rOutCell,
    ::rtl::OUString& rOutTableName )
{
    static const sal_Unicode aDot( '.' );
    static const sal_Unicode aQuote( '\'' );
    static const sal_Unicode aBackslash( '\\' );

    sal_Int32 nNextDelimiterPos = nStartPos;

    sal_Int32 nDelimiterPos = nStartPos;
    bool bInQuotation = false;
    // parse table name
    while( nDelimiterPos < nEndPos &&
           ( bInQuotation || rXMLString[ nDelimiterPos ] != aDot ))
    {
        // skip escaped characters (with backslash)
        if( rXMLString[ nDelimiterPos ] == aBackslash )
            ++nDelimiterPos;
        // toggle quotation mode when finding single quotes
        else if( rXMLString[ nDelimiterPos ] == aQuote )
            bInQuotation = ! bInQuotation;

        ++nDelimiterPos;
    }

    if( nDelimiterPos == -1 ||
        nDelimiterPos >= nEndPos )
    {
#ifdef DBG_UTIL
        String aStr( rXMLString.copy( nStartPos, nEndPos - nStartPos + 1 ));
        ByteString aBstr( aStr, RTL_TEXTENCODING_ASCII_US );
        DBG_ERROR1( "Invalid Cell Address <%s> found in XML file", aBstr.GetBuffer());
#endif
        return false;
    }
    if( nDelimiterPos > nStartPos )
    {
        // there is a table name before the address

        ::rtl::OUStringBuffer aTableNameBuffer;
        const sal_Unicode * pTableName = rXMLString.getStr();

        // remove escapes from table name
        ::std::for_each( pTableName + nStartPos,
                         pTableName + nDelimiterPos,
                         lcl_UnEscape( aTableNameBuffer ));

        // unquote quoted table name
        const sal_Unicode * pBuf = aTableNameBuffer.getStr();
        if( pBuf[ 0 ] == aQuote &&
            pBuf[ aTableNameBuffer.getLength() - 1 ] == aQuote )
        {
            ::rtl::OUString aName = aTableNameBuffer.makeStringAndClear();
            rOutTableName = aName.copy( 1, aName.getLength() - 2 );
        }
        else
            rOutTableName = aTableNameBuffer.makeStringAndClear();
    }

    for( sal_Int32 i = 0;
         nNextDelimiterPos < nEndPos;
         nDelimiterPos = nNextDelimiterPos, i++ )
    {
        nNextDelimiterPos = rXMLString.indexOf( aDot, nDelimiterPos + 1 );
        if( nNextDelimiterPos == -1 ||
            nNextDelimiterPos > nEndPos )
            nNextDelimiterPos = nEndPos + 1;

        rOutCell.maCells.resize( i + 1 );
        getSingleCellAddressFromXMLString( rXMLString,
                                           nDelimiterPos + 1, nNextDelimiterPos - 1,
                                           rOutCell.maCells[ i ] );
    }

    return true;
}

bool SchMemChart::getCellRangeAddressFromXMLString(
    const ::rtl::OUString& rXMLString,
    sal_Int32 nStartPos, sal_Int32 nEndPos,
    SchCellRangeAddress& rOutRange )
{
    bool bResult = true;
    static const sal_Unicode aColon( ':' );
    static const sal_Unicode aQuote( '\'' );
    static const sal_Unicode aBackslash( '\\' );

    sal_Int32 nDelimiterPos = nStartPos;
    bool bInQuotation = false;
    // parse table name
    while( nDelimiterPos < nEndPos &&
           ( bInQuotation || rXMLString[ nDelimiterPos ] != aColon ))
    {
        // skip escaped characters (with backslash)
        if( rXMLString[ nDelimiterPos ] == aBackslash )
            ++nDelimiterPos;
        // toggle quotation mode when finding single quotes
        else if( rXMLString[ nDelimiterPos ] == aQuote )
            bInQuotation = ! bInQuotation;

        ++nDelimiterPos;
    }

    if( nDelimiterPos <= nStartPos ||              // includes == and 'not found' (==-1)
        nDelimiterPos >= nEndPos )
    {
#if OSL_DEBUG_LEVEL > 0
        String aStr( rXMLString.copy( nStartPos, nEndPos - nStartPos + 1 ));
        ByteString aBstr( aStr, RTL_TEXTENCODING_ASCII_US );
        DBG_ERROR1( "Invalid Cell Range <%s> found in XML file", aBstr.GetBuffer());
#endif
        return false;
    }
    bResult = getCellAddressFromXMLString( rXMLString, nStartPos, nDelimiterPos - 1,
                                           rOutRange.maUpperLeft,
                                           rOutRange.msTableName );
    ::rtl::OUString sTableSecondName;
    if( bResult )
    {
        bResult = getCellAddressFromXMLString( rXMLString, nDelimiterPos + 1, nEndPos,
                                               rOutRange.maLowerRight,
                                               sTableSecondName );
    }
    DBG_ASSERT( sTableSecondName.getLength() == 0 ||
                sTableSecondName.equals( rOutRange.msTableName ),
                "Cell Range must be inside the same sheet" );
    return bResult;
}

/// interpret maChartRange and fill XML string with that
::rtl::OUString SchMemChart::getXMLStringForChartRange()
{
    static const sal_Unicode aSpace( ' ' );
    static const sal_Unicode aQuote( '\'' );

    ::rtl::OUStringBuffer aBuffer;
    ::std::vector< SchCellRangeAddress >::iterator aIter;
    const ::std::vector< SchCellRangeAddress >::iterator aEndIter = maChartRange.maRanges.end();

    for( aIter = maChartRange.maRanges.begin(); aIter != aEndIter; /* increment done in body */ )
    {
        if( (aIter->msTableName).getLength())
        {
            bool bNeedsEscaping = ( aIter->msTableName.indexOf( aQuote ) > -1 );
            bool bNeedsQuoting = bNeedsEscaping || ( aIter->msTableName.indexOf( aSpace ) > -1 );

            // quote table name if it contains spaces or quotes
            if( bNeedsQuoting )
            {
                // leading quote
                aBuffer.append( aQuote );

                // escape existing quotes
                if( bNeedsEscaping )
                {
                    const sal_Unicode * pTableNameBeg = aIter->msTableName.getStr();

                    // append the quoted string at the buffer
                    ::std::for_each( pTableNameBeg,
                                     pTableNameBeg + aIter->msTableName.getLength(),
                                     lcl_Escape( aBuffer ) );
                }
                else
                    aBuffer.append( aIter->msTableName );

                // final quote
                aBuffer.append( aQuote );
            }
            else
                aBuffer.append( aIter->msTableName );
        }
        aBuffer.append( getXMLStringForCellAddress( aIter->maUpperLeft ));

        if( aIter->maLowerRight.maCells.size())
        {
            // we have a range (not a single cell)
            aBuffer.append( sal_Unicode( ':' ));
            aBuffer.append( getXMLStringForCellAddress( aIter->maLowerRight ));
        }

        aIter++;
        // separator for more than one range
        if( aIter != aEndIter )
            aBuffer.append( sal_Unicode( ' ' ));
    }

    return aBuffer.makeStringAndClear();
}

/// parse String and put results into maChartRange
void SchMemChart::getChartRangeForXMLString( const ::rtl::OUString& rXMLString )
{
    static const sal_Unicode aSpace( ' ' );
    static const sal_Unicode aQuote( '\'' );
    static const sal_Unicode aDoubleQuote( '\"' );
    static const sal_Unicode aDollar( '$' );
    static const sal_Unicode aBackslash( '\\' );

    sal_Int32 nStartPos = 0;
    sal_Int32 nEndPos = nStartPos;
    const sal_Int32 nLength = rXMLString.getLength();

    // reset
    maChartRange.maRanges.clear();

    // iterate over different ranges
    for( sal_Int32 i = 0;
         nEndPos < nLength;
         nStartPos = ++nEndPos, i++ )
    {
        // find start point of next range

        // ignore leading '$'
        if( rXMLString[ nEndPos ] == aDollar)
            nEndPos++;

        bool bInQuotation = false;
        // parse range
        while( nEndPos < nLength &&
               ( bInQuotation || rXMLString[ nEndPos ] != aSpace ))
        {
            // skip escaped characters (with backslash)
            if( rXMLString[ nEndPos ] == aBackslash )
                ++nEndPos;
            // toggle quotation mode when finding single quotes
            else if( rXMLString[ nEndPos ] == aQuote )
                bInQuotation = ! bInQuotation;

            ++nEndPos;
        }

        maChartRange.maRanges.resize( i + 1 );
        if( ! getCellRangeAddressFromXMLString(
                rXMLString,
                nStartPos, nEndPos - 1,
                maChartRange.maRanges[ i ] ))
        {
            // if an error occured, bail out
            maChartRange.maRanges.clear();
            break;
        }
    }

#if OSL_DEBUG_LEVEL > 0
    // output result
    OSL_TRACE(
        ::rtl::OUStringToOString(
            ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Ranges retrieved from XML-String: \"" )) +
            rXMLString +
            ::rtl::OUString( sal_Unicode( '\"' )),
            RTL_TEXTENCODING_ASCII_US ).getStr() );
    OSL_TRACE( "Size: %d", maChartRange.maRanges.size() );
    for( ::std::vector< SchCellRangeAddress >::const_iterator aIter = maChartRange.maRanges.begin();
         aIter != maChartRange.maRanges.end();
         ++aIter )
    {
        OSL_TRACE( " Cell Address found:" );
        OSL_TRACE( "  Upper-Left: " );
        for( ::std::vector< SchSingleCell >::const_iterator aIter2 = (*aIter).maUpperLeft.maCells.begin();
             aIter2 != (*aIter).maUpperLeft.maCells.end();
             ++aIter2 )
        {
            OSL_TRACE( "  Column: %d, Row: %d,  Rel-Col: %s, Rel-Row: %s",
                       (*aIter2).mnColumn, (*aIter2).mnRow,
                       (*aIter2).mbRelativeColumn ? "true" : "false",
                       (*aIter2).mbRelativeRow ? "true" : "false" );
        }
        OSL_TRACE( "  Lower-Right: " );
        for( ::std::vector< SchSingleCell >::const_iterator aIter3 = (*aIter).maLowerRight.maCells.begin();
             aIter3 != (*aIter).maLowerRight.maCells.end();
             ++aIter3 )
        {
            OSL_TRACE( "  Column: %d, Row: %d,  Rel-Col: %s, Rel-Row: %s",
                       (*aIter3).mnColumn, (*aIter3).mnRow,
                       (*aIter3).mbRelativeColumn ? "true" : "false",
                       (*aIter3).mbRelativeRow ? "true" : "false" );
        }
        OSL_TRACE(
            ::rtl::OUStringToOString(
                ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "  Table-Name: \"" )) +
                (*aIter).msTableName +
                ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "\", Number: " )) +
                ::rtl::OUString::valueOf( (*aIter).mnTableNumber ),
                RTL_TEXTENCODING_ASCII_US ).getStr() );
    }
#endif
}

/** this is needed for export of charts embedded in calc
    for saving an XML document in old binary format
*/
::rtl::OUString SchMemChart::createTableNumberList()
{
    ::rtl::OUStringBuffer aBuffer;
    ::std::vector< SchCellRangeAddress >::iterator aIter;
    const ::std::vector< SchCellRangeAddress >::iterator aEndIter = maChartRange.maRanges.end();
    sal_Bool bStarted = sal_False;

    for( aIter = maChartRange.maRanges.begin(); aIter != aEndIter; aIter++ )
    {
        if( aIter->mnTableNumber != -1 )
        {
            if( bStarted )
                aBuffer.append( (sal_Unicode)' ' );
            else
                bStarted = sal_True;

            aBuffer.append( aIter->mnTableNumber );
        }
    }

    return aBuffer.makeStringAndClear();
}

// prerequisite: maChartRange must be set and have the correct dimension
// for all table numbers to fit in
void SchMemChart::parseTableNumberList( const ::rtl::OUString& aList )
{
    static const sal_Unicode aSpace( ' ' );
    sal_Int32 nChartRangeSize = maChartRange.maRanges.size();
    sal_Int32 nStartPos = 0, nEndPos;
    sal_Int32 nLength = aList.getLength();
    sal_Int32 nRangeNumber = 0;

    while( nStartPos < nLength )
    {
        nEndPos = aList.indexOf( aSpace, nStartPos );
        if( nEndPos == -1 )
            nEndPos = nLength;

        if( nStartPos != nEndPos ) // there were more than one space
        {
            if( nRangeNumber < nChartRangeSize )
            {
                maChartRange.maRanges[ nRangeNumber++ ].mnTableNumber =
                    aList.copy( nStartPos, (nEndPos - nStartPos)).toInt32();
            }
            else
            {
                DBG_ERROR( "SchMemChart::parseTableNumberList: Too many table numbers for chart range" );
            }
        }

        nStartPos = nEndPos + 1;
    }
}


// methods to modify SchChartRange
// -------------------------------

static sal_Int32 lcl_GetWriterBoxNum( String& rStr, BOOL bFirst )
{
	sal_Int32 nRet = 0;
	xub_StrLen nPos = 0;
	if( bFirst )
	{
		// the first box starts with a letter
		sal_Unicode cChar;
		BOOL bFirst = TRUE;
		while( 0 != ( cChar = rStr.GetChar( nPos )) &&
			   ( (cChar >= 'A' && cChar <= 'Z') ||
			     (cChar >= 'a' && cChar <= 'z') ) )
		{
			if( (cChar -= 'A') >= 26 )
				cChar -= 'a' - '[';
			if( bFirst )
				bFirst = FALSE;
			else
				++nRet;
			nRet = nRet * 52 + cChar;
			++nPos;
		}
		rStr.Erase( 0, nPos );		// remove the read characters
	}
	else if( STRING_NOTFOUND == ( nPos = rStr.Search( ':' ) ))
	{
		nRet = rStr.ToInt32();
		rStr.Erase();
	}
	else
	{
		nRet = rStr.Copy( 0, nPos ).ToInt32();
		rStr.Erase( 0, nPos+1 );
	}
	return nRet;
}

static void lcl_GetWriterTblBox( const String& rStr,
								SchCellAddress& rToFill )
{
	BOOL bFirst = TRUE;
	String sNm( rStr );
	while( sNm.Len() )
	{
		SchSingleCell aCell;
		aCell.mnColumn = ::lcl_GetWriterBoxNum( sNm, bFirst );
		bFirst = FALSE;
		aCell.mnRow = ::lcl_GetWriterBoxNum( sNm, bFirst );
		rToFill.maCells.push_back( aCell );
	}
}

String lcl_GetWriterBoxName( const SchCellAddress& rCell )
{
	String sNm;

    ::std::vector< SchSingleCell >::const_iterator aIter = rCell.maCells.begin();
    const ::std::vector< SchSingleCell >::const_iterator aEnd = rCell.maCells.end();
	BOOL bFirst = TRUE;
	for( ; aIter != aEnd; aIter++ )
	{
		String sTmp( String::CreateFromInt32( aIter->mnRow ));
		if( sNm.Len() )
			sNm.Insert( '.', 0 ).Insert( sTmp, 0 );
		else
			sNm = sTmp;

		if( bFirst )
		{
			const sal_Int32 coDiff = 52; 	// 'A'-'Z' 'a' - 'z'
			register sal_Int32 nCalc, nCol = aIter->mnColumn;

			do {
				nCalc = nCol % coDiff;
				if( nCalc >= 26 )
					sNm.Insert( sal_Unicode('a' - 26 + nCalc ), 0 );
				else
					sNm.Insert( sal_Unicode('A' + nCalc ), 0 );

				if( !(nCol -= nCalc) )
					break;
				nCol /= coDiff;
				--nCol;
			} while( 1 );
			bFirst = FALSE;
		}
		else
			sNm.Insert( '.', 0 ).Insert(
						String::CreateFromInt32( aIter->mnColumn ), 0 );
	}
	return sNm;
}


/// convert SomeData string(s) to SchChartRange and vice versa for Writer
void SchMemChart::ConvertChartRangeForWriter( BOOL bOldToNew )
{
    if( bOldToNew )     // convert SomeData1 to SchChartRange
    {
		SchChartRange aRange;
		if( 2 < aSomeData1.Len() )
		{
			// spitze Klammern am Anfang & Ende enfernen
			String sBox( aSomeData1 );
			if( '<' == sBox.GetChar( 0  ) ) sBox.Erase( 0, 1 );
			if( '>' == sBox.GetChar( sBox.Len()-1  ) ) sBox.Erase( sBox.Len()-1 );

			xub_StrLen nTrenner = sBox.Search( ':' );
			DBG_ASSERT( STRING_NOTFOUND != nTrenner, "no valid selection" );

			SchCellRangeAddress aCRA;
			::lcl_GetWriterTblBox( sBox.Copy( 0, nTrenner ), aCRA.maUpperLeft );
			::lcl_GetWriterTblBox( sBox.Copy( nTrenner+1 ), aCRA.maLowerRight );
			aRange.maRanges.push_back( aCRA );
		}
		if( aSomeData2.Len() )
		{
			aRange.mbFirstRowContainsLabels = '1' == aSomeData2.GetChar(0);
			aRange.mbFirstColumnContainsLabels = '1' == aSomeData2.GetChar(1);
		}
		SetChartRange( aRange );
    }
    else                // convert SchChartRange to SomeData1
    {
		String sData1, sData2;
		const SchChartRange& rRg = GetChartRange();
		if( rRg.maRanges.size() )
		{
		    ::std::vector< SchCellRangeAddress >::const_iterator
												aIter = rRg.maRanges.begin();
			sData1.Assign( '<' )
				  .Append( ::lcl_GetWriterBoxName( aIter->maUpperLeft ))
				  .Append( ':' )
				  .Append( ::lcl_GetWriterBoxName( aIter->maLowerRight ))
				  .Append( '>' );

			sData2.Assign( rRg.mbFirstRowContainsLabels ? '1' : '0' )
				  .Append( rRg.mbFirstColumnContainsLabels ? '1' : '0' );
		}
		aSomeData1 = sData1;
		aSomeData2 = sData2;
    }
}

/// convert SomeData string(s) to SchChartRange and vice versa for Calc
void SchMemChart::ConvertChartRangeForCalc( BOOL bOldToNew )
{
    if( bOldToNew )
    {   // convert SomeData1/2/3 to SchChartRange
        DBG_ASSERT( SomeData1().Len() && SomeData2().Len() && SomeData3().Len(),
            "ConvertChartRangeForCalc: can't convert old to new" );
        SchChartRange aChartRange;
		const sal_Unicode cTok = ';';
		xub_StrLen nToken;
        String aPos = SomeData1();
		if ( (nToken = aPos.GetTokenCount( cTok )) >= 5)
		{
            aChartRange.mbKeepCopyOfData = sal_False;
            String aOpt = SomeData2();
			xub_StrLen nOptToken = aOpt.GetTokenCount( cTok );
            BOOL bNewChart = (nOptToken >= 4);      // as of 341/342
            DBG_ASSERT( SomeData3().Len(), "ConvertChartRangeForCalc: no sheet names" );
            String aSheetNames = SomeData3();       // as of 638m
			USHORT nCol1, nRow1, nTab1, nCol2, nRow2, nTab2;
			xub_StrLen nInd = 0;
            xub_StrLen nSheetInd = 0;
			for ( xub_StrLen j=0; j < nToken; j+=5 )
			{
				xub_StrLen nInd2 = nInd;
				nTab1 = (USHORT) aPos.GetToken( 0, cTok, nInd ).ToInt32();
                // To make old versions (<341/342) skip it, the token separator
                // is a ','
				if ( bNewChart )
					nTab2 = (USHORT) aPos.GetToken( 1, ',', nInd2 ).ToInt32();
				else
					nTab2 = nTab1;
				nCol1 = (USHORT) aPos.GetToken( 0, cTok, nInd ).ToInt32();
				nRow1 = (USHORT) aPos.GetToken( 0, cTok, nInd ).ToInt32();
				nCol2 = (USHORT) aPos.GetToken( 0, cTok, nInd ).ToInt32();
				nRow2 = (USHORT) aPos.GetToken( 0, cTok, nInd ).ToInt32();
                for ( USHORT nTab = nTab1; nTab <= nTab2; ++nTab )
                {
                    SchCellRangeAddress aCellRangeAddress;
                    SchSingleCell aCell;
                    aCell.mnColumn = nCol1;
                    aCell.mnRow = nRow1;
                    aCellRangeAddress.maUpperLeft.maCells.push_back( aCell );
                    aCell.mnColumn = nCol2;
                    aCell.mnRow = nRow2;
                    aCellRangeAddress.maLowerRight.maCells.push_back( aCell );
                    aCellRangeAddress.mnTableNumber = nTab;
                    String aName( aSheetNames.GetToken( 0, cTok, nSheetInd ) );
                    aCellRangeAddress.msTableName = aName;
                    aChartRange.maRanges.push_back( aCellRangeAddress );
                }
			}

            if ( aOpt.Len() >= 2 )
			{
                aChartRange.mbFirstRowContainsLabels    = ( aOpt.GetChar(0) != '0' );
                aChartRange.mbFirstColumnContainsLabels = ( aOpt.GetChar(1) != '0' );
#if 0
/*  Calc internal data
				if ( aOpt.Len() >= 3 )
				{
					if ( bNewChart )
					{
						bDummyUpperLeft = ( aOpt.GetChar(2) != '0' );
						xub_StrLen nInd = 4;	// 111;
						eGlue = (ScChartGlue) aOpt.GetToken( 0, cTok, nInd ).ToInt32();
						nStartCol = (USHORT) aOpt.GetToken( 0, cTok, nInd ).ToInt32();
						nStartRow = (USHORT) aOpt.GetToken( 0, cTok, nInd ).ToInt32();
						bInitOk = TRUE;
					}
				}
 */
#endif
			}
			else
            {
                aChartRange.mbFirstColumnContainsLabels = sal_False;
                aChartRange.mbFirstRowContainsLabels = sal_False;
            }
		}
		else
		{
            aChartRange.mbFirstColumnContainsLabels = sal_False;
            aChartRange.mbFirstRowContainsLabels = sal_False;
            aChartRange.mbKeepCopyOfData = sal_True;
		}
        SetChartRange( aChartRange );
    }
    else
    {   // convert SchChartRange to SomeData1/2/3
        const sal_Unicode cTok = ';';
        String aRef, aSheetNames;
        const SchChartRange& rChartRange = GetChartRange();
        ::std::vector< SchCellRangeAddress >::const_iterator iRange =
            rChartRange.maRanges.begin();
        DBG_ASSERT( iRange != rChartRange.maRanges.end(),
            "ConvertChartRangeForCalc: no SchCellRangeAddress vector" );
        for ( ; iRange != rChartRange.maRanges.end(); ++iRange )
        {
            const SchSingleCell& rAddr1 = iRange->maUpperLeft.maCells[0];
            const SchSingleCell& rAddr2 = iRange->maLowerRight.maCells[0];
            sal_Int32 nTab = iRange->mnTableNumber;
            if ( aRef.Len() )
                aRef += cTok;
            aRef += String::CreateFromInt32( nTab );
            // here ',' as TokenSep so old versions (<341/342) will ignore it
            aRef += ',';  aRef += String::CreateFromInt32( nTab );
            aRef += cTok; aRef += String::CreateFromInt32( rAddr1.mnColumn );
            aRef += cTok; aRef += String::CreateFromInt32( rAddr1.mnRow );
            aRef += cTok; aRef += String::CreateFromInt32( rAddr2.mnColumn );
            aRef += cTok; aRef += String::CreateFromInt32( rAddr2.mnRow );
            if ( aSheetNames.Len() )
                aSheetNames += cTok;
            aSheetNames += String( iRange->msTableName );
        }

        String aFlags = rChartRange.mbFirstRowContainsLabels ? '1' : '0';
        aFlags += rChartRange.mbFirstColumnContainsLabels ? '1' : '0';
#if 0
/* these can't be stored, automatically recalculated after load by old versions
        aFlags += bDummyUpperLeft ? '1' : '0';
        aFlags += cTok;
        aFlags += String::CreateFromInt32( eGlue );
        aFlags += cTok;
        aFlags += String::CreateFromInt32( nStartCol );
        aFlags += cTok;
        aFlags += String::CreateFromInt32( nStartRow );
*/
#endif

        SomeData1() = aRef;
        SomeData2() = aFlags;
        SomeData3() = aSheetNames;
    }
}
