/*************************************************************************
 *
 *  $RCSfile: OfficeScriptInfo.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/10/22 14:14:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


package org.mozilla.javascript.tools.debugger;
import java.net.URL;
import java.util.Hashtable;
import org.mozilla.javascript.Scriptable;

public class OfficeScriptInfo
{
    private Hashtable loadedSFScripts = new Hashtable();
   
    public void addScript( URL url, Scriptable scope, Runnable closeCallback )
    {
        addScript( url.toString(), url, scope, closeCallback );
    }

    public void addScript( String key, URL url, Scriptable scope, Runnable closeCallback )
    {
        SFScriptInfo si = (SFScriptInfo)loadedSFScripts.get( key );
        if ( si == null )
        {
            si = new SFScriptInfo();
            si.url = url;
            si.scope = scope; 
            si.closeCallback = closeCallback; 
            loadedSFScripts.put( key, si );
        }  
    }   

    public void deleteScript( String key )
    {
        SFScriptInfo info = (SFScriptInfo)loadedSFScripts.remove( key );
        if ( info != null )
        {
            if ( info.closeCallback != null )
            {
                System.out.println("** In removeSFScriptInfo  have callback for " + key );
                info.closeCallback.run(); // really need to do this in seperate thread????
            }
        }
    }

    public Scriptable getScriptScope( String key )
    {
        Scriptable result = null;
        SFScriptInfo info = (SFScriptInfo)loadedSFScripts.get( key );
        if ( info != null )
        {
            result = info.scope;
        }
        return result;
    } 
  
    public URL getScriptUrl( String key )
    {
        URL result = null;
        SFScriptInfo info = (SFScriptInfo)loadedSFScripts.get( key );
        if ( info != null )
        {
            result = info.url;
        }
        return result;
    } 
    public boolean hasScript( String key )
    {
        boolean result = true;
        SFScriptInfo info = (SFScriptInfo)loadedSFScripts.get( key );
        if ( info == null )
        {
            result = false;
        }      
        return result;
    } 

    public void setScriptRunning( String key, boolean running )
    {
        SFScriptInfo info = (SFScriptInfo)loadedSFScripts.get( key );
        if ( info != null )
        {
            info.isExecuting = running;
        }
    }

    public boolean isScriptRunning( String key )
    {
        boolean result = false;
        SFScriptInfo info = (SFScriptInfo)loadedSFScripts.get( key );
        if ( info != null )
        {
            result = info.isExecuting;
        }
        return result;
    }

    
  
    class SFScriptInfo
    {
        Scriptable scope;
        boolean isExecuting;
        URL url;
        Runnable closeCallback;
    }
}
