/*************************************************************************
 *
 *  $RCSfile: documentproperties.cxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: rt $ $Date: 2004/09/08 14:11:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef	__FRAMEWORK_SERVICES_DOCUMENTPROPERTIES_HXX_
#include <services/documentproperties.hxx>
#endif

#ifndef __FRAMEWORK_HELPER_XMLDOCPROPERTIES_HXX_
#include <helper/xmldocproperties.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#ifndef _SOT_EXCHANGE_HXX
#include <sot/exchange.hxx>
#endif

#ifndef _CPPUHELPER_PROPTYPEHLP_HXX
#include <cppuhelper/proptypehlp.hxx>
#endif

#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _TOOLS_TENCCVT_HXX
#include <tools/tenccvt.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::std							;
using namespace ::osl							;
using namespace ::rtl							;
using namespace ::cppu							;
using namespace ::com::sun::star::uno			;
using namespace ::com::sun::star::lang			;
using namespace ::com::sun::star::beans			;
using namespace ::com::sun::star::util			;
using namespace ::com::sun::star::container		;
using namespace ::com::sun::star::io			;
using namespace ::com::sun::star::xml::sax		;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

// Handles for properties
// (PLEASE SORT THIS FIELD, IF YOU ADD NEW PROPERTIES!)
// We use an enum to define these handles, to use all numbers from 0 to nn and
// if you add someone, you don't must control this!
// But don't forget to change values of follow defines, if you do something with this enum!
enum EPROPERTIES
{
	HANDLE_AUTHOR					,
	HANDLE_AUTOLOADENABLED			,
	HANDLE_AUTOLOADSECS				,
	HANDLE_AUTOLOADURL				,
	HANDLE_BLINDCOPIESTO			,
	HANDLE_COPIESTO					,
	HANDLE_CREATIONDATE				,
	HANDLE_DEFAULTTARGET			,
	HANDLE_DESCRIPTION				,
	HANDLE_EDITINGCYCLES			,
	HANDLE_EDITINGDURATION			,
	HANDLE_EXTRADATA				,
	HANDLE_INREPLYTO				,
	HANDLE_ISENCRYPTED				,
	HANDLE_KEYWORDS			   		,
	HANDLE_MIMETYPE					,
	HANDLE_MODIFIEDBY				,
	HANDLE_MODIFYDATE				,
	HANDLE_NEWSGROUPS				,
	HANDLE_ORIGINAL					,
	HANDLE_PORTABLEGRAPHICS         ,
	HANDLE_PRINTDATE				,
	HANDLE_PRINTEDBY				,
	HANDLE_PRIORITY					,
	HANDLE_QUERYTEMPLATE            ,
	HANDLE_RECIPIENT				,
	HANDLE_REFERENCES				,
	HANDLE_REPLYTO					,
	HANDLE_SAVEGRAPHICSCOMPRESSED   ,
	HANDLE_SAVEORIGINALGRAPHICS     ,
	HANDLE_SAVEVERSIONONCLOSE       ,
	HANDLE_TEMPLATE					,
	HANDLE_TEMPLATECONFIG           ,
	HANDLE_TEMPLATEFILENAME			,
	HANDLE_TEMPLATEDATE				,
	HANDLE_THEME					,
	HANDLE_TITLE					,
	HANDLE_USERDATA
};

#define	MIN_PROPERTIES							HANDLE_AUTHOR									// Must be the number of first handle !!!
#define	MAX_PROPERTIES							HANDLE_USERDATA									// Must be the number of last  handle !!!
#define	PROPERTYCOUNT							(MAX_PROPERTIES+1)								// Count of properties (+1, while based on 0!)
#define	HEADERNAME								DECLARE_ASCII("SfxDocumentInfo")				// Typename of fileheader
#define	SLOTNAME								DECLARE_ASCII("SfxDocumentInfo")				// Name of documentinfo-stream in file
#define	STREAMENCODING							RTL_TEXTENCODING_MS_1252
#define	META_XML								DECLARE_ASCII("meta.xml")						// Name of xml documentinfo-stream in file

// Some default values for internal variables
#define	DEFAULT_HEADERTYPE						HEADERNAME
#define	DEFAULT_HEADERVERSION					11
#define DEFAULT_FILEVERSION                     SOFFICE_FILEFORMAT_50
#define	DEFAULT_FORMATID						0

// All default values for properties
#define	DEFAULT_AUTHOR							OUString()
#define	DEFAULT_AUTOLOADENABLED					sal_False
#define	DEFAULT_AUTOLOADSECS					60
#define	DEFAULT_AUTOLOADURL						OUString()
#define	DEFAULT_BLINDCOPIESTO					OUString()
#define	DEFAULT_COPIESTO						OUString()
#define	DEFAULT_DEFAULTTARGET					OUString()
#define	DEFAULT_DESCRIPTION						OUString()
#define	DEFAULT_EDITINGCYCLES					0
#define	DEFAULT_EDITINGDURATION					0
#define	DEFAULT_INREPLYTO						OUString()
#define	DEFAULT_ISENCRYPTED						sal_True
#define	DEFAULT_KEYWORDS						OUString()
#define	DEFAULT_MIMETYPE						OUString()
#define	DEFAULT_MODIFIEDBY						OUString()
#define	DEFAULT_NEWSGROUPS						OUString()
#define	DEFAULT_ORIGINAL						OUString()
#define	DEFAULT_PORTABLEGRAPHICS				sal_True
#define	DEFAULT_PRINTEDBY						OUString()
#define	DEFAULT_PRIORITY						0
#define	DEFAULT_QUERYTEMPLATE					sal_True
#define	DEFAULT_RECIPIENT						OUString()
#define	DEFAULT_REFERENCES						OUString()
#define	DEFAULT_REPLYTO							OUString()
#define	DEFAULT_SAVEGRAPHICSCOMPRESSED			sal_True
#define	DEFAULT_SAVEORIGINALGRAPHICS			sal_True
#define	DEFAULT_SAVEVERSIONONCLOSE				sal_True
#define	DEFAULT_TEMPLATE						OUString()
#define	DEFAULT_TEMPLATECONFIG					sal_True
#define	DEFAULT_TEMPLATEFILENAME				OUString()
#define	DEFAULT_THEME							OUString()
#define	DEFAULT_TITLE							OUString()
#define	DEFAULT_USERDATA						sal_True
#define	DEFAULT_EXTRADATA						Sequence< sal_Int8 >()

// Some properties have a fixed size in file ...
#define FIXSIZE_TITLE							63
#define FIXSIZE_THEME							63
#define FIXSIZE_DESCRIPTION						255
#define FIXSIZE_KEYWORDS						127
#define FIXSIZE_DOCUSERKEY						19
#define	MAXCOUNT_DOCUSERKEYS					4

//______________________________________________________________________________________________________________
//	switches
//	Use these to de/activate some features of this implementation.
//	(for debugging or testing!)
//______________________________________________________________________________________________________________

// de/activate permanently testing of stream
//#define	DOCUMENTPROPERTIES_SWITCH_ON_CHECK_SVSTREAM

// Read user specified properties.
// We cant use this place! Namecontainer can have more then 4 elements.
// And size of everyone can be greater then 19 letters.
// We can do the follow:
//		1)	Truncate first 4 items of namecontainer to right size and
//			write it to this place. All other properties will be saved
//			later at the end of header!
//		2)	Search for 4 items of namecontainer, which have right size!
//			But performance wil be low...
//		3)  Let this place free and unused! Save ALL properties
//			later at the end of header! We loose 152 bytes only ...
// We use option 1) yet!
#define	ENABLE_PROPERTY_RESTRICTION

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

// This struct handle a mimetype- and a fileversion-value and is used
// at follow static convert table.
// (see "aStaticConvertTable[]" using too)

struct tIMPL_ConverterItem
{
	OUString	sMIMEType		;
	sal_Int32	nFileVersion	;

	tIMPL_ConverterItem(	const	OUString&	sNewMIMEType	,
									sal_Int32	nNewFileVersion	)
			:	sMIMEType		( sNewMIMEType		)
			,	nFileVersion	( nNewFileVersion	)
	{
	}
};

// Follow struct is used to convert FormatID to MIMEType and/or version of file!
// (FormatID is the index in table.)

// All values are sorted by ID. Every ID is ID from predecessor + 1.
// We use this to find right value in table without string compare.
// If one item has no MIMEType or version, use an empty-string and SOFFICE_FILEFORMAT_50 as defaults.
// Its necessary to use ID directly as index in table.
// If you delete some lines with default-members, this algorithm will be get invalid results...!!!

static const tIMPL_ConverterItem aStaticConvertTable[] =
{
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	  0	SOT_FORMAT_SYSTEM_START							""
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	  1	SOT_FORMAT_STRING								"Text"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	  2	SOT_FORMAT_BITMAP								"Bitmap"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	  3	SOT_FORMAT_GDIMETAFILE							"GDIMetaFile"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	  4	SOT_FORMAT_PRIVATE								"Private"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	  5	SOT_FORMAT_FILE									"FileName"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	  6	SOT_FORMAT_FILE_LIST							"FileList"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	  7	EMPTY											""
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	  8	EMPTY											""
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	  9	EMPTY											""
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 10	SOT_FORMAT_RTF									"Rich Text Format"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 11	SOT_FORMATSTR_ID_DRAWING						"StarOffice Drawing Format"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 12	SOT_FORMATSTR_ID_SVXB							"SVXB (StarView Bitmap/Animation)"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 13	SOT_FORMATSTR_ID_SVIM							"SVIM (StarView ImageMap)"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 14	SOT_FORMATSTR_ID_XFA							"XFA (XOutDev FillAttr)"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 15	SOT_FORMATSTR_ID_EDITENGINE						"EditEngineFormat"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 16	SOT_FORMATSTR_ID_INTERNALLINK_STATE				"StatusInfo vom SvxInternalLink"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 17	SOT_FORMATSTR_ID_SOLK							"SOLK (StarOffice Link)"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 18	SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK				"Netscape Bookmark"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 19	SOT_FORMATSTR_ID_TREELISTBOX					"SV_LBOX_DD_FORMAT"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 20	SOT_FORMATSTR_ID_NATIVE							"Native"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 21	SOT_FORMATSTR_ID_OWNERLINK						"OwnerLink"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 22	SOT_FORMATSTR_ID_STARSERVER						"StarServerFormat"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 23	SOT_FORMATSTR_ID_STAROBJECT						"StarObjectFormat"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 24	SOT_FORMATSTR_ID_APPLETOBJECT					"Applet Object"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 25	SOT_FORMATSTR_ID_PLUGIN_OBJECT					"PlugIn Object"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starwriter"					)	,SOFFICE_FILEFORMAT_31	),	//	 26	SOT_FORMATSTR_ID_STARWRITER_30					"StarWriter 3.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starwriter"					)	,SOFFICE_FILEFORMAT_40	),	//	 27	SOT_FORMATSTR_ID_STARWRITER_40					"StarWriter 4.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/vnd.stardivision.writer"		)	,SOFFICE_FILEFORMAT_50	),	//	 28	SOT_FORMATSTR_ID_STARWRITER_50					"StarWriter 5.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starwriter/web"				)	,SOFFICE_FILEFORMAT_40	),	//	 29	SOT_FORMATSTR_ID_STARWRITERWEB_40				"StarWriter/Web 4.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/vnd.stardivision.writer/web"	)	,SOFFICE_FILEFORMAT_50	),	//	 30	SOT_FORMATSTR_ID_STARWRITERWEB_50				"StarWriter/Web 5.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starwriter"					)	,SOFFICE_FILEFORMAT_40	),	//	 31	SOT_FORMATSTR_ID_STARWRITERGLOB_40				"StarWriter/Global 4.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/vnd.stardivision.writer-global"	)	,SOFFICE_FILEFORMAT_50	),	//	 32	SOT_FORMATSTR_ID_STARWRITERGLOB_50				"StarWriter/Global 5.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-stardraw"						)	,SOFFICE_FILEFORMAT_40	),	//	 33	SOT_FORMATSTR_ID_STARDRAW						"StarDrawDocument"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starimpress"					)	,SOFFICE_FILEFORMAT_40	),	//	 34	SOT_FORMATSTR_ID_STARDRAW_40					"StarDrawDocument 4.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/vnd.stardivision.impress"		)	,SOFFICE_FILEFORMAT_50	),	//	 35	SOT_FORMATSTR_ID_STARIMPRESS_50					"StarImpress 5.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/vnd.stardivision.draw"			)	,SOFFICE_FILEFORMAT_50	),	//	 36	SOT_FORMATSTR_ID_STARDRAW_50					"StarDraw 5.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starcalc"						)	,SOFFICE_FILEFORMAT_31	),	//	 37	SOT_FORMATSTR_ID_STARCALC						"StarCalcDocument"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starcalc"						)	,SOFFICE_FILEFORMAT_40	),	//	 38	SOT_FORMATSTR_ID_STARCALC_40					"StarCalc 4.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/vnd.stardivision.calc"			)	,SOFFICE_FILEFORMAT_50	),	//	 39	SOT_FORMATSTR_ID_STARCALC_50					"StarCalc 5.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starchart"					)	,SOFFICE_FILEFORMAT_31	),	//	 40	SOT_FORMATSTR_ID_STARCHART						"StarChartDocument"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starchart"					)	,SOFFICE_FILEFORMAT_40	),	//	 41	SOT_FORMATSTR_ID_STARCHART_40					"StarChartDocument 4.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/vnd.stardivision.chart"			)	,SOFFICE_FILEFORMAT_50	),	//	 42	SOT_FORMATSTR_ID_STARCHART_50					"StarChart 5.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starimage"					)	,SOFFICE_FILEFORMAT_31	),	//	 43	SOT_FORMATSTR_ID_STARIMAGE						"StarImageDocument"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starimage"					)	,SOFFICE_FILEFORMAT_40	),	//	 44	SOT_FORMATSTR_ID_STARIMAGE_40					"StarImageDocument 4.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starimage"					)	,SOFFICE_FILEFORMAT_50	),	//	 45	SOT_FORMATSTR_ID_STARIMAGE_50					"StarImage 5.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starmath"						)	,SOFFICE_FILEFORMAT_31	),	//	 46	SOT_FORMATSTR_ID_STARMATH						"StarMath"
	tIMPL_ConverterItem( DECLARE_ASCII("application/x-starmath"						)	,SOFFICE_FILEFORMAT_40	),	//	 47	SOT_FORMATSTR_ID_STARMATH_40					"StarMathDocument 4.0"
	tIMPL_ConverterItem( DECLARE_ASCII("application/vnd.stardivision.math"			)	,SOFFICE_FILEFORMAT_50	),	//	 48	SOT_FORMATSTR_ID_STARMATH_50					"StarMath 5.0"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 49	SOT_FORMATSTR_ID_STAROBJECT_PAINTDOC			"StarObjectPaintDocument"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 50	SOT_FORMATSTR_ID_FILLED_AREA					"FilledArea"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 51	SOT_FORMATSTR_ID_HTML							"HTML (HyperText Markup Language)"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 52	SOT_FORMATSTR_ID_HTML_SIMPLE					"HTML Format"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 53	SOT_FORMATSTR_ID_CHAOS							"FORMAT_CHAOS"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 54	SOT_FORMATSTR_ID_CNT_MSGATTACHFILE				"CNT_MSGATTACHFILE_FORMAT"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 55	SOT_FORMATSTR_ID_BIFF_5							"Biff5"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 56	SOT_FORMATSTR_ID_BIFF__5						"Biff 5"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 57	SOT_FORMATSTR_ID_SYLK							"Sylk"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 58	SOT_FORMATSTR_ID_SYLK_BIGCAPS					"SYLK"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 59	SOT_FORMATSTR_ID_LINK							"Link"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 60	SOT_FORMATSTR_ID_DIF							"DIF"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 61	SOT_FORMATSTR_ID_STARDRAW_TABBAR				"StarDraw TabBar"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 62	SOT_FORMATSTR_ID_SONLK							"SONLK (StarOffice Navi Link)"
	tIMPL_ConverterItem( DECLARE_ASCII("application/msword"							)	,DEFAULT_FILEVERSION	),	//	 63	SOT_FORMATSTR_ID_MSWORD_DOC						"MSWordDoc"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 64	SOT_FORMATSTR_ID_STAR_FRAMESET_DOC				"StarFrameSetDocument"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 65	SOT_FORMATSTR_ID_OFFICE_DOC						"OfficeDocument"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 66	SOT_FORMATSTR_ID_NOTES_DOCINFO					"NotesDocInfo"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 67	SOT_FORMATSTR_ID_NOTES_HNOTE					"NoteshNote"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 68	SOT_FORMATSTR_ID_NOTES_NATIVE					"Native"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 69	SOT_FORMATSTR_ID_SFX_DOC						"SfxDocument"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 70	SOT_FORMATSTR_ID_EVDF							"EVDF (Explorer View Dummy Format)"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 71	SOT_FORMATSTR_ID_ESDF							"ESDF (Explorer Search Dummy Format)"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 72	SOT_FORMATSTR_ID_IDF							"IDF (Iconview Dummy Format)"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 73	SOT_FORMATSTR_ID_EFTP							"EFTP (Explorer Ftp File)"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 74	SOT_FORMATSTR_ID_EFD							"EFD (Explorer Ftp Dir)"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 75	SOT_FORMATSTR_ID_SVX_FORMFIELDEXCH				"SvxFormFieldExch"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 76	SOT_FORMATSTR_ID_EXTENDED_TABBAR				"ExtendedTabBar"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 77	SOT_FORMATSTR_ID_SBA_DATAEXCHANGE				"SBA-DATAFORMAT"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 78	SOT_FORMATSTR_ID_SBA_FIELDDATAEXCHANGE			"SBA-FIELDFORMAT"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 79	SOT_FORMATSTR_ID_SBA_PRIVATE_URL				"SBA-PRIVATEURLFORMAT"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 80	SOT_FORMATSTR_ID_SBA_TABED						"Tabed"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 81	SOT_FORMATSTR_ID_SBA_TABID						"Tabid"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 82	SOT_FORMATSTR_ID_SBA_JOIN						"SBA-JOINFORMAT"
/*#ifdef MAC
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 83	SOT_FORMATSTR_ID_OBJECTDESCRIPTOR				"Star OBJD"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 84	SOT_FORMATSTR_ID_LINKSRCDESCRIPTOR				"Star LKSD"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 85	SOT_FORMATSTR_ID_EMBED_SOURCE					"Star EMBS"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 86	SOT_FORMATSTR_ID_LINK_SOURCE					"Star LNKS"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 87	SOT_FORMATSTR_ID_EMBEDDED_OBJ					"Star EMBO"
#else*/
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 83	SOT_FORMATSTR_ID_OBJECTDESCRIPTOR				"Star Object Descriptor"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 84	SOT_FORMATSTR_ID_LINKSRCDESCRIPTOR				"Star Link Source Descriptor"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 85	SOT_FORMATSTR_ID_EMBED_SOURCE					"Star Embed Source"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 86	SOT_FORMATSTR_ID_LINK_SOURCE					"Star Link Source"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 87	SOT_FORMATSTR_ID_EMBEDDED_OBJ					"Star Embedded Object"
//#endif
/*#ifdef WNT
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 88	SOT_FORMATSTR_ID_FILECONTENT					CFSTR_FILECONTENTS
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 89	SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR				CFSTR_FILEDESCRIPTOR
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 90	SOT_FORMATSTR_ID_FILENAME						CFSTR_FILENAME
#else*/
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 88	SOT_FORMATSTR_ID_FILECONTENT					"FileContents"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 89	SOT_FORMATSTR_ID_FILEGRPDESCRIPTOR				"FileGroupDescriptor"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 90	SOT_FORMATSTR_ID_FILENAME						"FileName"
//#endif
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 91	SOT_FORMATSTR_ID_SD_OLE							"SD-OLE"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 92	SOT_FORMATSTR_ID_EMBEDDED_OBJ_OLE				"Embedded Object"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 93	SOT_FORMATSTR_ID_EMBED_SOURCE_OLE				"Embed Source"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 94	SOT_FORMATSTR_ID_OBJECTDESCRIPTOR_OLE			"Object Descriptor"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 95	SOT_FORMATSTR_ID_LINKSRCDESCRIPTOR_OLE			"Link Source Descriptor"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 96	SOT_FORMATSTR_ID_LINK_SOURCE_OLE				"Link Source"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 97	SOT_FORMATSTR_ID_SBA_CTRLDATAEXCHANGE			"SBA-CTRLFORMAT"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 98	SOT_FORMATSTR_ID_OUTPLACE_OBJ					"OutPlace Object"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	 99	SOT_FORMATSTR_ID_CNT_OWN_CLIP					"CntOwnClipboard"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	100	SOT_FORMATSTR_ID_INET_IMAGE						"SO-INet-Image"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	101	SOT_FORMATSTR_ID_NETSCAPE_IMAGE					"Netscape Image Format"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	102	SOT_FORMATSTR_ID_SBA_FORMEXCHANGE				"SBA_FORMEXCHANGE"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	103	SOT_FORMATSTR_ID_SBA_REPORTEXCHANGE				"SBA_REPORTEXCHANGE"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	104	SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR			"UniformResourceLocator"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	105	SOT_FORMATSTR_ID_STARCHARTDOCUMENT_50			"StarChartDocument 5.0"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	106	SOT_FORMATSTR_ID_GRAPHOBJ						"Graphic Object"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	),	//	107	SOT_FORMATSTR_ID_DUMMY3							"SO_DUMMYFORMAT_3"
	tIMPL_ConverterItem( DEFAULT_MIMETYPE												,DEFAULT_FILEVERSION	)	//	108	SOT_FORMATSTR_ID_DUMMY4							"SO_DUMMYFORMAT_4"
};

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
DocumentProperties::DocumentProperties( const Reference< XMultiServiceFactory >& xFactory )
		// Init baseclasses first
		//	Attention:
		//		Don't change order of initialization!
		//      IMPL_OMutexContainer is a struct with a mutex as member. We can't use a mutex as member, while
		//		we must garant right initialization and a valid value of this! First initialize
		//		baseclasses and then members. And we need the mutex for other baseclasses !!!
        :   ThreadHelpBase          ( &Application::GetSolarMutex()                     )
        ,   OBroadcastHelper        ( m_aLock.getShareableOslMutex()                    )
		,	OPropertySetHelper		( *SAL_STATIC_CAST( OBroadcastHelper *, this )		)
		,	OWeakObject				(													)
		// Init member variables
		,	m_xFactory				( xFactory											)
		,	m_aPropertyHash			(													)
{
	// Set default values on members and clear some structures.
	impl_resetObject();
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
DocumentProperties::~DocumentProperties()
{
	// Clear memory!
	m_aPropertyHash.clear();
	m_aFixedProperties.m_seqExtraData = Sequence< sal_Int8 >();
}

//*****************************************************************************************************************
//	XInterface, XTypeProvider, XServiceInfo
//*****************************************************************************************************************
DEFINE_XINTERFACE_10				(	DocumentProperties						,
										OWeakObject								,
										DIRECT_INTERFACE(XTypeProvider			),
										DIRECT_INTERFACE(XServiceInfo			),
										DIRECT_INTERFACE(XPersist				),
										DIRECT_INTERFACE(XNameContainer			),
										DIRECT_INTERFACE(XNameReplace			),
										DIRECT_INTERFACE(XNameAccess			),
										DIRECT_INTERFACE(XElementAccess			),
										DIRECT_INTERFACE(XPropertySet			),
										DIRECT_INTERFACE(XFastPropertySet		),
										DIRECT_INTERFACE(XMultiPropertySet		)
									)

DEFINE_XTYPEPROVIDER_10				(	DocumentProperties						,
										XTypeProvider							,
										XServiceInfo							,
										XPersist								,
										XNameContainer							,
										XNameReplace							,
										XNameAccess								,
										XElementAccess							,
										XPropertySet							,
										XFastPropertySet						,
										XMultiPropertySet
									)

DEFINE_XSERVICEINFO_MULTISERVICE	(	DocumentProperties						,
                                        OWeakObject                             ,
										SERVICENAME_DOCUMENTPROPERTIES			,
										IMPLEMENTATIONNAME_DOCUMENTPROPERTIES
									)

DEFINE_INIT_SERVICE                 (   DocumentProperties,
                                        {
                                        }
                                    )

//******************************************************************************************************************************
//	XPersist
//******************************************************************************************************************************
void SAL_CALL DocumentProperties::read( const OUString& sURL ) throw(	IOException			,
																		RuntimeException	)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter.
	LOG_ASSERT( impldbg_checkParameter_read( sURL ), "DocumentProperties::read()\nInvalid parameter detected.\n" )

	// We can't work without a valid URL!
	// It must be a valid storage file.
	if( SotStorage::IsStorageFile( sURL ) == sal_False )
	{
		throw IOException( DECLARE_ASCII("DocumentProperties::read()\nGiven URL isn't a valid storage!\n"), static_cast< OWeakObject* >( this ) );
	}

	// Open storage for given URL.
	// Open a stream to storage.
    SotStorageRef xStorage = new SotStorage( sURL, STREAM_STD_READ );
	SotStorageStreamRef xStream;

	if ( xStorage->IsOLEStorage() )
		xStream = xStorage->OpenSotStream( SLOTNAME, STREAM_STD_READ );
	else
		xStream = xStorage->OpenSotStream( META_XML, STREAM_STD_READ );

	// If stream not open ...
	// we can't work!
    if( !xStream.Is() || xStream->GetError() )
	{
		throw IOException( DECLARE_ASCII("DocumentProperties::read()\nCould not open storage!\n"), static_cast< OWeakObject* >( this ) );
	}

	// a) Set default values for properties!
	// b) Get FormatID of storage ...
	//    This value is used in "impl_readProperties()" to set right MIMEType, if not exist in document!
	// c) Load properties from stream
	//    This can throw an IO- or RuntimeException!
	impl_resetObject();
    m_nFormatID = xStorage->GetFormat();
	if ( xStorage->IsOLEStorage() )
		impl_readProperties( *xStream );
	else
		impl_readXMLProperties( *xStream );

	Any a;
	if ( xStorage->GetProperty( String::CreateFromAscii( "MediaType" ), a ))
	{
		OUString aTmp;
		if ( a >>= aTmp )
			m_aFixedProperties.m_sMIMEType = aTmp;
	}

	// Don't close storage!
	// SotStorage do that for us ...
}

//******************************************************************************************************************************
//	XPersist
//******************************************************************************************************************************
void SAL_CALL DocumentProperties::write( const OUString& sURL ) throw(	IOException			,
																		RuntimeException	)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter.
	LOG_ASSERT( impldbg_checkParameter_read( sURL ), "DocumentProperties::write()\nInvalid parameter detected.\n" )

	// We can't work without a valid URL!
	// It must be a valid storage file.
	if( SotStorage::IsStorageFile( sURL ) == sal_False )
	{
		throw IOException( DECLARE_ASCII("DocumentProperties::write()\nGiven URL isn't a valid storage!\n"), static_cast< OWeakObject* >( this ) );
	}

	// Open storage for given URL.
	// Open a stream to storage.
    SotStorageRef xStorage = new SotStorage( sURL, STREAM_STD_READWRITE );
	SotStorageStreamRef xStream;

	if ( xStorage->IsOLEStorage() )
		xStream = xStorage->OpenSotStream( SLOTNAME, STREAM_STD_READWRITE );
	else
	{
		throw IOException( DECLARE_ASCII("DocumentProperties::write()\nXML format not yet implemented!\n"), static_cast< OWeakObject* >( this ) );
	}

	// If stream not open ...
	// we can't work!
    if( !xStream.Is() || xStream->GetError() )
	{
		throw IOException( DECLARE_ASCII("DocumentProperties::write()\nCould not open storage!\n"), static_cast< OWeakObject* >( this ) );
	}

	// a) Get FormatID of storage ...
	//    This value is used in "impl_writeProperties()" to set right MIMEType!
	// b) Write properties to stream.
	//    This can throw an IO- or RuntimeException!
    m_nFormatID = xStorage->GetFormat();
    impl_writeProperties( *xStream );

	// Flush written properties!!!
	// If it failed throw an exception.
    if( xStorage->Commit() == sal_False )
	{
		throw IOException( DECLARE_ASCII("DocumentProperties::write()\nCould not commit data!\n"), static_cast< OWeakObject* >( this ) );
	}

	// Don't close storage!
	// SotStorage do that for us ...
}

//******************************************************************************************************************************
//	XNameContainer
//******************************************************************************************************************************
void SAL_CALL DocumentProperties::insertByName(	const	OUString&	sName	,
												const	Any&		aValue	) throw(	IllegalArgumentException	,
																						ElementExistException		,
																						WrappedTargetException		,
																						RuntimeException			)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter. ( NULL-pointer!)
	LOG_ASSERT( impldbg_checkParameter_insertByName( sName, aValue ), "DocumentProperties::insertByName()\nInvalid parameter detected.\n" )

	// Check incoming parameter.
	if	(
			( sName.getLength()				<	1					)	||
			( aValue.hasValue()				==	sal_False			)	||
			( aValue.getValueTypeClass()	!=	TypeClass_STRING	)
		)
	{
		throw IllegalArgumentException( DECLARE_ASCII("DocumentProperties::insertByName()\nEmpty name or invalid value detected.\n"), static_cast< OWeakObject* >( this ), 0 );
	}

	// Search for existing element with same name!
	// If element already exist throw an exception.
	if( m_aPropertyHash.find( sName ) != m_aPropertyHash.end() )
	{
		throw ElementExistException( DECLARE_ASCII("DocumentProperties::insertByName()\nElement alrady exist!\n"), static_cast< OWeakObject* >( this ) );
	}

	// Element doesn't exist at this point.
	// Extract value of new property before. Type must be [string]!
	OUString sValue;
	aValue >>= sValue;

/* #106821#
	// Attention: Size of namecontainer-properties is fixed to 19 letters in file :-(
	// Throw an exception, if values are greater!
	if	(
			( sName.getLength()		>	FIXSIZE_DOCUSERKEY	)	||
			( sValue.getLength()	>	FIXSIZE_DOCUSERKEY	)
		)
	{
		throw IllegalArgumentException( DECLARE_ASCII("DocumentProperties::insertByName()\nCan't handle property names and values greater then 19 letters!\n"), static_cast< OWeakObject* >( this ), 0 );
	}
*/
    LOG_ASSERT(((sName.getLength()<=FIXSIZE_DOCUSERKEY) && (sValue.getLength()<=FIXSIZE_DOCUSERKEY)),"DocumentProperties::insertByName()\nCan't handle property names and values greater then 19 letters!\n")

	// Put value in hashtable. Use name as key.
	m_aPropertyHash[ sName ] = sValue;
}

//******************************************************************************************************************************
//	XNameContainer
//******************************************************************************************************************************
void SAL_CALL DocumentProperties::removeByName( const OUString& sName ) throw(	NoSuchElementException	,
																				WrappedTargetException	,
																				RuntimeException		)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter. ( NULL-pointer!)
	LOG_ASSERT( impldbg_checkParameter_removeByName( sName ), "DocumentProperties::removeByName()\nInvalid parameter detected.\n" )

	// Search for existing element with same name!
	if( m_aPropertyHash.find( sName ) == m_aPropertyHash.end() )
	{
		throw NoSuchElementException( DECLARE_ASCII("DocumentProperties::removeByName()\nProperty not exist!\n"), static_cast< OWeakObject* >( this ) );
	}

	// Else ... remove element from hash.
	m_aPropertyHash.erase( sName );
}

//******************************************************************************************************************************
//	XNameReplace
//******************************************************************************************************************************
void SAL_CALL DocumentProperties::replaceByName(	const	OUString&	sName	,
													const	Any&		aValue	) throw(	IllegalArgumentException	,
																							NoSuchElementException		,
																							WrappedTargetException		,
																							RuntimeException			)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter. ( NULL-pointer!)
	LOG_ASSERT( impldbg_checkParameter_replaceByName( sName, aValue ), "DocumentProperties::replaceByName()\nInvalid parameter detected.\n" )

	// Check incoming parameter.
	if	(
			( sName.getLength()				<	1					)	||
			( aValue.hasValue()				==	sal_False			)	||
			( aValue.getValueTypeClass()	!=	TypeClass_STRING	)
		)
	{
		throw IllegalArgumentException( DECLARE_ASCII("DocumentProperties::replaceByName()\nEmpty name or invalid value detected.\n"), static_cast< OWeakObject* >( this ), 0 );
	}

	// Search for existing element with same name!
	// If element not exist throw an exception.
	if( m_aPropertyHash.find( sName ) == m_aPropertyHash.end() )
	{
		throw NoSuchElementException( DECLARE_ASCII("DocumentProperties::replaceByName()\nElement not exist!\n"), static_cast< OWeakObject* >( this ) );
	}

	// Element exist at this point.
	// Extract value of new property. Type must be [string]!
	OUString sValue;
	aValue >>= sValue;

/*#106821#
    // Attention: Size of namecontainer-properties is fixed to 19 letters in file :-(
	// Throw an exception, if values are greater!
	if	(
			( sName.getLength()		>	FIXSIZE_DOCUSERKEY	)	||
			( sValue.getLength()	>	FIXSIZE_DOCUSERKEY	)
		)
	{
		throw IllegalArgumentException( DECLARE_ASCII("DocumentProperties::replaceByName()\nCan't handle property names and values greater then 19 letters!\n"), static_cast< OWeakObject* >( this ), 0 );
	}
*/
    LOG_ASSERT(((sName.getLength()<=FIXSIZE_DOCUSERKEY) && (sValue.getLength()<=FIXSIZE_DOCUSERKEY)),"DocumentProperties::replaceByName()\nCan't handle property names and values greater then 19 letters!\n")

	// Set new value.
	m_aPropertyHash[ sName ] = sValue;
}

//******************************************************************************************************************************
//	XNameAccess
//******************************************************************************************************************************
Any SAL_CALL DocumentProperties::getByName( const OUString& sName ) throw(	NoSuchElementException	,
																			WrappedTargetException	,
																			RuntimeException		)
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter. ( NULL-pointer!)
	LOG_ASSERT( impldbg_checkParameter_getByName( sName ), "DocumentProperties::replaceByName()\nInvalid parameter detected.\n" )

	// Search for existing element with same name!
	if( m_aPropertyHash.find( sName ) == m_aPropertyHash.end() )
	{
		throw NoSuchElementException( DECLARE_ASCII("DocumentProperties::getByName()\nProperty not exist!\n"), static_cast< OWeakObject* >( this ) );
	}

	// Else ... return value.
	Any aValue;
	aValue <<= m_aPropertyHash[ sName ];
	return aValue;
}

//******************************************************************************************************************************
//	XNameAccess
//******************************************************************************************************************************
Sequence< OUString > SAL_CALL DocumentProperties::getElementNames() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

	// Get count of elements in hashtable and initialize return list.
	sal_uInt32 nCount = (sal_uInt32)(m_aPropertyHash.size());
	Sequence< OUString > lNames( nCount );

	// Step over list and copy all names to return list.
	sal_uInt32 nEntry = 0;
	for( tIMPL_PropertyHashTable::iterator pEntry=m_aPropertyHash.begin(); pEntry!=m_aPropertyHash.end(); ++pEntry )
	{
		lNames[ nEntry ] = pEntry->first; // first=key=name! second=value
		++nEntry;
	}
	// Return sequence with all element names.
	return lNames;
}

//******************************************************************************************************************************
//	XNameAccess
//******************************************************************************************************************************
sal_Bool SAL_CALL DocumentProperties::hasByName( const OUString& sName ) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter. ( NULL-pointer!)
	LOG_ASSERT( impldbg_checkParameter_hasByName( sName ), "DocumentProperties::hasByName()\nInvalid parameter detected.\n" )

	return( m_aPropertyHash.find( sName ) != m_aPropertyHash.end() );
}

//******************************************************************************************************************************
//	XElementAccess
//******************************************************************************************************************************
Type SAL_CALL DocumentProperties::getElementType() throw( RuntimeException )
{
	return ::getCppuType( (const OUString*)0 );
}

//******************************************************************************************************************************
//	XElementAccess
//******************************************************************************************************************************
sal_Bool SAL_CALL DocumentProperties::hasElements() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	return( m_aPropertyHash.size() > 0 );
}

//******************************************************************************************************************************
//	OPropertySetHelper
//******************************************************************************************************************************
sal_Bool SAL_CALL DocumentProperties::convertFastPropertyValue(			Any&		aConvertedValue	,
																		Any&		aOldValue		,
																		sal_Int32	nHandle			,
																const	Any&		aValue			) throw( IllegalArgumentException )
{
	//	Check, if value of property will changed in method "setFastPropertyValue_NoBroadcast()".
	//	Return TRUE, if changed - else return FALSE.
	//	Attention: Method "impl_tryToChangeProperty()" can throw the IllegalArgumentException !!!
	//	Initialize return value with FALSE !!!
	//	(Handle can be invalid)
	sal_Bool bReturn = sal_False;

	switch( nHandle )
	{
		case	HANDLE_AUTHOR					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sAuthor					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_AUTOLOADENABLED			:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_bAutoloadEnabled			, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_AUTOLOADSECS				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_nAutoloadSecs				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_AUTOLOADURL				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sAutoloadURL				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_BLINDCOPIESTO			:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sBlindCopiesTo				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_COPIESTO					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sCopiesTo					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_CREATIONDATE				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_aCreationDate				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_DEFAULTTARGET			:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sDefaultTarget				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_DESCRIPTION				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sDescription				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_EDITINGCYCLES			:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_nEditingCycles				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_EDITINGDURATION			:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_nEditingDuration			, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_EXTRADATA				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_seqExtraData				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_INREPLYTO				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sInReplyTo					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_ISENCRYPTED				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_bIsEncrypted				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_KEYWORDS					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sKeywords					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_MIMETYPE					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sMIMEType					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_MODIFIEDBY				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sModifiedBy				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_MODIFYDATE				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_aModifyDate				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_NEWSGROUPS				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sNewsgroups				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_ORIGINAL					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sOriginal					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_PORTABLEGRAPHICS			:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_bPortableGraphics			, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_PRINTDATE				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_aPrintDate					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_PRINTEDBY				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sPrintedBy					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_PRIORITY					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_nPriority					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_QUERYTEMPLATE			:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_bQueryTemplate				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_RECIPIENT				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sRecipient					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_REFERENCES				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sReferences				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_REPLYTO					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sReplyTo					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_SAVEGRAPHICSCOMPRESSED	:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_bSaveGraphicsCompressed	, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_SAVEORIGINALGRAPHICS		:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_bSaveOriginalGraphics		, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_SAVEVERSIONONCLOSE		:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_bSaveVersionOnClose		, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_TEMPLATE					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sTemplate					, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_TEMPLATECONFIG			:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_bTemplateConfig			, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_TEMPLATEFILENAME			:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sTemplateFileName			, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_TEMPLATEDATE				:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_aTemplateDate				, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_THEME					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sTheme						, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_TITLE					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_sTitle						, aValue, aOldValue, aConvertedValue ) ;
													break;
		case	HANDLE_USERDATA					:	bReturn = impl_tryToChangeProperty( m_aFixedProperties.m_bUserData					, aValue, aOldValue, aConvertedValue ) ;
													break;
	}

	// Return state of operation.
	return bReturn;
}

//******************************************************************************************************************************
//	OPropertySetHelper
//******************************************************************************************************************************
void SAL_CALL DocumentProperties::setFastPropertyValue_NoBroadcast(			sal_Int32	nHandle	,
			  														const	Any&		aValue	) throw( Exception )
{
	// Search for right handle ... and try to set property value.
	switch( nHandle )
	{
		case	HANDLE_AUTHOR					:	aValue >>= m_aFixedProperties.m_sAuthor					;
				 									break ;
		case	HANDLE_AUTOLOADENABLED			:	aValue >>= m_aFixedProperties.m_bAutoloadEnabled   		;
				 									break;
		case	HANDLE_AUTOLOADSECS				:	aValue >>= m_aFixedProperties.m_nAutoloadSecs      		;
				 									break ;
		case	HANDLE_AUTOLOADURL				:	aValue >>= m_aFixedProperties.m_sAutoloadURL       		;
				 									break ;
		case	HANDLE_BLINDCOPIESTO			:	aValue >>= m_aFixedProperties.m_sBlindCopiesTo     		;
				 									break ;
		case	HANDLE_COPIESTO					:	aValue >>= m_aFixedProperties.m_sCopiesTo            	;
				 									break ;
		case	HANDLE_CREATIONDATE				:	aValue >>= m_aFixedProperties.m_aCreationDate      		;
				 									break ;
		case	HANDLE_DEFAULTTARGET			:	aValue >>= m_aFixedProperties.m_sDefaultTarget     		;
				 									break ;
		case	HANDLE_DESCRIPTION				:	aValue >>= m_aFixedProperties.m_sDescription       		;
				 									break ;
		case	HANDLE_EDITINGCYCLES			:	aValue >>= m_aFixedProperties.m_nEditingCycles     		;
				 									break ;
		case	HANDLE_EDITINGDURATION			:	aValue >>= m_aFixedProperties.m_nEditingDuration   		;
				 									break ;
		case	HANDLE_EXTRADATA				:	aValue >>= m_aFixedProperties.m_seqExtraData			;
				 									break ;
		case	HANDLE_INREPLYTO				:	LOG_ASSERT( sal_False, "DocumentProperties::setFastPropertyValue_NoBoradcast()\nYou can't set readonly property \"INREPLYTO\"!\n" )
				 									break ;
		case	HANDLE_ISENCRYPTED				:	aValue >>= m_aFixedProperties.m_bIsEncrypted       		;
				 									break ;
		case	HANDLE_KEYWORDS					:	aValue >>= m_aFixedProperties.m_sKeywords          		;
				 									break ;
		case	HANDLE_MIMETYPE					:	LOG_ASSERT( sal_False, "DocumentProperties::setFastPropertyValue_NoBoradcast()\nYou can't set readonly property \"MIMETYPE\"!\n" )
				 									break ;
		case	HANDLE_MODIFIEDBY				:	aValue >>= m_aFixedProperties.m_sModifiedBy        		;
				 									break ;
		case	HANDLE_MODIFYDATE				:	aValue >>= m_aFixedProperties.m_aModifyDate        		;
				 									break ;
		case	HANDLE_NEWSGROUPS				:	aValue >>= m_aFixedProperties.m_sNewsgroups        		;
				 									break ;
		case	HANDLE_ORIGINAL					:	aValue >>= m_aFixedProperties.m_sOriginal          		;
				 									break ;
		case	HANDLE_PORTABLEGRAPHICS			:	aValue >>= m_aFixedProperties.m_bPortableGraphics		;
				 									break ;
		case	HANDLE_PRINTDATE				:	aValue >>= m_aFixedProperties.m_aPrintDate         		;
				 									break ;
		case	HANDLE_PRINTEDBY				:	aValue >>= m_aFixedProperties.m_sPrintedBy         		;
				 									break ;
		case	HANDLE_PRIORITY					:	aValue >>= m_aFixedProperties.m_nPriority          		;
				 									break ;
		case	HANDLE_QUERYTEMPLATE			:	aValue >>= m_aFixedProperties.m_bQueryTemplate			;
				 									break ;
		case	HANDLE_RECIPIENT				:	aValue >>= m_aFixedProperties.m_sRecipient         		;
				 									break ;
		case	HANDLE_REFERENCES				:	aValue >>= m_aFixedProperties.m_sReferences        		;
				 									break ;
		case	HANDLE_REPLYTO					:	aValue >>= m_aFixedProperties.m_sReplyTo           		;
				 									break ;
		case	HANDLE_SAVEGRAPHICSCOMPRESSED	:	aValue >>= m_aFixedProperties.m_bSaveGraphicsCompressed	;
				 									break ;
		case	HANDLE_SAVEORIGINALGRAPHICS		:	aValue >>= m_aFixedProperties.m_bSaveOriginalGraphics	;
				 									break ;
		case	HANDLE_SAVEVERSIONONCLOSE		:	aValue >>= m_aFixedProperties.m_bSaveVersionOnClose		;
				 									break ;
		case	HANDLE_TEMPLATE					:	aValue >>= m_aFixedProperties.m_sTemplate          		;
				 									break ;
		case	HANDLE_TEMPLATECONFIG			:	aValue >>= m_aFixedProperties.m_bTemplateConfig       	;
				 									break ;
		case	HANDLE_TEMPLATEFILENAME			:	aValue >>= m_aFixedProperties.m_sTemplateFileName		;
				 									break ;
		case	HANDLE_TEMPLATEDATE				:	aValue >>= m_aFixedProperties.m_aTemplateDate      		;
				 									break ;
		case	HANDLE_THEME					:	aValue >>= m_aFixedProperties.m_sTheme             		;
				 									break ;
		case	HANDLE_TITLE					:	aValue >>= m_aFixedProperties.m_sTitle             		;
				 									break ;
		case	HANDLE_USERDATA					:	aValue >>= m_aFixedProperties.m_bUserData           	;
				 									break ;
	}
}

//******************************************************************************************************************************
//	OPropertySetHelper
//******************************************************************************************************************************
void SAL_CALL DocumentProperties::getFastPropertyValue(	Any&		aValue	,
			  											sal_Int32	nHandle	) const
{
	// Search for right handle ... and try to get property value.
	switch( nHandle )
	{
		case	HANDLE_AUTHOR					:		aValue <<= m_aFixedProperties.m_sAuthor            		;
				 										break ;
		case	HANDLE_AUTOLOADENABLED			:		aValue <<= m_aFixedProperties.m_bAutoloadEnabled   		;
				 										break;
		case	HANDLE_AUTOLOADSECS				:		aValue <<= m_aFixedProperties.m_nAutoloadSecs      		;
				 										break ;
		case	HANDLE_AUTOLOADURL				:		aValue <<= m_aFixedProperties.m_sAutoloadURL       		;
				 										break ;
		case	HANDLE_BLINDCOPIESTO			:		aValue <<= m_aFixedProperties.m_sBlindCopiesTo     		;
				 										break ;
		case	HANDLE_COPIESTO					:		aValue <<= m_aFixedProperties.m_sCopiesTo            	;
				 										break ;
		case	HANDLE_CREATIONDATE				:		aValue <<= m_aFixedProperties.m_aCreationDate      		;
				 										break ;
		case	HANDLE_DEFAULTTARGET			:		aValue <<= m_aFixedProperties.m_sDefaultTarget     		;
				 										break ;
		case	HANDLE_DESCRIPTION				:		aValue <<= m_aFixedProperties.m_sDescription       		;
				 										break ;
		case	HANDLE_EDITINGCYCLES			:		aValue <<= m_aFixedProperties.m_nEditingCycles     		;
				 										break ;
		case	HANDLE_EDITINGDURATION			:		aValue <<= m_aFixedProperties.m_nEditingDuration   		;
				 										break ;
		case	HANDLE_EXTRADATA				:		aValue <<= m_aFixedProperties.m_seqExtraData			;
				 										break ;
		case	HANDLE_INREPLYTO				:		aValue <<= m_aFixedProperties.m_sInReplyTo         		;
				 										break ;
		case	HANDLE_ISENCRYPTED				:		aValue <<= m_aFixedProperties.m_bIsEncrypted       		;
				 										break ;
		case	HANDLE_KEYWORDS					:		aValue <<= m_aFixedProperties.m_sKeywords          		;
				 										break ;
		case	HANDLE_MIMETYPE					:		aValue <<= m_aFixedProperties.m_sMIMEType          		;
				 										break ;
		case	HANDLE_MODIFIEDBY				:		aValue <<= m_aFixedProperties.m_sModifiedBy        		;
				 										break ;
		case	HANDLE_MODIFYDATE				:		aValue <<= m_aFixedProperties.m_aModifyDate        		;
				 										break ;
		case	HANDLE_NEWSGROUPS				:		aValue <<= m_aFixedProperties.m_sNewsgroups        		;
				 										break ;
		case	HANDLE_ORIGINAL					:		aValue <<= m_aFixedProperties.m_sOriginal          		;
				 										break ;
		case	HANDLE_PORTABLEGRAPHICS			:		aValue <<= m_aFixedProperties.m_bPortableGraphics		;
				 										break ;
		case	HANDLE_PRINTDATE				:		aValue <<= m_aFixedProperties.m_aPrintDate         		;
				 										break ;
		case	HANDLE_PRINTEDBY				:		aValue <<= m_aFixedProperties.m_sPrintedBy         		;
				 										break ;
		case	HANDLE_PRIORITY					:		aValue <<= m_aFixedProperties.m_nPriority          		;
				 										break ;
		case	HANDLE_QUERYTEMPLATE			:		aValue <<= m_aFixedProperties.m_bQueryTemplate			;
				 										break ;
		case	HANDLE_RECIPIENT				:		aValue <<= m_aFixedProperties.m_sRecipient         		;
				 										break ;
		case	HANDLE_REFERENCES				:		aValue <<= m_aFixedProperties.m_sReferences        		;
				 										break ;
		case	HANDLE_REPLYTO					:		aValue <<= m_aFixedProperties.m_sReplyTo           		;
				 										break ;
		case	HANDLE_SAVEGRAPHICSCOMPRESSED	:		aValue <<= m_aFixedProperties.m_bSaveGraphicsCompressed	;
				 										break ;
		case	HANDLE_SAVEORIGINALGRAPHICS		:		aValue <<= m_aFixedProperties.m_bSaveOriginalGraphics	;
				 										break ;
		case	HANDLE_SAVEVERSIONONCLOSE		:		aValue <<= m_aFixedProperties.m_bSaveVersionOnClose		;
				 										break ;
		case	HANDLE_TEMPLATE					:		aValue <<= m_aFixedProperties.m_sTemplate          		;
				 										break ;
		case	HANDLE_TEMPLATECONFIG			:		aValue <<= m_aFixedProperties.m_bTemplateConfig       	;
				 										break ;
		case	HANDLE_TEMPLATEFILENAME			:		aValue <<= m_aFixedProperties.m_sTemplateFileName		;
				 										break ;
		case	HANDLE_TEMPLATEDATE				:		aValue <<= m_aFixedProperties.m_aTemplateDate      		;
				 										break ;
		case	HANDLE_THEME					:		aValue <<= m_aFixedProperties.m_sTheme             		;
				 										break ;
		case	HANDLE_TITLE					:		aValue <<= m_aFixedProperties.m_sTitle             		;
				 										break ;
		case	HANDLE_USERDATA					:		aValue <<= m_aFixedProperties.m_bUserData           	;
				 										break ;
	}
}

//******************************************************************************************************************************
//	OPropertySetHelper
//******************************************************************************************************************************
IPropertyArrayHelper& SAL_CALL DocumentProperties::getInfoHelper()
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pInfoHelper is NULL - for the second call pInfoHelper is different from NULL!
	static OPropertyArrayHelper* pInfoHelper = NULL;

	if( pInfoHelper == NULL )
	{
		// Ready for multithreading
        ::osl::MutexGuard aGuard( LockHelper::getGlobalLock().getShareableOslMutex() );
		// Control this pointer again, another instance can be faster then these!
		if( pInfoHelper == NULL )
		{
			// Define static member to give structure of properties to baseclass "OPropertySetHelper".
			// "impl_getStaticPropertyDescriptor" is a non exported and static funtion, who will define a static propertytable.
			// "sal_True" say: Table is sorted by name.
			static OPropertyArrayHelper aInfoHelper( impl_getStaticPropertyDescriptor(), sal_True );
			pInfoHelper = &aInfoHelper;
		}
	}

	return (*pInfoHelper);
}

//******************************************************************************************************************************
//	OPropertySetHelper
//******************************************************************************************************************************
Reference< XPropertySetInfo > SAL_CALL DocumentProperties::getPropertySetInfo () throw (::com::sun::star::uno::RuntimeException)
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pInfo is NULL - for the second call pInfo is different from NULL!
	static Reference< XPropertySetInfo >* pInfo = NULL ;

	if( pInfo == NULL )
	{
		// Ready for multithreading
        ::osl::MutexGuard aGuard( LockHelper::getGlobalLock().getShareableOslMutex() );
		// Control this pointer again, another instance can be faster then these!
		if( pInfo == NULL )
		{
			// Create structure of propertysetinfo for baseclass "OPropertySetHelper".
			// (Use method "getInfoHelper()".)
			static Reference< XPropertySetInfo > xInfo( createPropertySetInfo( getInfoHelper() ) );
			pInfo = &xInfo;
		}
	}

	return (*pInfo);
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
sal_Bool DocumentProperties::impl_tryToChangeProperty(	const	OUString&	sCurrentValue	,
														const	Any&		aNewValue		,
																Any&		aOldValue		,
																Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value if method failed.
	sal_Bool bReturn = sal_False;
	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	OUString sValue ;
	convertPropertyValue( sValue, aNewValue );

	// If value change ...
	if( sValue != sCurrentValue )
	{
		// ... set information of change.
		aOldValue		<<= sCurrentValue	;
		aConvertedValue	<<= sValue			;
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}
	else
	{
		// ... clear information of return parameter!
		aOldValue.clear			() ;
		aConvertedValue.clear	() ;
		// Return NOTHING - "value will not be change ..."
		bReturn = sal_False;
	}

	return bReturn;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
sal_Bool DocumentProperties::impl_tryToChangeProperty(	const	css::util::DateTime&	aCurrentValue	,
														const	Any&					aNewValue		,
																Any&					aOldValue		,
																Any&					aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value if method failed.
	sal_Bool bReturn = sal_False;
	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	css::util::DateTime aValue;
	convertPropertyValue( aValue, aNewValue );

	// If "value" change ...
	// (There is no operator!= for DateTime. This is a struct !!!!....)
	if	(
			( aValue.HundredthSeconds	!=	aCurrentValue.HundredthSeconds	)	||
    		( aValue.Seconds			!=	aCurrentValue.Seconds			)	||
    		( aValue.Minutes			!=	aCurrentValue.Minutes			)	||
    		( aValue.Hours				!=	aCurrentValue.Hours				)	||
    		( aValue.Day				!=	aCurrentValue.Day				)	||
    		( aValue.Month				!=	aCurrentValue.Month				)	||
    		( aValue.Year				!=	aCurrentValue.Year				)
		)
	{
		// ... set information of change.
		aOldValue		<<= aCurrentValue	;
		aConvertedValue	<<= aValue			;
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}
	else
	{
		// ... clear information of return parameter!
		aOldValue.clear			() ;
		aConvertedValue.clear	() ;
		// Return NOTHING - "value will not be change ..."
		bReturn = sal_False;
	}
	return bReturn;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
sal_Bool DocumentProperties::impl_tryToChangeProperty(	const	sal_Bool&	bCurrentValue	,
														const	Any&		aNewValue		,
																Any&		aOldValue		,
																Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value if method failed.
	sal_Bool bReturn = sal_False;
	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	sal_Bool bValue;
	convertPropertyValue( bValue, aNewValue );

	// If value change ...
	if( bValue != bCurrentValue )
	{
		// ... set information of change.
		// Attention:	Use setValue and getCppuBooleanType to set value in any!
		//				It's necessary, if BOOL can be int or char.
		aOldValue.setValue			( &bCurrentValue, ::getCppuBooleanType () );
		aConvertedValue.setValue	( &bValue		, ::getCppuBooleanType () );
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}
	else
	{
		// ... clear information of return parameter!
		aOldValue.clear			() ;
		aConvertedValue.clear	() ;
		// Return NOTHING - "value will not be change ..."
		bReturn = sal_False;
	}
	return bReturn;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
sal_Bool DocumentProperties::impl_tryToChangeProperty(	const	sal_Int16&	nCurrentValue	,
														const	Any&		aNewValue		,
																Any&		aOldValue		,
																Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value if method failed.
	sal_Bool bReturn = sal_False;
	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	sal_Int16 nValue ;
	convertPropertyValue( nValue, aNewValue );

	// If value change ...
	if( nValue != nCurrentValue )
	{
		// ... set information of change.
		aOldValue		<<= nCurrentValue	;
		aConvertedValue	<<= nValue			;
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}
	else
	{
		// ... clear information of return parameter!
		aOldValue.clear			() ;
		aConvertedValue.clear	() ;
		// Return NOTHING - "value will not be change ..."
		bReturn = sal_False;
	}
	return bReturn;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
sal_Bool DocumentProperties::impl_tryToChangeProperty(	const	sal_uInt16&	nCurrentValue	,
														const	Any&		aNewValue		,
																Any&		aOldValue		,
																Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value if method failed.
	sal_Bool bReturn = sal_False;
	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	sal_uInt16 nValue ;
	convertPropertyValue( nValue, aNewValue );

	// If value change ...
	if( nValue != nCurrentValue )
	{
		// ... set information of change.
		aOldValue		<<= nCurrentValue	;
		aConvertedValue	<<= nValue			;
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}
	else
	{
		// ... clear information of return parameter!
		aOldValue.clear			() ;
		aConvertedValue.clear	() ;
		// Return NOTHING - "value will not be change ..."
		bReturn = sal_False;
	}
	return bReturn;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
sal_Bool DocumentProperties::impl_tryToChangeProperty(	const	sal_Int32&	nCurrentValue	,
														const	Any&		aNewValue		,
																Any&		aOldValue		,
																Any&		aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value if method failed.
	sal_Bool bReturn = sal_False;
	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	sal_Int32 nValue ;
	convertPropertyValue( nValue, aNewValue );

	// If value change ...
	if( nValue != nCurrentValue )
	{
		// ... set information of change.
		aOldValue		<<= nCurrentValue	;
		aConvertedValue	<<= nValue			;
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}
	else
	{
		// ... clear information of return parameter!
		aOldValue.clear			() ;
		aConvertedValue.clear	() ;
		// Return NOTHING - "value will not be change ..."
		bReturn = sal_False;
	}
	return bReturn;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
sal_Bool DocumentProperties::impl_tryToChangeProperty(	const	Sequence< sal_Int8 >&	lCurrentValue	,
														const	Any&					aNewValue		,
																Any&					aOldValue		,
																Any&					aConvertedValue	) throw( IllegalArgumentException )
{
	// Set default return value if method failed.
	sal_Bool bReturn = sal_False;
	// Get new value from any.
	// IllegalArgumentException() can be thrown!
	Sequence< sal_Int8 > lValue ;

/*BUG #71852#*/
#if OSL_DEBUG_LEVEL > 1
	LOG_ASSERT( !(aNewValue.hasValue()==sal_False), "no value\n" )
	LOG_ASSERT( !(aNewValue.getValueTypeClass()!=TypeClass_SEQUENCE), "invalid type\n" )
	LOG_ASSERT( !((aNewValue>>=lValue)==sal_False), "can't unpack\n" )
	OUString sTypeName = aNewValue.getValueTypeName();
#endif
/*BUG #71852#*/

	convertPropertyValue( lValue, aNewValue );

	// If value change ...
	if( lValue != lCurrentValue )
	{
		// ... set information of change.
		aOldValue		<<= lCurrentValue	;
		aConvertedValue	<<= lValue			;
		// Return OK - "value will be change ..."
		bReturn = sal_True;
	}
	else
	{
		// ... clear information of return parameter!
		aOldValue.clear			() ;
		aConvertedValue.clear	() ;
		// Return NOTHING - "value will not be change ..."
		bReturn = sal_False;
	}
	return bReturn;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_readProperties( SvStream& aStream ) throw(	IOException			,
											  								RuntimeException	)
{
	// Get current version of stream and safe it !
	sal_Int32 nFileVersion = aStream.GetVersion();
	// If version invalid, set correct value. Use FormatID to do that!
	if( impl_isFileVersionValid( nFileVersion ) == sal_False )
	{
		nFileVersion = impl_FormatID2FileVersion( m_nFormatID ); // m_nFormatID was set in "read()"!
	}

	// The follow 3 items are written in file format 4.0 !!!
	aStream.SetVersion( SOFFICE_FILEFORMAT_40 );

	// I)   HeaderType		[string ]
	// II)  HeaderVersion	[uint16 ]
	// III) IsEncrypted		[boolean]
	// Throw an exception if wrong header was found!
	impl_readFromStream( aStream, m_sHeaderType );
	if( m_sHeaderType != HEADERNAME )
	{
		aStream.SetError( SVSTREAM_FILEFORMAT_ERROR );
		throw IOException( DECLARE_ASCII("DocumentProperties::impl_readProperties()\nWrong header detected!\n"), static_cast< OWeakObject* >( this ) );
	}
	impl_readFromStream( aStream, m_nHeaderVersion	);
	impl_readFromStream( aStream, m_aFixedProperties.m_bIsEncrypted	);

	// Reset version of stream. (Reset to safed value! see before)
	aStream.SetVersion( nFileVersion );
	// Get information about right charset and set it on stream.
    sal_uInt16 nTmp = (sal_uInt16)m_eFileEncoding;
	impl_readFromStream( aStream, nTmp );
    m_eFileEncoding = GetSOLoadTextEncoding( m_eFileEncoding );
	aStream.SetStreamCharSet( m_eFileEncoding );

	// Read follow properties.
	impl_readFromStream( aStream, m_aFixedProperties.m_bPortableGraphics	);
	impl_readFromStream( aStream, m_aFixedProperties.m_bQueryTemplate		);

	// Time stamps support own read method!
	// Read stamps and copy needed values from it in internal member.
	TimeStamp aCreatedStamp	;
	TimeStamp aModifiedStamp;
	TimeStamp aPrintedStamp ;
	aCreatedStamp.Load	( aStream );
	aModifiedStamp.Load	( aStream );
	aPrintedStamp.Load	( aStream );
	m_aFixedProperties.m_sAuthor		= aCreatedStamp.GetName	();
	m_aFixedProperties.m_sModifiedBy	= aModifiedStamp.GetName();
	m_aFixedProperties.m_sPrintedBy 	= aPrintedStamp.GetName	();
	m_aFixedProperties.m_aCreationDate	= impl_TimeStamp2DateTime( aCreatedStamp	);
	m_aFixedProperties.m_aModifyDate	= impl_TimeStamp2DateTime( aModifiedStamp	);
	m_aFixedProperties.m_aPrintDate	= impl_TimeStamp2DateTime( aPrintedStamp	);

	// Attention:	Follow properties have the same size everytime!
	//				Skip unreaded bytes.
	// Read title, theme, description and keywords ...
	impl_readFromStream( aStream, m_aFixedProperties.m_sTitle		,FIXSIZE_TITLE		);
	impl_readFromStream( aStream, m_aFixedProperties.m_sTheme		,FIXSIZE_THEME		);
	impl_readFromStream( aStream, m_aFixedProperties.m_sDescription	,FIXSIZE_DESCRIPTION);
	impl_readFromStream( aStream, m_aFixedProperties.m_sKeywords	,FIXSIZE_KEYWORDS	);

	// Read user specified properties.
	// At this point we can get 4 elements only! The size in file is fixed.
	// Add strings to namecontainer.
	// (see description for define ENABLE_PROPERTY_RESTRICTION for further informations too!)
	OUString	sName		;
	OUString	sValue		;
	sal_uInt16	nCounter	;
 	for( nCounter=0; nCounter<MAXCOUNT_DOCUSERKEYS; ++nCounter )
	{
		// Get name and value of property.
		// These value have an fix size! Skip to much letters!
		impl_readFromStream( aStream, sName , FIXSIZE_DOCUSERKEY );
		impl_readFromStream( aStream, sValue, FIXSIZE_DOCUSERKEY );
		// File is corrupt if DocUserKeys dont have a valid name!!!
		// Throw an exception.
		if( sName.getLength() < 1 )
		{
			throw IOException( DECLARE_ASCII("DocumentProperties::impl_readProperties()\nWrong DocUserKey detected!\n"), static_cast< OWeakObject* >( this ) );
		}
		// Insert property in namecontainer.
        try
        {
            insertByName( sName, makeAny( sValue ) );
        }
        catch(css::uno::Exception& exNoRuntime)
        {
            throw css::io::IOException(exNoRuntime.Message,static_cast< ::cppu::OWeakObject* >(this));
        }
	}

	// Read name, filename, date and time of template.
	impl_readFromStream( aStream, m_aFixedProperties.m_sTemplate			);
	impl_readFromStream( aStream, m_aFixedProperties.m_sTemplateFileName	);
	sal_Int32 nDate;
	sal_Int32 nTime;
	impl_readFromStream( aStream, nDate );
	impl_readFromStream( aStream, nTime );
	Date aDate( nDate );
	Time aTime( nTime );
    m_aFixedProperties.m_aTemplateDate.Day				= aDate.GetDay		();
    m_aFixedProperties.m_aTemplateDate.Month			= aDate.GetMonth	();
    m_aFixedProperties.m_aTemplateDate.Year				= aDate.GetYear		();
	m_aFixedProperties.m_aTemplateDate.HundredthSeconds	= aTime.Get100Sec	();
    m_aFixedProperties.m_aTemplateDate.Seconds			= aTime.GetSec		();
    m_aFixedProperties.m_aTemplateDate.Minutes			= aTime.GetMin		();
    m_aFixedProperties.m_aTemplateDate.Hours			= aTime.GetHour		();

	// OBSOLETE!!!
	// Read AND forget it :-)
	// (There are only some mailaddresses.)
	if( aStream.GetVersion() <= SOFFICE_FILEFORMAT_40 )
	{
		sal_uInt16	nMaxCount		;
		OUString	sDummyString	;
		sal_uInt16	nDummyFlags		;
		impl_readFromStream( aStream, nMaxCount );
		for( nCounter=0; nCounter<nMaxCount; ++nCounter )
		{
			impl_readFromStream( aStream, sDummyString	);
 			impl_readFromStream( aStream, nDummyFlags	);
		}
	}

	// Read edit time, documentnumber (if it exist !), extra data and TemplateConfig.
	impl_readFromStream( aStream, m_aFixedProperties.m_nEditingDuration );
	if( m_nHeaderVersion > 4 )
	{
		 impl_readFromStream( aStream, m_aFixedProperties.m_nEditingCycles );
	}
	impl_readFromStream( aStream, m_aFixedProperties.m_seqExtraData	);
	impl_readFromStream( aStream, m_aFixedProperties.m_bTemplateConfig	);

	// Read some other properties - depends from headerversion!
	if( m_nHeaderVersion > 5 )
	{
		impl_readFromStream( aStream, m_aFixedProperties.m_bAutoloadEnabled);
		impl_readFromStream( aStream, m_aFixedProperties.m_sAutoloadURL	);
		impl_readFromStream( aStream, m_aFixedProperties.m_nAutoloadSecs	);
		impl_readFromStream( aStream, m_aFixedProperties.m_sDefaultTarget	);
	}
	if( m_nHeaderVersion > 6 )
	{
		impl_readFromStream( aStream, m_aFixedProperties.m_bSaveGraphicsCompressed );
	}
	if( m_nHeaderVersion > 7 )
	{
		impl_readFromStream( aStream, m_aFixedProperties.m_bSaveOriginalGraphics );
	}
	if( m_nHeaderVersion > 8 )
	{
		impl_readFromStream( aStream, m_aFixedProperties.m_bSaveVersionOnClose	);
		impl_readFromStream( aStream, m_aFixedProperties.m_sCopiesTo			);
		impl_readFromStream( aStream, m_aFixedProperties.m_sOriginal			);
		impl_readFromStream( aStream, m_aFixedProperties.m_sReferences			);
		impl_readFromStream( aStream, m_aFixedProperties.m_sRecipient			);
		impl_readFromStream( aStream, m_aFixedProperties.m_sReplyTo				);
		impl_readFromStream( aStream, m_aFixedProperties.m_sBlindCopiesTo		);
		impl_readFromStream( aStream, m_aFixedProperties.m_sInReplyTo			);
		impl_readFromStream( aStream, m_aFixedProperties.m_sNewsgroups			);
		impl_readFromStream( aStream, m_aFixedProperties.m_nPriority			);
	}
	if( m_nHeaderVersion > 9 )
	{
		impl_readFromStream( aStream, m_aFixedProperties.m_sMIMEType );
		// If value not exist (???) ...
		if( m_aFixedProperties.m_sMIMEType.getLength() < 1 )
		{
			// ... use format-ID to set right MIMEType!
			// (m_nFormatID is set in method "read(URL)".)
			m_aFixedProperties.m_sMIMEType = impl_FormatID2MIMEType( m_nFormatID );
		}
	}
	if( m_nHeaderVersion > 10 )
	{
		impl_readFromStream( aStream, m_aFixedProperties.m_bUserData );
	}
	if( m_nHeaderVersion > 11 )
	{
		// Read rest of user specified properties.
		// Add strings to namecontainer.
		// (See also declaration of "ENABLE_PROPERTY_RESTRICTION" to get more information!)
		// nCounter, sName and sValue are defined below!

		sal_uInt32 nPropertiesCount = 0;
		impl_readFromStream( aStream, nPropertiesCount );
 		for( nCounter=0 ; nCounter<nPropertiesCount; ++nCounter )
		{
			impl_readFromStream( aStream, sName  );
			impl_readFromStream( aStream, sValue );
			// File is corrupt when we detect an empty name.
			// Throw an exception.
			if( sName.getLength() < 1 )
			{
				throw IOException( DECLARE_ASCII("DocumentProperties::impl_readProperties()\nWrong user propertie detected.\n"), static_cast< OWeakObject* >( this ) );
			}
			// Insert property in namecontainer.
            try
            {
                insertByName( sName, makeAny ( sValue ) );
            }
            catch(css::uno::Exception& exNoRuntime)
            {
                throw css::io::IOException(exNoRuntime.Message,static_cast< ::cppu::OWeakObject* >(this));
            }
		}
	}

	// Control state of this operation !
	// We control this NOT everytime and after every reading of values from stream ...
	// but at the end of all instructions. -> PERFORMANCE !!!
	if( aStream.GetError() != SVSTREAM_OK )
	{
		throw IOException( DECLARE_ASCII("DocumentProperties::impl_readProperties()\nStream has errors!\n"), static_cast< OWeakObject* >( this ) );
	}
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_readXMLProperties( SvStream& aStream ) throw(	IOException			,
								  											RuntimeException	)
{
	::utl::OInputStreamWrapper* pInputStream = new ::utl::OInputStreamWrapper( aStream );

	Reference< XParser > xParser( m_xFactory->createInstance(
									::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.xml.sax.Parser" ))),
								  UNO_QUERY);

	// stream for xml meta data
	InputSource aInputSource;

	aInputSource.aInputStream = Reference< XInputStream >( static_cast< OWeakObject* >( pInputStream ), UNO_QUERY );

	// set meta xml handler
    Reference< XNameContainer > xCont( static_cast< OWeakObject* >( this ), UNO_QUERY );
	Reference< XDocumentHandler > xDocHandler( new XMLDocumentPropertiesHandler( xCont, m_aFixedProperties ));
//	Reference< XDocumentHandler > xFilter( new SaxNamespaceFilter( xDocHandler ));

	// connect parser and filter
	xParser->setDocumentHandler( xDocHandler );

	try
	{
		xParser->parseStream( aInputSource );
	}
	catch( SAXException& e )
	{
		SAXException aWrappedSAXException;

		if ( !( e.WrappedException >>= aWrappedSAXException ))
			throw IOException( e.Message, static_cast< OWeakObject* >( this ) );
		else
			throw IOException( aWrappedSAXException.Message, static_cast< OWeakObject* >( this ) );
	}
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_writeProperties( SvStream& aStream ) throw(	IOException			,
																			RuntimeException	)
{
	// Get current version of stream and safe it !
	sal_Int32 nFileVersion = aStream.GetVersion();
	// If version invalid, set correct value. Use FormatID to do this!
	if( impl_isFileVersionValid( nFileVersion ) == sal_False )
	{
		nFileVersion = impl_FormatID2FileVersion( m_nFormatID ); // m_nFormatID was set in "write()"!
	}

	// The follow 3 items are written in file format 4.0 !!!
	// Set right version on stream ...
	aStream.SetVersion( SOFFICE_FILEFORMAT_40 );
	impl_writeToStream( aStream, m_sHeaderType		);
	impl_writeToStream( aStream, m_nHeaderVersion	);
	impl_writeToStream( aStream, m_aFixedProperties.m_bIsEncrypted		);
	// Reset version of stream. (Reset to safed value!)
	aStream.SetVersion( nFileVersion );

	// Set information about right charset in file and stream.
	// If we write, but don't have read before ... "m_eFileCharSet" has default value!
	// In this way, we get default charset from stream!
    m_eFileEncoding = GetSOStoreTextEncoding( m_eFileEncoding );
	if( m_eFileEncoding == STREAMENCODING )
	{
		// We don't have read before. Get default charset from stream.
		m_eFileEncoding = aStream.GetStreamCharSet();
	}
	else
	{
		// We have read before. Use readed charset! (set it on stream)
		aStream.SetStreamCharSet( m_eFileEncoding );
	}
	// Write charset in document info!
	impl_writeToStream( aStream, (sal_uInt16)m_eFileEncoding );

	// Write some properties.
	impl_writeToStream( aStream, m_aFixedProperties.m_bPortableGraphics	) ;
	impl_writeToStream( aStream, m_aFixedProperties.m_bQueryTemplate		) ;

	// Write some timestamps ...
	TimeStamp aCreatedStamp		= impl_DateTime2TimeStamp ( m_aFixedProperties.m_aCreationDate	);
	TimeStamp aModifiedStamp	= impl_DateTime2TimeStamp ( m_aFixedProperties.m_aModifyDate	);
	TimeStamp aPrintedStamp		= impl_DateTime2TimeStamp ( m_aFixedProperties.m_aPrintDate	);
	aCreatedStamp.SetName	( m_aFixedProperties.m_sAuthor		);
	aModifiedStamp.SetName	( m_aFixedProperties.m_sModifiedBy	);
	aPrintedStamp.SetName	( m_aFixedProperties.m_sPrintedBy	);
	aCreatedStamp.Save		( aStream		);
	aModifiedStamp.Save		( aStream		);
	aPrintedStamp.Save		( aStream		);

	// Attention:	Follow properties have the same size everytime!
	//				Skip not written bytes.
	// Write title, theme, description and keywords.
	impl_writeToStream( aStream, m_aFixedProperties.m_sTitle		, FIXSIZE_TITLE			);
	impl_writeToStream( aStream, m_aFixedProperties.m_sTheme		, FIXSIZE_THEME			);
	impl_writeToStream( aStream, m_aFixedProperties.m_sDescription	, FIXSIZE_DESCRIPTION	);
	impl_writeToStream( aStream, m_aFixedProperties.m_sKeywords		, FIXSIZE_KEYWORDS		);

	// Write user specified properties.
	// At this point we can set 4 elements only! The size in file is fixed.
	// Get strings from namecontainer ... but don't forget the others ... they will saved sometimes later!!!
	// If there not enough items, take default values.
	OUString				sName															;
	OUString				sValue															;
	Any						aValue															;
	sal_uInt16				nCounter														;
	Sequence< OUString >	seqContainerProperties	= getElementNames()						;
	sal_uInt32				nSequenceSize			= seqContainerProperties.getLength()	;

 	for( nCounter=0; nCounter<MAXCOUNT_DOCUSERKEYS; ++nCounter )
	{
		// Get property from namecontainer. (if someone exist...)
		if( nCounter < nSequenceSize )
		{
			sName	=	seqContainerProperties[ nCounter ]	;
			aValue	=	getByName( sName )					;
			aValue	>>=	sValue								;
		}
		// Else; take default values!!!
		else
		{
			// Create string like "Info 0" or "Info 1" ...
			OUString sTemp = DECLARE_ASCII("Info ");
			sTemp  += OUString::valueOf( (sal_Int32)nCounter );
			sName	= sTemp		;
			sValue	= OUString();
		}
		// Write name and value of property.
		// These values have a fix size! Appends some blanks, if string to short.
		impl_writeToStream( aStream, sName , FIXSIZE_DOCUSERKEY );
		impl_writeToStream( aStream, sValue, FIXSIZE_DOCUSERKEY );
	}

	// Write name, filename, date and time of template.
	impl_writeToStream( aStream, m_aFixedProperties.m_sTemplate			);
	impl_writeToStream( aStream, m_aFixedProperties.m_sTemplateFileName	);

	Date 		aDate			( m_aFixedProperties.m_aTemplateDate.Day	,
								  m_aFixedProperties.m_aTemplateDate.Month	,
								  m_aFixedProperties.m_aTemplateDate.Year		);
	Time		aTime			( m_aFixedProperties.m_aTemplateDate.Hours				,
								  m_aFixedProperties.m_aTemplateDate.Minutes			,
								  m_aFixedProperties.m_aTemplateDate.Seconds			,
								  m_aFixedProperties.m_aTemplateDate.HundredthSeconds		);
	::DateTime	aDateTimeObject	( aDate, aTime );

	impl_writeToStream( aStream, aDateTimeObject.GetDate() );
	impl_writeToStream( aStream, aDateTimeObject.GetTime() );

	// OBSOLETE!!!
	// Write a size of 0 AND forget it :-)
	// (There are only some mailaddresses.)
	if( aStream.GetVersion () <= SOFFICE_FILEFORMAT_40 )
	{
		impl_writeToStream( aStream, (sal_uInt16)0 );
	}

	// Write edit time, documentnumber (if it exist !), extra data and TemplateConfig.
	impl_writeToStream( aStream, m_aFixedProperties.m_nEditingDuration );
	if( m_nHeaderVersion > 4 )
	{
		impl_writeToStream( aStream, m_aFixedProperties.m_nEditingCycles );
	}
	impl_writeToStream( aStream, m_aFixedProperties.m_seqExtraData		);
	impl_writeToStream( aStream, m_aFixedProperties.m_bTemplateConfig	);

	// Write some other properties - depends from headerversion!
	if( m_nHeaderVersion > 5 )
	{
		impl_writeToStream( aStream, m_aFixedProperties.m_bAutoloadEnabled	);
		impl_writeToStream( aStream, m_aFixedProperties.m_sAutoloadURL		);
		impl_writeToStream( aStream, m_aFixedProperties.m_nAutoloadSecs	);
		impl_writeToStream( aStream, m_aFixedProperties.m_sDefaultTarget	);
	}
	if( m_nHeaderVersion > 6 )
	{
		impl_writeToStream( aStream, m_aFixedProperties.m_bSaveGraphicsCompressed );
	}
	if( m_nHeaderVersion > 7 )
	{
		impl_writeToStream( aStream, m_aFixedProperties.m_bSaveOriginalGraphics );
	}
	if( m_nHeaderVersion > 8 )
	{
		impl_writeToStream( aStream, m_aFixedProperties.m_bSaveVersionOnClose	);
		impl_writeToStream( aStream, m_aFixedProperties.m_sCopiesTo			);
		impl_writeToStream( aStream, m_aFixedProperties.m_sOriginal			);
		impl_writeToStream( aStream, m_aFixedProperties.m_sReferences			);
		impl_writeToStream( aStream, m_aFixedProperties.m_sRecipient			);
		impl_writeToStream( aStream, m_aFixedProperties.m_sReplyTo				);
		impl_writeToStream( aStream, m_aFixedProperties.m_sBlindCopiesTo		);
		impl_writeToStream( aStream, m_aFixedProperties.m_sInReplyTo			);
		impl_writeToStream( aStream, m_aFixedProperties.m_sNewsgroups			);
		impl_writeToStream( aStream, m_aFixedProperties.m_nPriority			);
	}
	if( m_nHeaderVersion > 9 )
	{
		// We have a open storage. This storage has a MIMEType. We have a value for MIMEType to!?
		// If these values are different, we use value of storage not of property!
		// We write a valid MIMEType at everytime ...
		// (User can't set property value - its readonly! But user can write this stream without open it !?...)
		m_aFixedProperties.m_sMIMEType = impl_FormatID2MIMEType( m_nFormatID );
		impl_writeToStream( aStream, m_aFixedProperties.m_sMIMEType );
	}
	if( m_nHeaderVersion > 10 )
	{
		impl_writeToStream( aStream, m_aFixedProperties.m_bUserData );
	}
	if( m_nHeaderVersion > 11 )
	{
		if( nSequenceSize > MAXCOUNT_DOCUSERKEYS )
		{
			// Write rest of user specified properties.
			// Get strings from namecontainer.
			// First write count of properties in file ...
			// Attention: We have written 4 items as DOCUSERKEYS before!
			nSequenceSize -= MAXCOUNT_DOCUSERKEYS ;
			impl_writeToStream( aStream, (sal_uInt32)nSequenceSize );

			// Then write rest of properties ...
 			for( nCounter=MAXCOUNT_DOCUSERKEYS; nCounter<nSequenceSize; ++nCounter )
			{
				sName	=	seqContainerProperties[ nCounter ]	;
				aValue	=	getByName( sName )					;
				aValue	>>= sValue								;
				// Write name and value of property.
				impl_writeToStream( aStream, sName	);
				impl_writeToStream( aStream, sValue	);
			}
		}
	}

	// Control state of this operation !
	// We control this NOT everytime and after every writing of values in stream ...
	// but at the end of all instructions. -> PERFORMANCE !!!
	if( aStream.GetError() != SVSTREAM_OK )
	{
		throw IOException( DECLARE_ASCII("DocumentProperties::impl_writeProperties()\nStream has errors!\n"), static_cast< OWeakObject* >( this ) );
	}
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_writeXMLProperties( SvStream& aStream ) throw(	IOException			,
																			RuntimeException	)
{
	throw IOException( DECLARE_ASCII("DocumentProperties::impl_writeXMLProperties()\nNot implemented!\n"), static_cast< OWeakObject* >( this ) );
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_readFromStream(			SvStream&	aStream		,
														OUString&	sValue		,
												const	sal_uInt16&	nFixSize	) const
{
	ByteString sTemp;
	aStream.ReadByteString( sTemp );
	sValue = B2U_ENC( sTemp, aStream.GetStreamCharSet() );

	// This value has a fix size in file!
	// Skip to much letters.
	if( nFixSize > 0 )
	{
        /* #106821#
                There was a bug inside an older office version, which wrotes
                a corrupted document stream. The bug was Skip(-1) ... with
                an overflow. Because Skip(-1) was designed with an USHORT parameter.
                So it was realy a Skip(64k)! To fix our bug, we have to simulate this
                old and wrong behaviour :-(
                Seams to be no problem - because such corrupted files will be corrected
                at saving time. There we cut all signs from these strings if size is greater
                then FIXSIZE :-)
         */
        USHORT nOverflow = (USHORT)(nFixSize-sTemp.Len());
        aStream.SeekRel( nOverflow );
	}

	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_readFromStream( string )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_readFromStream(	SvStream&				aStream	,
												Sequence< sal_Int8 >&	lValue	) const
{
	// Get size of follow byte array from stream.
	sal_uInt16 nSequenceSize ;
	aStream >> nSequenceSize ;

	// Create new sequence with right size ...
	// ... and fill it with values.
	lValue.realloc( nSequenceSize );
	aStream.Read( (void*)lValue.getArray(), nSequenceSize );

	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_readFromStream( sequence< byte > )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_readFromStream(	SvStream&	aStream	,
												sal_Bool&	bValue	) const
{
	// Read a byte from stream!
	// sal_Bool can be "int" or "unsigned char"(!!!), but there is only a byte in this file.
	sal_uInt8 nTemp;
	aStream >> nTemp;

	// Check "BOOL" ... and return right value.
	if( nTemp == 0 )
	{
		bValue = sal_False;
	}
	else
	{
		bValue = sal_True;
	}

	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_readFromStream( boolean )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_readFromStream(	SvStream&	aStream	,
												sal_Int8&	nValue	) const
{
	aStream >> nValue;
	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_readFromStream( int8 )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_readFromStream(	SvStream&	aStream	,
												sal_Int16&	nValue	) const
{
	aStream >> nValue;
	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_readFromStream( int16 )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_readFromStream(	SvStream&	aStream	,
												sal_uInt16&	nValue	) const
{
	aStream >> nValue;
	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_readFromStream( unsigned int16 )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_readFromStream(	SvStream&	aStream	,
												sal_Int32&	nValue	) const
{
	aStream >> nValue;
	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_readFromStream( int32 )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_readFromStream(	SvStream&	aStream	,
												sal_uInt32&	nValue	) const
{
	aStream >> nValue;
	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_readFromStream( unsigned int32 )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_writeToStream(			SvStream&	aStream		,
												const	OUString&	sValue		,
												const	sal_uInt16&	nFixSize	)
{
	// If a FixSize is given ...
	// a) truncate to much letter ...
	// b) write string normaly(!) AND write blanks after string value(!!!) till FixSize is reached.
	OUString sWriteValue = sValue;

	// a)
	if	(
			( nFixSize				>	0			)	&&
			( sValue.getLength()	>	nFixSize	)
		)
	{
		// Warn programmer - perhaps he dont wich that!
		LOG_ASSERT( sal_False, "DocumentProperties::impl_writeToStream()\nString is to long! There is a fix size set. I truncate to much letters!\n" ) ;
		sWriteValue = sValue.copy( 0, nFixSize );
	}

	// Write string to stream. Use right encoding MS_1252.
	aStream.WriteByteString( sWriteValue );

	// b)
	for( sal_uInt16 nCounter=(sal_uInt16)(sWriteValue.getLength()); nCounter<nFixSize; ++nCounter )
	{
		aStream << ' ';
	}

	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_writeToStream( string )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_writeToStream(			SvStream&				aStream	,
												const	Sequence< sal_Int8 >&	lValue	)
{
	// Get count of elements and save it on stream.
	sal_uInt16 nSequenceSize = (sal_uInt16)(lValue.getLength());
	impl_writeToStream( aStream, nSequenceSize );

	// Save elements only, if some exist!
	if( nSequenceSize > 0 )
	{
		const sal_Int8* pArray = lValue.getConstArray();
		aStream.Write( (void*)pArray, nSequenceSize );
	}

	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_writeToStream( sequence< byte > )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_writeToStream(			SvStream&	aStream	,
												const	sal_Bool&	bValue	)
{
	// Check "BOOL" ... and write right value as unsigned int8!
	if( bValue == sal_False )
	{
		aStream << (sal_uInt8)0;
	}
	else
	{
		aStream << (sal_uInt8)1;
	}

	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_writeToStream( boolean )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_writeToStream(			SvStream&	aStream	,
												const	sal_Int8&	nValue	)
{
	aStream << nValue;
	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_writeToStream( int8 )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_writeToStream(			SvStream&	aStream	,
												const	sal_Int16&	nValue	)
{
	aStream << nValue;
	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_writeToStream( int16 )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_writeToStream(			SvStream&	aStream	,
												const	sal_uInt16&	nValue	)
{
	aStream << nValue;
	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_writeToStream( unsigned int16 )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_writeToStream(			SvStream&	aStream	,
												const	sal_Int32&	nValue	)
{
	aStream << nValue;
	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_writeToStream( int32 )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_writeToStream(			SvStream&	aStream	,
												const	sal_uInt32&	nValue	)
{
	aStream << nValue;
	#ifdef ENABLE_STREAMCHECK
	impldbg_checkSvStream( aStream, "impl_writeToStream( unsigned int32 )" );
	#endif
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
OUString DocumentProperties::impl_FormatID2MIMEType( sal_uInt32 nFormatID ) const
{
	const int nCount = sizeof( aStaticConvertTable ) / sizeof( tIMPL_ConverterItem );
	OUString aRet;
	if ( nFormatID < nCount )
		aRet = aStaticConvertTable[nFormatID].sMIMEType;
	return aRet;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
sal_Int32 DocumentProperties::impl_FormatID2FileVersion( sal_uInt32 nFormatID ) const
{
	const int nCount = sizeof( aStaticConvertTable ) / sizeof( tIMPL_ConverterItem );
	sal_Int32 nRet = 0;
	if ( nFormatID < nCount )
		nRet = aStaticConvertTable[nFormatID].nFileVersion;
	return nRet;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
sal_Bool DocumentProperties::impl_isFileVersionValid( sal_Int32 nFileVersion ) const
{
	sal_Bool bReturn;
	if	(
			( nFileVersion	==	SOFFICE_FILEFORMAT_31	)	||
			( nFileVersion	==	SOFFICE_FILEFORMAT_40	)	||
            ( nFileVersion  ==  SOFFICE_FILEFORMAT_50   )
		)
	{
		bReturn = sal_True;
	}
	else
	{
		bReturn = sal_False;
	}
	return bReturn;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
css::util::DateTime DocumentProperties::impl_TimeStamp2DateTime( const TimeStamp& aTimeStamp ) const
{
	//	Attention!
	//		We can't use a DateTime-object as type of any property with new UNO!
	//		We must use a DateTime-struct and convert the values.

	::DateTime	aDateTimeObject	;	// tools/DateTime				!!!
	css::util::DateTime	aDateTimeStruct	;	// com/sun/star/util/DateTime	!!!

	// Get date and time ...
	aDateTimeObject = aTimeStamp.GetTime();
	// ... and convert DateTime-object to struct ! (copy values)
    aDateTimeStruct.HundredthSeconds	= aDateTimeObject.Get100Sec	();
    aDateTimeStruct.Seconds				= aDateTimeObject.GetSec	();
    aDateTimeStruct.Minutes				= aDateTimeObject.GetMin	();
    aDateTimeStruct.Hours				= aDateTimeObject.GetHour	();
    aDateTimeStruct.Day					= aDateTimeObject.GetDay	();
    aDateTimeStruct.Month				= aDateTimeObject.GetMonth	();
    aDateTimeStruct.Year				= aDateTimeObject.GetYear	();

	// Return ricght type with right values.
	return aDateTimeStruct;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
TimeStamp DocumentProperties::impl_DateTime2TimeStamp( const css::util::DateTime& aDateTime ) const
{
	//	Attention!
	//		We can't use a DateTime-object as type of any property with new UNO!
	//		We must use a DateTime-struct and convert the values.

	// Get values from DateTime-struct and create a date and time instance ...
	Date aDate ( aDateTime.Day	, aDateTime.Month	, aDateTime.Year								);
	Time aTime ( aDateTime.Hours, aDateTime.Minutes	, aDateTime.Seconds, aDateTime.HundredthSeconds );

	// ... to use it for creation of a DateTime-object ...
	::DateTime	aDateTimeObject ( aDate, aTime		);
	// ... and a TimeStamp!
	TimeStamp	aTimeStamp		( aDateTimeObject	);

	// Return converted timestamp.
	return aTimeStamp;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_resetObject()
{
	// Set default values on some internal members.
	m_sHeaderType					=	DEFAULT_HEADERTYPE				;
	m_nHeaderVersion				=	DEFAULT_HEADERVERSION			;
	m_eFileEncoding					=	STREAMENCODING					;
	m_nFormatID						=	DEFAULT_FORMATID				;

	// Set default values on properties.
	m_aFixedProperties.m_sAuthor					=	DEFAULT_AUTHOR					;
	m_aFixedProperties.m_bAutoloadEnabled			=	DEFAULT_AUTOLOADENABLED			;
	m_aFixedProperties.m_nAutoloadSecs				=	DEFAULT_AUTOLOADSECS			;
	m_aFixedProperties.m_sAutoloadURL				=	DEFAULT_AUTOLOADURL				;
	m_aFixedProperties.m_sBlindCopiesTo				=	DEFAULT_BLINDCOPIESTO			;
	m_aFixedProperties.m_sCopiesTo		  			=	DEFAULT_COPIESTO				;
	m_aFixedProperties.m_sDefaultTarget  			=	DEFAULT_DEFAULTTARGET			;
	m_aFixedProperties.m_sDescription				=	DEFAULT_DESCRIPTION				;
	m_aFixedProperties.m_nEditingCycles  			=	DEFAULT_EDITINGCYCLES			;
	m_aFixedProperties.m_nEditingDuration			=	DEFAULT_EDITINGDURATION			;
	m_aFixedProperties.m_sInReplyTo					=	DEFAULT_INREPLYTO				;
	m_aFixedProperties.m_bIsEncrypted				=	DEFAULT_ISENCRYPTED				;
	m_aFixedProperties.m_sKeywords					=	DEFAULT_KEYWORDS				;
	m_aFixedProperties.m_sMIMEType					=	DEFAULT_MIMETYPE				;
	m_aFixedProperties.m_sModifiedBy				=	DEFAULT_MODIFIEDBY				;
	m_aFixedProperties.m_sNewsgroups				=	DEFAULT_NEWSGROUPS				;
	m_aFixedProperties.m_sOriginal					=	DEFAULT_ORIGINAL				;
	m_aFixedProperties.m_bPortableGraphics			=	DEFAULT_PORTABLEGRAPHICS		;
	m_aFixedProperties.m_sPrintedBy					=	DEFAULT_PRINTEDBY				;
	m_aFixedProperties.m_nPriority					=	DEFAULT_PRIORITY				;
	m_aFixedProperties.m_bQueryTemplate				=	DEFAULT_QUERYTEMPLATE			;
	m_aFixedProperties.m_sRecipient					=	DEFAULT_RECIPIENT				;
	m_aFixedProperties.m_sReferences				=	DEFAULT_REFERENCES				;
	m_aFixedProperties.m_sReplyTo					=	DEFAULT_REPLYTO					;
	m_aFixedProperties.m_bSaveGraphicsCompressed	=	DEFAULT_SAVEGRAPHICSCOMPRESSED	;
	m_aFixedProperties.m_bSaveOriginalGraphics		=	DEFAULT_SAVEORIGINALGRAPHICS	;
	m_aFixedProperties.m_bSaveVersionOnClose		=	DEFAULT_SAVEVERSIONONCLOSE		;
	m_aFixedProperties.m_sTemplate					=	DEFAULT_TEMPLATE				;
	m_aFixedProperties.m_bTemplateConfig			=	DEFAULT_TEMPLATECONFIG			;
	m_aFixedProperties.m_sTemplateFileName			=	DEFAULT_TEMPLATEFILENAME		;
	m_aFixedProperties.m_sTheme						=	DEFAULT_THEME					;
	m_aFixedProperties.m_sTitle						=	DEFAULT_TITLE					;
	m_aFixedProperties.m_bUserData					=	DEFAULT_USERDATA				;

	/*BUG #71852#

		If follow sequence empty - basic can't handle it by calling getPropertyValue()/setPropertyValue().
		It will set as a sequence< any >!?
		If script programmer use property name dirctly - all works fine.
	 */

	// a) Use follow line normaly and if you will reproduce the problem!
	m_aFixedProperties.m_seqExtraData					=	DEFAULT_EXTRADATA				;
	// b) Use follow lines if you will "disable" the bug!
	//m_seqExtraData.realloc(1);
	//m_seqExtraData[0] = 1;

	/*BUG #71852#*/

	// Reset DateTime-structures.
	impl_resetDateTime( m_aFixedProperties.m_aCreationDate	);
	impl_resetDateTime( m_aFixedProperties.m_aModifyDate	);
	impl_resetDateTime( m_aFixedProperties.m_aPrintDate		);
	impl_resetDateTime( m_aFixedProperties.m_aTemplateDate	);

	// Reset "NameContainer" !
	m_aPropertyHash.clear();
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
void DocumentProperties::impl_resetDateTime( css::util::DateTime& aDateTime )
{
    aDateTime.HundredthSeconds	= 0;
    aDateTime.Seconds			= 0;
    aDateTime.Minutes			= 0;
    aDateTime.Hours				= 0;
    aDateTime.Day				= 0;
    aDateTime.Month				= 0;
    aDateTime.Year				= 0;
}

//******************************************************************************************************************************
//	private method
//******************************************************************************************************************************
const Sequence< Property > DocumentProperties::impl_getStaticPropertyDescriptor()
{
	// Create a new static property array to initialize sequence!
	// Table of all predefined properties of this class. Its used from OPropertySetHelper-class!
	// Don't forget to change the defines (see begin of this file), if you add, change or delete a property in this list!!!
	// It's necessary for methods of OPropertyHelper.
	// ATTENTION:
	//		YOU MUST SORT FOLLOW TABLE BY NAME !!!
	static const Property pPropertys[] =
	{
		Property( DECLARE_ASCII("Author"				), HANDLE_AUTHOR				, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("AutoloadEnabled"		), HANDLE_AUTOLOADENABLED		, ::getCppuType((sal_Bool*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("AutoloadSecs"        	), HANDLE_AUTOLOADSECS			, ::getCppuType((sal_Int32*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("AutoloadURL"         	), HANDLE_AUTOLOADURL			, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("BlindCopiesTo"       	), HANDLE_BLINDCOPIESTO			, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("CopiesTo"              ), HANDLE_COPIESTO				, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("CreationDate"        	), HANDLE_CREATIONDATE			, ::getCppuType((css::util::DateTime*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("DefaultTarget"       	), HANDLE_DEFAULTTARGET			, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("Description"         	), HANDLE_DESCRIPTION			, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("EditingCycles"       	), HANDLE_EDITINGCYCLES			, ::getCppuType((sal_Int16*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("EditingDuration"     	), HANDLE_EDITINGDURATION		, ::getCppuType((sal_Int32*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("ExtraData"				), HANDLE_EXTRADATA				, ::getCppuType((Sequence< sal_Int8 >*)0)	, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("InReplyTo"           	), HANDLE_INREPLYTO				, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("IsEncrypted"         	), HANDLE_ISENCRYPTED			, ::getCppuType((sal_Bool*)0)				, PropertyAttribute::TRANSIENT | PropertyAttribute::READONLY),
		Property( DECLARE_ASCII("Keywords"            	), HANDLE_KEYWORDS				, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("MIMEType"            	), HANDLE_MIMETYPE				, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT | PropertyAttribute::READONLY),
		Property( DECLARE_ASCII("ModifiedBy"          	), HANDLE_MODIFIEDBY			, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("ModifyDate"          	), HANDLE_MODIFYDATE			, ::getCppuType((css::util::DateTime*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("Newsgroups"          	), HANDLE_NEWSGROUPS			, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("Original"            	), HANDLE_ORIGINAL				, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("PortableGraphics"		), HANDLE_PORTABLEGRAPHICS		, ::getCppuType((sal_Bool*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("PrintDate"           	), HANDLE_PRINTDATE				, ::getCppuType((css::util::DateTime*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("PrintedBy"           	), HANDLE_PRINTEDBY				, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("Priority"            	), HANDLE_PRIORITY				, ::getCppuType((sal_uInt16*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("QueryTemplate"			), HANDLE_QUERYTEMPLATE			, ::getCppuType((sal_Bool*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("Recipient"           	), HANDLE_RECIPIENT				, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("References"          	), HANDLE_REFERENCES			, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("ReplyTo"             	), HANDLE_REPLYTO				, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("SaveGraphicsCompressed"), HANDLE_SAVEGRAPHICSCOMPRESSED, ::getCppuType((sal_Bool*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("SaveOriginalGraphics"	), HANDLE_SAVEORIGINALGRAPHICS	, ::getCppuType((sal_Bool*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("SaveVersionOnClose"	), HANDLE_SAVEVERSIONONCLOSE	, ::getCppuType((sal_Bool*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("Template"            	), HANDLE_TEMPLATE				, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("TemplateConfig"		), HANDLE_TEMPLATECONFIG		, ::getCppuType((sal_Bool*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("TemplateDate"        	), HANDLE_TEMPLATEDATE			, ::getCppuType((css::util::DateTime*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("TemplateFileName"		), HANDLE_TEMPLATEFILENAME		, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("Theme"               	), HANDLE_THEME					, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("Title"               	), HANDLE_TITLE					, ::getCppuType((OUString*)0)				, PropertyAttribute::TRANSIENT								),
		Property( DECLARE_ASCII("UserData"				), HANDLE_USERDATA				, ::getCppuType((sal_Bool*)0)				, PropertyAttribute::TRANSIENT								) // NO "," at last item !!!
	};
	// Use it to initialize sequence!
	static const Sequence< Property > seqPropertyDescriptor( pPropertys, PROPERTYCOUNT );
	// Return static "PropertyDescriptor"
	return seqPropertyDescriptor ;
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
sal_Bool DocumentProperties::impldbg_checkParameter_DocumentProperties( const Reference< XMultiServiceFactory >& xFactory )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &xFactory		==	NULL		)	||
			( xFactory.is()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool DocumentProperties::impldbg_checkParameter_read( const OUString& sURL )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sURL				==	NULL	)	||
			( sURL.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool DocumentProperties::impldbg_checkParameter_write( const OUString& sURL )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sURL				==	NULL	)	||
			( sURL.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool DocumentProperties::impldbg_checkParameter_insertByName(	const	OUString&	sName	,
 																	const	Any&		aValue 	)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sName			==	NULL		)	||
			( sName.getLength()	<	1			)	||
			( &aValue			==	NULL		)	||
			( aValue.hasValue()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool DocumentProperties::impldbg_checkParameter_removeByName( const OUString& sName )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sName			==	NULL	)	||
			( sName.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool DocumentProperties::impldbg_checkParameter_replaceByName(	const	OUString&	sName	,
 											   						const	Any&		aValue	)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sName			==	NULL		)	||
			( sName.getLength()	<	1			)	||
			( &aValue			==	NULL		)	||
			( aValue.hasValue()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool DocumentProperties::impldbg_checkParameter_getByName( const OUString& sName )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sName			==	NULL	)	||
			( sName.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool DocumentProperties::impldbg_checkParameter_hasByName( const OUString& sName )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sName			==	NULL	)	||
			( sName.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

#endif // ENABLE_ASSERTIONS

//******************************************************************************************************************************
// Don't use follow method at everytime! Only for debugging and testing
//******************************************************************************************************************************
#ifdef ENABLE_SVSTREAM_CHECK

void DocumentProperties::impldbg_checkSvStream(			SvStream&	aStream	,
												const	OString&	sCaller	)
{
	// Has stream errors?
	sal_uInt32 nError = aStream.GetError();

	if( nError != SVSTREAM_OK )
	{
		// Yes; Format message to informize user !!!
		OUStringBuffer sMessage( 10000 );
		sMessage.appendAscii( sCaller	);
		sMessage.appendAscii( "\n"		);

		switch( nError )
		{
//			case SVSTREAM_GENERALERROR			:	// same ID like SVSTREAM_SHARE_BUFF_EXCEEDED
			case SVSTREAM_FILE_NOT_FOUND		:	sMessage.appendAscii( "File not found" );
													break ;
			case SVSTREAM_PATH_NOT_FOUND		:	sMessage.appendAscii( "Path not found" );
													break ;
			case SVSTREAM_TOO_MANY_OPEN_FILES	:	sMessage.appendAscii( "Too many open files" );
													break ;
			case SVSTREAM_ACCESS_DENIED			:	sMessage.appendAscii( "Access denied" );
													break ;
//			case SVSTREAM_SHARING_VIOLATION		:	// same ID like SVSTREAM_SHARE_BUFF_EXCEEDED
//			case SVSTREAM_LOCKING_VIOLATION		:	// same ID like SVSTREAM_SHARE_BUFF_EXCEEDED
			case SVSTREAM_SHARE_BUFF_EXCEEDED	:	sMessage.appendAscii( "Sharing violation or Locking violation or Share buffer exceeded" );
													break ;
			case SVSTREAM_INVALID_ACCESS		:	sMessage.appendAscii( "Invalid access" );
													break ;
			case SVSTREAM_INVALID_HANDLE		:	sMessage.appendAscii( "General Error or Invalid handle" );
													break ;
			case SVSTREAM_CANNOT_MAKE			:	sMessage.appendAscii( "Cannot make" );
													break ;
			case SVSTREAM_INVALID_PARAMETER		:	sMessage.appendAscii( "Invalid parameter" );
													break ;
			case SVSTREAM_READ_ERROR			:	sMessage.appendAscii( "Read error" );
													break ;
			case SVSTREAM_WRITE_ERROR			:	sMessage.appendAscii( "Write error" );
													break ;
			case SVSTREAM_SEEK_ERROR			:	sMessage.appendAscii( "Seek error" );
													break ;
			case SVSTREAM_TELL_ERROR			:	sMessage.appendAscii( "Tell error" );
													break ;
			case SVSTREAM_OUTOFMEMORY			:	sMessage.appendAscii( "Out of memory" );
													break ;
			case SVSTREAM_FILEFORMAT_ERROR		:	sMessage.appendAscii( "Fileformat error" );
													break ;
			case SVSTREAM_WRONGVERSION			:	sMessage.appendAscii( "Wrong version" );
													break ;
			case SVSTREAM_DISK_FULL				:	sMessage.appendAscii( "Disk full" );
													break ;
			default								:	sMessage.appendAscii( "Unknown error !!!" );
													break ;
		}

		sMessage.appendAscii( "\n" );
		LOG_ASSERT( sal_False, U2B( sMessage.makeStringAndClear() ) );
	}
}

#endif	// ENABLE_SVSTREAM_CHECK

}		// namespace framework
