/*************************************************************************
 *
 *  $RCSfile: contenthandlerfactory.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/04 16:04:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_SERVICES_CONTENTHANDLERFACTORY_HXX_
#include <services/contenthandlerfactory.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_TRANSACTIONGUARD_HXX_
#include <threadhelp/transactionguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

#ifndef __FRAMEWORK_QUERIES_H_
#include <queries.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	XInterface, XTypeProvider, XServiceInfo
//*****************************************************************************************************************
DEFINE_XINTERFACE_8                     (   ContentHandlerFactory                                ,
                                            OWeakObject                                          ,
                                            DIRECT_INTERFACE(css::lang::XTypeProvider           ),
                                            DIRECT_INTERFACE(css::lang::XServiceInfo            ),
                                            DIRECT_INTERFACE(css::lang::XMultiServiceFactory    ),
                                            DIRECT_INTERFACE(css::container::XNameContainer     ),
                                            DIRECT_INTERFACE(css::container::XNameReplace       ),
                                            DIRECT_INTERFACE(css::container::XNameAccess        ),
                                            DIRECT_INTERFACE(css::container::XElementAccess     ),
                                            DIRECT_INTERFACE(css::util::XFlushable              )
										)

DEFINE_XTYPEPROVIDER_8                  (   ContentHandlerFactory                                ,
                                            css::lang::XTypeProvider                             ,
                                            css::lang::XServiceInfo                              ,
                                            css::lang::XMultiServiceFactory                      ,
                                            css::container::XNameContainer                       ,
                                            css::container::XNameReplace                         ,
                                            css::container::XNameAccess                          ,
                                            css::container::XElementAccess                       ,
                                            css::util::XFlushable
										)

DEFINE_XSERVICEINFO_ONEINSTANCESERVICE  (   ContentHandlerFactory                                ,
                                            ::cppu::OWeakObject                                  ,
                                            SERVICENAME_CONTENTHANDLERFACTORY                    ,
                                            IMPLEMENTATIONNAME_CONTENTHANDLERFACTORY
                                        )

DEFINE_INIT_SERVICE                     (   ContentHandlerFactory,
                                            {
                                            }
                                        )

/*-************************************************************************************************************//**
    @short      standard constructor/destructor
    @descr      Initialize a new instance and fill our cache with values ...
                but we do nothing in our dtor! Because - it's not agood idea to do something in a service destructor.
                Do it in dispose()!

    @attention  Don't use ctor to work with your own reference! Use DEFINE_INIT_SERVICE instaendly. It's called directly
                after the ctor automaticly by our factory.

    @seealso    member m_aCache
    @seealso    method dispose()

    @param      "xFactory", factory which has created us.
    @return     -

    @onerror    An ASSERTION is thrown in debug version, if xFactory is invalid or cache can't filled.
*//*-*************************************************************************************************************/
ContentHandlerFactory::ContentHandlerFactory( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory )
		//	Init baseclasses first
        :   ThreadHelpBase  (           )
        ,   TransactionBase (           )
		,	OWeakObject		(			)
		// Init member
		,	m_xFactory		( xFactory	)
		,	m_aCache		(			)
{
	// Safe impossible cases
	// a) We can't work without valid initialization.
	// b) We need our cache for working.
    LOG_ASSERT2( implcp_ContentHandlerFactory( xFactory )  , "ContentHandlerFactory::ContentHandlerFactory()", "Invalid parameter detected!"                           )
    LOG_ASSERT2( m_aCache.isValidOrRepairable()==sal_False , "ContentHandlerFactory::ContentHandlerFactory()", "Initializing of cache failed. Factory can't work so!"  )

	// Enable working mode on object!
    m_aTransactionManager.setWorkingMode( E_WORK );
}

//*****************************************************************************************************************
ContentHandlerFactory::~ContentHandlerFactory()
{
    // 1) It's not agood idea to do anything in our dtor - Use dispose()!
    // 2) Our cache is cleared automaticly!
    //    He use a ref count to do that!
}

/*-************************************************************************************************************//**
    @short      create a new handler
    @descr      We search for an agreement between given type name and our cache-content.
                If we found some information, we create the registered handler for these type.
                Otherwise - we return NULL.
                We search from begin to end of internal list!

    @seealso    class FilterCache

    @param      "sTypeName", type name which handler should be registered for
    @param      "lArguments", list of optional arguments for initializing of new handler.
    @return     A reference to a new created handler.

    @onerror    A null reference is returned.
*//*-*************************************************************************************************************/
css::uno::Reference< css::uno::XInterface > SAL_CALL ContentHandlerFactory::createInstance( const ::rtl::OUString& sTypeName ) throw( css::uno::Exception        ,
                                                                                                                               css::uno::RuntimeException )
{
    return createInstanceWithArguments( sTypeName, css::uno::Sequence< css::uno::Any >() );
}

//*****************************************************************************************************************
css::uno::Reference< css::uno::XInterface > SAL_CALL ContentHandlerFactory::createInstanceWithArguments( const ::rtl::OUString&                      sTypeName  ,
                                                                                                  const css::uno::Sequence< css::uno::Any >&  lArguments ) throw( css::uno::Exception        ,
                                                                                                                                                                  css::uno::RuntimeException )
{
	/* UNSAFE AREAY -------------------------------------------------------------------------------------------- */
    LOG_ASSERT2( implcp_createInstanceWithArguments( sTypeName, lArguments ), "ContentHandlerFactory::createInstanceWidthArguments()", "Invalid parameter detected!" )

    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

	/* SAFE AREAY ---------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( m_aLock );

    // Hold member by references!
    FilterCache                                              aCacheRef                   ;
    css::uno::Reference< css::lang::XMultiServiceFactory >   xFactoryRef =   m_xFactory  ;

    aReadLock.unlock();
    /* UNSAFE AREAY ---------------------------------------------------------------------------------------- */

    ::rtl::OUString                             sHandlerName;
    css::uno::Reference< css::uno::XInterface > xHandler    ;

    //-------------------------------------------------------------------------------------------------------------
    // Try all registered handlers for these type.
    // first come, first serve
    {
        CheckedStringListIterator   pIterator    ;
        ::rtl::OUString             sHandlerName ;
        while(
                ( aCacheRef.searchContentHandlerForType( sTypeName, pIterator, sHandlerName ) == sal_True  )   &&
                ( xHandler.is()                                                               == sal_False )
             )
        {
            // Try to create handler.
            xHandler = css::uno::Reference< css::uno::XInterface >( xFactoryRef->createInstance( sHandlerName ), css::uno::UNO_QUERY );
            LOG_ASSERT2( xHandler.is()==sal_False, "ContentHandlerFactory::createInstance()", "I found a registered handler for your given type name .. but couldn't create it!" )
        }
    }

    // Set configuration data on handler.
    // Support given handler the new property mechanism?
    // It's a MUST!
    // If xHandler = NULL => xInit = NULL too! (Don't check xHandler again!)
    css::uno::Reference< css::lang::XInitialization > xInit( xHandler, css::uno::UNO_QUERY );
    if( xInit.is() == sal_True )
    {
        // Yes these handler support the new mechanism.
        // Try to set configuration values on it.
        css::uno::Sequence< css::uno::Any > lProperties( 1 );
        lProperties[0] <<= aCacheRef.getContentHandlerProperties( sHandlerName );
        xInit->initialize( lProperties );
    }

	// Return result of operation.
    return xHandler;
}

/*-************************************************************************************************************//**
    @short      not implemented
    @descr      Please use XNameAcces instead of these!

    @attention  At createInstance/WithArguments() you must give me a TypeName ... and not a handler name!
                Thats the reason for NON-IMPLEMENTING of these method!

    @seealso    -

    @param      -
    @return     -

    @onerror    -
*//*-*************************************************************************************************************/
css::uno::Sequence< ::rtl::OUString > SAL_CALL ContentHandlerFactory::getAvailableServiceNames() throw( css::uno::RuntimeException )
{
    LOG_ERROR( "ContentHandlerFactory::getAvailableServiceNames()", "Not supported! Please use XNameContainer interface instead of these!" )
    return css::uno::Sequence< ::rtl::OUString >();
}

/*-************************************************************************************************************//**
    @short      register new handler in configuration
    @descr      Use this method to register a new handler. We will write given information in our configuration
                file "org.openoffice.Office.TypeDetection.xml" and use it from follow office startup.
                We will change it at internal cache only. call flush() to write it on configuration realy!

    @seealso    method flush()

    @param      "sHandlerName"       , internal name of new handler
    @param      "aHandlerProperties" , properties of new handler with follow structure:

                    [0].Name    =   "Types"
                    [0].Value   =   list of supported types by this handler implementation as [stringlist]

    @return     -

    @onerror    Exceptions are thrown.
*//*-*************************************************************************************************************/
void SAL_CALL ContentHandlerFactory::insertByName( const ::rtl::OUString& sHandlerName       ,
                                            const css::uno::Any&   aHandlerProperties ) throw( css::lang::IllegalArgumentException   ,
                                                                                               css::container::ElementExistException ,
                                                                                               css::lang::WrappedTargetException     ,
                                                                                               css::uno::RuntimeException            )
{
    LOG_WARNING( "ContentHandlerFactory::insertByName()", "Not supported yet!" );

	/* UNSAFE AREAY -------------------------------------------------------------------------------------------- */
	// Check arguments first.
	if	(
            ( &sHandlerName              ==  NULL    )   ||
            ( sHandlerName.getLength()   <   1       )
		)
	{
        throw css::lang::IllegalArgumentException( DECLARE_ASCII("ContentHandlerFactory::insertByName()\nInvalid parameter \"sHandlerName\" detected! We don't accept NULL pointer or empty values.\n"), static_cast< ::cppu::OWeakObject* >( this ), 1 );
	}

	if	(
            ( &aHandlerProperties                ==  NULL                                                                           )   ||
            ( aHandlerProperties.hasValue()      ==  sal_False                                                                      )   ||
            ( aHandlerProperties.getValueType()  !=  ::getCppuType( (const css::uno::Sequence< css::beans::PropertyValue >*)NULL )  )
		)
	{
        throw css::lang::IllegalArgumentException( DECLARE_ASCII("ContentHandlerFactory::insertByName()\nInvalid parameter \"aHandlerProperties\" detected! We don't accept NULL pointer or empty values.\n"), static_cast< ::cppu::OWeakObject* >( this ), 2 );
	}

    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

	/* SAFE AREAY ---------------------------------------------------------------------------------------------- */
    ReadGuard   aReadLock( m_aLock );
    FilterCache aCacheRef;
    aReadLock.unlock();
    /* UNSAFE AREAY -------------------------------------------------------------------------------------------- */

    // Attention: ElementExistException is thrown by addHandler() automaticly!
    css::uno::Sequence< css::beans::PropertyValue > lProperties;
    aHandlerProperties >>= lProperties;
//  aCacheRef.addHandler( sHandlerName, lProperties );
}

/*-************************************************************************************************************//**
    @short      remove handler from configuration
    @descr      We will change it at internal cache only. call flush() to write it on configuration realy!

    @seealso    method flush()

    @param      "sHandlerName", internal name of handler to remove
    @return     -

    @onerror    Exceptions are thrown.
*//*-*************************************************************************************************************/
void SAL_CALL ContentHandlerFactory::removeByName( const ::rtl::OUString& sHandlerName ) throw( css::container::NoSuchElementException ,
                                                                                         css::lang::WrappedTargetException      ,
                                                                                         css::uno::RuntimeException             )
{
    LOG_WARNING( "ContentHandlerFactory::removeByName()", "Not supported yet!" );

	/* UNSAFE AREAY -------------------------------------------------------------------------------------------- */
    LOG_ASSERT2( implcp_removeByName( sHandlerName ), "ContentHandlerFactory::removeByName()", "Invalid parameter detected!" )
    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

	/* SAFE AREAY ---------------------------------------------------------------------------------------------- */
    ReadGuard   aReadLock( m_aLock );
    FilterCache aCacheRef;
    aReadLock.unlock();
    /* UNSAFE AREAY -------------------------------------------------------------------------------------------- */

    // Attention: NoSuchElementException is thrown by removeHandler() automaticly!
//    aCacheRef.removeHandler( sHandlerName );
}

/*-************************************************************************************************************//**
    @short      replace properties of handler
    @descr      We will change it at internal cache only. call flush() to write it on configuration realy!

    @seealso    method flush()

    @param      "sHandlerName"      , internal name of handler to replace
    @param      "aHandlerProperties", new properties of handler
    @return     -

    @onerror    Exceptions are thrown.
*//*-*************************************************************************************************************/
void SAL_CALL ContentHandlerFactory::replaceByName( const ::rtl::OUString& sHandlerName       ,
                                             const css::uno::Any&   aHandlerProperties ) throw( css::lang::IllegalArgumentException    ,
                                                                                                css::container::NoSuchElementException ,
                                                                                                css::lang::WrappedTargetException      ,
                                                                                                css::uno::RuntimeException             )
{
    LOG_WARNING( "ContentHandlerFactory::replaceByName()", "Not supported yet!" );

	/* UNSAFE AREAY -------------------------------------------------------------------------------------------- */
	if	(
            ( &sHandlerName              ==  NULL    )   ||
            ( sHandlerName.getLength()   <   1       )
		)
	{
        throw css::lang::IllegalArgumentException( DECLARE_ASCII("ContentHandlerFactory::replaceByName()\nInvalid parameter detected! We don't accept NULL pointer or empty values.\n"), static_cast< ::cppu::OWeakObject* >( this ), 1 );
	}

	if	(
            ( &aHandlerProperties                ==  NULL                                                                          )   ||
            ( aHandlerProperties.hasValue()      ==  sal_False                                                                     )   ||
            ( aHandlerProperties.getValueType()  !=  ::getCppuType( (const css::uno::Sequence< css::beans::PropertyValue >*)NULL ) )
		)
	{
        throw css::lang::IllegalArgumentException( DECLARE_ASCII("ContentHandlerFactory::replaceByName()\nInvalid parameter detected! We don't accept NULL pointer or empty values.\n"), static_cast< ::cppu::OWeakObject* >( this ), 2 );
    }

    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

	/* SAFE AREAY ---------------------------------------------------------------------------------------------- */
    ReadGuard   aReadLock( m_aLock );
    FilterCache aCacheRef;
    aReadLock.unlock();
    /* UNSAFE AREAY -------------------------------------------------------------------------------------------- */

    // Attention: NoSuchElementException is thrown by replaceHandler() automaticly!
    css::uno::Sequence< css::beans::PropertyValue > lProperties;
    aHandlerProperties >>= lProperties;
//  aCacheRef.replaceHandler( sHandlerName, lProperties );
}

/*-************************************************************************************************************//**
    @short      return properties of registered handler specified by his service name
    @descr      Use these method to get all informations about our internal handler cache.
                We return a Sequence< PropertyValue > in an Any packed as result.

                structure of return value:
                    [0].Name    =   "Types"
                    [0].Value   =   list of supported types by this handler implementation as [stringlist]

    @seealso    method getElementNames()
    @seealso    method hasByName()

    @param      "sName", the name of searched handler (use getElementNames() to get it!)
    @return     A Sequence< PropertyValue > packed in an Any.

    @onerror    If given name not exist a NoSuchElementException is thrown.
*//*-*************************************************************************************************************/
css::uno::Any SAL_CALL ContentHandlerFactory::getByName( const ::rtl::OUString& sName ) throw( css::container::NoSuchElementException ,
                                                                                        css::lang::WrappedTargetException      ,
                                                                                        css::uno::RuntimeException             )
{
	/* UNSAFE AREAY -------------------------------------------------------------------------------------------- */
    LOG_ASSERT2( implcp_getByName( sName ), "ContentHandlerFactory::getByName()", "Invalid parameter detected!" )
    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREAY ------------------------------------------------------------------------------------------ */
    // Attention: Normaly our filter cache is threadsafe himself. But we need a thread synchronization between
    // "exist()" and get...Properties()"!
    css::uno::Any   aResult             ;
    ReadGuard       aReadLock( m_aLock );
    if( m_aCache.existsContentHandler( sName ) == sal_False )
    {
        throw css::container::NoSuchElementException( DECLARE_ASCII("ContentHandlerFactory::getByName()\nSpecified handler not exist!\n"), static_cast< ::cppu::OWeakObject* >( this ) );
    }
    aResult <<= m_aCache.getContentHandlerProperties( sName );

	return aResult;
}

/*-************************************************************************************************************//**
    @short      return list of all well known handler names from configuration
    @descr      Use these method to get all names of well known handler.
                You can use it to get the properties of a handler by calling getByName()!

    @seealso    method getByName()
    @seealso    method hasByName()

    @param      -
    @return     A list of well known handler

    @onerror    No error should occure.
*//*-*************************************************************************************************************/
css::uno::Sequence< ::rtl::OUString > SAL_CALL ContentHandlerFactory::getElementNames() throw( css::uno::RuntimeException )
{
    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREAY ------------------------------------------------------------------------------------------ */
    // I think we don't need any lock here ... because:
    // - cache live if we live
    // - he is threadsafe by himself
    // - this transaction is non breakable by a dispose() call!
    return m_aCache.getAllContentHandlerNames();
}

/*-************************************************************************************************************//**
    @short      check if searched frame handler exist in configuration
    @descr      Normaly nobody need these method realy (use getElementNames() in combination with getByName()).
                We guarantee correctness of these mechanism. There is no reason to check for existing elements then ...
                but if you have an unknwon name and has no fun to search it in returned sequence ...
                you can call these ...

    @seealso    method getByName()
    @seealso    method getElementNames()

    @param      "sName", implementation name of searched frame handler
    @return     sal_True if handler exist, sal_False otherwise.

    @onerror    No error should occure.
*//*-*************************************************************************************************************/
sal_Bool SAL_CALL ContentHandlerFactory::hasByName( const ::rtl::OUString& sName ) throw( css::uno::RuntimeException )
{
    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREAY ------------------------------------------------------------------------------------------ */
    // I think we don't need any lock here ... because:
    // - cache live if we live
    // - he is threadsafe by himself
    // - this transaction is non breakable by a dispose() call!
    return m_aCache.existsContentHandler( sName );
}

/*-************************************************************************************************************//**
    @short      return the type of retrun value of method XNameAccess::getByName()
    @descr      In these implementation its a Sequence< PropertyValue > everytime!

    @seealso    description of interface XNameAccess

    @param      -
    @return     Type of Sequence< PropertyValue >.

    @onerror    No error should occure.
*//*-*************************************************************************************************************/
css::uno::Type SAL_CALL ContentHandlerFactory::getElementType() throw( css::uno::RuntimeException )
{
    // Look for rejected calls!
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    return( ::getCppuType( (const css::uno::Sequence< css::beans::PropertyValue >*)NULL ) );
}

/*-************************************************************************************************************//**
    @short      return state if informations about frame handler available
    @descr      If these method return false - no information could'nt read from configuration ...
                I think nothing will work then. Normaly we return TRUE!

    @seealso    class FilterCache!

    @param      -
    @return     sal_True if information available, sal_False otherwise.

    @onerror    No error should occure.
*//*-*************************************************************************************************************/
sal_Bool SAL_CALL ContentHandlerFactory::hasElements() throw( css::uno::RuntimeException )
{
    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREAY ------------------------------------------------------------------------------------------ */
    // I think we don't need any lock here ... because:
    // - cache live if we live
    // - he is threadsafe by himself
    // - this transaction is non breakable by a dispose() call!
    return m_aCache.hasContentHandlers();
}

/*-************************************************************************************************************//**
    @short      support of saving changed data if user need it
    @descr      We support a name container at this implementation. User can read AND write handlers.
                We don't write all changes directly to disk ... We change ou internal structures only.
                User must call this method to do that! We don't support automaticly saving of changed data ...
                because, we cant guarantee these! May be configuration services are dead before we will die.

    @seealso    class FilterCache
    @seealso    method insertByName()
    @seealso    method replaceByName()

    @param      -
    @return     -

    @onerror    No error should occure.
*//*-*************************************************************************************************************/
void SAL_CALL ContentHandlerFactory::flush() throw ( css::uno::RuntimeException)
{
    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREAY ------------------------------------------------------------------------------------------ */
    // I think we don't need any lock here ... because:
    // - cache live if we live
    // - he is threadsafe by himself
    // - this transaction is non breakable by a dispose() call!
    m_aCache.flush(DataContainer::E_CONTENTHANDLER);
}

/*-************************************************************************************************************//**
    @short      add/remove listener for flush calls
    @descr      If you whish to get information about changed data, you should add your implementation
                as a listener.

    @seealso    method flush()

    @param      "xListener", reference to listener
    @return     -

    @onerror    -
*//*-*************************************************************************************************************/
void SAL_CALL ContentHandlerFactory::addFlushListener( const css::uno::Reference< css::util::XFlushListener >& xListener ) throw ( css::uno::RuntimeException )
{
    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    LOG_ERROR( "ContentHandlerFactory::addFlushListener()", "Not implemented yet!" )
}

//*****************************************************************************************************************
void SAL_CALL ContentHandlerFactory::removeFlushListener( const css::uno::Reference< css::util::XFlushListener >& xListener ) throw ( css::uno::RuntimeException )
{
    // Look for rejected calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    LOG_ERROR( "ContentHandlerFactory::addFlushListener()", "Not implemented yet!" )
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
sal_Bool ContentHandlerFactory::implcp_ContentHandlerFactory( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory )
{
	return	(
				( &xFactory		==	NULL		)	||
				( xFactory.is()	==	sal_False	)
			);
}

//*****************************************************************************************************************
sal_Bool ContentHandlerFactory::implcp_createInstanceWithArguments( const ::rtl::OUString&                     sTypeName  ,
                                                             const css::uno::Sequence< css::uno::Any >& lArguments )
{
	return	(
				( &sTypeName			==	NULL	)	||
				( sTypeName.getLength()	<	1		)	||
				( &lArguments			==	NULL	)
			);
}

//*****************************************************************************************************************
sal_Bool ContentHandlerFactory::implcp_getByName( const ::rtl::OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
sal_Bool ContentHandlerFactory::implcp_hasByName( const ::rtl::OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
sal_Bool ContentHandlerFactory::implcp_removeByName( const ::rtl::OUString& sHandlerName )
{
	return	(
                ( &sHandlerName              ==  NULL    )   ||
                ( sHandlerName.getLength()   <   1       )
			);
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
