/*************************************************************************
 *
 *  $RCSfile: asynceventnotifier.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/18 13:25:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//------------------------------------------------------------------------
// includes
//------------------------------------------------------------------------

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef _ASYNCEVENTNOTIFIER_HXX_
#include "asynceventnotifier.hxx"
#endif

#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif

#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERLISTENER_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerListener.hpp>
#endif

#include <memory>

//------------------------------------------------
//
//------------------------------------------------

using namespace com::sun::star;
using ::com::sun::star::ui::dialogs::XFilePickerListener;

//------------------------------------------------
//
//------------------------------------------------

SalGtkAsyncEventNotifier::SalGtkAsyncEventNotifier(cppu::OBroadcastHelper& rBroadcastHelper) :    
	m_bRun(false)
	, m_rBroadcastHelper(rBroadcastHelper)
{    
}

//------------------------------------------------
//
//------------------------------------------------

SalGtkAsyncEventNotifier::~SalGtkAsyncEventNotifier()
{
	OSL_ENSURE(!isRunning(),"Thread not stopped, destroying this instance leads to desaster");
}

//------------------------------------------------
//
//------------------------------------------------

bool SAL_CALL SalGtkAsyncEventNotifier::startup(bool bCreateSuspended)
{
	osl::MutexGuard aGuard(m_aMutex);

	// m_bRun may already be false because of a
	// call to stop but the thread did not yet
	// terminate so m_hEventNotifierThread is
	// yet a valid thread handle that should 
	// not be overwritten
	if (!m_bRun)
	{
		if (bCreateSuspended)
	        	m_bRun = createSuspended();
		else
			m_bRun = create();
	}

	OSL_POSTCOND(m_bRun, "Could not start event notifier!");

	return m_bRun;
}


//------------------------------------------------
//
//------------------------------------------------
void SAL_CALL SalGtkAsyncEventNotifier::shutdown()
{
	osl::ResettableMutexGuard aGuard(m_aMutex);
	
	OSL_PRECOND(m_bRun,"Event notifier does not run!");

	m_bRun = false;
	m_aExitCondition.reset();

	m_aNotifyCondition.set();
	
	aGuard.clear();
	m_aExitCondition.wait();

	terminate();
	join();
}

//------------------------------------------------
//
//------------------------------------------------

void SAL_CALL SalGtkAsyncEventNotifier::notifyEvent(CEventNotification* EventNotification)
{
	osl::MutexGuard aGuard(m_aMutex);

	OSL_ENSURE(m_bRun,"Event notifier is not running!");

	if (m_bRun)
	{
		m_EventList.push_back(EventNotification);
		m_aNotifyCondition.set();
	}
}

//------------------------------------------------
//
//------------------------------------------------

size_t SAL_CALL SalGtkAsyncEventNotifier::getEventListSize()
{
	osl::MutexGuard aGuard(m_aMutex);
	return m_EventList.size();
}

//------------------------------------------------
//
//------------------------------------------------

CEventNotification* SAL_CALL SalGtkAsyncEventNotifier::getNextEventRecord()
{
	osl::MutexGuard aGuard(m_aMutex);
	return m_EventList.front();
}
//------------------------------------------------
//
//------------------------------------------------

void SAL_CALL SalGtkAsyncEventNotifier::removeNextEventRecord()
{
	osl::MutexGuard aGuard(m_aMutex);    
	m_EventList.pop_front();	
}

//------------------------------------------------
//
//------------------------------------------------

void SAL_CALL SalGtkAsyncEventNotifier::run() 
{
	while (m_bRun)
	{       
		m_aNotifyCondition.wait();

		while (getEventListSize() > 0)
		{
			std::auto_ptr<CEventNotification> EventNotification(getNextEventRecord());
			removeNextEventRecord();

			::cppu::OInterfaceContainerHelper* pICHelper = 
				m_rBroadcastHelper.getContainer(getCppuType(
					(uno::Reference<XFilePickerListener>*)0));

			if (pICHelper)
			{
				::cppu::OInterfaceIteratorHelper iter(*pICHelper);

				while(iter.hasMoreElements())
				{
					try
					{
						EventNotification->notifyEventListener(iter.next());
					}
					catch(uno::RuntimeException&)
					{
					    OSL_ENSURE(sal_False,
						"RuntimeException during event dispatching");
					}
				}
			}
		} // while(getEventListSize() > 0)
		m_aNotifyCondition.reset();
	} // while(m_bRun)
	m_aExitCondition.set();
}
