<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: ooo2xhtml.xsl,v $

   $Revision: 1.5 $

   last change: $Author: rt $ $Date: 2005/01/28 15:24:21 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
    For further documentation and updates visit http://xml.openoffice.org/sx2ml
    -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:office="http://openoffice.org/2000/office"
                xmlns:style="http://openoffice.org/2000/style"
                xmlns:text="http://openoffice.org/2000/text"
                xmlns:table="http://openoffice.org/2000/table"
                xmlns:draw="http://openoffice.org/2000/drawing"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:number="http://openoffice.org/2000/datastyle"
                xmlns:svg="http://www.w3.org/2000/svg"
                xmlns:chart="http://openoffice.org/2000/chart"
                xmlns:dr3d="http://openoffice.org/2000/dr3d"
                xmlns:math="http://www.w3.org/1998/Math/MathML"
                xmlns:form="http://openoffice.org/2000/form"
                xmlns:script="http://openoffice.org/2000/script"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:meta="http://openoffice.org/2000/meta"
                xmlns:config="http://openoffice.org/2001/config"
                xmlns:help="http://openoffice.org/2000/help"
                exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help"
                xmlns="http://www.w3.org/1999/xhtml">


    <!--+++++ INCLUDED XSL MODULES +++++-->

    <!-- inheritance of office style properties is resolved into absolute styles. Office properties gathered as elements -->
    <xsl:include href="../common/styles/style_collector.xsl" />

    <!-- mapping rules of office style properties to CSS/HTML properties -->
    <xsl:include href="../common/styles/style_mapping_css.xsl" />

    <!-- office header element handling especially for XHTML -->
    <xsl:include href="header.xsl" />

    <!-- office body element handling especially for XHTML -->
    <xsl:include href="body.xsl" />


    <xsl:output method               = "xml"
                encoding             = "UTF-8"
                media-type           = "application/xhtml+xml"
                indent               = "yes"
                doctype-public       = "-//W3C//DTD XHTML 1.0 Strict//EN"
                doctype-system       = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
                omit-xml-declaration = "no" />

    <xsl:variable name="namespace" select="'http://www.w3.org/1999/xhtml'" />

    <!--+++++ PARAMETER SECTION +++++-->

    <!-- OPTIONAL: (MANDATORY: for all input document with relative external links): parameter is a absolute file URL to the target directory.
         Relative links from the office document (e.g. to external graphics) will get this parameter as a prefix -->
    <xsl:param name="targetBaseURL" select="'./'" />

    <!-- OPTIONAL: (MANDATORY: for all input document with content table) : parameter is a absolute file URL to the target document.
         Relative links to this office document (e.g. to internal anchor) will get this parameter as a prefix -->
    <xsl:param name="targetURL" select="'./'" />

    <!-- OPTIONAL: (MANDATORY: for input document with relative internal links)
         To access contents of a office file (content like the meta.xml, styles.xml file or  graphics) a URL could be choosen.
	 This could be even a JAR URL. The sourceBase of the content URL "jar:file:/C:/temp/Test.sxw!/content.xml" would be
	 "jar:file:/C:/temp/Test.sxw!/" for example.
         When working with OpenOffice API a Package-URL encoded over HTTP can be used to access the jared contents of the the jared document. -->
    <xsl:param name="sourceBaseURL" select="'./'" />

    <!-- OPTIONAL: (MANDATORY: for session management by URL rewriting)
         Useful for WebApplications: if a HTTP session is not cookie based, URL rewriting is beeing used (the session is appended to the URL).
         This URL session is used for example when links to graphics are created by XSLT. Otherwise the user havt to log again in for every graphic he liks to see. -->
    <xsl:param name="optionalURLSuffix" />

    <!-- OPTIONAL: URL to office meta file (flat xml use the URL to the input file) -->
    <xsl:param name="metaFileURL" />

    <!-- OPTIONAL: URL to office meta file (flat xml use the URL to the input file) -->
    <xsl:param name="stylesFileURL" />

    <!-- OPTIONAL: DPI (dots per inch) the standard resolution of given pictures (necessary for the conversion of 'cm' into 'pixel')-->
    <!-- Although many pictures have a 96 dpi resolution, a higher resoltion give better results for common browsers -->
    <!-- Cmp. measure_conversion.xsl:
         <xsl:param name="dpi" select="111" /> -->


    <!-- OPTIONAL: in case of using a different processor than a JAVA XSLT, you can unable the Java functionality
         (e.g. encoding chapter names for the content-table as href and anchors ) -->
    <xsl:param name="java"        select="true()" />
    <xsl:param name="javaEnabled" select="boolean($java)" />

    <!-- OPTIONAL: different transformation are bundled in this stylesheet and are choosen by this parameter.
                   A user-agent will request the desired transformation by providing his "outputType" (e.g. 'PALM' for Palm devices)
                   WML 1.0 has templates in common, too, but is triggered by a different starting sheet (i.e. office2wml.xsl).
                   This is as the DOCTYPE can not be differentiated in XSLT1.0,
                   visit http://xml.openoffice.org/sx2ml for further information and updated stylesheets.
                   -->
    <xsl:param name="outputType" select="'CSS_HEADER'" />
    <!-- set of possible deviceTypes (WML, PALM are set in their own startfile office2wml.xsl and office2palm.xsl):
    <xsl:param name="outputType" select="'CSS_HEADER'" />
    <xsl:param name="outputType" select="'CSS_INLINED'" /> -->


    <!-- OPTIONAL: for activating the debug mode set the variable here to 'true()' or give any value from outside -->
    <xsl:param name="debug"                    select="false()" />
    <xsl:param name="debugEnabled"             select="boolean($debug)" />
    <xsl:param name="onlyStyleOutput"          select="false()" />
    <xsl:param name="onlyStyleOutputEnabled"   select="boolean($onlyStyleOutput)" />


    <!-- ************************************* -->
    <!-- *** build the propriate HTML file *** -->
    <!-- ************************************* -->
    <xsl:template match="/">
        <!-- debug output of parameter value set -->
        <xsl:if test="$debugEnabled">
            <xsl:call-template name="debug-check-paramter" />
        </xsl:if>
        <!-- gathers style properties and
            returns them as globalData parameter to the 'start-main' template -->
        <xsl:call-template name="collect-global-OOo-properties" />
    </xsl:template>


    <!-- *************************** -->
    <!-- *** Built up XHTML file *** -->
    <!-- *************************** -->
    <xsl:template name="start-main">
        <xsl:param name="globalData" />

        <xsl:element name="html">
            <xsl:call-template name='create-header'>
                <xsl:with-param name="globalData" select="$globalData" />
            </xsl:call-template>

            <xsl:call-template name='create-body'>
                <xsl:with-param name="globalData" select="$globalData" />
            </xsl:call-template>
        </xsl:element>
    </xsl:template>


    <!-- debug purpose only:
         verbose checking of the parameters of this template-->
    <xsl:template name="debug-check-paramter">
        <xsl:message>Parameter outputType: <xsl:value-of select="$outputType" /></xsl:message>
        <xsl:message>Parameter dpi: <xsl:value-of select="$dpi" /></xsl:message>
        <xsl:message>Parameter metaFileURL: <xsl:value-of select="$metaFileURL" /></xsl:message>
        <xsl:message>Parameter stylesFileURL: <xsl:value-of select="$stylesFileURL" /></xsl:message>
        <xsl:message>Parameter sourceBaseURL: <xsl:value-of select="$sourceBaseURL" /></xsl:message>
        <xsl:message>Parameter targetBaseURL: <xsl:value-of select="$targetBaseURL" /></xsl:message>
        <xsl:message>Parameter onlyStyleOutputEnabled: <xsl:value-of select="$onlyStyleOutputEnabled" /></xsl:message>
        <xsl:message>Parameter debugEnabled: <xsl:value-of select="$debugEnabled" /></xsl:message>
        <xsl:message>Parameter java: <xsl:value-of select="$java" /></xsl:message>
        <xsl:message>Parameter javaEnabled: <xsl:value-of select="$javaEnabled" /></xsl:message>
        <xsl:if test="$masterDocumentEnabled">
        <xsl:message><xsl:text>
        Masterdocument parameters:
        </xsl:text></xsl:message>
        <xsl:message>Parameter precedingChapterLevel1 : <xsl:value-of select="$precedingChapterLevel1" /></xsl:message>
        <xsl:message>Parameter precedingChapterLevel2 : <xsl:value-of select="$precedingChapterLevel2" /></xsl:message>
        <xsl:message>Parameter precedingChapterLevel3 : <xsl:value-of select="$precedingChapterLevel3" /></xsl:message>
        <xsl:message>Parameter precedingChapterLevel4 : <xsl:value-of select="$precedingChapterLevel4" /></xsl:message>
        <xsl:message>Parameter precedingChapterLevel5 : <xsl:value-of select="$precedingChapterLevel5" /></xsl:message>
        <xsl:message>Parameter precedingChapterLevel6 : <xsl:value-of select="$precedingChapterLevel6" /></xsl:message>
        <xsl:message>Parameter precedingChapterLevel7 : <xsl:value-of select="$precedingChapterLevel7" /></xsl:message>
        <xsl:message>Parameter precedingChapterLevel8 : <xsl:value-of select="$precedingChapterLevel8" /></xsl:message>
        <xsl:message>Parameter precedingChapterLevel9 : <xsl:value-of select="$precedingChapterLevel9" /></xsl:message>
        <xsl:message>Parameter precedingChapterLevel10: <xsl:value-of select="$precedingChapterLevel10" /></xsl:message>
        <xsl:message>Parameter childDocumentExist: <xsl:value-of select="$childDocumentExist" /></xsl:message>
        <xsl:message>Parameter contentTableURL: <xsl:value-of select="$contentTableURL" /></xsl:message>
        <xsl:message>Parameter currentChildContentRef: <xsl:value-of select="$currentChildContentRef" /></xsl:message>
        <xsl:message>Parameter contentTableHeadings: <xsl:value-of select="$contentTableHeadings" />

        </xsl:message>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
