<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: master_usability_links.xsl,v $

   $Revision: 1.4 $

   last change: $Author: rt $ $Date: 2004/09/20 12:24:05 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
    For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:office="http://openoffice.org/2000/office"
        xmlns:style="http://openoffice.org/2000/style"
        xmlns:text="http://openoffice.org/2000/text"
        xmlns:table="http://openoffice.org/2000/table"
        xmlns:draw="http://openoffice.org/2000/drawing"
        xmlns:fo="http://www.w3.org/1999/XSL/Format"
        xmlns:xlink="http://www.w3.org/1999/xlink"
        xmlns:number="http://openoffice.org/2000/datastyle"
        xmlns:svg="http://www.w3.org/2000/svg"
        xmlns:chart="http://openoffice.org/2000/chart"
        xmlns:dr3d="http://openoffice.org/2000/dr3d"
        xmlns:math="http://www.w3.org/1998/Math/MathML"
        xmlns:form="http://openoffice.org/2000/form"
        xmlns:script="http://openoffice.org/2000/script"
        xmlns:dc="http://purl.org/dc/elements/1.1/"
        xmlns:meta="http://openoffice.org/2000/meta"
        xmlns:config="http://openoffice.org/2001/config"
        xmlns:help="http://openoffice.org/2000/help"
        xmlns:sxg="http://www.jclark.com/xt/java/org.openoffice.xslt.OOoMasterDocument"
        xmlns:java="http://xml.apache.org/xslt/java"
        xmlns="http://www.w3.org/1999/xhtml"
        version="1.0"
        exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help java sxg">


    <!-- ******************************************************************************************************* -->
    <!-- ***  Creation of a line of links at the beginning and end of a child document to enhance usability  *** -->
    <!-- ******************************************************************************************************* -->

    <xsl:template name="add-child-document-usability-links">
        <xsl:if test="$contentTableHeadings">
        <p style="text-align:center;">
            <xsl:element name="small">
                <xsl:text>[ </xsl:text>
                <xsl:variable name="currentChildNo" select="number($contentTableHeadings/heading[$currentChildContentRef = @file-url]/@child-document-no)" />
                <xsl:variable name="earlierDocURL" select="$contentTableHeadings/heading[($currentChildNo - 1) = @child-document-no]/@out-file-url" />
<!--
2DO: add character entity CR - enable debugvariable -->
                <xsl:if test="$debugEnabled">
                    <xsl:if test="$currentChildContentRef">
                        <xsl:message>
                            <xsl:text>

currentChildContentRef:
</xsl:text>
                            <xsl:value-of select="$currentChildContentRef" />
                            <xsl:text>

</xsl:text>

                        </xsl:message>
                    </xsl:if>
                    <xsl:if test="$earlierDocURL">
                        <xsl:message>
                            <xsl:text>

earlierDoc:
</xsl:text>
                            <xsl:value-of select="$earlierDocURL" />
                            <xsl:text>

</xsl:text>

                        </xsl:message>
                    </xsl:if>
                    <xsl:message>
                        <xsl:text>

FinalRef:
</xsl:text>
                        <xsl:call-template name="get-relative-u-r-l-between-master-children">
                            <xsl:with-param name="fromChildFileRef" select="$currentChildContentRef" />
                            <xsl:with-param name="toChildFileRef" select="$earlierDocURL" />
                        </xsl:call-template>
                        <xsl:text>

</xsl:text>
                    </xsl:message>
                </xsl:if>
                <xsl:if test="$earlierDocURL">
                    <xsl:element name="a">
                        <xsl:attribute name="href">
                            <!-- when the links starts with a '#' it's a link to the Content Table-->
                            <xsl:choose>
                                <xsl:when test="starts-with($earlierDocURL, '#')">
                                    <xsl:call-template name="get-relative-u-r-l-between-master-children">
                                        <xsl:with-param name="fromChildFileRef" select="$currentChildContentRef" />
                                        <xsl:with-param name="toChildFileRef" select="." />
                                    </xsl:call-template>

                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="get-relative-u-r-l-between-master-children">
                                        <xsl:with-param name="fromChildFileRef" select="$currentChildContentRef" />
                                        <xsl:with-param name="toChildFileRef" select="$earlierDocURL" />
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
                        <xsl:attribute name="title">Link to previous document</xsl:attribute>
                        <xsl:text>Previous document</xsl:text>
                    </xsl:element>

                    <xsl:text> | </xsl:text>
                </xsl:if>
                <xsl:element name="a">
                    <xsl:attribute name="href">
                        <!-- when currentChildContentRef is unset the current file is the Content Table-->
                        <xsl:choose>
                            <xsl:when test="$currentChildContentRef">
                                <xsl:call-template name="get-relative-content-table-u-r-l">
                                    <xsl:with-param name="fromChildFileRef" select="$currentChildContentRef" />
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>#</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                    <xsl:attribute name="title">Link to the Content Table</xsl:attribute>
                    <xsl:text>Content Table</xsl:text>
                </xsl:element>


                <xsl:variable name="nextDocURL" select="$contentTableHeadings/heading[($currentChildNo + 1) = @child-document-no]/@out-file-url" />
                <xsl:if test="$nextDocURL">
                    <xsl:text> | </xsl:text>
                    <xsl:element name="a">
                        <xsl:attribute name="href">
                            <!-- when the links starts with a '#' it's a link to the Content Table-->
                            <xsl:choose>
                                <xsl:when test="starts-with($nextDocURL, '#')">
                                    <xsl:call-template name="get-relative-u-r-l-between-master-children">
                                        <xsl:with-param name="fromChildFileRef" select="$currentChildContentRef" />
                                        <xsl:with-param name="toChildFileRef" select="." />
                                    </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="get-relative-u-r-l-between-master-children">
                                        <xsl:with-param name="fromChildFileRef" select="$currentChildContentRef" />
                                        <xsl:with-param name="toChildFileRef" select="$nextDocURL" />
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
                        <xsl:attribute name="title">Link to next document</xsl:attribute>
                        <xsl:text>Next document</xsl:text>
                    </xsl:element>
                </xsl:if>
                <xsl:text> ]</xsl:text>
            </xsl:element>
        </p>
        </xsl:if>
    </xsl:template>


    <xsl:template name="get-relative-u-r-l-between-master-children">
        <xsl:param name="fromChildFileRef" />
        <xsl:param name="toChildFileRef" />

        <xsl:choose>
            <xsl:when test="function-available('sxg:get-relative-u-r-l-between-master-children')">
                <xsl:value-of select="sxg:get-relative-u-r-l-between-master-children(string($fromChildFileRef), string($toChildFileRef))" />
            </xsl:when>
            <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getRelativeURLBetweenMasterChildren')">
                <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.getRelativeURLBetweenMasterChildren(string($fromChildFileRef), string($toChildFileRef))" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getRelativeURLBetweenMasterChildren</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template name="get-relative-content-table-u-r-l">
        <xsl:param name="fromChildFileRef" />

        <xsl:choose>
            <xsl:when test="function-available('sxg:get-relative-content-table-u-r-l')">
                <xsl:value-of select="sxg:get-relative-content-table-u-r-l(string($fromChildFileRef))" />
            </xsl:when>
            <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getRelativeContentTableURL')">
                <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.getRelativeContentTableURL(string($fromChildFileRef))" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getRelativeContentTableURL</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
