<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: body.xsl,v $

   $Revision: 1.5 $

   last change: $Author: rt $ $Date: 2005/01/28 15:23:36 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
    For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:office="http://openoffice.org/2000/office"
        xmlns:style="http://openoffice.org/2000/style"
        xmlns:text="http://openoffice.org/2000/text"
        xmlns:table="http://openoffice.org/2000/table"
        xmlns:draw="http://openoffice.org/2000/drawing"
        xmlns:fo="http://www.w3.org/1999/XSL/Format"
        xmlns:xlink="http://www.w3.org/1999/xlink"
        xmlns:number="http://openoffice.org/2000/datastyle"
        xmlns:svg="http://www.w3.org/2000/svg"
        xmlns:chart="http://openoffice.org/2000/chart"
        xmlns:dr3d="http://openoffice.org/2000/dr3d"
        xmlns:math="http://www.w3.org/1998/Math/MathML"
        xmlns:form="http://openoffice.org/2000/form"
        xmlns:script="http://openoffice.org/2000/script"
        xmlns:dc="http://purl.org/dc/elements/1.1/"
        xmlns:meta="http://openoffice.org/2000/meta"
        xmlns:config="http://openoffice.org/2001/config"
        xmlns:help="http://openoffice.org/2000/help"
        exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help"
        xmlns="http://www.w3.org/1999/xhtml">


    <!--+++++ INCLUDED XSL MODULES +++++-->

    <!-- helper collection, to convert measures (e.g. inch to pixel using DPI (dots per inch) parameter)-->
    <xsl:import  href="../../common/measure_conversion.xsl" />

    <!-- common office body element handling -->
    <xsl:import  href="../common/body.xsl" />

    <!-- common table handling -->
    <xsl:import  href="../common/table/table.xsl" />

    <!-- xhtml table handling -->
    <xsl:include  href="table.xsl" />

    <!-- OPTIONAL - MASTER DOCUMENT handling
    by default disabled in conjunction with following paramter 'masterDocument' set to 'false()' -->
    <xsl:include  href="master_document.xsl" />

    <!-- OPTIONAL - MASTER DOCUMENT handling, in case of using features for master documents, needed for
      the creation of the Development Guide (e.g. calculating chapter numbers for the content-table) -->
    <xsl:variable name="masterDocument" select="false()" />
    <xsl:variable name="masterDocumentEnabled" select="boolean($masterDocument)" />


    <!-- ************ -->
    <!-- *** body *** -->
    <!-- ************ -->

    <xsl:template name="create-body">
        <xsl:param  name="globalData" />

        <!-- multiple backgroundimages for different page styles (never used in html) -->
        <xsl:variable name="backgroundImage" select="$globalData/styles-file/*/office:automatic-styles/style:page-master/style:properties/style:background-image" />
        <!-- approximation as attribute belongs to a page style, which won't work in XHTML -->
        <xsl:variable name="writingMode" select="/office:document/office:automatic-styles/style:page-master/style:properties/@style:writing-mode" />
        <xsl:element name="body">
            <!-- direction of text flow -->
            <xsl:if test="$writingMode">
                <xsl:choose>
                    <xsl:when test="contains($writingMode, 'lr')">
                        <xsl:attribute name="dir">ltr</xsl:attribute>
                    </xsl:when>
                    <xsl:when test="contains($writingMode, 'rl')">
                        <xsl:attribute name="dir">rtl</xsl:attribute>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>

            <!-- background image -->
            <xsl:if test="$backgroundImage/@xlink:href">
                <xsl:attribute name="style">
                    <xsl:text>background-image:url(</xsl:text>
                    <xsl:call-template name="create-href">
                        <xsl:with-param  name="href" select="$backgroundImage/@xlink:href" />
                    </xsl:call-template>
                    <xsl:text>);</xsl:text>

                    <xsl:if test="$backgroundImage/@style:repeat">
                        <xsl:choose>
                            <xsl:when test="$backgroundImage/@style:repeat = 'no-repeat'">
                                <xsl:text>background-repeat:no-repeat;</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>background-repeat:repeat;</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:if>
                    <xsl:if test="$backgroundImage/@style:position">
                        <xsl:text>background-position:</xsl:text>
                        <xsl:value-of  select="$backgroundImage/@style:position" />
                        <xsl:text>;</xsl:text>
                    </xsl:if>
                </xsl:attribute>
            </xsl:if>

            <!-- processing the content of the xml file -->
            <xsl:apply-templates select="/*/office:body">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:apply-templates>
        </xsl:element>
    </xsl:template>



    <xsl:template match="office:body">
        <xsl:param  name="globalData" />

        <!-- not using of 'apply-styles-and-content' as the content table information migth have been added to 'globalData' variable -->
        <xsl:apply-templates select="@text:style-name | @draw:style-name | @draw:text-style-name | @table:style-name"><!-- | @presentation:style-name -->
            <xsl:with-param  name="globalData" select="$globalData" />
        </xsl:apply-templates>


        <!-- Usability feature, a link to the content table above all level 1 header -->
        <xsl:if test="$masterDocumentEnabled">
            <xsl:call-template  name="add-child-document-usability-links" />
        </xsl:if>

        <xsl:choose>
            <!--If the input document is a master document and embed child documents (links) the transformation of the children will be started as well.
                This is necessary as child documents do not know anything about their embedding into a master document. Chapters of childs
                always start to count by zero instead of continously numbering.
                For this, the chapter numbers of the current document (as a sequence of a master document) is dependent
                of the number of chapter of the same level in preceding documents.
                In case of multiple children, for usability reasons some linking is gonna be offered and the URLs of the content-table,
                preceding and following file have to be given for the transformation.
                -->
            <xsl:when test="$masterDocumentEnabled">
                <xsl:choose>
                    <xsl:when test="/*/@office:class='text-global' and /*/office:body/text:section/text:section-source/@xlink:href">
                        <!-- the children will be called later with a modified 'globalData' variable -->
                        <xsl:call-template name="transform-global-document-and-children">
                            <xsl:with-param  name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates>
                            <xsl:with-param  name="globalData" select="$globalData" />
                        </xsl:apply-templates>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates>
                    <xsl:with-param  name="globalData" select="$globalData" />
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>

        <!-- Usability feature, a link to the content-table above of all level-1 header -->
        <xsl:if test="$masterDocumentEnabled">
            <xsl:call-template  name="add-child-document-usability-links" />
        </xsl:if>
    </xsl:template>

    <!-- ******************************* -->
    <!-- *** User Field Declarations *** -->
    <!-- ******************************* -->

    <xsl:key name="user-field-decl" match="/*/office:body/text:user-field-decls/text:user-field-decl" use="@text:name" />

    <xsl:template match="text:user-field-get">
        <xsl:param  name="globalData" />

        <xsl:value-of select="key('user-field-decl', @text:name)/@text:string-value" />
    </xsl:template>


    <!-- *************** -->
    <!-- *** Textbox *** -->
    <!-- *************** -->

    <xsl:template match="draw:text-box">
        <xsl:param  name="globalData" />

        <xsl:element name="div">
            <xsl:if test="@svg:height | @svg:width">
                <xsl:attribute name="style">
                    <xsl:choose>
                        <xsl:when test="not(@svg:width)">
                            <xsl:call-template  name="svg:height" />
                        </xsl:when>
                        <xsl:when test="not(@svg:height)">
                            <xsl:call-template  name="svg:width" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template  name="svg:height" />
                            <xsl:call-template  name="svg:width" />
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="@draw:name">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:apply-templates>

            <xsl:call-template name="apply-styles-and-content">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:call-template>
        </xsl:element>
    </xsl:template>

    <!-- inline style helper for the 'div' boxes -->
    <xsl:template name="svg:height">
        <xsl:text>height: </xsl:text>
        <xsl:choose>
            <!-- changing the distance measure: inch to in -->
            <xsl:when test="contains(@svg:height, 'inch')">
                <xsl:value-of  select="substring-before(@svg:height, 'ch')" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of  select="@svg:height" />
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text>; </xsl:text>
    </xsl:template>

    <!-- inline style helper for the 'div' boxes -->
    <xsl:template name="svg:width">
        <xsl:text>width: </xsl:text>
        <xsl:choose>
            <!-- changing the distance measure: inch to in -->
            <xsl:when test="contains(@svg:width, 'inch')">
                <xsl:value-of  select="substring-before(@svg:width, 'ch')" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of  select="@svg:width" />
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text>; </xsl:text>
    </xsl:template>



    <!-- ****************** -->
    <!-- *** Paragraphs *** -->
    <!-- ****************** -->

    <xsl:template match="text:p | draw:page">
        <xsl:param  name="globalData" />
        <!-- 1) A draw:text-box my include paragraphs (text:p) itself and in HTML a 'p' can only have inline documents (no other 'p' as children'),
                a 'div' will be given out instead.
             2) A images are embedded in a paragraph, but are in CSS not able to express a horizontal alignment for themself (text:align is only valid for block elements).
                A surrounding 'div' element taking over the image style solves that problem, but is invalid as child of a paragraph
        -->
        <xsl:choose>
            <xsl:when test="draw:text-box or draw:image">
                <xsl:element name="div">
                    <xsl:call-template name="apply-styles-and-content">
                        <xsl:with-param  name="globalData" select="$globalData" />
                    </xsl:call-template>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="p">
                    <!-- empty paragraph tags does not provoke an carridge return,
                        therefore an non breakable space (&nbsp) have been inserted.-->
                    <xsl:choose>
                        <xsl:when test="*">
                            <xsl:call-template name="apply-styles-and-content">
                                <xsl:with-param  name="globalData" select="$globalData" />
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="apply-styles-and-content">
                                <xsl:with-param  name="globalData" select="$globalData" />
                            </xsl:call-template>
                            <xsl:text>&#160;</xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <!-- ***************** -->
    <!-- *** Text Span *** -->
    <!-- ***************** -->

    <xsl:template match="text:span">
        <xsl:param  name="globalData" />

        <xsl:element name="span">
            <xsl:call-template name="apply-styles-and-content">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:call-template>
        </xsl:element>
    </xsl:template>



    <!-- **************** -->
    <!-- *** Headings *** -->
    <!-- **************** -->

    <xsl:template match="text:h">
        <xsl:param  name="globalData" />

        <!-- no creation of empty headings (without text content)   -->
        <xsl:if test="text()">
            <xsl:call-template name="create-heading">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <!-- default matching for header elements -->
    <xsl:template name="create-default-heading-anchor">
        <xsl:variable name="title"><xsl:apply-templates mode="concatenate" /></xsl:variable>
        <xsl:element namespace="{$namespace}" name="a">
            <xsl:attribute name="name">
                <xsl:call-template name="encode-string">
                <!-- the space has to be normalized,
                    otherwise an illegal argument exception will be thrown for XT-->
                    <xsl:with-param name="textToBeEncoded" select="normalize-space(string($title))" />
                </xsl:call-template>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <!-- Neglect Annotations -->
    <xsl:template match="office:annotation" mode="concatenate"/>

    <!-- default matching for header elements -->
    <xsl:template name="create-heading">
        <xsl:param  name="globalData" />

        <xsl:choose>
            <!--+++++ CSS (CASCADING STYLE SHEET) HEADER STYLE WAY +++++-->
            <xsl:when test="$outputType = 'CSS_HEADER'">

                <xsl:variable  name="headertyp" select="concat('h', @text:level)" />
                <xsl:element name="{$headertyp}">

                    <!-- outline style 'text:min-label-width' is interpreted as a CSS 'margin-left' attribute -->
                    <xsl:variable  name="min-label" select="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/style:properties/@text:min-label-width" />
                    <xsl:if test="$min-label">
                        <xsl:attribute name="style">
                            <xsl:text>margin-left:</xsl:text>
                            <xsl:value-of  select="$min-label" />
                            <xsl:text>;</xsl:text>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:attribute name="class">
                        <xsl:value-of  select="translate(@text:style-name, '. %()/\+', '')" />
                    </xsl:attribute>

                    <xsl:choose>
                        <xsl:when test="$masterDocumentEnabled">
                             <xsl:if test="$childDocumentExist and $javaEnabled">
                                <!-- Every heading element will get an unique anchor for its file, from its hiearchy level and name:
                                     For example:  The heading title 'My favorite heading' might get <a name="1_2_2_My_favorite_heading" /> -->
                                <div>
                                <!-- necessary as anchor for the content table -->
                                <xsl:call-template name="create-heading-anchor">
                                    <xsl:with-param  name="globalData" select="$globalData" />
                                </xsl:call-template>
                                </div>
                            </xsl:if>
                        </xsl:when>
                        <xsl:otherwise>
                        <!-- The URL linking of an table-of-content is due to a bug (cmp. bug id# 102311) not mapped as URL in the XML.
                             Linking of the table-of-content can therefore only be archieved by a work-around in HTML -->
                            <xsl:call-template name="create-default-heading-anchor">
                                <xsl:with-param  name="globalData" select="$globalData" />
                            </xsl:call-template>
                        </xsl:otherwise>
                    </xsl:choose>

                    <!-- writing out a chapter number if desired (noticable when a corresponding 'text:outline-style' exist or is not empty -->
                    <xsl:if test="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/@style:num-format != ''">
                        <xsl:choose>
                            <xsl:when test="$childDocumentExist and $javaEnabled and ($outputType = 'CSS_HEADER')">
<!-- 2DO: This call is dependent on java helper!! -->
                                <xsl:call-template name="get-absolute-chapter-no">
                                    <xsl:with-param  name="precedingChapterLevel1" select="$precedingChapterLevel1" />
                                    <xsl:with-param  name="globalData" select="$globalData" />
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                <!-- the chapter number is the sum of 'text:start-value' and preceding siblings of 'text:h' with the same 'text:level',
                                     furthermore when the current document is referenced by a master document - as part of a whole sequence of documents -,
                                     the chapter no. is dependent of the amount of started headers in preceding documents.
                                     If the 'text:start-value is not set the default value of '1' has to be taken. -->
                                <xsl:variable  name="startValue" select="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/@text:start-value" />
                                <xsl:choose>
                                    <xsl:when test="$startValue">
                                        <xsl:choose>
                                            <xsl:when test="@text:level='1'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel1 + $startValue" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='2'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel2 + $startValue" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='3'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel3 + $startValue" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='4'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel4 + $startValue" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='5'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel5 + $startValue" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='6'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel6 + $startValue" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='7'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel7 + $startValue" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='8'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel8 + $startValue" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='9'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel9 + $startValue" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='10'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel10 + $startValue" />
                                            </xsl:when>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:choose>
                                            <xsl:when test="@text:level='1'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel1 + 1" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='2'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel2 + 1" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='3'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel3 + 1" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='4'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel4 + 1" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='5'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel5 + 1" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='6'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel6 + 1" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='7'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel7 + 1" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='8'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel8 + 1" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='9'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel9 + 1" />
                                            </xsl:when>
                                            <xsl:when test="@text:level='10'">
                                                <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $precedingChapterLevel10 + 1" />
                                            </xsl:when>
                                        </xsl:choose>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:text> &#160; &#160;</xsl:text>
                    </xsl:if>
                    <xsl:apply-templates>
                        <xsl:with-param  name="globalData" select="$globalData" />
                    </xsl:apply-templates>
                </xsl:element>
            </xsl:when>
            <!--+++++ HTML 4.0 INLINED WAY  +++++-->
            <xsl:when test="$outputType = 'CSS_INLINED'">
                <xsl:variable  name="headertyp" select="concat('h', @text:level)" />
                <xsl:element name="{$headertyp}">

                    <xsl:attribute name="style">
                        <!-- adding a workaround for the end of flow attributes -->
                        <xsl:text>clear:both; </xsl:text>
                        <xsl:value-of  select="$globalData/all-styles/style[@style:name = current()/@text:style-name]/final-properties" />
                    </xsl:attribute>

                    <!-- writing out a chapter number if desired (noticable when a corresponding 'text:outline-style' exist -->
                    <xsl:if test="$globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/@text:style-name">

                        <!-- the chapter number is the sum of 'text:start-value' and preceding siblings of 'text:h' with the same 'text:level' -->
                        <xsl:value-of  select="count(preceding-sibling::text:h[@text:level = current()/@text:level]) + $globalData/office:styles/text:outline-style/text:outline-level-style[@text:level = current()/@text:level]/@text:start-value" />
                        <xsl:text> &#160; &#160;</xsl:text>
                    </xsl:if>

                    <xsl:apply-templates>
                        <xsl:with-param  name="globalData" select="$globalData" />
                    </xsl:apply-templates>
                </xsl:element>
            </xsl:when>
        </xsl:choose>
    </xsl:template>



    <!-- ************* -->
    <!-- *** Link  *** -->
    <!-- ************* -->

    <xsl:template match="text:a | draw:a">
        <xsl:param  name="globalData" />

        <xsl:call-template name="create-common-anchor-link">
            <xsl:with-param  name="globalData" select="$globalData" />
        </xsl:call-template>
    </xsl:template>


    <xsl:template name="create-common-anchor-link">
        <xsl:param  name="globalData" />

        <xsl:element name="a">
            <xsl:attribute name="href">
                <xsl:call-template name="create-href">
                    <xsl:with-param  name="href" select="@xlink:href" />
                </xsl:call-template>
            </xsl:attribute>
            <!--<xsl:attribute name="class">ContentLink</xsl:attribute>-->
            <xsl:call-template name="apply-styles-and-content">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:call-template>
        </xsl:element>
    </xsl:template>



    <!-- ******************* -->
    <!-- *** Image Link  *** -->
    <!-- ******************* -->

    <!-- currently suggesting that all draw:object-ole elements are images -->
    <xsl:template match="draw:image | draw:object-ole">
        <xsl:param  name="globalData" />

        <xsl:choose>
            <xsl:when test="parent::draw:a">
                <!-- XHTML does not allow anchors to contain paragraphs -->
                <xsl:call-template name="create-draw-object">
                    <xsl:with-param  name="globalData" select="$globalData" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- images are embedded in a paragraph, but are in CSS not able to express a horizontal alignment for themself.
                    A 'div' element taking over the image style would solve that problem, but is invalid as child of a paragraph -->
                <xsl:element name="p">
                    <xsl:apply-templates select="@draw:style-name">
                        <xsl:with-param  name="globalData" select="$globalData" />
                    </xsl:apply-templates>

                    <xsl:call-template name="create-draw-object">
                        <xsl:with-param  name="globalData" select="$globalData" />
                    </xsl:call-template>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="create-draw-object">
        <xsl:param  name="globalData" />

        <xsl:element name="img">
            <xsl:if test="@svg:width">
                <xsl:attribute name="width">
                    <xsl:call-template name="convert2px">
                        <xsl:with-param  name="value" select="@svg:width" />
                    </xsl:call-template>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="@svg:height">
                <xsl:attribute name="height">
                    <xsl:call-template name="convert2px">
                        <xsl:with-param  name="value" select="@svg:height" />
                    </xsl:call-template>
                </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="alt">
                <xsl:choose>
                    <xsl:when test="svg:desc">
                        <xsl:value-of  select="svg:desc" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:message>
    Accessibility Warning:
         No alternate text ('svg:desc' element) set for
         image '<xsl:value-of  select="@xlink:href" />'!</xsl:message>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>

            <xsl:attribute name="src">
                <xsl:call-template name="create-href">
                    <xsl:with-param  name="href" select="@xlink:href" />
                </xsl:call-template>
            </xsl:attribute>

            <!-- style interpretation only, as no subelements are allowed for img in XHTML -->
            <xsl:apply-templates select="@draw:style-name">
                <xsl:with-param name="globalData" select="$globalData" />
            </xsl:apply-templates>
        </xsl:element>
    </xsl:template>

    <!-- ******************** -->
    <!-- *** ordered list *** -->
    <!-- ******************** -->
    <xsl:template match="text:ordered-list">
        <xsl:param  name="globalData" />

        <xsl:element name="ol">
            <xsl:call-template name="apply-styles-and-content">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:call-template>
        </xsl:element>
    </xsl:template>



    <!-- ********************** -->
    <!-- *** unordered list *** -->
    <!-- ********************** -->

    <xsl:template match="text:unordered-list">
        <xsl:param  name="globalData" />

        <xsl:element name="ul">
            <xsl:call-template name="apply-styles-and-content">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:call-template>
        </xsl:element>
    </xsl:template>



    <!-- ****************** -->
    <!-- *** list item  *** -->
    <!-- ****************** -->

<!--
    Left margin of complete list:
    The space between left page and the list symbol is implemented in Star/OpenOffice by
    the sum of two values:
    The first comes from the 'margin:left' style of the first child (e.g. paragraph).
    The second is the amount of 'text:space-before', which is part of the 'text:list-style' element.

    Left margin problem with XHTML:
    In XHTML the earlier mentioned 'margin-left' of the Office document's first
    paragraph would only result in an indent of the first paragraph AFTER the
    list symbol. In the Office the value is interpreted as space BEFORE the list symbol.

    Workaround:
    The list-item receives a potential margin-left from its children, when it belongs
    to a first level list.
    All children

    <!ELEMENT text:list-item (text:p|text:h|text:ordered-list|text:unordered-list)+>
-->
    <xsl:template match="text:list-item | text:list-header">
        <xsl:param  name="globalData" />

        <xsl:element name="li">
            <xsl:choose>
                <xsl:when test="not(ancestor::text:list-item)">
                    <!-- receiving the style of child to use it's left-margin for the list -->
                    <xsl:apply-templates select="*/@text:style-name">
                        <xsl:with-param  name="globalData" select="$globalData" />
                    </xsl:apply-templates>
                </xsl:when>
            </xsl:choose>
            <xsl:apply-templates mode="no-margin-left" select="*[1]">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:apply-templates>
            <xsl:apply-templates select="*[position() &gt; 1]">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:apply-templates>
        </xsl:element>
    </xsl:template>

    <xsl:template mode="no-margin-left" match="text:p">
        <xsl:param  name="globalData" />

        <xsl:element name="p">
            <xsl:apply-templates mode="no-margin-left" select="@text:style-name">
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:apply-templates>
            <xsl:apply-templates>
                <xsl:with-param  name="globalData" select="$globalData" />
            </xsl:apply-templates>
        </xsl:element>
    </xsl:template>

    <!-- For ease of use: Neglecting the margin behavior for headings -->
    <xsl:template mode="no-margin-left" match="text:h">
        <xsl:param  name="globalData" />

        <xsl:apply-templates select="self::*">
            <xsl:with-param  name="globalData" select="$globalData" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template mode="no-margin-left" match="*">
        <xsl:param  name="globalData" />

        <xsl:apply-templates select="self::*">
            <xsl:with-param  name="globalData" select="$globalData" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template mode="no-margin-left" match="text()">
        <xsl:value-of select="." />
    </xsl:template>

    <xsl:template mode="no-margin-left"  match="@text:style-name">
        <xsl:param  name="globalData" />

        <xsl:attribute name="class">
            <xsl:value-of  select="translate(., '. %()/\+', '')" />
        </xsl:attribute>
        <xsl:attribute name="style">
            <xsl:text>margin-left: 0cm;</xsl:text>
        </xsl:attribute>
    </xsl:template>



    <!-- ********************************************** -->
    <!-- *** Text Section (contains: draw:text-box) *** -->
    <!-- ********************************************** -->

    <xsl:template match="text:section">
        <xsl:param  name="globalData" />

        <xsl:if test="not(contains(@text:display, 'none'))">
            <xsl:choose>
                <!--+++++ CSS (CASCADING STYLE SHEET) HEADER STYLE WAY +++++-->
                <xsl:when test="$outputType = 'CSS_HEADER'">
                    <xsl:element name="div">
                        <xsl:call-template name="apply-styles-and-content">
                            <xsl:with-param  name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
                <!--+++++ HTML 4.0 INLINED WAY  +++++-->
                <xsl:when test="$outputType = 'CSS_INLINED'">
                    <xsl:element name="div">
                        <xsl:call-template name="apply-styles-and-content">
                            <xsl:with-param  name="globalData" select="$globalData" />
                        </xsl:call-template>
                    </xsl:element>
                </xsl:when>
            </xsl:choose>
        </xsl:if>
    </xsl:template>


    <!-- Hidden text dependend on Office variables:
         The text is not shown, if condition is 'true'.
         Implemented solely for conditons as '<VARIABLE>==0' or '<VARIABLE>==1'
    -->
    <xsl:key match="text:variable-set" name="varSet" use="@text:name" />
    <xsl:template match="text:hidden-text">
        <xsl:param  name="globalData" />

        <xsl:variable name="varName" select="substring-before(@text:condition, '==')" />
        <xsl:variable name="varValue" select="substring-after(@text:condition, '==')" />
        <xsl:choose>
            <xsl:when test="key('varSet', $varName)/@text:value != $varValue">
                <xsl:value-of select="@text:string-value" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:comment><xsl:value-of select="$varName" />
                <xsl:value-of select="@text:string-value" />
                <xsl:value-of select="$varName" /></xsl:comment>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template match="@text:style-name | @draw:style-name | @draw:text-style-name | @table:style-name"><!-- | @presentation:style-name-->
        <xsl:param  name="globalData" />

        <xsl:choose>
            <!--+++++ CSS (CASCADING STYLE SHEET) HEADER STYLE WAY +++++-->
            <xsl:when test="$outputType = 'CSS_HEADER'">
                <xsl:attribute name="class">
                    <xsl:value-of  select="translate(., '. %()/\+', '')" />
                </xsl:attribute>
            </xsl:when>

            <!--+++++ HTML 4.0 INLINED WAY  +++++-->
            <xsl:when test="$outputType = 'CSS_INLINED'">
                <xsl:attribute name="style">
                    <xsl:value-of  select="$globalData/all-styles/style[@style:name = current()]/final-properties" />
                </xsl:attribute>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
