/*************************************************************************
 *
 *  $RCSfile: stringrepresentation.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2004/11/16 12:13:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef EXTENSIONS_SOURCE_PROPCTRLR_STRINGREPRESENTATION_HXX
#define EXTENSIONS_SOURCE_PROPCTRLR_STRINGREPRESENTATION_HXX

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _COM_SUN_STAR_SCRIPT_XTYPECONVERTER_HPP_
#include <com/sun/star/script/XTypeConverter.hpp>
#endif

//........................................................................
namespace pcr
{
//........................................................................

    class IPropertyInfoService;
	//====================================================================
	//= StringRepresentation
	//====================================================================
    /** is a helper class for handling string representations of property values
    */
	class StringRepresentation
	{
    private:
		::com::sun::star::uno::Reference< ::com::sun::star::script::XTypeConverter >
							m_xTypeConverter;

    public:
        StringRepresentation( const ::com::sun::star::uno::Reference< ::com::sun::star::script::XTypeConverter >& _rxConverter );

	    ::rtl::OUString convertSimpleToString( const ::com::sun::star::uno::Any& _rValue );

        ::rtl::OUString getStringRepFromPropertyValue(
                            const ::com::sun::star::uno::Any& rValue,
                            sal_Int32 _nPropertyId,
                            const IPropertyInfoService* _pMetaData
                        );

        ::com::sun::star::uno::Any
                        getPropertyValueFromStringRep(
                            const ::rtl::OUString& _rStringRep,
                            const ::com::sun::star::uno::Type& _rTargetType,
                            sal_Int32 _nPropertyId,
                            const IPropertyInfoService* _pMetaData
                        );

        /** converts a generic value into a string representation

            If you want to convert values whose string representation does not depend
            on a concrete property, use this version

            @return <TRUE/>
                if and only if the value could be converted
        */
        bool            convertGenericValueToString(
                            const ::com::sun::star::uno::Any&   _rValue,
                                  ::rtl::OUString&              _rStringRep
                        );

        /** converts string representation into generic value

            If you want to convert values whose string representation does not depend
            on a concrete property, use this version

            @return <TRUE/>
                if and only if the value could be converted
        */
        bool            convertStringToGenericValue(
                            const ::rtl::OUString&              _rStringRep,
                                  ::com::sun::star::uno::Any&   _rValue,
                            const ::com::sun::star::uno::Type& _rTargetType
                        );
	};

//........................................................................
} // namespace pcr
//........................................................................

#endif // EXTENSIONS_SOURCE_PROPCTRLR_STRINGREPRESENTATION_HXX

