/*************************************************************************
 *
 *  $RCSfile: dp_xml.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kz $ $Date: 2005/01/21 17:12:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "dp_misc.h"
#include "dp_xml.h"
#include "rtl/ustrbuf.hxx"
#include "ucbhelper/content.hxx"
#include "com/sun/star/xml/sax/XParser.hpp"


using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using ::rtl::OUString;

namespace dp_misc
{

//==============================================================================
void xml_parse(
    Reference<xml::sax::XDocumentHandler> const & xDocHandler,
    ::ucb::Content & ucb_content,
    Reference<XComponentContext> const & xContext )
{
    // raise sax parser:
    Reference<xml::sax::XParser> xParser(
        xContext->getServiceManager()->createInstanceWithContext(
            OUSTR("com.sun.star.xml.sax.Parser"), xContext ), UNO_QUERY_THROW );
    
    // error handler, entity resolver omitted
    xParser->setDocumentHandler( xDocHandler );
    xml::sax::InputSource source;
    source.aInputStream = ucb_content.openStream();
    source.sSystemId = ucb_content.getURL();
    xParser->parseStream( source );
}

//==============================================================================
void xml_parse(
    Reference<xml::input::XRoot> const & xRoot,
    ::ucb::Content & ucb_content,
    Reference<XComponentContext> const & xContext )
{
    const Any arg(xRoot);
    const Reference<xml::sax::XDocumentHandler> xDocHandler(
        xContext->getServiceManager()->createInstanceWithArgumentsAndContext(
            OUSTR("com.sun.star.xml.input.SaxDocumentHandler"),
            Sequence<Any>( &arg, 1 ), xContext ), UNO_QUERY_THROW );
    xml_parse( xDocHandler, ucb_content, xContext );
}

//##############################################################################

//______________________________________________________________________________
XmlRootElement::XmlRootElement(
    OUString const & uri, OUString const & localname )
    : m_uri( uri )
{
    m_localname = localname;
}

//______________________________________________________________________________
XmlRootElement::~XmlRootElement()
{
}

// XRoot
//______________________________________________________________________________
void XmlRootElement::startDocument(
    Reference<xml::input::XNamespaceMapping> const & xMapping )
    throw (xml::sax::SAXException, RuntimeException)
{
    m_xNamespaceMapping = xMapping;
    
    try {
        m_uid = m_xNamespaceMapping->getUidByUri( m_uri );
    }
    catch (container::NoSuchElementException & exc) {
        throw xml::sax::SAXException(
			exc.Message, static_cast<OWeakObject *>(this), Any(exc) );
    }
}

//______________________________________________________________________________
void XmlRootElement::endDocument()
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
void XmlRootElement::processingInstruction(
    OUString const & target, OUString const & data )
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
void XmlRootElement::setDocumentLocator(
    Reference<xml::sax::XLocator> const & xLocator )
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
Reference<xml::input::XElement> XmlRootElement::startRootElement(
    sal_Int32 uid, OUString const & localname,
    Reference<xml::input::XAttributes> const & xAttributes )
    throw (xml::sax::SAXException, RuntimeException)
{
    check_xmlns( uid );
    if (! localname.equals( m_localname )) {
		throw xml::sax::SAXException(
			OUSTR("unexpected root element ") + localname,
            static_cast<OWeakObject *>(this), Any() );
    }
    m_xAttributes = xAttributes;
    
    return this;
}

//##############################################################################

//______________________________________________________________________________
XmlElement::~XmlElement()
{
}

//______________________________________________________________________________
Reference<xml::input::XNamespaceMapping> const &
XmlElement::getNamespaceMapping() const
{
    if (! m_xNamespaceMapping.is()) {
        throw RuntimeException(
            OUSTR("document has not been parsed yet!"),
            static_cast<OWeakObject *>( const_cast<XmlElement *>(this) ) );
    }
    return m_xNamespaceMapping;
}

//______________________________________________________________________________
void XmlElement::check_xmlns( sal_Int32 uid ) const
    throw (xml::sax::SAXException)
{
    if (uid != m_uid)
    {
        ::rtl::OUStringBuffer buf;
        buf.appendAscii(
            RTL_CONSTASCII_STRINGPARAM("illegal xml namespace uri=\"") );
        try {
            buf.append( m_xNamespaceMapping->getUriByUid( uid ) );
        }
        catch (container::NoSuchElementException & exc) {
            throw xml::sax::SAXException(
                exc.Message, static_cast<OWeakObject *>(
                    const_cast<XmlElement *>(this) ), Any(exc) );
        }
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("\"!") );
        throw xml::sax::SAXException(
            buf.makeStringAndClear(),
            static_cast<OWeakObject *>( const_cast<XmlElement *>(this) ),
            Any() );
    }
}

//______________________________________________________________________________
void XmlElement::check_parsed() const
    throw (xml::sax::SAXException)
{
    if (! isParsed()) {
        ::rtl::OUStringBuffer buf;
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("missing closing element "
                                                    "event for \"") );
        buf.append( m_localname );
        buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("\"!") );
        throw xml::sax::SAXException(
            buf.makeStringAndClear(),
            static_cast<OWeakObject *>( const_cast<XmlElement *>(this) ),
            Any() );
    }
}

// XElement
//______________________________________________________________________________
Reference<xml::input::XElement> XmlElement::getParent()
    throw (RuntimeException)
{
    return m_xParent;
}

//______________________________________________________________________________
OUString XmlElement::getLocalName()
    throw (RuntimeException)
{
    return m_localname;
}

//______________________________________________________________________________
sal_Int32 XmlElement::getUid()
    throw (RuntimeException)
{
    return m_uid;
}

//______________________________________________________________________________
Reference<xml::input::XAttributes> XmlElement::getAttributes()
    throw (RuntimeException)
{
    return m_xAttributes;
}

//______________________________________________________________________________
void XmlElement::ignorableWhitespace(
    OUString const & whitespaces )
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
void XmlElement::characters( OUString const & chars )
    throw (xml::sax::SAXException, RuntimeException)
{
    m_characters += chars;
}

//______________________________________________________________________________
void XmlElement::processingInstruction(
    OUString const & target, OUString const & data )
    throw (xml::sax::SAXException, RuntimeException)
{
}

//______________________________________________________________________________
void XmlElement::endElement()
    throw (xml::sax::SAXException, RuntimeException)
{
    m_got_endElement = true;
}

//______________________________________________________________________________
Reference<xml::input::XElement> XmlElement::startChildElement(
    sal_Int32 uid, OUString const & localName,
    Reference<xml::input::XAttributes> const & xAttributes )
    throw (xml::sax::SAXException, RuntimeException)
{
    ::rtl::OUStringBuffer buf;
    buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("unexpected element "
                                                "{ tag=\"") );
    buf.append( localName );
    buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("\", uri=\"") );
    try {
        buf.append( m_xNamespaceMapping->getUriByUid( uid ) );
    }
    catch (container::NoSuchElementException & exc) {
        throw xml::sax::SAXException(
            exc.Message, static_cast<OWeakObject *>(this), Any(exc) );
    }
    buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("\" }!") );
    throw xml::sax::SAXException(
        buf.makeStringAndClear(), static_cast<OWeakObject *>(this), Any() );
}

}
