/*************************************************************************
 *
 *  $RCSfile: querydesignaccess.hxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: hr $ $Date: 2004/08/02 16:02:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_QUERYDESIGNACCESS_HXX_
#define _DBAUI_QUERYDESIGNACCESS_HXX_

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
#include <com/sun/star/sdbc/XConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XDATASOURCE_HPP_
#include <com/sun/star/sdbc/XDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCH_HPP_
#include <com/sun/star/frame/XDispatch.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_ 
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_ 
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _VOS_REF_HXX_ 
#include <vos/ref.hxx>
#endif

// .........................................................................
namespace dbaui
{
// .........................................................................
	class OComponentClientMonitor;

	class ODesignAccess
	{
	protected:
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >
					m_xORB;
		::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader >
					m_xFrameLoader;

	private:
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
					doDispatch( const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rArgs );

	protected:
		virtual ::rtl::OUString getDispatchURL() const = 0;

		virtual void fill(
			::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rDispatchArguments,
			const ::com::sun::star::uno::Any& _aDataSource,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection,
			const ::rtl::OUString& _rName = ::rtl::OUString()
		) = 0;

	public:
		ODesignAccess(	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB
						,const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader >& _xFrameLoader = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader >());
		virtual ~ODesignAccess(){}

		/** opens a design for a new object
			@param _rDatasourceName
				the name of the data source the new query should belong to
			@param _rxConnection
				an existent connection for this data source, if available
			@return
				the controller of the newly created document
		*/
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
			create(
				const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDataSource >& _xDataSource,
				const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection
			);

		/** opens a design for a new object
			@param _rDatasourceName
				the name of the data source the new query should belong to
			@param _rClientMonitor
				a reference to a object monitoring clients of the connection. The object itself is asked for
				it's connection (<method>OComponentClientMonitor::getComponent</method>).<br/>
				If opening the design component is successfull, it is registered as client of the connection
				at the client monitor.
			@return
				the controller of the newly created document
		*/
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
			create(
				const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDataSource >& _xDataSource,
				const ::vos::ORef< OComponentClientMonitor >& _rClientMonitor
			);

		/** opens a design for editing an existent object
			@param _rDatasourceName
				the name of the data source the new query should belong to
			@param _rQueryName
				the name of the query to be edited
			@param _rxConnection
				an existent connection for this data source, if available
			@param	_rArgs
				Additional settings which should be forwarded to the frame
			@return
				the controller of the newly created document
		*/
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
			edit(
				const ::com::sun::star::uno::Any& _aDataSource,
				const ::rtl::OUString& _rName,
				const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection = NULL,
				const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rArgs = ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >()
			);

		/** opens a design for editing an existent object
			@param _rDatasourceName
				the name of the data source the new query should belong to
			@param _rQueryName
				the name of the query to be edited
			@param _rClientMonitor
				a reference to a object monitoring clients of the connection. The object itself is asked for
				it's connection (<method>OComponentClientMonitor::getComponent</method>).<br/>
				If opening the design component is successfull, it is registered as client of the connection
				at the client monitor.
			@param	_rArgs
				Additional settings which should be forwarded to the frame
			@return
				the controller of the newly created document
		*/
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
			edit(
				const ::com::sun::star::uno::Any& _aDataSource,
				const ::rtl::OUString& _rName,
				const ::vos::ORef< OComponentClientMonitor >& _rClientMonitor,
				const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rArgs = ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >()
			);
	};
	//======================================================================
	//= OQueryDesignAccess
	//======================================================================
	class OQueryDesignAccess : public ODesignAccess
	{
	protected:
		sal_Bool	m_bCreateView;
		sal_Bool	m_bPreferSQLView;

	protected:
		virtual ::rtl::OUString getDispatchURL() const;

		virtual void fill(
			::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rDispatchArguments,
			const ::com::sun::star::uno::Any& _aDataSource,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection,
			const ::rtl::OUString& _rQueryName = ::rtl::OUString()/*,
			sal_Bool _bAsView = sal_True*/
		);

	public:
		OQueryDesignAccess(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB,
			sal_Bool _bCreateView = sal_False,
			sal_Bool _bPreferSQLView = sal_False,
			const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader >& _xFrameLoader = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader >());
	};
	//======================================================================
	//= OTableDesignAccess
	//======================================================================
	class OTableDesignAccess : public ODesignAccess
	{
	protected:
		virtual ::rtl::OUString getDispatchURL() const;

		virtual void fill(
			::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rDispatchArguments,
			const ::com::sun::star::uno::Any& _aDataSource,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection,
			const ::rtl::OUString& _rQueryName = ::rtl::OUString()/*,
			sal_Bool _bAsView = sal_True*/
		);

	public:
		OTableDesignAccess(	 const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB
							,const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader >& _xFrameLoader = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader >());
	};
	//======================================================================
	//= OTableAccess
	//======================================================================
	class OTableAccess : public ODesignAccess
	{
		sal_Bool	m_bTable;
	protected:
		virtual ::rtl::OUString getDispatchURL() const;

		virtual void fill(
			::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rDispatchArguments,
			const ::com::sun::star::uno::Any& _aDataSource,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection,
			const ::rtl::OUString& _rQualifiedName 
		);

	public:
		OTableAccess(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB
					,sal_Bool _bTable
					,const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader >& _xFrameLoader = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XComponentLoader >());

	};
	//======================================================================
	//= ORelationDesignAccess
	//======================================================================
	class ORelationDesignAccess : public ODesignAccess
	{
	protected:
		virtual ::rtl::OUString getDispatchURL() const;

		virtual void fill(
			::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rDispatchArguments,
			const ::com::sun::star::uno::Any& _aDataSource,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection,
			const ::rtl::OUString& _rQueryName = ::rtl::OUString()/*,
			sal_Bool _bAsView = sal_True*/
		);

	public:
		ORelationDesignAccess(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB);
	};

// .........................................................................
}	// namespace dbaui
// .........................................................................

#endif // _DBAUI_QUERYDESIGNACCESS_HXX_

