/*************************************************************************
 *
 *  $RCSfile: macros.hxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: pjunck $ $Date: 2004/10/22 10:58:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CPPU_MACROS_HXX_
#define _CPPU_MACROS_HXX_

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _UNO_LBNAMES_H_
#include <uno/lbnames.h>
#endif

/** Namespace name for compiler/ platform, e.g. gcc3, msci */
#define	CPPU_CURRENT_NAMESPACE CPPU_ENV

/** Patching the GCC 3 incomatible alignment change for Linux.

    This macro is appended by cppumaker to every first member of a struct, if
    the struct inherits from a base struct and the first member is neither
    double nor sal_[u]Int64.  (The double/sal_[u]Int64 restriction is due to a
    bug in GCC prior to version 3.3, which would cause __alignof__ of such a
    struct to become 8 instead of 4 if CPPU_GCC3_ALIGN were added to its first
    member.)

    @internal
*/
#if defined(__GNUC__) && (__GNUC__ >= 3)
#define CPPU_GCC3_ALIGN( base_struct ) __attribute__ ((aligned (__alignof__ (base_struct))))
#else
#define CPPU_GCC3_ALIGN( base_struct )
#endif

/**
   Exporting the symbols necessary for exception handling on GCC.

   These macros are used in the headers generated by cppumaker for UNO exception
   types, to ensure that exception handling does not fail on GCC.

   @internal
*/
#if defined __GNUC__
#define CPPU_GCC_DLLPUBLIC_EXPORT SAL_DLLPUBLIC_EXPORT
#define CPPU_GCC_DLLPRIVATE SAL_DLLPRIVATE
#else
#define CPPU_GCC_DLLPUBLIC_EXPORT
#define CPPU_GCC_DLLPRIVATE
#endif

#endif	// _CPPU_MACROS_HXX_

