/*************************************************************************
 *
 *  $RCSfile: fanalyzer.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: obo $ $Date: 2003/09/04 08:28:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_FILE_FANALYZER_HXX_
#define _CONNECTIVITY_FILE_FANALYZER_HXX_

#ifndef _CONNECTIVITY_FILE_FCOMP_HXX_
#include "file/fcomp.hxx"
#endif

namespace connectivity
{
	namespace file
	{
		
		class OSQLAnalyzer
		{
			typedef ::std::list<OEvaluateSet*>		OEvaluateSetList;
			typedef ::std::pair< ::vos::ORef<OPredicateCompiler>,::vos::ORef<OPredicateInterpreter> > TPredicates;

			::std::vector< TPredicates >		m_aSelectionEvaluations;
			::vos::ORef<OPredicateCompiler>		m_aCompiler;
			::vos::ORef<OPredicateInterpreter>	m_aInterpreter;

			mutable sal_Bool 					m_bHasSelectionCode;
			mutable sal_Bool 					m_bSelectionFirstTime;

			void bindRow(OCodeList& rCodeList,const OValueRefRow& _pRow,OEvaluateSetList& _rEvaluateSetList);

		public:
			OSQLAnalyzer();
			virtual ~OSQLAnalyzer();
			inline static void * SAL_CALL operator new( size_t nSize ) SAL_THROW( () )
				{ return ::rtl_allocateMemory( nSize ); }
			inline static void * SAL_CALL operator new( size_t nSize,void* _pHint ) SAL_THROW( () )
				{ return _pHint; }
			inline static void SAL_CALL operator delete( void * pMem ) SAL_THROW( () )
				{ ::rtl_freeMemory( pMem ); }
			inline static void SAL_CALL operator delete( void * pMem,void* _pHint ) SAL_THROW( () )
				{  }

			void describeParam(::vos::ORef<OSQLColumns> rParameterColumns); // genauere Beschreibung der Parameter
			::std::vector<sal_Int32>* bindEvaluationRow(OValueRefRow& _pRow);					// Anbinden einer Ergebniszeile an die Restrictions
			/** bind the select columns if they contain a function which needs a row value
				@param	_pRow	the result row
			*/
			void bindSelectRow(const OValueRefRow& _pRow);

			/** binds the row to parameter for the restrictions
				@param	_pRow	the parameter row
			*/
			void bindParameterRow(OValueRefRow& _pRow);

			void setIndexes(const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess>& _xIndexes);

			void dispose();
			void start(OSQLParseNode* pSQLParseNode);
			void clean();
			virtual BOOL hasRestriction() const;
			virtual BOOL hasFunctions() const;
			inline BOOL evaluateRestriction()	{ return m_aInterpreter->start(); }
			void setSelectionEvaluationResult(OValueRefRow& _pRow,const ::std::vector<sal_Int32>& _rColumnMapping);
			void setOrigColumns(const OFileColumns& rCols);
			virtual OOperandAttr* createOperandAttr(sal_Int32 _nPos,
													const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet>& _xCol,
													const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess>& _xIndexes=NULL);
		};
	}
}
#endif // _CONNECTIVITY_FILE_FANALYZER_HXX_

