/*************************************************************************
 *
 *  $RCSfile: segmentheap.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jb $ $Date: 2002/03/15 11:39:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_SEGMENTHEAP_HXX
#define CONFIGMGR_SEGMENTHEAP_HXX

#ifndef CONFIGMGR_DATAHEAP_HXX
#include "heap.hxx"
#endif
#ifndef CONFIGMGR_UTILITY_HXX_
#include "utility.hxx"
#endif

namespace configmgr
{
// -----------------------------------------------------------------------------	
    namespace memory
    {
    // -------------------------------------------------------------------------	
        class SegmentHeap : Noncopyable
        {
            friend class Segment;
            typedef Heap::Lock Lock;

            Heap   m_heap;
            void * m_base;
            Lock * m_lock;

            Lock & lock() const { return *m_lock; }
        public:
            typedef Heap::HeapId        HeapId;
            typedef Heap::HeapIdParam   HeapIdParam;
            typedef Heap::Size          Size;
            typedef Heap::Address       Address;
            
            SegmentHeap(HeapManager & _rImpl)
            : m_heap(_rImpl)
            { init(); }

            SegmentHeap(HeapManager & _rImpl, Size _aInitialSize)
            : m_heap(_rImpl,_aInitialSize)
            { init(); }

            SegmentHeap(HeapManager & _rImpl, HeapIdParam _anId)
            : m_heap(_rImpl,_anId)
            { init(); }

            ~SegmentHeap();

            // PRE: lock must be acquired
            void*   base() const { return m_base; }
            HeapId  id() const { return m_heap.id(); }

            Address allocate(Size _sz) 
            {
                Address aResult = m_heap.allocate(_sz);
                if (!aResult)
                    aResult = this->allocateMore(_sz);
                return aResult;
            }

            void deallocate(Address _addr) 
            { 
                m_heap.deallocate(_addr); 
            }

            bool isValidAddress(Address _addr) const
            { 
                return m_heap.didAllocate(_addr); 
            }
        private:
            void init();
            Address allocateMore(Size _sz);
        };
    // -------------------------------------------------------------------------	
    }
// -----------------------------------------------------------------------------	
} // namespace configmgr

#endif // CONFIGMGR_SEGMENT_HXX

