/*************************************************************************
 *
 *  $RCSfile: ObjectIdentifier.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: bm $ $Date: 2004/01/26 09:13:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2003 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "chartview/ObjectIdentifier.hxx"
#include "macros.hxx"
#include "TitleHelper.hxx"
#include "ChartModelHelper.hxx"

#ifndef _COM_SUN_STAR_CHART2_XAXISCONTAINER_HPP_
#include <com/sun/star/chart2/XAxisContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XCHARTDOCUMENT_HPP_
#include <com/sun/star/chart2/XChartDocument.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XGRIDCONTAINER_HPP_
#include <com/sun/star/chart2/XGridContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XIDENTIFIABLE_HPP_
#include <com/sun/star/chart2/XIdentifiable.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XREGRESSIONCURVECONTAINER_HPP_
#include <com/sun/star/chart2/XRegressionCurveContainer.hpp>
#endif

#include <rtl/ustrbuf.hxx>

//.............................................................................
namespace chart
{
//.............................................................................
using namespace ::com::sun::star;
using namespace ::com::sun::star::chart2;

static rtl::OUString m_aMultiClick( C2U("MultiClick") );
static rtl::OUString m_aProtocol( C2U("CID/") );
static rtl::OUString m_aEmptyString;

ObjectIdentifier::ObjectIdentifier()
{
}


//static
rtl::OUString ObjectIdentifier::createClassifiedIdentifier(
        enum ObjectType eObjectType //e.g. OBJECTTYPE_DATA_SERIES
        , const rtl::OUString& rParticleID )//e.g. SeriesID
{
    return createClassifiedIdentifier(
        eObjectType, rParticleID, m_aEmptyString );
}

//static
rtl::OUString ObjectIdentifier::createClassifiedIdentifier(
        enum ObjectType eObjectType //e.g. OBJECTTYPE_DATA_POINT
        , const rtl::OUString& rParticleID //e.g. Point Index
        , const rtl::OUString& rParentPartical ) //e.g. "Series=SeriesID"
        //, bool bIsMultiClickObject ) //e.g. true
{
    //e.g. "MultiClick;Series=2:Point=34"

    rtl::OUStringBuffer aRet( m_aProtocol );
    aRet.append( getClassificationStringForType( eObjectType ));
    if(aRet.getLength()>m_aProtocol.getLength())
        aRet.appendAscii("/");
    aRet.append(rParentPartical);
    if(rParentPartical.getLength())
        aRet.appendAscii(":");

    aRet.append(getStringForType( eObjectType ));
    aRet.appendAscii("=");
    aRet.append(rParticleID);

    return aRet.makeStringAndClear();
}

//static
rtl::OUString ObjectIdentifier::createParticle(
		ObjectType eObjectType, const rtl::OUString& rID  )
{
	rtl::OUStringBuffer aRet;
	aRet.append(getStringForType( eObjectType ));
	aRet.appendAscii("=");
	aRet.append(rID);
	return aRet.makeStringAndClear();
}

//static
bool ObjectIdentifier::isDragableObject( const rtl::OUString& rClassifiedIdentifier )
{
    ObjectType eObjectType = ObjectIdentifier::getObjectType( rClassifiedIdentifier );
    switch( eObjectType )
    {
        case OBJECTTYPE_TITLE:
        case OBJECTTYPE_LEGEND:
        case OBJECTTYPE_DIAGRAM:
        case OBJECTTYPE_DIAGRAM_WALL:
            return true;
        default:
            return false;
    }
    return false;
}

//static
bool ObjectIdentifier::isRotateableObject( const rtl::OUString& rClassifiedIdentifier )
{
    ObjectType eObjectType = ObjectIdentifier::getObjectType( rClassifiedIdentifier );
    switch( eObjectType )
    {
        case OBJECTTYPE_DIAGRAM:
        case OBJECTTYPE_DIAGRAM_WALL:
            return true;
        default:
            return false;
    }
    return false;
}

//static
bool ObjectIdentifier::isMultiClickObject( const rtl::OUString& rClassifiedIdentifier )
{
    //the name of a shape is it's ClassifiedIdentifier

    //a MultiClickObject is an object that is selectable by more than one click only ;
    //before a MultiClickObject can be selected it is necessary that a named parent group object
    //was selected before;

    //!!!!! by definition the name of a MultiClickObject starts with "CID/MultiClick:"
    bool bRet = false;
    bRet = rClassifiedIdentifier.match( m_aMultiClick, m_aProtocol.getLength() );
    return bRet;
}

bool ObjectIdentifier::areSiblings( const rtl::OUString& rCID1, const rtl::OUString& rCID2 )
{
    bool bRet=false;
    //sal_Int32 indexOf( sal_Unicode ch, sal_Int32 fromIndex = 0 ) const SAL_THROW(())
    //sal_Int32 lastIndexOf( sal_Unicode ch ) const SAL_THROW(())
    //OUString copy( sal_Int32 beginIndex, sal_Int32 count ) const SAL_THROW(())
    sal_Int32 nLastSign1 = rCID1.lastIndexOf( '=' );
    sal_Int32 nLastSign2 = rCID2.lastIndexOf( '=' );
    if( nLastSign1 == rCID1.indexOf( '=' ) )//CID cannot be sibling if only one "=" occurs
        bRet=false;
    else if( nLastSign2 == rCID2.indexOf( '=' ) )//CID cannot be sibling if only one "=" occurs
        bRet=false;
    else
    {
        //each CID has at least one '='
        rtl::OUString aEqualPart = rCID1.copy(0,nLastSign1);
        bRet=rCID2.match(aEqualPart);
    }
    return bRet;
}

//static
rtl::OUString ObjectIdentifier::getClassificationStringForType( ObjectType eObjectType )
{
    rtl::OUString aRet;
    switch( eObjectType )
    {
        //these object types are all selected only after their parents was selected before
        case OBJECTTYPE_LEGEND_ENTRY: //parent is intended to be OBJECTTYPE_LEGEND
        case OBJECTTYPE_DATA_POINT: //parent is intended to be OBJECTTYPE_DATA_SERIES
        case OBJECTTYPE_DATA_LABEL: //parent is intended to be OBJECTTYPE_DATA_LABELS
        case OBJECTTYPE_DATA_ERRORS_X: //parent is intended to be OBJECTTYPE_DATA_ERRORS
        case OBJECTTYPE_DATA_ERRORS_Y: //parent is intended to be OBJECTTYPE_DATA_ERRORS
        case OBJECTTYPE_DATA_ERRORS_Z: //parent is intended to be OBJECTTYPE_DATA_ERRORS
            aRet=m_aMultiClick;
        default:
            ;//empty string
    }
    return aRet;
}
//static
rtl::OUString ObjectIdentifier::getStringForType( ObjectType eObjectType )
{
    rtl::OUString aRet;
    switch( eObjectType )
    {
        case OBJECTTYPE_PAGE:
                aRet=C2U("Page");
                break;
        case OBJECTTYPE_TITLE:
                aRet=C2U("Title");
                break;
        case OBJECTTYPE_LEGEND:
                aRet=C2U("Legend");
                break;
        case OBJECTTYPE_LEGEND_ENTRY:
                aRet=C2U("LegendEntry");
                break;
        case OBJECTTYPE_DIAGRAM:
                aRet=C2U("Diagram");
                break;
        case OBJECTTYPE_DIAGRAM_WALL:
                aRet=C2U("DiagramWall");
                break;
        case OBJECTTYPE_DIAGRAM_FLOOR:
                aRet=C2U("DiagramFloor");
                break;
        case OBJECTTYPE_AXIS:
                aRet=C2U("Axis");
                break;
        case OBJECTTYPE_AXIS_UNITLABEL:
                aRet=C2U("AxisUnitLabel");
                break;
        case OBJECTTYPE_GRID:
                aRet=C2U("Grid");
                break;
        case OBJECTTYPE_DATA_SERIES:
                aRet=C2U("Series");
                break;
        case OBJECTTYPE_DATA_POINT:
                aRet=C2U("Point");
                break;
        case OBJECTTYPE_DATA_LABELS:
                aRet=C2U("DataLabels");
                break;
        case OBJECTTYPE_DATA_LABEL:
                aRet=C2U("DataLabel");
                break;
        case OBJECTTYPE_DATA_ERRORS:
                aRet=C2U("Errors");
                break;
        case OBJECTTYPE_DATA_ERRORS_X:
                aRet=C2U("ErrorsX");
                break;
        case OBJECTTYPE_DATA_ERRORS_Y:
                aRet=C2U("ErrorsY");
                break;
        case OBJECTTYPE_DATA_ERRORS_Z:
                aRet=C2U("ErrorsZ");
                break;
        case OBJECTTYPE_DATA_CURVE:
                aRet=C2U("Curve");
                break;
        case OBJECTTYPE_DATA_STOCK_RANGE:
                aRet=C2U("StockRange");
                break;
        case OBJECTTYPE_DATA_STOCK_LOSS:
                aRet=C2U("StockLoss");
                break;
        case OBJECTTYPE_DATA_STOCK_GAIN:
                aRet=C2U("StockGain");
                break;
        default: //OBJECTTYPE_UNKNOWN
            ;
    }
    return aRet;
}

//static
ObjectType ObjectIdentifier::getObjectType( const rtl::OUString& rCID )
{
    ObjectType eRet;
    sal_Int32 nLastSign = rCID.lastIndexOf( ':' );//last sign before the type string
    if(nLastSign==-1)
        nLastSign = rCID.lastIndexOf( '/' );
    if(nLastSign==-1)
        return OBJECTTYPE_UNKNOWN;
    if( nLastSign>0 )
        nLastSign++;

    if( rCID.match(C2U("Page"),nLastSign) )
        eRet = OBJECTTYPE_PAGE;
    else if( rCID.match(C2U("Title"),nLastSign) )
        eRet = OBJECTTYPE_TITLE;
    else if( rCID.match(C2U("LegendEntry"),nLastSign) )
        eRet = OBJECTTYPE_LEGEND_ENTRY;
    else if( rCID.match(C2U("Legend"),nLastSign) )
        eRet = OBJECTTYPE_LEGEND;
    else if( rCID.match(C2U("DiagramWall"),nLastSign) )
        eRet = OBJECTTYPE_DIAGRAM_WALL;
    else if( rCID.match(C2U("DiagramFloor"),nLastSign) )
        eRet = OBJECTTYPE_DIAGRAM_FLOOR;
    else if( rCID.match(C2U("Diagram"),nLastSign) )
        eRet = OBJECTTYPE_DIAGRAM;
    else if( rCID.match(C2U("AxisUnitLabel"),nLastSign) )
        eRet = OBJECTTYPE_AXIS_UNITLABEL;
    else if( rCID.match(C2U("Axis"),nLastSign) )
        eRet = OBJECTTYPE_AXIS;
    else if( rCID.match(C2U("Grid"),nLastSign) )
        eRet = OBJECTTYPE_GRID;
    else if( rCID.match(C2U("Series"),nLastSign) )
        eRet = OBJECTTYPE_DATA_SERIES;
    else if( rCID.match(C2U("Point"),nLastSign) )
        eRet = OBJECTTYPE_DATA_POINT;
    else if( rCID.match(C2U("DataLabels"),nLastSign) )
        eRet = OBJECTTYPE_DATA_LABELS;
    else if( rCID.match(C2U("DataLabel"),nLastSign) )
        eRet = OBJECTTYPE_DATA_LABEL;
    else if( rCID.match(C2U("ErrorsX"),nLastSign) )
        eRet = OBJECTTYPE_DATA_ERRORS_X;
    else if( rCID.match(C2U("ErrorsY"),nLastSign) )
        eRet = OBJECTTYPE_DATA_ERRORS_Y;
    else if( rCID.match(C2U("ErrorsZ"),nLastSign) )
        eRet = OBJECTTYPE_DATA_ERRORS_Z;
    else if( rCID.match(C2U("Errors"),nLastSign) )
        eRet = OBJECTTYPE_DATA_ERRORS;
    else if( rCID.match(C2U("Curve"),nLastSign) )
        eRet = OBJECTTYPE_DATA_CURVE;
    else if( rCID.match(C2U("StockRange"),nLastSign) )
        eRet = OBJECTTYPE_DATA_STOCK_RANGE;
    else if( rCID.match(C2U("StockLoss"),nLastSign) )
        eRet = OBJECTTYPE_DATA_STOCK_LOSS;
    else if( rCID.match(C2U("StockGain"),nLastSign) )
        eRet = OBJECTTYPE_DATA_STOCK_GAIN;
    else
        eRet = OBJECTTYPE_UNKNOWN;

    return eRet;
}

//static
rtl::OUString ObjectIdentifier::createDataCurveCID(
                                const rtl::OUString& rSeriesID
                                , const rtl::OUString& rDataCurveID )
{
    rtl::OUString aSeriesCID = ObjectIdentifier::createClassifiedIdentifier(
                OBJECTTYPE_DATA_SERIES, rSeriesID );
    rtl::OUString aRet( createClassifiedIdentifier(
        OBJECTTYPE_DATA_CURVE, m_aEmptyString, aSeriesCID ) );
    return aRet+=rDataCurveID;
}

//static
rtl::OUString ObjectIdentifier::createPointCID_Stub( const rtl::OUString& rSeriesID  )
{
    return createClassifiedIdentifier(
        OBJECTTYPE_DATA_POINT
        , m_aEmptyString
        , rSeriesID );
}

//static
rtl::OUString ObjectIdentifier::createPointCID( const rtl::OUString& rPointCID_Stub, sal_Int32 nIndex  )
{
    rtl::OUString aRet(rPointCID_Stub);
    return aRet+=rtl::OUString::valueOf( nIndex );
}

//static
rtl::OUString ObjectIdentifier::getParticleID( const rtl::OUString& rCID )
{
    rtl::OUString aRet;
    sal_Int32 nLast = rCID.lastIndexOf('=');
    if(nLast>=0)
        aRet = rCID.copy(++nLast);
    return aRet;
}

//static
rtl::OUString ObjectIdentifier::getParentParticleID( const rtl::OUString& rCID )
{
    rtl::OUString aRet;
    sal_Int32 nLast = rCID.lastIndexOf(':');
    if(nLast>=0)
    {
        sal_Int32 nLastButOne = rCID.lastIndexOf( '=', --nLast );
        if(nLastButOne>=0 && ++nLastButOne<nLast)
            aRet = rCID.copy(nLastButOne,nLast-nLastButOne+1);
    }
    return aRet;
}

//static
bool ObjectIdentifier::isCID( const rtl::OUString& rName )
{
    return rName.getLength() && rName.match( m_aProtocol );
}

//static
uno::Reference< beans::XPropertySet > ObjectIdentifier::getObjectPropertySet(
                const rtl::OUString& rObjectCID
                , const uno::Reference< frame::XModel >& xChartModel )
{
    //return the model object that is indicated by rObjectCID
    if(!rObjectCID.getLength())
        return NULL;
    if(!xChartModel.is())
        return NULL;

    uno::Reference< beans::XPropertySet > xObjectProperties = NULL;
    try
    {
        ObjectType eObjectType = ObjectIdentifier::getObjectType( rObjectCID );
        rtl::OUString aParticleID = ObjectIdentifier::getParticleID( rObjectCID );
        switch(eObjectType)
        {
            case OBJECTTYPE_PAGE:
                {
                    uno::Reference< XChartDocument > xChartDocument( xChartModel, uno::UNO_QUERY );
                    if( xChartDocument.is())
                        xObjectProperties.set( xChartDocument->getPageBackground() );
                }
                break;
            case OBJECTTYPE_TITLE:
                {
                    if( TitleHelper::getIdentifierForTitle(TitleHelper::MAIN_TITLE).equals( aParticleID ) )
                        xObjectProperties.set( TitleHelper::getTitle(TitleHelper::MAIN_TITLE,xChartModel), uno::UNO_QUERY );
                    else if( TitleHelper::getIdentifierForTitle(TitleHelper::SUB_TITLE).equals( aParticleID ) )
                        xObjectProperties.set( TitleHelper::getTitle(TitleHelper::SUB_TITLE,xChartModel), uno::UNO_QUERY );
                    else if( TitleHelper::getIdentifierForTitle(TitleHelper::X_AXIS_TITLE).equals( aParticleID ) )
                        xObjectProperties.set( TitleHelper::getTitle(TitleHelper::X_AXIS_TITLE,xChartModel), uno::UNO_QUERY );
                    else if( TitleHelper::getIdentifierForTitle(TitleHelper::Y_AXIS_TITLE).equals( aParticleID ) )
                        xObjectProperties.set( TitleHelper::getTitle(TitleHelper::Y_AXIS_TITLE,xChartModel), uno::UNO_QUERY );
                    else if( TitleHelper::getIdentifierForTitle(TitleHelper::Z_AXIS_TITLE).equals( aParticleID ) )
                        xObjectProperties.set( TitleHelper::getTitle(TitleHelper::Z_AXIS_TITLE,xChartModel), uno::UNO_QUERY );
                }
                break;
            case OBJECTTYPE_LEGEND:
                {
                    uno::Reference< XDiagram > xDia( ChartModelHelper::findDiagram( xChartModel ) );
                    if( xDia.is())
                        xObjectProperties.set( xDia->getLegend(), uno::UNO_QUERY );
                }
                break;
            case OBJECTTYPE_LEGEND_ENTRY:
                    break;
            case OBJECTTYPE_DIAGRAM:
                     break;
            case OBJECTTYPE_DIAGRAM_WALL:
                {
                    uno::Reference< XDiagram > xDia( ChartModelHelper::findDiagram( xChartModel ) );
                    if( xDia.is())
                        xObjectProperties.set( xDia->getWall() );
                }
                break;
            case OBJECTTYPE_DIAGRAM_FLOOR:
                {
                    uno::Reference< XDiagram > xDia( ChartModelHelper::findDiagram( xChartModel ) );
                    if( xDia.is())
                        xObjectProperties.set( xDia->getFloor() );
                }
                break;
            case OBJECTTYPE_AXIS:
                {
                    uno::Reference< XAxisContainer > xAxisCnt( ChartModelHelper::findDiagram(xChartModel), uno::UNO_QUERY );
                    if( xAxisCnt.is())
                        xObjectProperties.set(
                            xAxisCnt->getAxisByIdentifier( aParticleID ),
                            uno::UNO_QUERY );
                }
                break;
            case OBJECTTYPE_AXIS_UNITLABEL:
                    break;
            case OBJECTTYPE_GRID:
                {
                    uno::Reference< XGridContainer > xGridCnt( ChartModelHelper::findDiagram(xChartModel), uno::UNO_QUERY );
                    if( xGridCnt.is())
                        xObjectProperties.set(
                            xGridCnt->getGridByIdentifier( aParticleID ),
                            uno::UNO_QUERY );
                }
                break;
            case OBJECTTYPE_DATA_LABELS:
            case OBJECTTYPE_DATA_SERIES:
                {
                    uno::Reference< XDataSeries > xSeries =
                        ChartModelHelper::getSeriesByIdentifier( aParticleID, xChartModel );
                    if(xSeries.is())
                        xObjectProperties = uno::Reference< beans::XPropertySet >(
                                                xSeries, uno::UNO_QUERY );
                    break;
                }
            case OBJECTTYPE_DATA_LABEL:
            case OBJECTTYPE_DATA_POINT:
                {
                    rtl::OUString aSeriesID = ObjectIdentifier::getParentParticleID( rObjectCID );

                    uno::Reference< XDataSeries > xSeries =
                        ChartModelHelper::getSeriesByIdentifier( aSeriesID, xChartModel );
                    if(xSeries.is())
                    {
                        sal_Int32 nIndex = aParticleID.toInt32();
                        xObjectProperties = xSeries->getDataPointByIndex( nIndex );
                    }
                    break;
                }
            case OBJECTTYPE_DATA_ERRORS:
                {
                    uno::Reference< XDataSeries > xSeries =
                        ChartModelHelper::getSeriesByIdentifier( aParticleID, xChartModel );
                    if(xSeries.is())
                    {
                        uno::Reference< beans::XPropertySet > xSeriesProp( xSeries, uno::UNO_QUERY );
                        uno::Reference< beans::XPropertySet > xErrorBarProp;
                        if( xSeriesProp.is() )
                        {
                            xSeriesProp->getPropertyValue( C2U( "ErrorBarY" )) >>= xErrorBarProp;
                            xObjectProperties = uno::Reference< beans::XPropertySet >( xErrorBarProp, uno::UNO_QUERY );
                        }
                    }
                    break;
                }
            case OBJECTTYPE_DATA_ERRORS_X:
                    break;
            case OBJECTTYPE_DATA_ERRORS_Y:
                    break;
            case OBJECTTYPE_DATA_ERRORS_Z:
                    break;
            case OBJECTTYPE_DATA_CURVE:
                {
                    rtl::OUString aSeriesID = ObjectIdentifier::getParentParticleID( rObjectCID );

                    uno::Reference< XDataSeries > xSeries =
                        ChartModelHelper::getSeriesByIdentifier( aSeriesID, xChartModel );
                    uno::Reference< XRegressionCurveContainer > xRegressionContainer( xSeries, uno::UNO_QUERY );
                    if(xRegressionContainer.is())
                    {
                        uno::Sequence< uno::Reference< XRegressionCurve > > aCurveList =
                            xRegressionContainer->getRegressionCurves();
                        for(sal_Int32 nN=0; nN<aCurveList.getLength(); nN++)
                        {
                            uno::Reference< XIdentifiable > xCurveIdentifier( aCurveList[nN], uno::UNO_QUERY );
                            if(xCurveIdentifier.is() && aParticleID.equals( xCurveIdentifier->getIdentifier() ) )
                            {
                                xObjectProperties = uno::Reference< beans::XPropertySet >( xCurveIdentifier, uno::UNO_QUERY );
                                break;
                            }
                        }
                    }
                    break;
                }
            case OBJECTTYPE_DATA_STOCK_RANGE:
                    break;
            case OBJECTTYPE_DATA_STOCK_LOSS:
                    break;
            case OBJECTTYPE_DATA_STOCK_GAIN:
                    break;
            default: //OBJECTTYPE_UNKNOWN
                    break;
        }
    }
    catch( uno::Exception& ex)
    {
        ASSERT_EXCEPTION( ex );
    }
    return xObjectProperties;
}

//static
uno::Reference< XDataSeries > ObjectIdentifier::getDataSeriesForCID(
                const rtl::OUString& rObjectCID
                , const uno::Reference< frame::XModel >& xChartModel )
{
    uno::Reference< XDataSeries > xSeries(NULL);
    ObjectType eObjectType = ObjectIdentifier::getObjectType( rObjectCID );
    switch(eObjectType)
	{
	case OBJECTTYPE_DATA_LABELS:
    case OBJECTTYPE_DATA_SERIES:
	{
		rtl::OUString aSeriesID = ObjectIdentifier::getParticleID( rObjectCID );
		xSeries = ChartModelHelper::getSeriesByIdentifier( aSeriesID, xChartModel );
		break;
	}
	case OBJECTTYPE_DATA_LABEL:
    case OBJECTTYPE_DATA_POINT:
    {
        rtl::OUString aSeriesID = ObjectIdentifier::getParentParticleID( rObjectCID );
        xSeries = ChartModelHelper::getSeriesByIdentifier( aSeriesID, xChartModel );
		break;
	}
	default:
		break;
	}
    return xSeries;
}

//.............................................................................
} //namespace chart
//.............................................................................
