/*************************************************************************
 *
 *  $RCSfile: Increment.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2004/01/26 09:12:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2003 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "Increment.hxx"
#include "macros.hxx"

using namespace ::com::sun::star;

namespace chart
{

Increment::Increment()
{
    m_aIncrement.PostEquidistant = uno::makeAny( sal_Bool( sal_True ));
    m_aIncrement.BaseValue = uno::makeAny( sal_Int32( 0 ));

    m_aSubIncrements.realloc( 1 );
    m_aSubIncrements[0].PostEquidistant = uno::makeAny( sal_Bool( sal_False ));
}

Increment::~Increment()
{}

void SAL_CALL Increment::setIncrementData( const chart2::IncrementData& aIncrement )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    m_aIncrement = aIncrement;
}

chart2::IncrementData SAL_CALL Increment::getIncrementData()
    throw (uno::RuntimeException)
{
    return m_aIncrement;
}

void SAL_CALL Increment::setSubIncrements( const uno::Sequence< chart2::SubIncrement >& aSubIncrements )
    throw (uno::RuntimeException)
{
    m_aSubIncrements = aSubIncrements;
}

uno::Sequence< chart2::SubIncrement > SAL_CALL Increment::getSubIncrements()
    throw (uno::RuntimeException)
{
    return m_aSubIncrements;
}

uno::Sequence< ::rtl::OUString > Increment::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 1 );
    aServices[ 0 ] = C2U( "com.sun.star.chart2.IncrementSupplier" );
    return aServices;
}

APPHELPER_XSERVICEINFO_IMPL( Increment,
                             ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
                                                  "com.sun.star.comp.chart2.Increment" )));

} //  namespace chart
