/*************************************************************************
 *
 *  $RCSfile: FileDataProvider.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2004/01/26 09:12:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2003 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "FileDataProvider.hxx"
#include "FileDataSource.hxx"
#include "macros.hxx"

using namespace ::com::sun::star;

namespace
{
static const ::rtl::OUString lcl_aServiceName(
    RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.chart.FileDataProvider" ));
}  // anonymous namespace

namespace chart
{

FileDataProvider::FileDataProvider(
    const uno::Reference< uno::XComponentContext > & xContext ) :
        m_xContext( xContext )
{
}

FileDataProvider::~FileDataProvider()
{}

uno::Sequence< ::rtl::OUString > FileDataProvider::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 2 );
    aServices[ 0 ] = lcl_aServiceName;
    aServices[ 1 ] = C2U( "com.sun.star.chart2.DataProvider" );
    return aServices;
}

APPHELPER_XSERVICEINFO_IMPL( FileDataProvider, lcl_aServiceName )

// ----------------------------------------

// ____ XDataProvider ____

uno::Reference< chart2::XDataSource > SAL_CALL
    FileDataProvider::getDataByRangeRepresentation( const ::rtl::OUString& aRangeRepresentation )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    // aRangeRepresentation is interpreted as FileName

    m_xChartData.set( m_xContext->getServiceManager()->createInstanceWithContext(
                          C2U( "com.sun.star.comp.chart.FileDataSource" ),
                          m_xContext ), uno::UNO_QUERY );

    uno::Reference< lang::XInitialization > xInit( m_xChartData, uno::UNO_QUERY );
    if( xInit.is())
    {
        uno::Sequence< uno::Any > aArgs( 1 );
        aArgs[ 0 ] <<= aRangeRepresentation;
        xInit->initialize( aArgs );
    }

    return m_xChartData;
}

uno::Reference< chart2::XDataSequence > SAL_CALL
    FileDataProvider::getDataSequenceByRangeIdentifier( const ::rtl::OUString& aRangeIdentifier )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    // n.i.
    return uno::Reference< chart2::XDataSequence >();
}

uno::Reference< chart2::XDataSequence > SAL_CALL
    FileDataProvider::replaceRange( const uno::Reference< chart2::XDataSequence >& aSeq )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    // n.i.
    return aSeq;
}

void SAL_CALL FileDataProvider::addDataChangeListener(
    const uno::Reference< chart2::XDataChangeListener >& aListener,
    const uno::Reference< chart2::XDataSource >& aData )
    throw (::com::sun::star::uno::RuntimeException)
{}

void SAL_CALL FileDataProvider::removeDataChangeListener(
    const uno::Reference< chart2::XDataChangeListener >& aListener,
    const uno::Reference< chart2::XDataSource >& aData )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{}

} //  namespace chart
