/*************************************************************************
 *
 *  $RCSfile: MeterHelper.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2004/01/26 09:12:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2003 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CHART2_TOOLS_METERHELPER_HXX
#define _CHART2_TOOLS_METERHELPER_HXX

#ifndef _COM_SUN_STAR_CHART2_XAXISCONTAINER_HPP_
#include <com/sun/star/chart2/XAxisContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XBOUNDEDCOORDINATESYSTEM_HPP_
#include <com/sun/star/chart2/XBoundedCoordinateSystem.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XDIAGRAM_HPP_
#include <com/sun/star/chart2/XDiagram.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART2_XGRID_HPP_
#include <com/sun/star/chart2/XGrid.hpp>
#endif

#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

//-----------------------------------------------------------------------------
/**
*/

class MeterHelper
{
public:
    static rtl::OUString MeterHelper::makeAxisIdentifier(
          sal_Int32 nDimensionIndex
        , sal_Int32 nCooSysIndex );

    static ::com::sun::star::uno::Reference<
           ::com::sun::star::chart2::XAxis >
        createAxis(
            sal_Int32 nDimensionIndex
            , const ::com::sun::star::uno::Reference<
                    ::com::sun::star::chart2::XBoundedCoordinateSystem >& xCooSys
            , const ::com::sun::star::uno::Reference<
                    ::com::sun::star::chart2::XAxisContainer >& xAxisContainer
            , const ::com::sun::star::uno::Reference<
                    ::com::sun::star::uno::XComponentContext > & xContext );

    static rtl::OUString makeGridIdentifier( sal_Int32 nDimensionIndex, sal_Int32 nCooSysIndex, bool bMainGrid );

    static ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XBoundedCoordinateSystem >
        getBoundedCoordinateSystemByIndex(
            const ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XDiagram >& xDiagram
            , sal_Int32 nIndex );

    static ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XAxis >
        getAxis( sal_Int32 nDimensionIndex, bool bMainAxis
            , const ::com::sun::star::uno::Reference<
                    ::com::sun::star::chart2::XDiagram >& xDiagram );
    static ::com::sun::star::uno::Reference<
            ::com::sun::star::chart2::XGrid >
        getGrid( sal_Int32 nDimensionIndex, bool bMainGrid
            , const ::com::sun::star::uno::Reference<
                        ::com::sun::star::chart2::XDiagram >& xDiagram );

    static void getMeterPossibilities( ::com::sun::star::uno::Sequence< sal_Bool >& rPossibilityList
        , const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDiagram>& xDiagram, sal_Bool bAxis=sal_True );
};

//.............................................................................
} //namespace chart
//.............................................................................
#endif
