/*************************************************************************
 *
 *  $RCSfile: SchItemPool.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: bm $ $Date: 2003/12/10 16:51:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "SchSfxItemIds.hxx"

#include "SchAllDefinesFor_svx_chrtitem.hxx"
#ifndef _SVX_CHRTITEM_HXX
#include <svx/chrtitem.hxx>
#endif
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
// header for class SvXMLAttrContainerItem
#ifndef _SVX_XMLCNITM_HXX
#include <svx/xmlcnitm.hxx>
#endif

#ifndef _SVX_BRSHITEM_HXX
#define ITEMID_BRUSH SCHATTR_SYMBOL_BRUSH
#include <svx/brshitem.hxx>
#endif
#ifndef _SVX_SIZEITEM_HXX
#define ITEMID_SIZE 0
#include <svx/sizeitem.hxx>
#endif

#include "SchItemPool.hxx"

// for Singleton GetSchItemPool() function
// ---------------------------------------
#ifndef INCLUDED_OSL_DOUBLECHECKEDLOCKING_H
#include "rtl/instance.hxx"
#endif
#ifndef INCLUDED_OSL_GETGLOBALMUTEX_HXX
#include "osl/getglobalmutex.hxx"
#endif

namespace {
struct SchItemPoolInitialization
{
    ::chart::wrapper::SchItemPool * operator()()
    {
        static ::chart::wrapper::SchItemPool aInstance;
        return &aInstance;
    }
};
}
// ---------------------------------------

namespace chart
{
namespace wrapper
{

SchItemPool * GetSchItemPool()
{
    return rtl_Instance< SchItemPool, SchItemPoolInitialization, ::osl::MutexGuard,
        ::osl::GetGlobalMutex >::create(
            SchItemPoolInitialization(), ::osl::GetGlobalMutex());
}

SchItemPool::SchItemPool():
		SfxItemPool( String( RTL_CONSTASCII_USTRINGPARAM( "SchItemPool" )), SCHATTR_START, SCHATTR_END, NULL, NULL )
{
//     OSL_TRACE( "SCH: CTOR: SchItemPool" );
	/**************************************************************************
	* PoolDefaults
	**************************************************************************/
	ppPoolDefaults = new SfxPoolItem*[SCHATTR_END - SCHATTR_START + 1];

	ppPoolDefaults[SCHATTR_DATADESCR_DESCR			- SCHATTR_START] = new SvxChartDataDescrItem;
	ppPoolDefaults[SCHATTR_DATADESCR_SHOW_SYM		- SCHATTR_START] = new SfxBoolItem(SCHATTR_DATADESCR_SHOW_SYM);
	ppPoolDefaults[SCHATTR_LEGEND_POS				- SCHATTR_START] = new SvxChartLegendPosItem( CHLEGEND_RIGHT );
// 	ppPoolDefaults[SCHATTR_TEXT_ORIENT				- SCHATTR_START] = new SvxChartTextOrientItem;
 	ppPoolDefaults[SCHATTR_TEXT_STACKED				- SCHATTR_START] = new SfxBoolItem(SCHATTR_TEXT_STACKED,FALSE);
	ppPoolDefaults[SCHATTR_TEXT_ORDER				- SCHATTR_START] = new SvxChartTextOrderItem;

	ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_MIN			- SCHATTR_START] = new SfxBoolItem(SCHATTR_Y_AXIS_AUTO_MIN);
	ppPoolDefaults[SCHATTR_Y_AXIS_MIN				- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_Y_AXIS_MIN);
	ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_MAX	  		- SCHATTR_START] = new SfxBoolItem(SCHATTR_Y_AXIS_AUTO_MAX);
	ppPoolDefaults[SCHATTR_Y_AXIS_MAX				- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_Y_AXIS_MAX);
	ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_STEP_MAIN	- SCHATTR_START] = new SfxBoolItem(SCHATTR_Y_AXIS_AUTO_STEP_MAIN);
	ppPoolDefaults[SCHATTR_Y_AXIS_STEP_MAIN			- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_Y_AXIS_STEP_MAIN);
	ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_STEP_HELP	- SCHATTR_START] = new SfxBoolItem(SCHATTR_Y_AXIS_AUTO_STEP_HELP);
	ppPoolDefaults[SCHATTR_Y_AXIS_STEP_HELP			- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_Y_AXIS_STEP_HELP);
	ppPoolDefaults[SCHATTR_Y_AXIS_LOGARITHM			- SCHATTR_START] = new SfxBoolItem(SCHATTR_Y_AXIS_LOGARITHM);
	ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_ORIGIN		- SCHATTR_START] = new SfxBoolItem(SCHATTR_Y_AXIS_AUTO_ORIGIN);
	ppPoolDefaults[SCHATTR_Y_AXIS_ORIGIN			- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_Y_AXIS_ORIGIN);

	ppPoolDefaults[SCHATTR_X_AXIS_AUTO_MIN			- SCHATTR_START] = new SfxBoolItem(SCHATTR_X_AXIS_AUTO_MIN);
	ppPoolDefaults[SCHATTR_X_AXIS_MIN				- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_X_AXIS_MIN);
	ppPoolDefaults[SCHATTR_X_AXIS_AUTO_MAX	  		- SCHATTR_START] = new SfxBoolItem(SCHATTR_X_AXIS_AUTO_MAX);
	ppPoolDefaults[SCHATTR_X_AXIS_MAX				- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_X_AXIS_MAX);
	ppPoolDefaults[SCHATTR_X_AXIS_AUTO_STEP_MAIN	- SCHATTR_START] = new SfxBoolItem(SCHATTR_X_AXIS_AUTO_STEP_MAIN);
	ppPoolDefaults[SCHATTR_X_AXIS_STEP_MAIN			- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_X_AXIS_STEP_MAIN);
	ppPoolDefaults[SCHATTR_X_AXIS_AUTO_STEP_HELP	- SCHATTR_START] = new SfxBoolItem(SCHATTR_X_AXIS_AUTO_STEP_HELP);
	ppPoolDefaults[SCHATTR_X_AXIS_STEP_HELP			- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_X_AXIS_STEP_HELP);
	ppPoolDefaults[SCHATTR_X_AXIS_LOGARITHM			- SCHATTR_START] = new SfxBoolItem(SCHATTR_X_AXIS_LOGARITHM);
	ppPoolDefaults[SCHATTR_X_AXIS_AUTO_ORIGIN		- SCHATTR_START] = new SfxBoolItem(SCHATTR_X_AXIS_AUTO_ORIGIN);
	ppPoolDefaults[SCHATTR_X_AXIS_ORIGIN			- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_X_AXIS_ORIGIN);

	ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_MIN			- SCHATTR_START] = new SfxBoolItem(SCHATTR_Z_AXIS_AUTO_MIN);
	ppPoolDefaults[SCHATTR_Z_AXIS_MIN				- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_Z_AXIS_MIN);
	ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_MAX	  		- SCHATTR_START] = new SfxBoolItem(SCHATTR_Z_AXIS_AUTO_MAX);
	ppPoolDefaults[SCHATTR_Z_AXIS_MAX				- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_Z_AXIS_MAX);
	ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_STEP_MAIN	- SCHATTR_START] = new SfxBoolItem(SCHATTR_Z_AXIS_AUTO_STEP_MAIN);
	ppPoolDefaults[SCHATTR_Z_AXIS_STEP_MAIN			- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_Z_AXIS_STEP_MAIN);
	ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_STEP_HELP	- SCHATTR_START] = new SfxBoolItem(SCHATTR_Z_AXIS_AUTO_STEP_HELP);
	ppPoolDefaults[SCHATTR_Z_AXIS_STEP_HELP			- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_Z_AXIS_STEP_HELP);
	ppPoolDefaults[SCHATTR_Z_AXIS_LOGARITHM			- SCHATTR_START] = new SfxBoolItem(SCHATTR_Z_AXIS_LOGARITHM);
	ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_ORIGIN		- SCHATTR_START] = new SfxBoolItem(SCHATTR_Z_AXIS_AUTO_ORIGIN);
	ppPoolDefaults[SCHATTR_Z_AXIS_ORIGIN			- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_Z_AXIS_ORIGIN);

	ppPoolDefaults[SCHATTR_AXISTYPE      			- SCHATTR_START] = new SfxInt32Item(SCHATTR_AXISTYPE, CHART_AXIS_X);
	ppPoolDefaults[SCHATTR_DUMMY0		         	- SCHATTR_START] = new SfxInt32Item(SCHATTR_DUMMY0, 0);
	ppPoolDefaults[SCHATTR_DUMMY1       			- SCHATTR_START] = new SfxInt32Item(SCHATTR_DUMMY1, 0);
	ppPoolDefaults[SCHATTR_DUMMY2		        	- SCHATTR_START] = new SfxInt32Item(SCHATTR_DUMMY2, 0);
	ppPoolDefaults[SCHATTR_DUMMY3	         		- SCHATTR_START] = new SfxInt32Item(SCHATTR_DUMMY3, 0);
	ppPoolDefaults[SCHATTR_DUMMY_END		        - SCHATTR_START] = new SfxInt32Item(SCHATTR_DUMMY_END, 0);

	ppPoolDefaults[SCHATTR_STAT_AVERAGE             - SCHATTR_START] = new SfxBoolItem (SCHATTR_STAT_AVERAGE);
	ppPoolDefaults[SCHATTR_STAT_KIND_ERROR          - SCHATTR_START] = new SvxChartKindErrorItem (CHERROR_NONE);
	ppPoolDefaults[SCHATTR_STAT_PERCENT             - SCHATTR_START] = new SvxDoubleItem (0.0, SCHATTR_STAT_PERCENT);
	ppPoolDefaults[SCHATTR_STAT_BIGERROR            - SCHATTR_START] = new SvxDoubleItem (0.0, SCHATTR_STAT_BIGERROR);
	ppPoolDefaults[SCHATTR_STAT_CONSTPLUS           - SCHATTR_START] = new SvxDoubleItem (0.0, SCHATTR_STAT_CONSTPLUS);
	ppPoolDefaults[SCHATTR_STAT_CONSTMINUS          - SCHATTR_START] = new SvxDoubleItem (0.0, SCHATTR_STAT_CONSTMINUS);
	ppPoolDefaults[SCHATTR_STAT_REGRESSTYPE         - SCHATTR_START] = new SvxChartRegressItem  (CHREGRESS_NONE);
	ppPoolDefaults[SCHATTR_STAT_INDICATE            - SCHATTR_START] = new SvxChartIndicateItem (CHINDICATE_NONE);

	ppPoolDefaults[SCHATTR_TEXT_DEGREES				- SCHATTR_START] = new SfxInt32Item(SCHATTR_TEXT_DEGREES, 0);
	ppPoolDefaults[SCHATTR_TEXT_OVERLAP	        	- SCHATTR_START] = new SfxBoolItem(SCHATTR_TEXT_OVERLAP,FALSE);
	ppPoolDefaults[SCHATTR_TEXT_DUMMY0		       	- SCHATTR_START] = new SfxInt32Item(SCHATTR_TEXT_DUMMY0, 0);
	ppPoolDefaults[SCHATTR_TEXT_DUMMY1      		- SCHATTR_START] = new SfxInt32Item(SCHATTR_TEXT_DUMMY1, 0);
	ppPoolDefaults[SCHATTR_TEXT_DUMMY2		      	- SCHATTR_START] = new SfxInt32Item(SCHATTR_TEXT_DUMMY2, 0);
	ppPoolDefaults[SCHATTR_TEXT_DUMMY3	       		- SCHATTR_START] = new SfxInt32Item(SCHATTR_TEXT_DUMMY3, 0);


	ppPoolDefaults[SCHATTR_STYLE_DEEP     - SCHATTR_START] = new SfxBoolItem (SCHATTR_STYLE_DEEP, 0);
	ppPoolDefaults[SCHATTR_STYLE_3D       - SCHATTR_START] = new SfxBoolItem (SCHATTR_STYLE_3D, 0);
	ppPoolDefaults[SCHATTR_STYLE_VERTICAL - SCHATTR_START] = new SfxBoolItem (SCHATTR_STYLE_VERTICAL, 0);
	ppPoolDefaults[SCHATTR_STYLE_BASETYPE - SCHATTR_START] = new SfxInt32Item(SCHATTR_STYLE_BASETYPE, 0);
	ppPoolDefaults[SCHATTR_STYLE_LINES    - SCHATTR_START] = new SfxBoolItem (SCHATTR_STYLE_LINES, 0);
	ppPoolDefaults[SCHATTR_STYLE_PERCENT  - SCHATTR_START] = new SfxBoolItem (SCHATTR_STYLE_PERCENT, 0);
	ppPoolDefaults[SCHATTR_STYLE_STACKED  - SCHATTR_START] = new SfxBoolItem (SCHATTR_STYLE_STACKED, 0);
	ppPoolDefaults[SCHATTR_STYLE_SPLINES  - SCHATTR_START] = new SfxInt32Item (SCHATTR_STYLE_SPLINES, 0); //Bug: war Bool! ->Fileformat testen (betrifft nur 5er)
	ppPoolDefaults[SCHATTR_STYLE_SYMBOL   - SCHATTR_START] = new SfxInt32Item (SCHATTR_STYLE_SYMBOL, 0);
	ppPoolDefaults[SCHATTR_STYLE_SHAPE    - SCHATTR_START] = new SfxInt32Item (SCHATTR_STYLE_SHAPE, 0);

	ppPoolDefaults[SCHATTR_AXIS					- SCHATTR_START] = new SfxInt32Item(SCHATTR_AXIS,2); //2 = Y-Achse!!!

	ppPoolDefaults[SCHATTR_AXIS_AUTO_MIN		- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_AUTO_MIN);
	ppPoolDefaults[SCHATTR_AXIS_MIN				- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_AXIS_MIN);
	ppPoolDefaults[SCHATTR_AXIS_AUTO_MAX	  	- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_AUTO_MAX);
	ppPoolDefaults[SCHATTR_AXIS_MAX				- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_AXIS_MAX);
	ppPoolDefaults[SCHATTR_AXIS_AUTO_STEP_MAIN	- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_AUTO_STEP_MAIN);
	ppPoolDefaults[SCHATTR_AXIS_STEP_MAIN		- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_AXIS_STEP_MAIN);
	ppPoolDefaults[SCHATTR_AXIS_AUTO_STEP_HELP	- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_AUTO_STEP_HELP);
// 	ppPoolDefaults[SCHATTR_AXIS_STEP_HELP		- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_AXIS_STEP_HELP);
    // type changed from double to sal_Int32
	ppPoolDefaults[SCHATTR_AXIS_STEP_HELP		- SCHATTR_START] = new SfxInt32Item(SCHATTR_AXIS_STEP_HELP,0);
	ppPoolDefaults[SCHATTR_AXIS_LOGARITHM		- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_LOGARITHM);
	ppPoolDefaults[SCHATTR_AXIS_AUTO_ORIGIN		- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_AUTO_ORIGIN);
	ppPoolDefaults[SCHATTR_AXIS_ORIGIN			- SCHATTR_START] = new SvxDoubleItem(0.0, SCHATTR_AXIS_ORIGIN);

	ppPoolDefaults[SCHATTR_AXIS_TICKS			- SCHATTR_START] = new SfxInt32Item(SCHATTR_AXIS_TICKS,CHAXIS_MARK_OUTER);
	ppPoolDefaults[SCHATTR_AXIS_HELPTICKS		- SCHATTR_START] = new SfxInt32Item(SCHATTR_AXIS_HELPTICKS,0);
	ppPoolDefaults[SCHATTR_AXIS_NUMFMT			- SCHATTR_START] = new SfxUInt32Item(SCHATTR_AXIS_NUMFMT,0);
	ppPoolDefaults[SCHATTR_AXIS_NUMFMTPERCENT	- SCHATTR_START] = new SfxUInt32Item(SCHATTR_AXIS_NUMFMTPERCENT,11);
	ppPoolDefaults[SCHATTR_AXIS_SHOWAXIS		- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_SHOWAXIS,0);
	ppPoolDefaults[SCHATTR_AXIS_SHOWDESCR		- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_SHOWDESCR,0);
	ppPoolDefaults[SCHATTR_AXIS_SHOWMAINGRID	- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_SHOWMAINGRID,0);
	ppPoolDefaults[SCHATTR_AXIS_SHOWHELPGRID	- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_SHOWHELPGRID,0);
	ppPoolDefaults[SCHATTR_AXIS_TOPDOWN			- SCHATTR_START] = new SfxBoolItem(SCHATTR_AXIS_TOPDOWN,0);

	ppPoolDefaults[SCHATTR_AXIS_DUMMY0			- SCHATTR_START] = new SfxInt32Item(SCHATTR_AXIS_DUMMY0,0);
	ppPoolDefaults[SCHATTR_AXIS_DUMMY1			- SCHATTR_START] = new SfxInt32Item(SCHATTR_AXIS_DUMMY1,0);
	ppPoolDefaults[SCHATTR_AXIS_DUMMY2			- SCHATTR_START] = new SfxInt32Item(SCHATTR_AXIS_DUMMY2,0);
	ppPoolDefaults[SCHATTR_AXIS_DUMMY3			- SCHATTR_START] = new SfxInt32Item(SCHATTR_AXIS_DUMMY3,0);
	ppPoolDefaults[SCHATTR_BAR_OVERLAP			- SCHATTR_START] = new SfxInt32Item(SCHATTR_BAR_OVERLAP,0);
	ppPoolDefaults[SCHATTR_BAR_GAPWIDTH			- SCHATTR_START] = new SfxInt32Item(SCHATTR_BAR_GAPWIDTH,0);

	ppPoolDefaults[SCHATTR_SYMBOL_BRUSH			- SCHATTR_START] = new SvxBrushItem(SCHATTR_SYMBOL_BRUSH);

	ppPoolDefaults[SCHATTR_STOCK_VOLUME 		- SCHATTR_START] = new SfxBoolItem(SCHATTR_STOCK_VOLUME,0);
	ppPoolDefaults[SCHATTR_STOCK_UPDOWN			- SCHATTR_START] = new SfxBoolItem(SCHATTR_STOCK_UPDOWN,0);

	ppPoolDefaults[SCHATTR_SYMBOL_SIZE			- SCHATTR_START] = new SvxSizeItem(SCHATTR_SYMBOL_SIZE,Size(0,0));
	ppPoolDefaults[SCHATTR_USER_DEFINED_ATTR	- SCHATTR_START] = new SvXMLAttrContainerItem( SCHATTR_USER_DEFINED_ATTR );

    // new for New Chart
	ppPoolDefaults[SCHATTR_TEXTBREAK            - SCHATTR_START] = new SfxBoolItem( SCHATTR_TEXTBREAK, FALSE );
    ppPoolDefaults[SCHATTR_DIAGRAM_STYLE        - SCHATTR_START] = new SvxChartStyleItem( CHSTYLE_2D_COLUMN );
    ppPoolDefaults[SCHATTR_NUM_OF_LINES_FOR_BAR - SCHATTR_START] = new SfxInt32Item( SCHATTR_NUM_OF_LINES_FOR_BAR, 0 );
    ppPoolDefaults[SCHATTR_SPLINE_ORDER         - SCHATTR_START] = new SfxInt32Item( SCHATTR_SPLINE_ORDER, 3 );
    ppPoolDefaults[SCHATTR_SPLINE_RESOLUTION    - SCHATTR_START] = new SfxInt32Item( SCHATTR_SPLINE_RESOLUTION, 20 );

	/**************************************************************************
	* ItemInfos
	**************************************************************************/
	pItemInfos = new SfxItemInfo[SCHATTR_END - SCHATTR_START + 1];

    USHORT i;
	for( i = SCHATTR_START; i <= SCHATTR_END; i++ )
	{
		pItemInfos[i - SCHATTR_START]._nSID = 0;
		pItemInfos[i - SCHATTR_START]._nFlags = SFX_ITEM_POOLABLE;
	}

    // non-persistent items
    for( i = SCHATTR_NONPERSISTENT_START; i <= SCHATTR_NONPERSISTENT_END; i++ )
    {
        pItemInfos[ i - SCHATTR_START ]._nFlags = 0;
    }

    // slot ids differing from which ids
	pItemInfos[SCHATTR_LEGEND_POS - SCHATTR_START]._nSID = CHATTR_LEGEND_POS;
	pItemInfos[SCHATTR_SYMBOL_BRUSH - SCHATTR_START]._nSID = SID_ATTR_BRUSH;
	pItemInfos[SCHATTR_STYLE_SYMBOL - SCHATTR_START]._nSID = SID_ATTR_SYMBOLTYPE;
	pItemInfos[SCHATTR_SYMBOL_SIZE - SCHATTR_START]._nSID  = SID_ATTR_SYMBOLSIZE;

	SetDefaults(ppPoolDefaults);
	SetItemInfos(pItemInfos);
}

SchItemPool::SchItemPool(const SchItemPool& rPool):
	SfxItemPool(rPool)
{
//     OSL_TRACE( "SCH: CTOR: SchItemPool" );
}

SchItemPool::~SchItemPool()
{
//     OSL_TRACE( "SCH: DTOR: SchItemPool" );
	Delete();

	delete[] pItemInfos;

	SetRefCount(*ppPoolDefaults[SCHATTR_DATADESCR_DESCR          - SCHATTR_START], 0);
	delete	ppPoolDefaults[SCHATTR_DATADESCR_DESCR			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_DATADESCR_SHOW_SYM		- SCHATTR_START], 0);
	delete	ppPoolDefaults[SCHATTR_DATADESCR_SHOW_SYM		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_LEGEND_POS				- SCHATTR_START], 0);
	delete	ppPoolDefaults[SCHATTR_LEGEND_POS				- SCHATTR_START];
// 	SetRefCount(*ppPoolDefaults[SCHATTR_TEXT_ORIENT				- SCHATTR_START], 0);
// 	delete  ppPoolDefaults[SCHATTR_TEXT_ORIENT				- SCHATTR_START];
 	SetRefCount(*ppPoolDefaults[SCHATTR_TEXT_STACKED			- SCHATTR_START], 0);
 	delete  ppPoolDefaults[SCHATTR_TEXT_STACKED				- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_TEXT_ORDER				- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_TEXT_ORDER				- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_TEXT_DEGREES 			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_TEXT_DEGREES				- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_TEXT_OVERLAP 			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_TEXT_OVERLAP				- SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_MIN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_MIN			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_MIN				- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_MIN				- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_MAX	  		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_MAX	  		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_MAX		  		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_MAX		  		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_STEP_MAIN	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_STEP_MAIN	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_STEP_MAIN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_STEP_MAIN			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_STEP_HELP	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_STEP_HELP	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_STEP_HELP			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_STEP_HELP			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_LOGARITHM			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_LOGARITHM			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_ORIGIN		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_AUTO_ORIGIN		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Y_AXIS_ORIGIN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Y_AXIS_ORIGIN			- SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_AUTO_MIN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_AUTO_MIN			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_MIN				- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_MIN				- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_AUTO_MAX	  		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_AUTO_MAX	  		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_MAX		  		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_MAX		  		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_AUTO_STEP_MAIN	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_AUTO_STEP_MAIN	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_STEP_MAIN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_STEP_MAIN			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_AUTO_STEP_HELP	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_AUTO_STEP_HELP	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_STEP_HELP			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_STEP_HELP			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_LOGARITHM			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_LOGARITHM			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_AUTO_ORIGIN		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_AUTO_ORIGIN		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_X_AXIS_ORIGIN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_X_AXIS_ORIGIN			- SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_MIN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_MIN			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_MIN				- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_MIN				- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_MAX	  		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_MAX	  		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_MAX		  		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_MAX		  		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_STEP_MAIN	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_STEP_MAIN	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_STEP_MAIN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_STEP_MAIN			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_STEP_HELP	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_STEP_HELP	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_STEP_HELP			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_STEP_HELP			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_LOGARITHM			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_LOGARITHM			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_ORIGIN		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_AUTO_ORIGIN		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_Z_AXIS_ORIGIN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_Z_AXIS_ORIGIN			- SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_AXISTYPE      			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXISTYPE      			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_DUMMY0		         	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_DUMMY0		         	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_DUMMY1       			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_DUMMY1       			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_DUMMY2		        	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_DUMMY2		        	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_DUMMY3	         		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_DUMMY3	         		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_DUMMY_END		        - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_DUMMY_END		        - SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_STAT_AVERAGE             - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_STAT_AVERAGE             - SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_STAT_KIND_ERROR          - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_STAT_KIND_ERROR          - SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_STAT_PERCENT             - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_STAT_PERCENT             - SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_STAT_BIGERROR            - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_STAT_BIGERROR            - SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_STAT_CONSTPLUS           - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_STAT_CONSTPLUS           - SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_STAT_CONSTMINUS          - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_STAT_CONSTMINUS          - SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_STAT_INDICATE            - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_STAT_INDICATE            - SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_STAT_REGRESSTYPE         - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_STAT_REGRESSTYPE         - SCHATTR_START];




	SetRefCount(*ppPoolDefaults[SCHATTR_STYLE_DEEP     - SCHATTR_START],0);
	SetRefCount(*ppPoolDefaults[SCHATTR_STYLE_3D       - SCHATTR_START],0);
	SetRefCount(*ppPoolDefaults[SCHATTR_STYLE_VERTICAL - SCHATTR_START],0);
	SetRefCount(*ppPoolDefaults[SCHATTR_STYLE_BASETYPE - SCHATTR_START],0);
	SetRefCount(*ppPoolDefaults[SCHATTR_STYLE_LINES    - SCHATTR_START],0);
	SetRefCount(*ppPoolDefaults[SCHATTR_STYLE_PERCENT  - SCHATTR_START],0);
	SetRefCount(*ppPoolDefaults[SCHATTR_STYLE_STACKED  - SCHATTR_START],0);
	SetRefCount(*ppPoolDefaults[SCHATTR_STYLE_SPLINES  - SCHATTR_START],0);
	SetRefCount(*ppPoolDefaults[SCHATTR_STYLE_SYMBOL   - SCHATTR_START],0);
	SetRefCount(*ppPoolDefaults[SCHATTR_STYLE_SHAPE    - SCHATTR_START],0);

	delete  ppPoolDefaults[SCHATTR_STYLE_DEEP     - SCHATTR_START];
	delete  ppPoolDefaults[SCHATTR_STYLE_3D       - SCHATTR_START];
	delete  ppPoolDefaults[SCHATTR_STYLE_VERTICAL - SCHATTR_START];
	delete  ppPoolDefaults[SCHATTR_STYLE_BASETYPE - SCHATTR_START];
	delete  ppPoolDefaults[SCHATTR_STYLE_LINES    - SCHATTR_START];
	delete  ppPoolDefaults[SCHATTR_STYLE_PERCENT  - SCHATTR_START];
	delete  ppPoolDefaults[SCHATTR_STYLE_STACKED  - SCHATTR_START];
	delete  ppPoolDefaults[SCHATTR_STYLE_SPLINES  - SCHATTR_START];
	delete  ppPoolDefaults[SCHATTR_STYLE_SYMBOL   - SCHATTR_START];
	delete  ppPoolDefaults[SCHATTR_STYLE_SHAPE    - SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_TEXT_DUMMY0 	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_TEXT_DUMMY0 	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_TEXT_DUMMY1  - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_TEXT_DUMMY1  - SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_TEXT_DUMMY2	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_TEXT_DUMMY2	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_TEXT_DUMMY3	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_TEXT_DUMMY3	- SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_AUTO_MIN		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_AUTO_MIN		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_MIN				- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_MIN				- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_AUTO_MAX		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_AUTO_MAX		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_MAX		  		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_MAX		  		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_AUTO_STEP_MAIN	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_AUTO_STEP_MAIN	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_STEP_MAIN		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_STEP_MAIN		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_AUTO_STEP_HELP	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_AUTO_STEP_HELP	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_STEP_HELP		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_STEP_HELP		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_LOGARITHM		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_LOGARITHM		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_AUTO_ORIGIN		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_AUTO_ORIGIN		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_ORIGIN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_ORIGIN			- SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS					- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS					- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_TICKS			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_TICKS			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_HELPTICKS		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_HELPTICKS		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_NUMFMT			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_NUMFMT			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_NUMFMTPERCENT	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_NUMFMTPERCENT	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_SHOWAXIS		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_SHOWAXIS		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_SHOWDESCR		- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_SHOWDESCR		- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_SHOWMAINGRID	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_SHOWMAINGRID	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_SHOWHELPGRID	- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_SHOWHELPGRID	- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_TOPDOWN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_TOPDOWN			- SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_DUMMY0			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_DUMMY0			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_DUMMY1			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_DUMMY1			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_DUMMY2			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_DUMMY2			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_AXIS_DUMMY3			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_AXIS_DUMMY3			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_BAR_OVERLAP			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_BAR_OVERLAP			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_BAR_GAPWIDTH			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_BAR_GAPWIDTH			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_SYMBOL_BRUSH			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_SYMBOL_BRUSH			- SCHATTR_START];


	SetRefCount(*ppPoolDefaults[SCHATTR_STOCK_UPDOWN			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_STOCK_UPDOWN			- SCHATTR_START];
	SetRefCount(*ppPoolDefaults[SCHATTR_STOCK_VOLUME			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_STOCK_VOLUME			- SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_SYMBOL_SIZE			- SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_SYMBOL_SIZE			- SCHATTR_START];

	SetRefCount(*ppPoolDefaults[SCHATTR_USER_DEFINED_ATTR    - SCHATTR_START], 0);
	delete  ppPoolDefaults[SCHATTR_USER_DEFINED_ATTR    - SCHATTR_START];

    // New items for New Chart
	SetRefCount(*ppPoolDefaults[SCHATTR_TEXTBREAK       - SCHATTR_START], 0);
	delete ppPoolDefaults[SCHATTR_TEXTBREAK             - SCHATTR_START];
    SetRefCount(*ppPoolDefaults[SCHATTR_DIAGRAM_STYLE   - SCHATTR_START], 0);
    delete ppPoolDefaults[SCHATTR_DIAGRAM_STYLE         - SCHATTR_START];
    SetRefCount(*ppPoolDefaults[SCHATTR_NUM_OF_LINES_FOR_BAR - SCHATTR_START], 0);
    delete ppPoolDefaults[SCHATTR_NUM_OF_LINES_FOR_BAR  - SCHATTR_START];
    SetRefCount(*ppPoolDefaults[SCHATTR_SPLINE_ORDER    - SCHATTR_START], 0);
    delete ppPoolDefaults[SCHATTR_SPLINE_ORDER          - SCHATTR_START];
    SetRefCount(*ppPoolDefaults[SCHATTR_SPLINE_RESOLUTION - SCHATTR_START], 0);
    delete ppPoolDefaults[SCHATTR_SPLINE_RESOLUTION     - SCHATTR_START];

	delete[] ppPoolDefaults;
}

SfxItemPool* SchItemPool::Clone() const
{
	return new SchItemPool(*this);
}

SfxMapUnit SchItemPool::GetMetric(USHORT nWhich) const
{
	return SFX_MAPUNIT_100TH_MM;
}

// static
SfxItemPool* SchItemPool::CreateSchItemPool()
{
    return new SchItemPool();
}

} //  namespace wrapper
} //  namespace chart
