/*************************************************************************
 *
 *  $RCSfile: SchSfxItemIds.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: bm $ $Date: 2003/10/06 09:58:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef SCHITEMS_HXX
#define SCHITEMS_HXX

#ifndef _SFXDEFS_HXX
#include <sfx2/sfxdefs.hxx>
#endif

// header for SID_OBJ1_START
#ifndef _SFXSIDS_HRC
#include <sfx2/sfxsids.hrc>
#endif

// Note: In the new chart all items are per definition non-persistent
// (Persistence in binary format is achieved by supporting the XML-Format via
// the old UNO-API and a binary filter component)

// ============================================================
// SCHATTR (persistent items)
// ============================================================

#define SCHATTR_START						1

#define SCHATTR_DATADESCR_START	   			SCHATTR_START
#define SCHATTR_DATADESCR_DESCR	   			SCHATTR_DATADESCR_START
#define SCHATTR_DATADESCR_SHOW_SYM 			(SCHATTR_DATADESCR_START + 1) //2
#define SCHATTR_DATADESCR_END	   			SCHATTR_DATADESCR_SHOW_SYM

#define SCHATTR_LEGEND_START	   			(SCHATTR_DATADESCR_END + 1)   //3
#define SCHATTR_LEGEND_POS		   			SCHATTR_LEGEND_START
#define SCHATTR_LEGEND_END		 			SCHATTR_LEGEND_POS

#define SCHATTR_TEXT_START					(SCHATTR_LEGEND_END + 1)      //4
// #define SCHATTR_TEXT_ORIENT					SCHATTR_TEXT_START
// name changed:
#define SCHATTR_TEXT_STACKED				SCHATTR_TEXT_START
#define SCHATTR_TEXT_ORDER					(SCHATTR_TEXT_START + 1)      //5
#define SCHATTR_TEXT_END					SCHATTR_TEXT_ORDER

#define SCHATTR_Y_AXIS_START				(SCHATTR_TEXT_END + 1)        //6
#define SCHATTR_Y_AXIS_AUTO_MIN				SCHATTR_Y_AXIS_START
#define SCHATTR_Y_AXIS_MIN					(SCHATTR_Y_AXIS_START + 1)	//7
#define SCHATTR_Y_AXIS_AUTO_MAX	  			(SCHATTR_Y_AXIS_START + 2)	//8
#define SCHATTR_Y_AXIS_MAX					(SCHATTR_Y_AXIS_START + 3)	//9
#define SCHATTR_Y_AXIS_AUTO_STEP_MAIN		(SCHATTR_Y_AXIS_START + 4)	//10
#define SCHATTR_Y_AXIS_STEP_MAIN			(SCHATTR_Y_AXIS_START + 5)	//11
#define SCHATTR_Y_AXIS_AUTO_STEP_HELP		(SCHATTR_Y_AXIS_START + 6)	//12
#define SCHATTR_Y_AXIS_STEP_HELP			(SCHATTR_Y_AXIS_START + 7)	//13
#define SCHATTR_Y_AXIS_LOGARITHM			(SCHATTR_Y_AXIS_START + 8)	//14
#define SCHATTR_Y_AXIS_AUTO_ORIGIN			(SCHATTR_Y_AXIS_START + 9)	//15
#define SCHATTR_Y_AXIS_ORIGIN				(SCHATTR_Y_AXIS_START + 10)	//16
#define SCHATTR_Y_AXIS_END					SCHATTR_Y_AXIS_ORIGIN

#define SCHATTR_X_AXIS_START				(SCHATTR_Y_AXIS_END + 1)	//17
#define SCHATTR_X_AXIS_AUTO_MIN				SCHATTR_X_AXIS_START		//17
#define SCHATTR_X_AXIS_MIN					(SCHATTR_X_AXIS_START + 1)	//18
#define SCHATTR_X_AXIS_AUTO_MAX	  			(SCHATTR_X_AXIS_START + 2)	//19
#define SCHATTR_X_AXIS_MAX					(SCHATTR_X_AXIS_START + 3)	//20
#define SCHATTR_X_AXIS_AUTO_STEP_MAIN		(SCHATTR_X_AXIS_START + 4)	//21
#define SCHATTR_X_AXIS_STEP_MAIN			(SCHATTR_X_AXIS_START + 5)	//22
#define SCHATTR_X_AXIS_AUTO_STEP_HELP		(SCHATTR_X_AXIS_START + 6)	//23
#define SCHATTR_X_AXIS_STEP_HELP			(SCHATTR_X_AXIS_START + 7)	//24
#define SCHATTR_X_AXIS_LOGARITHM			(SCHATTR_X_AXIS_START + 8)	//25
#define SCHATTR_X_AXIS_AUTO_ORIGIN			(SCHATTR_X_AXIS_START + 9)	//26
#define SCHATTR_X_AXIS_ORIGIN				(SCHATTR_X_AXIS_START + 10)	//27
#define SCHATTR_X_AXIS_END					SCHATTR_X_AXIS_ORIGIN

#define SCHATTR_Z_AXIS_START				(SCHATTR_X_AXIS_END + 1)    //28
#define SCHATTR_Z_AXIS_AUTO_MIN				SCHATTR_Z_AXIS_START		//28
#define SCHATTR_Z_AXIS_MIN					(SCHATTR_Z_AXIS_START + 1)	//29
#define SCHATTR_Z_AXIS_AUTO_MAX	  			(SCHATTR_Z_AXIS_START + 2)  //30
#define SCHATTR_Z_AXIS_MAX					(SCHATTR_Z_AXIS_START + 3)	//31
#define SCHATTR_Z_AXIS_AUTO_STEP_MAIN		(SCHATTR_Z_AXIS_START + 4)	//32
#define SCHATTR_Z_AXIS_STEP_MAIN			(SCHATTR_Z_AXIS_START + 5)	//33
#define SCHATTR_Z_AXIS_AUTO_STEP_HELP		(SCHATTR_Z_AXIS_START + 6)	//34
#define SCHATTR_Z_AXIS_STEP_HELP			(SCHATTR_Z_AXIS_START + 7)	//35
#define SCHATTR_Z_AXIS_LOGARITHM			(SCHATTR_Z_AXIS_START + 8)	//36
#define SCHATTR_Z_AXIS_AUTO_ORIGIN			(SCHATTR_Z_AXIS_START + 9)	//37
#define SCHATTR_Z_AXIS_ORIGIN				(SCHATTR_Z_AXIS_START + 10)	//38
#define SCHATTR_Z_AXIS_END					SCHATTR_Z_AXIS_ORIGIN

// miscellaneous

#define SCHATTR_AXISTYPE				    (SCHATTR_Z_AXIS_END + 1) //39
#define SCHATTR_DUMMY0  				    (SCHATTR_Z_AXIS_END + 2) //40
#define SCHATTR_DUMMY1  				    (SCHATTR_Z_AXIS_END + 3) //41
#define SCHATTR_DUMMY2  				    (SCHATTR_Z_AXIS_END + 4) //42
#define SCHATTR_DUMMY3  				    (SCHATTR_Z_AXIS_END + 5) //43
#define SCHATTR_DUMMY_END  				    (SCHATTR_Z_AXIS_END + 6) //44

#define SCHATTR_STAT_START                  (SCHATTR_DUMMY_END + 1)  //45
#define SCHATTR_STAT_AVERAGE                SCHATTR_STAT_START
#define SCHATTR_STAT_KIND_ERROR             (SCHATTR_STAT_START + 1) //46
#define SCHATTR_STAT_PERCENT                (SCHATTR_STAT_START + 2) //47
#define SCHATTR_STAT_BIGERROR               (SCHATTR_STAT_START + 3) //48
#define SCHATTR_STAT_CONSTPLUS              (SCHATTR_STAT_START + 4) //49
#define SCHATTR_STAT_CONSTMINUS             (SCHATTR_STAT_START + 5) //50
#define SCHATTR_STAT_REGRESSTYPE            (SCHATTR_STAT_START + 6) //51
#define SCHATTR_STAT_INDICATE               (SCHATTR_STAT_START + 7) //52
#define SCHATTR_STAT_END                    SCHATTR_STAT_INDICATE

#define SCHATTR_TEXT2_START                 ( SCHATTR_STAT_END + 1) //53
#define SCHATTR_TEXT_DEGREES                ( SCHATTR_TEXT2_START   )
#define SCHATTR_TEXT_OVERLAP                (SCHATTR_TEXT2_START +1) //54
#define SCHATTR_TEXT_DUMMY0				    (SCHATTR_TEXT2_START + 2)//55
#define SCHATTR_TEXT_DUMMY1				    (SCHATTR_TEXT2_START + 3)//56
#define SCHATTR_TEXT_DUMMY2				    (SCHATTR_TEXT2_START + 4)//57
#define SCHATTR_TEXT_DUMMY3				    (SCHATTR_TEXT2_START + 5)//58
#define SCHATTR_TEXT2_END                   ( SCHATTR_TEXT_DUMMY3 )

// --------------------------------------------------------
// these attributes are for replacement of enum eChartStyle
// --------------------------------------------------------

#define SCHATTR_STYLE_START             ( SCHATTR_TEXT2_END +1 )  //59

// for whole chart
#define SCHATTR_STYLE_DEEP              ( SCHATTR_STYLE_START     )//59
#define SCHATTR_STYLE_3D                ( SCHATTR_STYLE_START + 1 )//60
#define SCHATTR_STYLE_VERTICAL          ( SCHATTR_STYLE_START + 2 )//61

// also for series
#define SCHATTR_STYLE_BASETYPE          ( SCHATTR_STYLE_START + 3 )//62 Line,Area,...,Pie
#define SCHATTR_STYLE_LINES             ( SCHATTR_STYLE_START + 4 )//63 draw line
#define SCHATTR_STYLE_PERCENT           ( SCHATTR_STYLE_START + 5 )//64
#define SCHATTR_STYLE_STACKED           ( SCHATTR_STYLE_START + 6 )//65
#define SCHATTR_STYLE_SPLINES           ( SCHATTR_STYLE_START + 7 )//66

// also for data point
#define SCHATTR_STYLE_SYMBOL            ( SCHATTR_STYLE_START + 8 )//67
#define SCHATTR_STYLE_SHAPE				( SCHATTR_STYLE_START + 9 )//68
#define SCHATTR_STYLE_END               ( SCHATTR_STYLE_SHAPE )

// --------------------------------------------------------------------------

#define SCHATTR_AXIS					(SCHATTR_STYLE_END + 1)//69	see chtmodel.hxx defines CHART_AXIS_PRIMARY_X, etc.
//Ummappen:
#define SCHATTR_AXIS_START				(SCHATTR_AXIS + 1)     //70
#define SCHATTR_AXIS_AUTO_MIN			 SCHATTR_AXIS_START
#define SCHATTR_AXIS_MIN				(SCHATTR_AXIS_START + 1)//71
#define SCHATTR_AXIS_AUTO_MAX	  		(SCHATTR_AXIS_START + 2)//72
#define SCHATTR_AXIS_MAX				(SCHATTR_AXIS_START + 3)//73
#define SCHATTR_AXIS_AUTO_STEP_MAIN		(SCHATTR_AXIS_START + 4)//74
#define SCHATTR_AXIS_STEP_MAIN			(SCHATTR_AXIS_START + 5)//75
#define SCHATTR_AXIS_AUTO_STEP_HELP		(SCHATTR_AXIS_START + 6)//76
// SCHATTR_AXIS_STEP_HELP: type changed from double to sal_Int32 !
#define SCHATTR_AXIS_STEP_HELP			(SCHATTR_AXIS_START + 7)//77
#define SCHATTR_AXIS_LOGARITHM			(SCHATTR_AXIS_START + 8)//78
#define SCHATTR_AXIS_AUTO_ORIGIN		(SCHATTR_AXIS_START + 9)//79
#define SCHATTR_AXIS_ORIGIN				(SCHATTR_AXIS_START + 10)//80
//Neu:
#define SCHATTR_AXIS_TICKS				(SCHATTR_AXIS_START + 11)//81
#define SCHATTR_AXIS_NUMFMT				(SCHATTR_AXIS_START + 12)//82
#define SCHATTR_AXIS_NUMFMTPERCENT		(SCHATTR_AXIS_START + 13)//83
#define SCHATTR_AXIS_SHOWAXIS			(SCHATTR_AXIS_START + 14)//84
#define SCHATTR_AXIS_SHOWDESCR			(SCHATTR_AXIS_START + 15)//85
#define SCHATTR_AXIS_SHOWMAINGRID		(SCHATTR_AXIS_START + 16)//86
#define SCHATTR_AXIS_SHOWHELPGRID		(SCHATTR_AXIS_START + 17)//87
#define SCHATTR_AXIS_TOPDOWN			(SCHATTR_AXIS_START + 18)//88
#define SCHATTR_AXIS_HELPTICKS			(SCHATTR_AXIS_START + 19)//89

#define SCHATTR_AXIS_DUMMY0				(SCHATTR_AXIS_START + 20)//90
#define SCHATTR_AXIS_DUMMY1				(SCHATTR_AXIS_START + 21)//91
#define SCHATTR_AXIS_DUMMY2				(SCHATTR_AXIS_START + 22)//92
#define SCHATTR_AXIS_DUMMY3				(SCHATTR_AXIS_START + 23)//93
#define SCHATTR_BAR_OVERLAP				(SCHATTR_AXIS_START + 24)//94
#define SCHATTR_BAR_GAPWIDTH			(SCHATTR_AXIS_START + 25)//95
#define SCHATTR_AXIS_END				 SCHATTR_BAR_GAPWIDTH

#define SCHATTR_SYMBOL_BRUSH			(SCHATTR_AXIS_END + 1) //96
#define SCHATTR_STOCK_VOLUME			(SCHATTR_AXIS_END + 2) //97
#define SCHATTR_STOCK_UPDOWN			(SCHATTR_AXIS_END + 3) //98
#define SCHATTR_SYMBOL_SIZE				(SCHATTR_AXIS_END + 4) //99

// non persistent items (binary format)
#define SCHATTR_NONPERSISTENT_START     (SCHATTR_SYMBOL_SIZE + 1)    //100
#define SCHATTR_USER_DEFINED_ATTR        SCHATTR_NONPERSISTENT_START //100

// new from New Chart
#define SCHATTR_TEXTBREAK               (SCHATTR_NONPERSISTENT_START + 1) //101
#define SCHATTR_DIAGRAM_STYLE           (SCHATTR_NONPERSISTENT_START + 2) //102
#define SCHATTR_NUM_OF_LINES_FOR_BAR    (SCHATTR_NONPERSISTENT_START + 3) //103
#define SCHATTR_SPLINE_ORDER            (SCHATTR_NONPERSISTENT_START + 4) //104
#define SCHATTR_SPLINE_RESOLUTION       (SCHATTR_NONPERSISTENT_START + 5) //105

#define SCHATTR_NONPERSISTENT_END        SCHATTR_SPLINE_RESOLUTION

#define SCHATTR_END						 SCHATTR_NONPERSISTENT_END

// ============================================================
// CHATTR (non-persisten items, only for dialogs and UNO API)
// ============================================================


// SID_OBJ1_START == 30000 + 512

#define CHATTR_START					(SID_OBJ1_START + 150)			//	30662

// diagram attributes
#define CHATTR_DIAGRAM_START			CHATTR_START					//	30662

// is SCHATTR now
// #define CHATTR_DIAGRAM_STYLE			CHATTR_DIAGRAM_START

#define CHATTR_DIAGRAM_GAPWIDTH			(CHATTR_DIAGRAM_START + 1)
#define CHATTR_DIAGRAM_OVERLAP			(CHATTR_DIAGRAM_START + 2)
#define CHATTR_DIAGRAM_END				CHATTR_DIAGRAM_OVERLAP			//	30664

// title attributes
#define CHATTR_TITLE_START				(CHATTR_DIAGRAM_END + 1)		//	30665
#define CHATTR_TITLE_SHOW_MAIN			CHATTR_TITLE_START
#define CHATTR_TITLE_MAIN				(CHATTR_TITLE_START + 1)
#define CHATTR_TITLE_SHOW_SUB			(CHATTR_TITLE_START + 2)
#define CHATTR_TITLE_SUB				(CHATTR_TITLE_START + 3)
#define CHATTR_TITLE_SHOW_X_AXIS		(CHATTR_TITLE_START + 4)
#define CHATTR_TITLE_X_AXIS				(CHATTR_TITLE_START + 5)
#define CHATTR_TITLE_SHOW_Y_AXIS		(CHATTR_TITLE_START + 6)
#define CHATTR_TITLE_Y_AXIS				(CHATTR_TITLE_START + 7)
#define CHATTR_TITLE_SHOW_Z_AXIS		(CHATTR_TITLE_START + 8)
#define CHATTR_TITLE_Z_AXIS				(CHATTR_TITLE_START + 9)
#define CHATTR_TITLE_END				CHATTR_TITLE_Z_AXIS				//	30674

// axis and grid attributes
#define CHATTR_AXISGRID_START			(CHATTR_TITLE_END + 1)			//	30675
#define CHATTR_AXISGRID_SHOW_X_AXIS		CHATTR_AXISGRID_START
#define CHATTR_AXISGRID_SHOW_X_MAIN		(CHATTR_AXISGRID_START + 1)
#define CHATTR_AXISGRID_SHOW_X_HELP		(CHATTR_AXISGRID_START + 2)
#define CHATTR_AXISGRID_SHOW_X_DESCR	(CHATTR_AXISGRID_START + 3)
#define CHATTR_AXISGRID_SHOW_Y_AXIS		(CHATTR_AXISGRID_START + 4)
#define CHATTR_AXISGRID_SHOW_Y_MAIN		(CHATTR_AXISGRID_START + 5)
#define CHATTR_AXISGRID_SHOW_Y_HELP		(CHATTR_AXISGRID_START + 6)
#define CHATTR_AXISGRID_SHOW_Y_DESCR	(CHATTR_AXISGRID_START + 7)
#define CHATTR_AXISGRID_SHOW_Z_AXIS		(CHATTR_AXISGRID_START + 8)
#define CHATTR_AXISGRID_SHOW_Z_MAIN		(CHATTR_AXISGRID_START + 9)
#define CHATTR_AXISGRID_SHOW_Z_HELP		(CHATTR_AXISGRID_START + 10)
#define CHATTR_AXISGRID_SHOW_Z_DESCR	(CHATTR_AXISGRID_START + 11)
#define CHATTR_AXIS_AUTO_ORIGIN			(CHATTR_AXISGRID_START + 12)
#define CHATTR_AXISGRID_END				CHATTR_AXIS_AUTO_ORIGIN			//	30687

// legend attributes
#define CHATTR_LEGEND_START				(CHATTR_AXISGRID_END + 1)		//	30688
#define CHATTR_LEGEND_POS				CHATTR_LEGEND_START
#define CHATTR_LEGEND_END				CHATTR_LEGEND_POS				//	30688

// data attributes
#define CHATTR_DATA_START				(CHATTR_LEGEND_END + 1)			//	30689
#define CHATTR_DATA_SWITCH				CHATTR_DATA_START
#define CHATTR_DATA_END					CHATTR_DATA_SWITCH				//	30689

#define CHATTR_AXISGRID_SHOW_2Y_AXIS	(CHATTR_DATA_END + 1)			//	30690
#define CHATTR_AXISGRID_SHOW_2Y_DESCR	(CHATTR_DATA_END + 2)
#define CHATTR_AXISGRID_SHOW_2X_AXIS	(CHATTR_DATA_END + 3)
#define CHATTR_AXISGRID_SHOW_2X_DESCR	(CHATTR_DATA_END + 4)			//	30693

#define CHATTR_STYLE_SHAPE				(CHATTR_DATA_END + 5)			// #67610#

#define CHATTR_DEFCOLORS				(CHATTR_DATA_END + 6)			// ListItem of default colors

#define CHATTR_REGRESSION_PROPS			(CHATTR_DATA_END + 7)			// #70231#
#define CHATTR_ERROR_PROPS				(CHATTR_DATA_END + 8)
#define CHATTR_AVERAGE_PROPS			(CHATTR_DATA_END + 9)

// is SCHATTR now
// #define CHATTR_NUM_OF_LINES_FOR_BAR		(CHATTR_DATA_END + 10)

#define CHATTR_PIE_SEGMENT_OFFSET		(CHATTR_DATA_END + 11)

#define CHATTR_ADDR_CATEGORIES			(CHATTR_DATA_END + 12)
#define CHATTR_ADDR_SERIES				(CHATTR_DATA_END + 13)
#define CHATTR_ADDR_MAIN_TITLE			(CHATTR_DATA_END + 14)
#define CHATTR_ADDR_SUB_TITLE			(CHATTR_DATA_END + 15)
#define CHATTR_ADDR_CHART               (CHATTR_DATA_END + 16)
#define CHATTR_TABLE_NUMBER_LIST        (CHATTR_DATA_END + 17)
#define CHATTR_EXPORT_TABLE             (CHATTR_DATA_END + 18)
#define CHATTR_FIRST_COL_LABELS         (CHATTR_DATA_END + 19)
#define CHATTR_FIRST_ROW_LABELS         (CHATTR_DATA_END + 20)			//	30709

// are SCHATTRs now
// #define CHATTR_SPLINE_ORDER             (CHATTR_DATA_END + 21)			//	30710
// #define CHATTR_SPLINE_RESOLUTION        (CHATTR_DATA_END + 22)			//	30711

#define CHATTR_ADDITIONAL_SHAPES        (CHATTR_DATA_END + 23)			//	30712

#define CHATTR_HAS_TRANSLATED_COLS      (CHATTR_DATA_END + 24)			//	30713
#define CHATTR_HAS_TRANSLATED_ROWS      (CHATTR_DATA_END + 25)			//	30714
#define CHATTR_TRANSLATED_COLS          (CHATTR_DATA_END + 26)			//	30715
#define CHATTR_TRANSLATED_ROWS          (CHATTR_DATA_END + 27)			//	30716

#define CHATTR_ATTRIBUTED_DATA_POINTS   (CHATTR_DATA_END + 28)          //  30717

#define CHATTR_END						CHATTR_ATTRIBUTED_DATA_POINTS   //  30717


#define CHATTR_TMP_START				CHATTR_DATA_END + 30			//	30719

#define CHATTR_BARWIDTH					CHATTR_TMP_START
#define CHATTR_BARCONNECT				CHATTR_TMP_START+1

#define CHATTR_TMP_END					CHATTR_BARCONNECT				//	30720

// ============================================================
// values for Items
// ============================================================

// /====
// copied from "sch/inc/chaxis.hxx"
// values for SCHATTR_AXIS_TICKS and SCHATTR_AXIS_HELPTICKS items
#define CHAXIS_MARK_BOTH   3
#define CHAXIS_MARK_OUTER  2
#define CHAXIS_MARK_INNER  1
#define CHAXIS_MARK_NONE   0
#define CHAXIS_MARK_ASMAIN 4
// \====

// /====
// copied from "sch/inc/defines.hxx"
// values for SCHATTR_AXISTYPE items
#define CHART_AXIS_X    0
#define CHART_AXIS_Y    1
#define CHART_AXIS_Z    2
// \====

// /====
// copied from "sch/inc/chmod3D.hxx"
// values for SCHATTR_STYLE_SHAPE items
#define CHART_SHAPE3D_IGNORE  -2 //intern! (GetChartShapeStyle()!)
#define CHART_SHAPE3D_ANY	  -1 //undefinierter Typ (GetChartShapeStyle()!)
#define CHART_SHAPE3D_SQUARE   0
#define CHART_SHAPE3D_CYLINDER 1
#define CHART_SHAPE3D_CONE     2
#define CHART_SHAPE3D_PYRAMID  3 //reserved
#define CHART_SHAPE3D_HANOI	   4
// \====

// /====
// copied from "sch/inc/chtmodel.hxx"
// values for SCHATTR_AXIS items
#define CHART_AXIS_PRIMARY_X	1	// never change these defines (persistent) !!!
#define CHART_AXIS_PRIMARY_Y	2
#define CHART_AXIS_PRIMARY_Z	3
#define CHART_AXIS_SECONDARY_Y	4
#define CHART_AXIS_SECONDARY_X	5
// \====

// ============================================================
// ============================================================

#endif

