/*************************************************************************
 *
 *  $RCSfile: dlg_RotateDiagram.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2004/08/20 08:45:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2003 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "dlg_RotateDiagram.hxx"
#include "dlg_RotateDiagram.hrc"

#include "ResId.hxx"

#ifndef INCLUDED_RTL_MATH_HXX
#include <rtl/math.hxx>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

RotateDiagramDialog::RotateDiagramDialog( Window* pWindow, double fXAngleDegree,
                                         double fYAngleDegree, double fZAngleDegree ) :
				ModalDialog 	( pWindow, SchResId( DLG_3D_VIEW ) ),
				aFtXAxis		( this, ResId( FT_X_AXIS ) ),
				aMtrFldXAxis	( this, ResId( MTR_FLD_X_AXIS ) ),
				aFtYAxis		( this, ResId( FT_Y_AXIS ) ),
				aMtrFldYAxis	( this, ResId( MTR_FLD_Y_AXIS ) ),
				aFtZAxis		( this, ResId( FT_Z_AXIS ) ),
				aMtrFldZAxis	( this, ResId( MTR_FLD_Z_AXIS ) ),
				aFlAxis			( this, ResId( FL_AXIS ) ),
				aBtnOK			( this, ResId( BTN_OK ) ),
				aBtnCancel		( this, ResId( BTN_CANCEL ) ),
				aBtnHelp		( this, ResId( BTN_HELP ) )
{
	FreeResource();

	aMtrFldXAxis.SetValue(static_cast<long>(fXAngleDegree*pow(10.0,aMtrFldXAxis.GetDecimalDigits())));
	aMtrFldYAxis.SetValue(static_cast<long>(-1*fYAngleDegree*pow(10.0,aMtrFldYAxis.GetDecimalDigits())));
	aMtrFldZAxis.SetValue(static_cast<long>(fZAngleDegree*pow(10.0,aMtrFldZAxis.GetDecimalDigits())));
}

RotateDiagramDialog::~RotateDiagramDialog()
{
}

void RotateDiagramDialog::getAngle( double& fXAngleDegree, double& fYAngleDegree, double& fZAngleDegree )
{
    fXAngleDegree = double(aMtrFldXAxis.GetValue())/double(pow(10.0,aMtrFldXAxis.GetDecimalDigits()));
    fYAngleDegree = double(-1*aMtrFldYAxis.GetValue())/double(pow(10.0,aMtrFldYAxis.GetDecimalDigits()));
    fZAngleDegree = double(aMtrFldZAxis.GetValue())/double(pow(10.0,aMtrFldZAxis.GetDecimalDigits()));
}

//.............................................................................
} //namespace chart
//.............................................................................
