/*************************************************************************
 *
 *  $RCSfile: dx_surfacemanager.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2004/11/26 17:25:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <canvas/debug.hxx>
#include <canvas/verbosetrace.hxx>

#include <dx_surfacemanager.hxx>
#include <dx_impltools.hxx>

#include <canvas/canvastools.hxx>

#ifndef INCLUDED_RTL_INSTANCE_HXX
#include <rtl/instance.hxx>
#endif
#ifndef INCLUDED_OSL_GETGLOBALMUTEX_HXX
#include <osl/getglobalmutex.hxx>
#endif


namespace dxcanvas
{
	/* Singleton handling */
    struct InitInstance
    {
        SurfaceManager* operator()()
        {
            return new SurfaceManager();
        }
    };

    SurfaceManager& SurfaceManager::getInstance()
    {
        return *rtl_Instance< SurfaceManager, InitInstance, ::osl::MutexGuard,
            ::osl::GetGlobalMutex >::create(
                InitInstance(), ::osl::GetGlobalMutex());
    }


    SurfaceManager::SurfaceManager()
    {
    }

    SurfaceManager::~SurfaceManager()
    {
    }

    PlainSurfaceSharedPtr SurfaceManager::createSurface( const ::basegfx::B2ISize& 	rSize, 
                                                         double 					priority, 
                                                         const DeviceSharedPtr& 	rDevice )
    {
        CHECK_AND_THROW(rSize.getX() > 0 && rSize.getY() > 0, 
                        "SurfaceManager::createSurface(): request for zero-sized surface");

        DDSURFACEDESC 		aSurfaceDesc;
        IDirectDrawSurface* pSurface;

        aSurfaceDesc.dwSize = sizeof(DDSURFACEDESC);
        aSurfaceDesc.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
        aSurfaceDesc.dwHeight= rSize.getY();
        aSurfaceDesc.dwWidth = rSize.getX();

        // TODO(P1): handle priority here
        aSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_VIDEOMEMORY | DDSCAPS_LOCALVIDMEM;
 
        HRESULT nRes = rDevice->mpDirectDraw->CreateSurface(&aSurfaceDesc, &pSurface, NULL);
        if( FAILED(nRes) )
        {
            if( nRes == DDERR_OUTOFVIDEOMEMORY )
            {
                // try AGP mem next
                aSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_VIDEOMEMORY | DDSCAPS_NONLOCALVIDMEM;
                if( FAILED(rDevice->mpDirectDraw->CreateSurface(&aSurfaceDesc, &pSurface, NULL)) )
                {
                    VERBOSE_TRACE( "SurfaceManager::createSurface(): out of vid mem for %d times %d surface", 
                                   rSize.getX(), rSize.getY() );

					// no chance on GPU-accessible mem. Fail and let
					// GdiPlus handle this
                    return PlainSurfaceSharedPtr(); 
                }

                VERBOSE_TRACE( "SurfaceManager::createSurface(): reverting to non-local vid mem for %d times %d surface", 
                               rSize.getX(), rSize.getY() );
            }
            else
            {
                return PlainSurfaceSharedPtr();
            }
        }

        // TODO(F1): Check whether palette needs any setup here (might have to copy palette from primary surface)
        return PlainSurfaceSharedPtr( new PlainSurface( COMReference<IDirectDrawSurface>(pSurface), rSize ) );
    }

    TextureSharedPtr SurfaceManager::implCreateTexture( const ::basegfx::B2ISize& 	rSize, 
                                                        const ::basegfx::B2ISize& 	rOrigSize, 
                                                        double 						priority, 
                                                        const DeviceSharedPtr& 		rDevice )
    {
        CHECK_AND_THROW(rSize.getX() > 0 && rSize.getY() > 0, 
                        "SurfaceManager::createTexture(): request for zero-sized surface");

        DDSURFACEDESC 		aSurfaceDesc;
        IDirectDrawSurface* pTexture;

        aSurfaceDesc.dwSize = sizeof(DDSURFACEDESC);
        aSurfaceDesc.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_PIXELFORMAT;
        aSurfaceDesc.dwHeight= ::canvas::tools::nextPow2( rSize.getY() );
        aSurfaceDesc.dwWidth = ::canvas::tools::nextPow2( rSize.getX() );
        rtl_copyMemory( &aSurfaceDesc.ddpfPixelFormat, &rDevice->maTextureFormat, sizeof(DDPIXELFORMAT) );
        aSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_TEXTURE | DDSCAPS_VIDEOMEMORY | DDSCAPS_LOCALVIDMEM;

        HRESULT nRes = rDevice->mpDirectDraw->CreateSurface(&aSurfaceDesc, &pTexture, NULL);
        if( FAILED(nRes) )
        {
            if( nRes == DDERR_OUTOFVIDEOMEMORY )
            {
                aSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_TEXTURE | DDSCAPS_VIDEOMEMORY | DDSCAPS_NONLOCALVIDMEM;
                
                if( FAILED(rDevice->mpDirectDraw->CreateSurface(&aSurfaceDesc, &pTexture, NULL)) )
                {
                    VERBOSE_TRACE( "SurfaceManager::createTexture(): out of vid mem for %d times %d texture",
                                   aSurfaceDesc.dwWidth, aSurfaceDesc.dwHeight );

                    if( aSurfaceDesc.dwWidth > 4 && aSurfaceDesc.dwWidth > 1 &&
                        (aSurfaceDesc.dwWidth > 32 || aSurfaceDesc.dwWidth > 32) )
                    {
                        // recurse, and try again with half the texture size
                        return implCreateTexture( ::basegfx::B2ISize(aSurfaceDesc.dwWidth >> 1U,
                                                                     aSurfaceDesc.dwHeight >> 1U), 
                                                  rOrigSize,
                                                  priority, rDevice );
                    }
                    else
                    {
                        // no chance on GPU-accessible mem. Fail and let
                        // GdiPlus handle this
                        return TextureSharedPtr();
                    }
                }

                VERBOSE_TRACE( "SurfaceManager::createTexture(): reverting to non-local vid mem for %d times %d texture", 
                               aSurfaceDesc.dwWidth, aSurfaceDesc.dwHeight );
            }
            else
            {
                return TextureSharedPtr();
            }
        }

        IDirect3DTexture2* pTexture2;
        if( FAILED(pTexture->QueryInterface(IID_IDirect3DTexture2, (LPVOID *)&pTexture2)) )
        {
            pTexture->Release();
            return TextureSharedPtr();
        }

        // TODO(F1): Check whether palette needs any setup here (might have to copy palette from primary surface)
        // TODO(F1): Setup shared textures
        return TextureSharedPtr( 
            new Texture( 
                COMReference<IDirectDrawSurface>(pTexture), 
                COMReference<IDirect3DTexture2>(pTexture2), 
                ::basegfx::B2IRectangle( 0,0,rSize.getX(),rSize.getY() ), 
                ::basegfx::B2ISize(aSurfaceDesc.dwWidth, aSurfaceDesc.dwHeight),
                rOrigSize,
                false ) );
    }

    TextureSharedPtr SurfaceManager::createTexture( const ::basegfx::B2ISize& 	rSize, 
                                                    double 						priority, 
                                                    const DeviceSharedPtr& 		rDevice )
    {
        return implCreateTexture(rSize, rSize, priority, rDevice);
    }

}
