/*************************************************************************
 *
 *  $RCSfile: moptions.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kz $ $Date: 2004/07/23 12:07:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <ide_pch.hxx>

#pragma hdrstop

#ifndef _SBXCLASS_HXX //autogen
#include <svtools/sbx.hxx>
#endif
#include <moptions.hxx>
#include <moptions.hrc>
#include <iderid.hxx>
#include <basobj.hxx>

MacroOptionsDialog::MacroOptionsDialog( Window* pParent, SbxVariable* pV )
	: ModalDialog( pParent, 	IDEResId(RID_MACROOPTIONS ) ),
		aSbxName( this, 		IDEResId( RID_FT_SBXNAME ) ),
		aOKButton( this, 		IDEResId( RID_PB_OK ) ),
		aCancelButton( this, 	IDEResId( RID_PB_CANCEL ) ),
		aHelpButton( this, 		IDEResId( RID_PB_HELP ) ),
        aFixedLine( this, 		IDEResId( RID_FL_HELP ) ),
        aDescription( this, 	IDEResId( RID_ME_DESCR ) ),
		aDescrText( this, 		IDEResId( RID_FT_DESCR ) ),
		aHelpIdText( this, 		IDEResId( RID_FT_HELPID ) ),
		aHelpFileText( this, 	IDEResId( RID_FT_HELPNAME ) ),
		aHelpId( this, 			IDEResId( RID_NF_HELPID ) ),
		aHelpFile( this, 		IDEResId( RID_ED_HELPNAME ) )
{
	FreeResource();

	Font aFont( aSbxName.GetFont() );
	aFont.SetWeight( WEIGHT_BOLD );
	aSbxName.SetFont( aFont );

	pVariable = pV;
	aSbxName.SetText( pVariable->GetName() );
	SbxInfoRef xInfo = pVariable->GetInfo();
	if ( xInfo.Is() )
	{
		aDescription.SetText( xInfo->GetComment() );
		aHelpFile.SetText( xInfo->GetHelpFile() );
		aHelpId.SetValue( xInfo->GetHelpId() );
	}

	aOKButton.SetClickHdl( LINK( this, MacroOptionsDialog, ButtonHdl ) );
	aCancelButton.SetClickHdl( LINK( this, MacroOptionsDialog, ButtonHdl ) );
//	aHelpButton.SetClickHdl( LINK( this, MacroOptionsDialog, ButtonHdl ) );
}



IMPL_LINK( MacroOptionsDialog, ButtonHdl, Button *, pButton )
{
	if ( pButton == &aOKButton )
		EndDialog( TRUE );
	else if ( pButton == &aCancelButton )
		EndDialog( FALSE );

    return 0;
}



short __EXPORT MacroOptionsDialog::Execute()
{
	aDescription.GrabFocus();
	return ModalDialog::Execute();
}



