/*************************************************************************
 *
 *  $RCSfile: FullBtreeDict.java,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/01/27 10:08:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

/*
import java.io.*;		// debugging in main
import java.util.*;		// debugging in main
*/

public class FullBtreeDict extends BtreeDict {
    protected BtreeDictParameters _params;
    private boolean update = false;
  
    private final class Entry {
	public byte[] key;
	public int    id;
	public int    block = -1;
  
	public Entry(byte[] key, int length, int id) {
	    this.key = new byte[length + 1];
	    System.arraycopy(key, 0, this.key, 0, length);
	    this.key[length] = 0;
	    this.id = id;
	}
  
	public boolean smallerThan(Entry other) {
	    for (int i = 0; i < Math.min(key.length, other.key.length); i++)
		if (key[i] != other.key[i])
		    return (key[i]&0xFF) < (other.key[i]&0xFF);
	    return false;
	}
    } // end of internal class Entry
  
    private void setBlockNumber2(int index, int number) {
	if (index >= blocks.length) {
	    int[] newBlocks = new int[index + 1000];
	    System.arraycopy(blocks, 0, newBlocks, 0, blocks.length);
	    blocks = newBlocks;
	}
	blocks[index] = number;
    }

    protected class FullDictBlock extends DictBlock {
	public void setFree(int free) {
	    _free = free - firstEntry();
	    _data[free] = _data[free + 1] = 0; // sentinel
	}
  
	public final void setNumberOfEntries(int n) {
	    setIntegerAt(0, n);
	}

	protected final void setChildIndex(int index, int value) {
	    setIntegerAt(4*(lastPtrIndex - index + 1), value);
	}
  
	public final void setEntryID(int i, int id) {
	    setIntegerAt(i + 2, id);
	}
    
	protected final void setBlockNumbers(int[] blocks) {
	    for (int e = firstEntry(); e < _free; e = nextEntry(e))
		setBlockNumber2(entryID(e), _number);
	}
  
	// finds the place and context
	/*BROKEN GCJ private*/ public final boolean insert(Entry entry) {
	    byte[] inkey = entry.key;
	    final int inputKeyLen = inkey.length - 1;
	    final int freeSpace   = free();
	    int entryPtr    = firstEntry();
	    int nCharsEqual = 0;
	    int prevNCEqual = 0;
	    int compression = 0;

	    for (int entryIndex = 0;;) {
		if (entryPtr == freeSpace)
		    return insert(entry, entryPtr, nCharsEqual, 0, numberOfEntries());
		else if (compression == nCharsEqual) {
		    int keyLen = entryKeyLength(entryPtr);
		    int keyPtr = entryKey(entryPtr), i;
		    prevNCEqual = nCharsEqual;
		    for (i = 0;
			 i < keyLen && inkey[nCharsEqual] == _data[keyPtr + i];
			 i++)
			++nCharsEqual;
		    if (i == keyLen) {
			if (nCharsEqual == inputKeyLen) {
			    System.err.println("setting to " + entry.id);
			    setEntryID(entryPtr, entry.id);
			    return true;
			}
		    }
		    else if ((inkey[nCharsEqual]&0xFF) < (_data[keyPtr + i]&0xFF))
			return insert(entry, entryPtr, prevNCEqual, nCharsEqual,
				      entryIndex);
		}
		else if (compression < nCharsEqual) // compression dropped
		    return insert(entry, entryPtr, nCharsEqual, compression,
				  entryPtr == freeSpace
				  ? numberOfEntries() : entryIndex);
		do {
		    entryPtr = nextEntry(entryPtr);
		    ++entryIndex;
		}
		while (entryCompression(entryPtr) > nCharsEqual);
		compression = entryCompression(entryPtr);
	    }
	}
    
	public final void makeEntry(int entry, byte[] key, int id, int length, int compr) {
	    _data[entry]     = (byte) length;
	    _data[entry + 1] = (byte) compr;
	    setEntryID(entry, id);
	    System.arraycopy(key, compr, _data, entryKey(entry), length);
	}

	private final boolean insert(Entry ent, final int entryPtr,
				     final int compr1, final int compr2,
				     final int index) {
	    final byte[] key = ent.key;
	    final int keyLen = key.length - 1 - compr1;
	    final int freeSpace = free();
	    // calculate how much space is needed to add the new entry
	    // first, how many bytes are needed for just the new entry
	    final int demand = ENTHEADERLEN + keyLen;
	    // adding an entry can increase compression in the following entry
      
	    int increase = 0;
	    if (entryPtr < freeSpace)
		if (entryCompression(entryPtr) < compr2)
		    increase = compr2 - entryCompression(entryPtr);
	    /*
	      System.err.println("key " + key);
	      System.err.println("entryPtr " + entryPtr);
	      System.err.println("compr1 " + compr1);
	      System.err.println("compr2 " + compr2);
	      System.err.println("index " + index);
	      System.err.println("demand " + demand);
	      System.err.println("increase " + increase);
	    */
	    // check if enough space is available
	    int limit = _isLeaf ? DATALEN-2 : 4*(lastPtrIndex-numberOfEntries()-1);
    
	    if (freeSpace + demand - increase <= limit) { // 2 for sentinel
		if (entryPtr < freeSpace) {
		    // need to shift extant entries forward
		    final int toMove = increase > 0
			? entryPtr + ENTHEADERLEN + increase
			: entryPtr;
		    // move entries
		    System.arraycopy(_data, toMove,
				     _data, toMove + demand - increase,
				     freeSpace - toMove);
		    if (increase > 0) {
			// update header
			_data[entryPtr]     -= increase;
			_data[entryPtr + 1] += increase;
			// shift header
			System.arraycopy(_data, entryPtr,
					 _data, entryPtr + demand, ENTHEADERLEN);
		    }
		}
		// now write the new entry in the space made above
		makeEntry(entryPtr, key, ent.id, keyLen, compr1);
		if (_isLeaf == false) {
		    int from = 4*(lastPtrIndex - numberOfEntries() + 1);
		    System.arraycopy(_data, from, _data, from - 4,
				     4*(numberOfEntries() - index));
		    setChildIndex(index + 1, ent.block);
		}
		setFree(freeSpace + demand - increase);
		setNumberOfEntries(numberOfEntries() + 1);
	  

		/*
		  System.err.println("------------list--------------");
		  byte[] buffer = new byte[MaxKeyLength];
		  final int freeSpace2 = free();
		  int entryPtr2 = firstEntry();
		  while (entryPtr2 < freeSpace2)
		  {
		  System.err.println(entryPtr2);
		  System.err.println(entryKeyLength(entryPtr2));
		  System.err.println(entryCompression(entryPtr2));
		  System.err.println(new String(_data,
		  entryKey(entryPtr2),
		  entryKeyLength(entryPtr2)));
		  System.err.println(restoreKey(entryPtr2, buffer)+" "+
		  entryID(entryPtr2));
		  entryPtr2 = nextEntry(entryPtr2);
		  }
		  System.err.println("------------end--------------");
		*/

	  
		return true;
	    }
	    else
		return false;
	}
  
	public final int insertInternal(Entry entry) {
	    byte[] inkey    = entry.key;
	    final int inputKeyLen = inkey.length - 1;
	    int entryPtr    = firstEntry();
	    final int freeSpace   = free();
	    int nCharsEqual = 0;
	    int compression = 0;

	    for (int entryIndex = 0;;) {
		if (entryPtr == freeSpace)
		    return numberOfEntries();
		else if (compression == nCharsEqual) {
		    int i;
		    int keyLen = entryKeyLength(entryPtr);
		    int keyPtr = entryKey(entryPtr);
		    for (i = 0;
			 i < keyLen && inkey[nCharsEqual] == _data[keyPtr + i];
			 i++)
			++nCharsEqual;
		    if (i == keyLen) {
			if (nCharsEqual == inputKeyLen) {
			    setEntryID(entryPtr, entry.id);
			    return -1;
			}
		    }
		    else if ((inkey[nCharsEqual]&0xFF) < (_data[keyPtr + i]&0xFF))
			return entryIndex;
		}
		else if (compression < nCharsEqual) // compression dropped
		    return entryPtr >= freeSpace ? numberOfEntries() : entryIndex;
    
		do {
		    entryPtr = nextEntry(entryPtr);
		    ++entryIndex;
		}
		while (entryCompression(entryPtr) > nCharsEqual);
		compression = entryCompression(entryPtr);
	    }
	}
  
	/*BROKEN GCJ private*/ public final Entry split(FullDictBlock newbl) {
	    byte[] buffer = new byte[MaxKeyLength];
	    int freeSpace = free();
	    int half      = freeSpace/2;
	    int index     = 0;		// of middle entry
	    newbl._isLeaf = _isLeaf;
	    int ent;
	    for (ent = firstEntry(); ent < half; ent = nextEntry(ent)) {
		restoreKeyInBuffer(ent, buffer);
		++index;
	    }
	    final int entriesToMove = numberOfEntries() - index - 1;
	    // middle entry
	    restoreKeyInBuffer(ent, buffer);
	    int len = entryKeyLength(ent) + entryCompression(ent);
	    Entry result = new Entry(buffer, len, entryID(ent));
	    result.block = newbl._number;
	    int newFree = ent;
	    // rest goes to the new block
	    ent = nextEntry(ent);
	    restoreKeyInBuffer(ent, buffer);
	    len = entryKeyLength(ent) + entryCompression(ent);
	    int nptr = firstEntry();
	    newbl.makeEntry(nptr, buffer, entryID(ent), len, 0);
	    ent = nextEntry(ent);
	    System.arraycopy(_data, ent,
			     newbl._data, newbl.nextEntry(nptr), freeSpace - ent);
	    newbl.setNumberOfEntries(entriesToMove);
	    newbl.setFree(newbl.nextEntry(nptr) + freeSpace - ent);
	    if (_isLeaf == false) {	// need to split pointers
		int from = 4*(lastPtrIndex - numberOfEntries() + 1);
		System.arraycopy(_data, from,
				 newbl._data, from + 4*(index + 1),
				 4*(entriesToMove + 1));
	    }
	    // this entry will end here
	    setFree(newFree);
	    setNumberOfEntries(index);
	    return result;
	    //!!!remember updating ID -> string association
	}
  
	public final void initInternal(int leftBlock, Entry entry) {
	    _isLeaf = false;
	    setNumberOfEntries(1);
	    setChildIndex(0, leftBlock);
	    setChildIndex(1, entry.block);
	    final int ent = firstEntry();
	    makeEntry(ent, entry.key, entry.id, entry.key.length - 1, 0);
	    setFree(nextEntry(ent));
	}
    }
    // end of internal class

    protected  FullBtreeDict() {/*empty*/}

    /*
    // !!! testing
    boolean logging = false;
    FileWriter log = null;
    */

    public FullBtreeDict(BtreeDictParameters params, boolean update)
	throws Exception {
	_params = params;
	this.update = update;
	init(params, update, new BlockFactory() {
		public Block makeBlock() {
		    return new FullDictBlock();
		}
	    });
	//      System.out.println("id is " + params.getFreeID());
	blocks = new int[params.getFreeID()];
	blockManager.mapBlocks(new BlockProcessor() {
		public void process(Block block) {
		    ((FullDictBlock)block).setBlockNumbers(blocks);
		}
	    });
	/*
	if (logging)
	    log = new FileWriter("/tmp/FullBtreeDict.log");
	*/
    }

    public void close(int freeID) throws Exception {
	_params.setFreeID(freeID);
	if (update)
	    _params.updateSchema();
	super.close();
	/*
	if (logging)
	    log.close();
	*/
    }

    public void store(String key, int id) throws Exception {
        // System.err.println("storing "+key+" id "+id);
	/*
	if (logging)
	    log.write(key + " " + id + "\n");
	*/
    final byte[] bytes = key.getBytes("UTF8");
	if (bytes.length >= 250)
	    throw new Exception("token " + key + " too long");
	Entry entry = insert((FullDictBlock)accessBlock(root),
			     new Entry(bytes, bytes.length, id));
	if (entry != null) {
	    // new root; writing to params needed
	    FullDictBlock nbl = getNewBlock();
	    nbl.initInternal(root, entry);
	    setBlockNumber2(entry.id, root = nbl._number);
	    _params.setRoot(root);
	}
    }
  
    private void setModified(Block bl) {
	blockManager.setModified(bl._number);
    }
  
    private FullDictBlock getNewBlock() throws Exception {
	FullDictBlock nbl = (FullDictBlock)blockManager.getNewBlock();
	setModified(nbl);
	return nbl;
    }

    /*
      delegation to powerful primitives at the FullDictBlock level lets us
      express the insertion algorithm very succintly here
    */

    private Entry insert(FullDictBlock bl, Entry ent) throws Exception {
	if (bl._isLeaf)
	    return insertHere(bl, ent);
	else {
	    int index = bl.insertInternal(ent);
	    if (index != -1)
		try {
		    lock(bl);
		    ent = insert((FullDictBlock)child(bl, index), ent);
		    return ent == null ? null : insertHere(bl, ent);
		}
		finally {
		    unlock(bl);
		}
	    else
		return null;
	}
    }

    private Entry insertHere(FullDictBlock bl, Entry ent) throws Exception {
	setModified(bl);		// to be modified in any case 
	if (bl.insert(ent))
	    return null;
	else {
	    FullDictBlock nbl = getNewBlock();
	    Entry middle = bl.split(nbl);
	    nbl.setBlockNumbers(blocks);
	    if ((middle.smallerThan(ent) ? nbl : bl).insert(ent) == false)
		throw new Exception("entry didn't fit into a freshly split block");
	    return middle;
	}
    }
  
    /*
      public static void main(String[] args) {
      try {
      Schema schema = new Schema(args[0], true);
      BtreeDictParameters tmapParams = new BtreeDictParameters(schema, "DICTIONARY");
      if (tmapParams.readState() == false)
      {
      tmapParams.setBlockSize(2048);
      tmapParams.setRoot(0);
      tmapParams.setFreeID(1);
      }
      FullBtreeDict dict = new FullBtreeDict(tmapParams, true);
      int freeID = tmapParams.getFreeID();
    
      LineNumberReader in = new LineNumberReader(new BufferedReader
      (new FileReader(args[1])));
      String line;
      while ((line = in.readLine()) != null)
      {
      StringTokenizer tokens = new StringTokenizer(line, " ");
      while (tokens.hasMoreTokens())
      {
      String token = tokens.nextToken();
      if (token.equals("storing"))
      dict.store(tokens.nextToken(), freeID++);
      else if (token.equals("fetching"))
      System.err.println("fetch " + dict.fetch(tokens.nextToken()));
      }
      }
      //      logging = false;
      
      while ((line = in.readLine()) != null)
      {
      }
      in.close();
      }
      catch (Exception e) {
      e.printStackTrace();
      }
      }
    */
}

