/*************************************************************************
 *
 *  $RCSfile: BtreeDictParameters.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2005/01/25 15:16:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

import java.util.StringTokenizer;
import java.io.*;

public class BtreeDictParameters extends BlockManagerParameters {
  private int _id1;
  private String _dirName;
  
  // some form of this is needed for starting new DBs
  public BtreeDictParameters(File file, int blockSize, int root, int freeID) {
    super(file, blockSize, root);
    _id1 = freeID;
  }
    
  public BtreeDictParameters(Schema schema, String partName) throws Exception {
    super(schema, partName);
  }
  
  public boolean readState() {
    if (super.readState()) {
      setFreeID(integerParameter("id1"));
      return true;
    }
    else
      return false;
  }

  public void writeState() {
  }
  
  public int getFreeID() {
    return _id1;
  }

  public final void setFreeID(int id) {
    _id1 = id;
  }

  private void setDirName(String dirName) {
    _dirName = dirName;
  }

  /*
  public static BtreeDictParameters create(URL dirName) {
    try {
      URL url = new URL(dirName, "DICTIONARY");
      BtreeDictParameters bdp = null;
      //	new BtreeDictParameters(url, 2048, 0, 1);
      bdp.setDirName(dirName.getFile());
      return bdp;
    } catch (java.net.MalformedURLException e) {
      System.out.println ("Couldn't create " + dirName + File.separator + "DICTIONARY");
    }
    return null;
  }
  */

  /*
  public static BtreeDictParameters read(String dir) throws Exception {
      int blockSize = -1;
      int rootPosition = -1;
      int freeID = -1;

      LineInput in = getSchemaLineInput(); // for SCHEMA
      // This needs to be replaced with our XML Parser
      String line;
      do {
	line = in.readLine();
      }
      while (!line.startsWith("DICTIONARY"));
      in.close();
      StringTokenizer tokens = new StringTokenizer(line, " =");
      tokens.nextToken();		// skip over 'DICTIONARY'
      while (tokens.hasMoreTokens()) {
	String token = tokens.nextToken();
	if (token.equals("bs"))
	  blockSize = Integer.parseInt(tokens.nextToken());
	else if (token.equals("rt"))
	  rootPosition = Integer.parseInt(tokens.nextToken());
	else if (token.equals("id1"))
	  freeID = Integer.parseInt(tokens.nextToken());
      }

      BtreeDictParameters bdp = null;
      //      new BtreeDictParameters(tmapURL, blockSize, rootPosition, freeID);

      if (hsBase == null) {
	bdp.setDirName(baseURL.getFile());
      }
      return bdp;
  }
  */

  public void updateSchema() {
    super.updateSchema("id1="+_id1+" id2=1");
  }
    
  public void write() throws java.io.IOException {
    FileWriter out = makeSchemaWriter();
    out.write("JavaSearch 1.0\n");
    out.write("DICTIONARY bs=2048 rt="+_root+" fl=-1 id1="+_id1+" id2=1\n");
    out.close();
  }

  /**
   * For printf debugging.
   */
  private static boolean debugFlag = false;
  private static void debug(String str) {
    if( debugFlag ) {
      System.out.println("BtreeDictParamters: " + str);
    }
  }

  public void setBlockSize(int size) {
    super.setBlockSize(size);
  }

  public void setRoot(int root) {
    super.setRoot(root);
  }
}
