#ifndef _FILSTAT_HXX_
#define _FILSTAT_HXX_

#ifndef _PTHREAD_H_
#include <pthread.h>
#define _PTHREAD_H_
#endif
#ifndef _SHELL_HXX_
#include "shell.hxx"
#endif


namespace fileaccess {
    
    
    class StatusFillerThread
    {
    public:
        
        StatusFillerThread();
        ~StatusFillerThread();
        
        StatusFiller* handle();
        
        // calls destructor function for old StatusFiller
        // and and clears the thread local storage for calling
        // thread
    
        void clear();
        
        
    private:
		
        /** Don't enable assignment and copy construction.
         *  Not defined:
         */
		
        StatusFillerThread(const StatusFillerThread&);
        StatusFillerThread& operator=(const StatusFillerThread&);
        
        pthread_key_t m_threadKey;

    };  // end class StatusFillerThread
    

    
    
    class StatusFiller:
        public osl::FileStatus
    {
    public:
        
        struct timedout {};

        StatusFiller(sal_Int32 n_Mask);
        ~StatusFiller();
        
        osl::FileBase::RC getStatusFromNextEntry(osl::Directory* pFolder);
        
        // starts the background thread
        void getStatusFromFilename(
            const rtl::OUString& aUnqPath,sal_Int32 nMask);
        
        
        // the thread start method
        void* run(void*);
        

        // special optimezed method for the resultset
		com::sun::star::uno::Reference< com::sun::star::sdbc::XRow > SAL_CALL
		getv( sal_Int32 CommandId,
			  Notifier* pNotifier,
			  const com::sun::star::uno::Sequence<
              com::sun::star::beans::Property >& properties,
			  shell* pShell,
			  rtl::OUString& aUnqPath,
			  sal_Bool       bisRegularUsed,
              sal_Bool&      bIsRegular )
			throw(timedout);
        
        
        struct Status {
            osl::FileStatus*  pFilStat;
            osl::FileBase::RC nError1,nError2;
        };
        
        Status getFileStatus() throw(StatusFiller::timedout);
        
        void exit(void);
        
    private:
        
        pthread_mutex_t _mut;        
        pthread_attr_t  _attr;
        pthread_t       _thread;
        
        pthread_cond_t    _cP;
        bool              m_bProvided;
        osl::FileStatus*  m_pFilStat;
        osl::FileBase::RC m_nError1,m_nError2;
        
        pthread_cond_t    _cR;
        bool              m_bRequested;
        rtl::OUString     m_aUnqPath;
        sal_Int32         m_nMask;

        bool m_bExited;   // also by _cR
        
        mutable osl::DirectoryItem m_aDirIte;
    };
    
}


#endif
