/*************************************************************************
 *
 *  $RCSfile: schartf.cpp,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef SOM_Module_schartf_Source
#define SOM_Module_schartf_Source
#endif
#define StarChartFile_Class_Source
#define M_StarChartFile_Class_Source

#include "schartf.xih"
#include <wpsids.hrc>
#include <wpsdll.h>
#include <sdataf.h>

#include <stdio.h>

#ifdef StarChartFileMethodDebug
#undef StarChartFileMethodDebug
#endif
#define StarChartFileMethodDebug

#ifdef M_StarChartFileMethodDebug
#undef M_StarChartFileMethodDebug
#endif
#define M_StarChartFileMethodDebug

SOM_Scope void  SOMLINK schartf_wpInitData(StarChartFile *somSelf)
{
    /* StarChartFileData *somThis = StarChartFileGetData(somSelf); */
    StarChartFileMethodDebug("StarChartFile","schartf_wpInitData");

    StarChartFile_parent_WPDataFile_wpInitData(somSelf);

    /* ensure correct icon */
    _wpSetAssociatedFileIcon();
}

SOM_Scope HWND  SOMLINK schartf_wpViewObject(StarChartFile *somSelf,
                                              HWND hwndCnr, ULONG ulView, 
                                              ULONG param)
{
    /* StarChartFileData *somThis = StarChartFileGetData(somSelf); */
    StarChartFileMethodDebug("StarChartFile","schartf_wpViewObject");

    if(ulView == OPEN_DEFAULT)
    {
        if(hwndCnr == openObject(somSelf, hwndCnr))
            return hwndCnr;
    }

    return (StarChartFile_parent_WPDataFile_wpViewObject(somSelf, 
                                                          hwndCnr, 
                                                          ulView, 
                                                          param));
}

SOM_Scope BOOL  SOMLINK schartf_wpPrintObject(StarChartFile *somSelf, 
                                               PPRINTDEST pPrintDest, 
                                               ULONG ulReserved)
{
    /* StarChartFileData *somThis = StarChartFileGetData(somSelf); */
    StarChartFileMethodDebug("StarChartFile","schartf_wpPrintObject");

    return printObject(somSelf, pPrintDest);
}

SOM_Scope void  SOMLINK schartf_wpSetAssociatedFileIcon(StarChartFile *somSelf)
{
    /* StarChartFileData *somThis = StarChartFileGetData(somSelf); */
    StarChartFileMethodDebug("StarChartFile","schartf_wpSetAssociatedFileIcon");


    _wpSetIcon(_StarChartFile->wpclsQueryIcon());
}


SOM_Scope void  SOMLINK schartfM_wpclsInitData(M_StarChartFile *somSelf)
{
    HMODULE hModule;

    M_StarChartFileData *somThis = M_StarChartFileGetData(somSelf);
    M_StarChartFileMethodDebug("M_StarChartFile","schartfM_wpclsInitData");

    _hIcon = NULLHANDLE;

    // the dll must be loaded already
    if(NO_ERROR == DosQueryModuleHandle(_TEMPLATES_DLL_NAME, &hModule))
    {
        _hIcon = WinLoadPointer(HWND_DESKTOP, hModule, WPS_RESID_ICON_SCHART);
    }

    // set default icon if resource not loaded
    if(_hIcon == NULLHANDLE)
    {
        _hIcon = M_StarChartFile_parent_M_WPDataFile_wpclsQueryIcon(somSelf);
    }

    M_StarChartFile_parent_M_WPDataFile_wpclsInitData(somSelf);
}

SOM_Scope void  SOMLINK schartfM_wpclsUnInitData(M_StarChartFile *somSelf)
{
    M_StarChartFileData *somThis = M_StarChartFileGetData(somSelf);
    M_StarChartFileMethodDebug("M_StarChartFile","schartfM_wpclsUnInitData");

    // release class default icon
    WinDestroyPointer(_hIcon);

    M_StarChartFile_parent_M_WPDataFile_wpclsUnInitData(somSelf);
}

SOM_Scope HPOINTER  SOMLINK schartfM_wpclsQueryIcon(M_StarChartFile *somSelf)
{
    M_StarChartFileData *somThis = M_StarChartFileGetData(somSelf);
    M_StarChartFileMethodDebug("M_StarChartFile","schartfM_wpclsQueryIcon");

    return _hIcon;
}

SOM_Scope PSZ  SOMLINK schartfM_wpclsQueryInstanceFilter(M_StarChartFile *somSelf)
{
    /* M_StarChartFileData *somThis = M_StarChartFileGetData(somSelf); */
    M_StarChartFileMethodDebug("M_StarChartFile","schartfM_wpclsQueryInstanceFilter");

    return "*.sds";
}

SOM_Scope PSZ  SOMLINK schartfM_wpclsQueryInstanceType(M_StarChartFile *somSelf)
{
    /* M_StarChartFileData *somThis = M_StarChartFileGetData(somSelf); */
    M_StarChartFileMethodDebug("M_StarChartFile","schartfM_wpclsQueryInstanceType");

    return "StarChart Document";
}

SOM_Scope BOOL  SOMLINK schartfM_wpclsCreateDefaultTemplates(M_StarChartFile *somSelf, 
                                                              WPObject* Folder)
{
    /* M_StarChartFileData *somThis = M_StarChartFileGetData(somSelf); */
    M_StarChartFileMethodDebug("M_StarChartFile","schartfM_wpclsCreateDefaultTemplates");

    /* tell the wps not to create a template itself */
    return TRUE;
}

